/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.registry;

import de.aristaflow.adept2.base.communication.ADEPT2ServiceExport;
import de.aristaflow.adept2.base.communication.CommunicationService;
import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.configuration.ConfigurationConstants;
import de.aristaflow.adept2.base.configuration.ConfigurationDescription;
import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.configuration.Property;
import de.aristaflow.adept2.base.registry.AbstractRegistry;
import de.aristaflow.adept2.base.registry.InstanceToInstanceRegistry;
import de.aristaflow.adept2.base.registry.RegistryWrapper;
import de.aristaflow.adept2.base.registry.ServiceInformation;
import de.aristaflow.adept2.base.registry.ServiceLoadGraph;
import de.aristaflow.adept2.base.security.AuthenticationException;
import de.aristaflow.adept2.base.security.SecurityManager;
import de.aristaflow.adept2.base.service.ADEPT2Service;
import de.aristaflow.adept2.base.service.AbstractADEPT2Service;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.model.common.ModelViewerProvider;
import de.aristaflow.adept2.util.Adept2ThreadFactory;
import de.aristaflow.adept2.util.ConfigurationTools;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.NullArgumentException;
import de.aristaflow.adept2.util.types.Pair;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import org.apache.commons.configuration.Configuration;

@ConfigurationDescription(properties={@Property(name="MultiThreadedServiceStart", type=Property.Type.BOOLEAN, defaultValue="off", description="Determines whether services should be started concurrently (otherwise they are started sequentially)."), @Property(name="AutoStartServices", type=Property.Type.STRING, defaultNull=true, description="The (simple) names of the services to start when starting the registry."), @Property(name="Components.ModelFactoryRegistry", type=Property.Type.STRING, isRequired=true, description="a required sub-registry for the server registry")}, validator=ConfigurationValidator.class)
public abstract class LocalServiceRegistry
extends InstanceToInstanceRegistry {
    protected final Set<String> autoStartServices = new HashSet<String>();
    protected Stack<Pair<String, ADEPT2Service>> startedServices = new Stack();
    protected volatile boolean shuttingDown = false;
    protected transient Map<String, Lock> startingLock = Collections.synchronizedMap(new HashMap());
    protected ExecutorService serviceStarterPool;
    protected final ThreadLocal<Stack<String>> startingService = new ThreadLocal();
    protected final ThreadLocal<Stack<String[]>> startingRequiredServices = new ThreadLocal();

    @Override
    protected <T> T getConfiguredPlugin(SessionToken session, String usingInstanceName, Object usingInstance, String pluginTypeName, Class<T> componentType, String pluginInstanceName, Class<?>[] additionalParameterTypes, Object[] additionalParameterValues) throws ConfigurationException {
        super.sessionActive(session);
        try {
            InstanceToInstanceRegistry mfRegistry;
            String hierachicalPluginName = LocalServiceRegistry.getHierarchicalInstanceName(pluginTypeName, pluginInstanceName);
            Class[] parameterTypes = new Class[additionalParameterTypes.length + 1];
            parameterTypes[0] = Registry.class;
            System.arraycopy(additionalParameterTypes, 0, parameterTypes, 1, additionalParameterTypes.length);
            if (!pluginTypeName.equals("ModelFactoryRegistry")) {
                try {
                    mfRegistry = this.getRegistry(session, "ModelFactoryRegistry", InstanceToInstanceRegistry.class);
                }
                catch (ServiceNotKnownException snke) {
                    throw new ConfigurationException(snke);
                }
            } else {
                mfRegistry = null;
            }
            Object[] parameterValues = new Object[additionalParameterTypes.length + 1];
            parameterValues[0] = this.createRegistryWrapper(hierachicalPluginName, mfRegistry, (ModelViewerProvider)((Object)mfRegistry));
            System.arraycopy(additionalParameterValues, 0, parameterValues, 1, additionalParameterValues.length);
            T t = super.getConfiguredPlugin(session, usingInstanceName, usingInstance, pluginTypeName, componentType, pluginInstanceName, parameterTypes, parameterValues);
            return t;
        }
        finally {
            super.sessionFinished(session);
        }
    }

    protected LocalServiceRegistry(Configuration configuration, Registry registry) {
        super(configuration, registry);
    }

    @Override
    protected void renewConfiguration(Configuration configuration) throws ConfigurationException {
        this.readStartServices(configuration);
        super.renewConfiguration(configuration);
    }

    private void readStartServices(Configuration configuration) {
        for (String service : configuration.getList("AutoStartServices")) {
            this.autoStartServices.add(service);
        }
    }

    @Override
    protected void readMetaConfiguration(Configuration registryConfiguration, String serviceType, String simpleInstanceName) throws ConfigurationException {
        String instanceName = LocalServiceRegistry.getHierarchicalInstanceName(serviceType, simpleInstanceName);
        AbstractRegistry.InstantiationMode instantiationMode = this.getInstantiationMode(serviceType, simpleInstanceName, registryConfiguration);
        String key = String.valueOf(simpleInstanceName) + "." + "Implementation";
        if (!ConfigurationTools.propertyValuePresent(registryConfiguration, key)) {
            String message = String.format("No implementation for service '%1$s' configured!", simpleInstanceName);
            this.logger.severe(message);
            throw new ConfigurationException(message);
        }
        String implementingClassName = registryConfiguration.getString(key);
        this.checkImplementingClassConfiguration(instanceName, implementingClassName);
        ServiceInformation serviceInformation = ServiceInformation.createNonExportedLocalService(serviceType, instantiationMode, implementingClassName);
        this.declaredInstances.put(instanceName, serviceInformation);
        if (this.autoStartServices.contains(simpleInstanceName)) {
            this.autoStartServices.remove(simpleInstanceName);
            this.autoStartServices.add(instanceName);
        }
        this.logger.fine(String.format("Local non-exported service '%1$s' declared.", instanceName));
    }

    @Override
    protected AbstractRegistry.InstantiationMode getInstantiationMode(String serviceType, String simpleName, Configuration registryConfiguration) {
        AbstractRegistry.InstantiationMode ret = super.getInstantiationMode(serviceType, simpleName, registryConfiguration);
        if (ret != AbstractRegistry.InstantiationMode.SINGLETON) {
            String msg = "Instantiation mode of '%1$s' ('%2$s') was '%3$s' and not 'SINGLETON'. Be sure that this is correct. Services are usually 'SINGLETON'!";
            msg = String.format(msg, new Object[]{simpleName, serviceType, ret});
            this.logger.info(msg);
        }
        return ret;
    }

    protected ServiceExportInformation prepareExport(SessionToken session, String serviceName, ADEPT2Service service) throws AbortServiceException {
        super.sessionActive(session);
        try {
            ADEPT2ServiceExport[] serviceExports = new ADEPT2ServiceExport[]{};
            URI[] serviceURIs = new URI[]{this.createLocalServiceURI(serviceName)};
            ServiceExportInformation serviceExportInformation = new ServiceExportInformation(serviceExports, serviceURIs, false);
            return serviceExportInformation;
        }
        finally {
            super.sessionFinished(session);
        }
    }

    protected void exportService(SessionToken session, String serviceName, ADEPT2Service service, ServiceExportInformation serviceExportInformation) throws AbortServiceException {
    }

    protected void unpublishService(SessionToken session, String serviceName) {
    }

    protected void syncExecute(ServiceStarter[] startServices) throws ExecutionException, AbortServiceException {
        Future[] results = new Future[startServices.length];
        Throwable execExcept = null;
        InterruptedException interExcept = null;
        String serviceName = null;
        int i = 0;
        while (i < startServices.length) {
            results[i] = this.serviceStarterPool.submit(startServices[i]);
            ++i;
        }
        i = 0;
        while (i < startServices.length) {
            if (execExcept == null && interExcept == null) {
                try {
                    results[i].get();
                }
                catch (ExecutionException ee) {
                    execExcept = ee;
                    serviceName = startServices[i].getServiceName();
                }
                catch (InterruptedException ie) {
                    interExcept = ie;
                    serviceName = startServices[i].getServiceName();
                }
            } else {
                results[i].cancel(true);
            }
            ++i;
        }
        if (execExcept != null) {
            if (execExcept.getCause() instanceof AbortServiceException) {
                throw (AbortServiceException)execExcept.getCause();
            }
            throw execExcept;
        }
        if (interExcept != null) {
            String message = String.format("Interrupted while waiting for startup-required services for starting service '%s'. Aborting start.", serviceName);
            this.logger.log(Level.SEVERE, message, interExcept);
            throw new AbortServiceException(message, interExcept);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startLocalService(SessionToken session, String serviceName, ADEPT2Service service, final ServiceLoadGraph loadGraph) throws AbortServiceException {
        if (this.shuttingDown) {
            return;
        }
        super.sessionActive(session);
        this.logger.fine(String.format("Local service '%s' starting.", serviceName));
        try {
            Lock serviceLock;
            Map<String, Lock> map = this.startingLock;
            synchronized (map) {
                serviceLock = this.startingLock.get(serviceName);
                if (serviceLock == null) {
                    serviceLock = new ReentrantLock();
                    this.startingLock.put(serviceName, serviceLock);
                }
            }
            serviceLock.lock();
            boolean alreadyStarted = true;
            try {
                if (this.startedServices.contains(new Pair<String, ADEPT2Service>(serviceName, service))) {
                    this.logger.fine(String.format("Local service '%s' already started.", serviceName));
                    return;
                }
                alreadyStarted = false;
            }
            finally {
                if (alreadyStarted) {
                    this.startingLock.remove(serviceName);
                    serviceLock.unlock();
                }
            }
            boolean isRegistry = false;
            try {
                if (Thread.interrupted()) {
                    String msg = String.format("Interrupted while trying to start service '%s'.", serviceName);
                    throw new AbortServiceException(msg);
                }
                final SessionToken subSession = this.sessionFactory.getChildSession(session, this.getURIs());
                List<String> requiredServices = loadGraph.getUsedServicesFor(serviceName);
                ServiceStarter[] serviceStarters = new ServiceStarter[requiredServices.size()];
                if (this.startingService.get() == null) {
                    this.startingService.set(new Stack());
                    this.startingRequiredServices.set(new Stack());
                }
                this.startingService.get().push(serviceName);
                String[] explStReqServ = service.getStartupRequiredServices();
                String[] stReqServ = new String[explStReqServ.length + 1];
                stReqServ[0] = "ModelFactoryRegistry";
                System.arraycopy(explStReqServ, 0, stReqServ, 1, explStReqServ.length);
                this.startingRequiredServices.get().push(stReqServ);
                int i = 0;
                while (i < requiredServices.size()) {
                    final String requiredServiceName = requiredServices.get(i);
                    final ADEPT2Service requiredService = this.getLocalServiceObject(session, requiredServiceName, ADEPT2Service.class);
                    serviceStarters[i] = new ServiceStarter(){

                        @Override
                        public String getServiceName() {
                            return requiredServiceName;
                        }

                        @Override
                        public Boolean call() throws AbortServiceException {
                            LocalServiceRegistry.this.privilegeThread();
                            LocalServiceRegistry.this.startLocalService(subSession, requiredServiceName, requiredService, loadGraph);
                            return Boolean.TRUE;
                        }
                    };
                    ++i;
                }
                if (Thread.interrupted()) {
                    String msg = String.format("Interrupted while trying to start service '%s'.", serviceName);
                    throw new AbortServiceException(msg);
                }
                try {
                    this.syncExecute(serviceStarters);
                }
                catch (ExecutionException ee) {
                    String message = String.format("An exception occurred while starting a startup-required services for starting service '%1$s'. Aborting start.", serviceName);
                    this.logger.log(Level.SEVERE, message, ee.getCause());
                    throw new AbortServiceException(message, ee.getCause());
                }
                if (Thread.interrupted()) {
                    String msg = String.format("Interrupted while trying to start service '%s'.", serviceName);
                    throw new AbortServiceException(msg);
                }
                SessionToken nonFinalSubSession = this.sessionFactory.getChildSession(session, this.getURIs());
                ServiceExportInformation serviceExportInformation = this.prepareExport(nonFinalSubSession, serviceName, service);
                this.changeLogContext("1_init_" + serviceName);
                this.logger.finer(String.format("Start initialisation of %s", serviceName));
                service.init(serviceExportInformation.serviceURIs);
                this.logger.finer(String.format("Finished initialisation of %s", serviceName));
                if (Thread.interrupted()) {
                    String msg = String.format("Interrupted while trying to start service '%s'.", serviceName);
                    throw new AbortServiceException(msg);
                }
                isRegistry = AbstractRegistry.class.isAssignableFrom(service.getClass());
                if (isRegistry) {
                    this.startedServices.push(new Pair<String, ADEPT2Service>(serviceName, service));
                    this.serviceStartCleanup(serviceName, serviceLock);
                }
                this.checkServiceInterface(serviceName, service);
                this.changeLogContext("2_start_" + serviceName);
                this.logger.finer(String.format("Start starting of %s", serviceName));
                service.start();
                this.logger.finer(String.format("Finished starting of %s", serviceName));
                if (!isRegistry) {
                    this.startedServices.push(new Pair<String, ADEPT2Service>(serviceName, service));
                }
                if (AbstractADEPT2Service.class.isAssignableFrom(service.getClass())) {
                    ((AbstractADEPT2Service)service).signalStart();
                }
                nonFinalSubSession = this.sessionFactory.getChildSession(session, this.getURIs());
                this.changeLogContext("3_export_" + serviceName);
                this.logger.finer(String.format("Start export of %s", serviceName));
                this.exportService(nonFinalSubSession, serviceName, service, serviceExportInformation);
                this.logger.finer(String.format("Finished export of %s", serviceName));
            }
            finally {
                if (!isRegistry) {
                    this.serviceStartCleanup(serviceName, serviceLock);
                }
            }
            this.changeLogContext("");
            this.logger.fine(String.format("Local service '%1$s' successfully started.", serviceName));
        }
        finally {
            super.sessionFinished(session);
        }
    }

    protected void autoStartServices() throws AbortServiceException {
        try {
            this.prepareSecurityManager();
        }
        catch (ServiceNotKnownException snke) {
            String msg = "The security manager could not be prepared but it is crucial for running the system. Aborting start!";
            throw new AbortServiceException(msg, snke);
        }
        try {
            this.sessionFactory = this.getSecurityManager().authenticatePrivileged(-2L, -2L, "password");
        }
        catch (AuthenticationException ae) {
            throw new ConfigurationException(ae);
        }
        catch (DataSourceException dse) {
            throw new ConfigurationException(dse);
        }
        SessionToken session = this.sessionFactory.getSessionToken(this.getURIs());
        try {
            for (String service : this.autoStartServices) {
                this.getService(this.sessionFactory.getChildSession(session, this.getURIs()), service, ADEPT2Service.class);
            }
        }
        catch (ServiceNotKnownException snke) {
            this.shutdown();
            if (snke.getCause() instanceof ConfigurationException) {
                throw (ConfigurationException)snke.getCause();
            }
            if (snke.getCause() instanceof AbortServiceException) {
                throw (AbortServiceException)snke.getCause();
            }
            throw snke;
        }
    }

    /*
     * Exception decompiling
     */
    public <T extends ADEPT2Service> T getService(SessionToken session, String serviceName, Class<T> serviceType) throws ServiceNotKnownException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 19[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public <T extends ADEPT2Service> T getService(SessionToken session, URI[] serviceURIs, Class<T> serviceType) throws ServiceNotKnownException {
        if (serviceURIs == null || serviceURIs.length == 0 || serviceType == null) {
            String msg = "Neither of the arguments may be null. serviceURIs='%1$s', serviceType='%2$s'";
            this.logger.warning(String.format(msg, Arrays.toString(serviceURIs), serviceType));
            throw new NullArgumentException(msg);
        }
        super.sessionActive(session);
        try {
            ServiceInformation serviceInformation;
            SessionToken subSession = this.sessionFactory.getChildSession(session, serviceURIs);
            URI serviceURI = this.chooseAppropriateURI(serviceURIs);
            this.checkServiceURI(subSession, serviceURI);
            this.logger.fine(String.format("Service with URI '%s' requested, expected type: '%s'", serviceURI, serviceType));
            String serviceName = this.getInstanceNameFromServiceURI(serviceURI);
            this.checkStartupRequiredService(serviceName);
            try {
                serviceInformation = this.getInstanceInformation(serviceName);
            }
            catch (ConfigurationException ce) {
                throw new ServiceNotKnownException(serviceURIs, (Throwable)ce);
            }
            if (serviceInformation == null || serviceInformation.isRemote()) {
                String message = String.format("The service '%1$s' should be declared  locally but it is not.", serviceURI);
                this.logger.warning(message);
                throw new ServiceNotKnownException(serviceURIs, message);
            }
            subSession = this.sessionFactory.getChildSession(session, serviceURIs);
            T ret = this.getService(subSession, serviceName, serviceType);
            T t = ret;
            return t;
        }
        finally {
            super.sessionFinished(session);
        }
    }

    protected <T extends ADEPT2Service> T getServiceForInstance(SessionToken session, String usingService, String usedServiceTypeName, Class<T> usedServiceType) throws ServiceNotKnownException {
        super.sessionActive(session);
        try {
            T ret;
            SessionToken subSession = this.sessionFactory.getChildSession(session, this.getURIs());
            Stack<String> tmpStartingService = null;
            Stack<String[]> tmpStartingRequiredService = null;
            if (this.startingService != null && this.startingService.get() != null) {
                tmpStartingService = this.startingService.get();
                this.startingService.set(null);
                tmpStartingRequiredService = this.startingRequiredServices.get();
                this.startingRequiredServices.set(null);
            }
            try {
                String otherServiceName;
                try {
                    otherServiceName = this.getAndCheckRequiredService(subSession, usingService, usedServiceTypeName);
                }
                catch (ConfigurationException ce) {
                    String msg = String.format("Could not retrieve used service instance of type '%s' for using service '%s'.", usedServiceTypeName, usingService);
                    throw new ServiceNotKnownException(msg, (Throwable)ce);
                }
                ret = this.getService(subSession, otherServiceName, usedServiceType);
            }
            finally {
                if (tmpStartingService != null) {
                    this.startingService.set(tmpStartingService);
                    this.startingRequiredServices.set(tmpStartingRequiredService);
                }
            }
            T t = ret;
            return t;
        }
        finally {
            super.sessionFinished(session);
        }
    }

    protected <T extends AbstractRegistry> T getRegistry(SessionToken session, String registryTypeName, Class<T> registryType) throws ServiceNotKnownException {
        super.sessionActive(session);
        try {
            AbstractRegistry abstractRegistry = (AbstractRegistry)this.getService(session, LocalServiceRegistry.getHierarchicalInstanceName(registryTypeName, registryTypeName), registryType);
            return (T)abstractRegistry;
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public void init(URI[] myURIs) throws AbortServiceException {
        super.init(myURIs);
        HashSet pluginTypes = new HashSet();
        for (Set set : this.declaredPluginTypes.values()) {
            pluginTypes.addAll(set);
        }
        for (Map.Entry entry : this.componentInterfaces.entrySet()) {
            if (pluginTypes.contains(entry.getKey())) continue;
            this.checkSupertype((String)entry.getKey(), ADEPT2Service.class, (Class)entry.getValue());
        }
        boolean bl = this.configuration.getBoolean("MultiThreadedServiceStart");
        this.serviceStarterPool = bl ? Executors.newCachedThreadPool(new Adept2ThreadFactory("LocalServiceRegistry_ServiceStarterPool")) : new CurrentThreadPoolExecutor();
        try {
            this.sessionFactory = this.getSecurityManager().authenticatePrivileged(-2L, -2L, "password");
        }
        catch (AuthenticationException ae) {
            throw new ConfigurationException(ae);
        }
        catch (DataSourceException dse) {
            throw new ConfigurationException(dse);
        }
    }

    @Override
    public void start() throws AbortServiceException {
        super.start();
        try {
            this.autoStartServices();
        }
        catch (Exception e) {
            this.shutdown();
            if (e instanceof AbortServiceException) {
                throw (AbortServiceException)e;
            }
            throw new AbortServiceException(e);
        }
    }

    @Override
    public void shutdown() {
        this.terminate(false);
    }

    @Override
    public void emergencyShutdown() {
        this.terminate(true);
    }

    private void terminate(boolean emergency) {
        this.shuttingDown = true;
        while (!this.startedServices.empty()) {
            Pair<String, ADEPT2Service> pair = this.startedServices.pop();
            ADEPT2Service service = pair.getSecond();
            String msg = emergency ? "Emergency shutting down of '%1$s'" : "Shutting down '%1$s'";
            this.logger.info(String.format(msg, service.getClass().getSimpleName()));
            if (AbstractADEPT2Service.class.isAssignableFrom(service.getClass()) && !AbstractRegistry.class.isAssignableFrom(service.getClass())) {
                ((AbstractADEPT2Service)service).signalShutdown(false);
            }
            try {
                this.unpublishService(this.createSessionToken(), pair.getFirst());
            }
            catch (RuntimeException re) {
                msg = "Caught an exception while unpublishing service '%1$s'. Continuing with shutting down the service.";
                msg = String.format(msg, service.getClass().getSimpleName());
                this.logger.log(Level.SEVERE, msg, re);
            }
            try {
                if (emergency) {
                    service.emergencyShutdown();
                } else {
                    service.shutdown();
                }
                msg = String.format("'%s' shut down.", service.getClass().getSimpleName());
                this.logger.info(msg);
            }
            catch (RuntimeException re) {
                msg = emergency ? "Caught an exception while performing an emergency shutdown '%1$s'." : "Caught an exception while shutting down '%1$s'.";
                String message = String.format(msg, service.getClass().getSimpleName());
                this.logger.log(Level.SEVERE, message, re);
            }
        }
        if (emergency) {
            super.emergencyShutdown();
        } else {
            super.shutdown();
        }
        if (!this.serviceStarterPool.isShutdown()) {
            this.serviceStarterPool.shutdown();
        }
    }

    @Override
    protected ServiceInformation getInstanceInformation(String instanceName) throws ConfigurationException {
        return (ServiceInformation)super.getInstanceInformation(instanceName);
    }

    protected abstract void prepareSecurityManager() throws ServiceNotKnownException;

    protected abstract SecurityManager getSecurityManager();

    protected Registry createRegistryWrapper(String serviceName, InstanceToInstanceRegistry mfRegistry, ModelViewerProvider mvProvider) {
        return new RegistryWrapper(serviceName, this, mfRegistry, mvProvider);
    }

    protected URI createLocalServiceURI(String instanceName) {
        return URI.create(String.valueOf(ConfigurationConstants.CommunicationProtocol.COMM_LOCAL.getScheme()) + ":" + instanceName);
    }

    protected <T extends ADEPT2Service> T getLocalServiceObject(SessionToken session, String serviceName, Class<T> requestedType) throws ConfigurationException {
        super.sessionActive(session);
        try {
            Object[] parameterValues;
            Class[] parameterTypes;
            InstanceToInstanceRegistry mfRegistry = !this.getComponentType(serviceName).equals("ModelFactoryRegistry") ? this.getRegistry(session, "ModelFactoryRegistry", InstanceToInstanceRegistry.class) : null;
            if (CommunicationService.class.isAssignableFrom(requestedType)) {
                parameterTypes = new Class[]{Registry.class, AbstractRegistry.class, String.class};
                Registry wrapper = this.createRegistryWrapper(serviceName, mfRegistry, (ModelViewerProvider)((Object)mfRegistry));
                parameterValues = new Object[]{wrapper, this, LocalServiceRegistry.getSimpleInstanceName(serviceName)};
            } else {
                parameterTypes = new Class[]{Registry.class};
                Registry wrapper = this.createRegistryWrapper(serviceName, mfRegistry, (ModelViewerProvider)((Object)mfRegistry));
                parameterValues = new Object[]{wrapper};
            }
            ADEPT2Service aDEPT2Service = (ADEPT2Service)this.getObjectForInstanceName(serviceName, requestedType, parameterTypes, parameterValues);
            return (T)aDEPT2Service;
        }
        catch (ServiceNotKnownException snke) {
            String msg = String.format("Could not retrieve service '%s' since the model factory registry could not be retrieved.", serviceName);
            throw new ConfigurationException(msg, snke);
        }
        finally {
            super.sessionFinished(session);
        }
    }

    protected void checkStartupRequiredService(String serviceName) {
        if (this.startingService.get() != null) {
            String serviceTypeName = this.getComponentType(serviceName);
            boolean found = false;
            String[] stringArray = this.startingRequiredServices.get().peek();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String requiredType = stringArray[n2];
                if (requiredType.equals(serviceTypeName)) {
                    found = true;
                    break;
                }
                ++n2;
            }
            if (!found) {
                String message = "QA Notice: Service '%1$s' has requested the service type '%2$s' but has not declared it as startup required!";
                this.logger.warning(String.format(message, this.startingService.get().peek(), serviceTypeName));
            }
        }
    }

    private void serviceStartCleanup(String serviceName, Lock serviceLock) {
        this.startingLock.remove(serviceName);
        serviceLock.unlock();
        if (this.startingService.get() != null) {
            this.startingService.get().pop();
            this.startingRequiredServices.get().pop();
            if (this.startingService.get().size() <= 0) {
                this.startingService.set(null);
                this.startingRequiredServices.set(null);
            }
        }
    }

    protected String getAndCheckRequiredService(SessionToken session, String usingService, String usedServiceTypeName) throws ConfigurationException {
        super.sessionActive(session);
        try {
            String ret;
            String string = ret = this.getUsedComponentInstanceNameForInstance(usingService, usedServiceTypeName);
            return string;
        }
        finally {
            super.sessionFinished(session);
        }
    }

    protected void checkServiceInterface(String serviceName, ADEPT2Service service) throws ConfigurationException {
        String msg = "Service '%s' does not fulfill the ADEPT2Service-interface appropriately!";
        msg = String.format(msg, serviceName);
        if (service.getStartupRequiredServices() == null) {
            msg = String.format("%s The startup required services must not be null!", msg);
            throw new ConfigurationException(msg);
        }
        if (service.getRuntimeRequiredServices() == null) {
            msg = String.format("%s The runtime required services must not be null!", msg);
            throw new ConfigurationException(msg);
        }
        if (service.getURIs() == null) {
            msg = String.format("%s The service URI must not be null!", msg);
            throw new ConfigurationException(msg);
        }
    }

    protected void checkServiceURI(SessionToken session, URI serviceURI) throws ServiceNotKnownException {
        String path;
        String message = null;
        if (serviceURI.getScheme() == null || !serviceURI.getScheme().equals(ConfigurationConstants.CommunicationProtocol.COMM_LOCAL.getScheme())) {
            message = String.format("The schema of the service URI '%s' is not valid.", serviceURI);
        }
        if ((path = serviceURI.getPath()) == null || path.equals("")) {
            message = String.format("The path '%s' of serviceURI '%s' is not a valid format of a hierarchical instance name.", path, serviceURI);
        } else if (!path.startsWith("/") || path.lastIndexOf("/") <= 1) {
            message = String.format("The path '%s' of serviceURI '%s' is not a valid format of a hierarchical instance name.", path, serviceURI);
        }
        if (message != null) {
            this.logger.warning(message);
            throw new IllegalArgumentException(message);
        }
    }

    protected URI chooseAppropriateURI(URI[] serviceURIs) {
        URI ret = null;
        URI[] uRIArray = serviceURIs;
        int n = serviceURIs.length;
        int n2 = 0;
        while (n2 < n) {
            URI uri = uRIArray[n2];
            if (uri.getScheme().equals(ConfigurationConstants.CommunicationProtocol.COMM_LOCAL.getScheme())) {
                ret = uri;
                break;
            }
            ++n2;
        }
        return ret;
    }

    protected String getInstanceNameFromServiceURI(URI serviceURI) throws ServiceNotKnownException {
        return serviceURI.getPath();
    }

    public static class ConfigurationValidator
    extends de.aristaflow.adept2.base.configuration.ConfigurationValidator {
        protected void checkForNonExportedLocal(Configuration configuration, String serviceType) throws ConfigurationException {
            String key = String.format("%s.%s", "Components", serviceType);
            if (ConfigurationTools.propertyValuePresent(configuration, key)) {
                ArrayList<String> serviceInstances;
                key = String.format("%s.%s", "Instances", serviceType);
                if (ConfigurationTools.propertyValuePresent(configuration, key)) {
                    serviceInstances = configuration.getList(key);
                } else {
                    serviceInstances = new ArrayList<String>(1);
                    serviceInstances.add(serviceType);
                }
                for (String serviceInstance : serviceInstances) {
                    key = String.valueOf(serviceInstance) + "." + "ExportVia";
                    if (ConfigurationTools.propertyValuePresent(configuration, key)) {
                        this.rebukeIllegalValue(configuration, "ExportVia", String.format("The service type '%1$s' must not be exported.", serviceType));
                    }
                    if (!ConfigurationTools.propertyValuePresent(configuration, key = String.valueOf(serviceInstance) + "." + "PublishService")) continue;
                    this.rebukeIllegalValue(configuration, "PublishService", String.format("The service type '%1$s' must not be published.", serviceType));
                }
            }
        }

        @Override
        protected void validate(Configuration configuration) throws ConfigurationException {
            this.checkForNonExportedLocal(configuration, "JDBCDataSource");
        }
    }

    static class CurrentThreadPoolExecutor
    extends ThreadPoolExecutor {
        protected CurrentThreadPoolExecutor() {
            super(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        }

        @Override
        public void execute(Runnable command) {
            command.run();
        }
    }

    protected static class ServiceExportInformation {
        public final ADEPT2ServiceExport[] serviceExports;
        public final URI[] serviceURIs;
        public final boolean publish;

        public ServiceExportInformation(ADEPT2ServiceExport[] serviceExports, URI[] serviceURIs, boolean publish) {
            this.serviceExports = (ADEPT2ServiceExport[])serviceExports.clone();
            this.serviceURIs = (URI[])serviceURIs.clone();
            this.publish = publish;
        }

        public boolean isExported() {
            return this.serviceExports.length > 0;
        }
    }

    protected class ServiceNameResolution
    implements ServiceLoadGraph.ServiceNameResolution {
        private final SessionToken session;

        protected ServiceNameResolution(SessionToken session) {
            this.session = session;
        }

        @Override
        public String getUsedServiceNameFor(String usingServiceName, String usedServiceType) throws ConfigurationException {
            return LocalServiceRegistry.this.getUsedComponentInstanceNameForInstance(usingServiceName, usedServiceType);
        }

        @Override
        public ADEPT2Service getUnstartedLocalServiceObject(String serviceName) throws ConfigurationException {
            ADEPT2Service ret = LocalServiceRegistry.this.getLocalServiceObject(this.session, serviceName, ADEPT2Service.class);
            Pair<String, ADEPT2Service> pair = new Pair<String, ADEPT2Service>(LocalServiceRegistry.getSimpleInstanceName(serviceName), ret);
            if (ret != null && LocalServiceRegistry.this.startedServices.contains(pair)) {
                ret = null;
            }
            return ret;
        }
    }

    protected static interface ServiceStarter
    extends Callable<Boolean> {
        public String getServiceName();
    }
}

