/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.registry;

import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.configuration.FileBasedConfigurationManager;
import de.aristaflow.adept2.base.registry.CSVFormatter;
import de.aristaflow.adept2.util.ConfigurationTools;
import de.aristaflow.adept2.util.LoggerTools;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.apache.commons.configuration.Configuration;

public class LoggerInitialisation {
    private static volatile Handler consoleHandler;
    protected static final Logger ourLogger;
    protected static final Collection<Logger> configuredLoggers;

    static {
        ourLogger = LoggerTools.getLogger(LoggerInitialisation.class);
        configuredLoggers = new HashSet<Logger>(5);
    }

    private static Logger getLogger(String name) {
        Logger ret = Logger.getLogger(name);
        if (!configuredLoggers.contains(ret)) {
            configuredLoggers.add(ret);
        }
        return ret;
    }

    static void initialiseDebugLogging(boolean debugLogging) {
        Logger rootLogger = LoggerInitialisation.getLogger("");
        Handler[] handlerArray = rootLogger.getHandlers();
        int n = handlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Handler handler = handlerArray[n2];
            rootLogger.removeHandler(handler);
            ++n2;
        }
        if (!debugLogging) {
            consoleHandler = null;
        } else {
            consoleHandler = new ConsoleHandler();
            consoleHandler.setLevel(Level.ALL);
            rootLogger.addHandler(consoleHandler);
        }
    }

    static void initialiseConsoleHandler(Configuration configuration) {
        boolean consoleHandlerPresent = consoleHandler != null;
        String consoleLevelString = configuration.getString("ConsoleLogger.Level");
        Level consoleLevel = null;
        if (consoleLevelString == null) {
            ourLogger.info("No default log level set for the console logger. Not using console logging.");
        } else {
            try {
                consoleLevel = Level.parse(consoleLevelString);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ourLogger.warning("Invalid default log level set for the console logger: " + consoleLevelString);
            }
        }
        if (consoleLevel == null) {
            if (consoleHandlerPresent) {
                LoggerInitialisation.getLogger("").removeHandler(consoleHandler);
            }
            return;
        }
        String consoleRoot = configuration.getString("ConsoleLogger.Root");
        if (consoleRoot == null) {
            consoleRoot = "";
            ourLogger.info("No root level set for the console logger. Setting to \"\"");
            LoggerInitialisation.getLogger("").setLevel(Level.OFF);
        }
        Logger consoleRootLogger = LoggerInitialisation.getLogger(consoleRoot);
        if (!consoleHandlerPresent) {
            consoleHandler = new ConsoleHandler();
        }
        LoggerInitialisation.adjustLogLevel(consoleLevel, consoleHandler, consoleRootLogger);
        if (!consoleRoot.equals("") && consoleHandlerPresent) {
            LoggerInitialisation.getLogger("").removeHandler(consoleHandler);
            consoleRootLogger.addHandler(consoleHandler);
        } else if (!consoleHandlerPresent) {
            consoleRootLogger.addHandler(consoleHandler);
        }
    }

    static void initialiseFileLogging(Configuration configuration, File globalLogDir, File defaultLogDir) throws ConfigurationException {
        String key = String.format("%s.%s", "Instances", "FileLogger");
        if (!ConfigurationTools.propertyValuePresent(configuration, key)) {
            ourLogger.info("No file logger instances configured, file logging disabled!");
            return;
        }
        File logDirectory = globalLogDir;
        if (logDirectory == null) {
            try {
                String propertyValue = configuration.getString("FileLogger.LogDirectory");
                logDirectory = FileBasedConfigurationManager.getDir(propertyValue, false);
            }
            catch (ConfigurationException configurationException) {}
        }
        if (logDirectory == null) {
            logDirectory = defaultLogDir;
        }
        LoggerInitialisation.checkOrCreateLogDirectory(logDirectory);
        SimpleFormatter simpleFormatter = new SimpleFormatter();
        CSVFormatter csvFormatter = new CSVFormatter();
        for (String fileLogger : configuration.getList(key)) {
            Level logLevel;
            FileHandler fileHandler;
            key = String.valueOf(fileLogger) + ".Root";
            String loggerRoot = configuration.getString(key);
            if (loggerRoot == null) {
                loggerRoot = "";
            }
            String logFileName = String.valueOf(fileLogger) + ".log";
            key = String.valueOf(fileLogger) + ".FileSize";
            int fileEntries = configuration.getInt(key, 0x1400000);
            key = String.valueOf(fileLogger) + ".FileCount";
            int fileCount = configuration.getInt(key, 5);
            try {
                String fileName = String.format("%s%s%s", logDirectory.getPath(), File.separator, logFileName);
                fileHandler = new FileHandler(fileName, fileEntries, fileCount, true);
            }
            catch (IOException ioe) {
                ourLogger.log(Level.WARNING, "IOException in file handler initialisation.", ioe);
                continue;
            }
            key = String.valueOf(fileLogger) + ".Level";
            if (!ConfigurationTools.propertyValuePresent(configuration, key)) continue;
            try {
                logLevel = Level.parse(configuration.getString(key));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ourLogger.info(String.format("Invalid default log level set for file logger '%1$s'. Ignoring logger.", fileLogger));
                continue;
            }
            key = String.valueOf(fileLogger) + ".CSVMode";
            boolean csvMode = configuration.getBoolean(key, false);
            if (csvMode) {
                fileHandler.setFormatter(csvFormatter);
            } else {
                fileHandler.setFormatter(simpleFormatter);
            }
            LoggerInitialisation.adjustLogLevel(logLevel, fileHandler, LoggerInitialisation.getLogger(loggerRoot));
            if (logLevel == Level.OFF) continue;
            LoggerInitialisation.getLogger(loggerRoot).addHandler(fileHandler);
        }
    }

    private static void checkOrCreateLogDirectory(File logDirectory) throws ConfigurationException {
        block8: {
            if (logDirectory == null) {
                throw new ConfigurationException("The provided log directory is null! Aborting logger initialisation.");
            }
            try {
                if (!logDirectory.exists()) {
                    String msg;
                    try {
                        msg = String.format("Log-directory '%s' does not exist, creating it.", logDirectory.getCanonicalPath());
                        ourLogger.info(msg);
                    }
                    catch (IOException ioe) {
                        String msg2 = "Could not access log-directory: " + logDirectory.getPath();
                        ourLogger.severe(msg2);
                        throw new ConfigurationException(msg2, ioe);
                    }
                    if (!logDirectory.mkdirs()) {
                        msg = "Could not create log-directory: " + logDirectory.getPath();
                        ourLogger.severe(msg);
                        throw new ConfigurationException(msg);
                    }
                    break block8;
                }
                if (!logDirectory.isDirectory()) {
                    String msg = "Given log-directory is not a directory: " + logDirectory.getPath();
                    ourLogger.severe(msg);
                    throw new ConfigurationException(msg);
                }
            }
            catch (SecurityException se) {
                String msg = "Could not access log-directory: " + logDirectory.getPath();
                ourLogger.severe(msg);
                throw new ConfigurationException(msg, se);
            }
        }
    }

    private static void adjustLogLevel(Level newLevel, Handler handler, Logger logger) {
        handler.setLevel(newLevel);
        Logger current = logger;
        boolean adjust = true;
        while (current != null) {
            if (current.getLevel() != null) {
                if (current.getLevel().intValue() > newLevel.intValue()) break;
                adjust = false;
                break;
            }
            current = current.getParent();
        }
        if (adjust) {
            logger.setLevel(newLevel);
        }
    }
}

