/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.registry;

import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.configuration.SystemPropertyConfigurationManager;
import de.aristaflow.adept2.util.ConfigurationTools;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration.Configuration;

public abstract class MapBasedConfigurationManager<T>
extends SystemPropertyConfigurationManager<T> {
    private static Map<String, String> configMap;

    protected static synchronized void setConfigMap(Map<String, String> configMap) {
        if (MapBasedConfigurationManager.configMap == null) {
            MapBasedConfigurationManager.configMap = configMap;
        }
    }

    protected MapBasedConfigurationManager(T initialisationData) throws ConfigurationException {
        super(initialisationData);
    }

    protected MapBasedConfigurationManager(Configuration rootConfiguration, String[] configDirectories) throws ConfigurationException {
        super(rootConfiguration, configDirectories);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initialiseProperties() throws ConfigurationException {
        Class<SystemPropertyConfigurationManager> clazz = SystemPropertyConfigurationManager.class;
        synchronized (SystemPropertyConfigurationManager.class) {
            if (systemProperties == null) {
                systemProperties = new HashMap(4);
                substitutedVariables = new HashMap(2);
                String propertyName = "os.name";
                systemProperties.put(propertyName, System.getProperty(propertyName));
                propertyName = "user.dir";
                String propertyValue = System.getProperty(propertyName);
                userDir = MapBasedConfigurationManager.getDir(propertyValue, true);
                propertyName = "arflow.confdir";
                propertyValue = configMap.get(propertyName);
                if (propertyValue == null || propertyValue.equals("")) {
                    propertyValue = "./conf";
                }
                confDirs = ConfigurationTools.parseCSVString(propertyValue, File.pathSeparator);
                propertyName = "user.home";
                propertyValue = System.getProperty(propertyName);
                try {
                    File confDir = MapBasedConfigurationManager.getDir(String.valueOf(propertyValue) + File.separatorChar + ".aristaflow", true);
                    this.logger.info(String.format("Adding user configuration directory ('%1$s').", confDir.getAbsolutePath()));
                    String[] newConfDirs = new String[confDirs.length + 1];
                    System.arraycopy(confDirs, 0, newConfDirs, 0, confDirs.length);
                    newConfDirs[MapBasedConfigurationManager.confDirs.length] = confDir.getAbsolutePath();
                    confDirs = newConfDirs;
                }
                catch (ConfigurationException configurationException) {
                    String msg = String.format("User configuration directory ('%s') does not exist or is not defined, ignoring.", propertyValue);
                    this.logger.fine(msg);
                }
                propertyName = "arflow.logdir";
                propertyValue = configMap.get(propertyName);
                if (propertyValue == null) {
                    logDir = null;
                } else {
                    if (File.separatorChar == '\\') {
                        propertyValue = propertyValue.replaceAll("\\\\", "/");
                    }
                    logDir = MapBasedConfigurationManager.getDir(propertyValue, false);
                }
                logDirDefault = new File(userDir, "logs");
                propertyName = "arflow.datadir";
                propertyValue = configMap.get(propertyName);
                if (propertyValue == null || propertyValue.equals("")) {
                    boolean success;
                    File f = new File("./examples");
                    if (!f.exists() && !(success = f.mkdirs())) {
                        String msg = String.format("The data-directory '%s' could not be created! Aborting initialisation.", f.getAbsolutePath());
                        throw new ConfigurationException(msg);
                    }
                    propertyValue = "./examples";
                } else if (File.separatorChar == '\\') {
                    propertyValue = propertyValue.replaceAll("\\\\", "/");
                }
                systemProperties.put(propertyName, propertyValue);
                substitutedVariables.put(propertyName, propertyValue);
                propertyName = "arflow.libdir";
                propertyValue = configMap.get(propertyName);
                if (propertyValue == null || propertyValue.equals("")) {
                    propertyValue = "./lib";
                } else if (File.separatorChar == '\\') {
                    propertyValue = propertyValue.replaceAll("\\\\", "/");
                }
                systemProperties.put(propertyName, propertyValue);
                substitutedVariables.put(propertyName, propertyValue);
                propertyName = "arflow.configuration.bundle";
                propertyValue = configMap.get(propertyName);
                if (propertyValue == null || propertyValue.equals("")) {
                    propertyValue = Boolean.FALSE.toString();
                }
                loadBundleConfig = Boolean.parseBoolean(propertyValue);
                propertyName = "arflow.debug.configuration";
                propertyValue = configMap.get(propertyName);
                if (propertyValue == null || propertyValue.equals("")) {
                    propertyValue = Boolean.FALSE.toString();
                }
                debugConfig = Boolean.parseBoolean(propertyValue);
                systemProperties.put(propertyName, propertyValue);
                propertyName = "arflow.configuration.loadEagerly";
                propertyValue = configMap.get(propertyName);
                if (propertyValue == null || propertyValue.equals("")) {
                    propertyValue = Boolean.FALSE.toString();
                }
                loadConfigEagerly = Boolean.parseBoolean(propertyValue);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

