/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.registry;

import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.registry.AbstractRegistry;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.util.ConfigurationTools;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration.Configuration;

public abstract class PluginRegistry
extends AbstractRegistry {
    protected Map<String, String> defaultInstances;
    protected Map<String, Set<String>> declaredPluginTypes;

    protected PluginRegistry(Configuration configuration, Registry registry) {
        super(configuration, registry);
    }

    @Override
    protected void renewConfiguration(Configuration configuration) throws ConfigurationException {
        super.renewConfiguration(configuration);
        this.defaultInstances = new HashMap<String, String>();
        this.readDefaultInstances(configuration);
        this.declaredPluginTypes = new HashMap<String, Set<String>>();
        this.readDeclaredPlugins(configuration);
    }

    private void readDefaultInstances(Configuration configuration) {
        for (String componentType : this.componentInterfaces.keySet()) {
            String hierarchicalInstanceName;
            String key = String.format("%s.%s", "Instances", componentType);
            if (!ConfigurationTools.propertyValuePresent(configuration, key)) {
                hierarchicalInstanceName = PluginRegistry.getHierarchicalInstanceName(componentType, componentType);
            } else {
                List instances = configuration.getList(key);
                hierarchicalInstanceName = PluginRegistry.getHierarchicalInstanceName(componentType, (String)instances.get(0));
            }
            this.defaultInstances.put(componentType, hierarchicalInstanceName);
            this.logger.finer(String.format("'%1$s' is a default instance.", hierarchicalInstanceName));
        }
    }

    private void readDeclaredPlugins(Configuration configuration) throws ConfigurationException {
        for (String usingInstance : this.declaredInstances.keySet()) {
            AbstractRegistry.InstanceInformation instanceInformation = this.getInstanceInformation(usingInstance);
            Set<String> pluginTypes = this.getDeclaredPluginTypes(usingInstance, instanceInformation.componentType, configuration);
            if (pluginTypes == null) continue;
            this.declaredPluginTypes.put(usingInstance, pluginTypes);
            this.logger.finer(String.format("'%1$s' has plugin types declared: %2$s.", usingInstance, pluginTypes));
        }
    }

    private Set<String> getDeclaredPluginTypes(String usingInstanceName, String usingComponentType, Configuration configuration) throws ConfigurationException {
        List pluginTypeNames;
        HashSet<String> ret = null;
        String key = String.valueOf(PluginRegistry.getSimpleInstanceName(usingInstanceName)) + "." + "PluginTypes";
        if (ConfigurationTools.propertyValuePresent(configuration, key)) {
            pluginTypeNames = configuration.getList(key);
            ret = new HashSet<String>();
            for (String pluginTypeName : pluginTypeNames) {
                if (!this.componentInterfaces.containsKey(pluginTypeName)) {
                    String message = String.format("The component instance %s defines a plug-in type '%s', but the plug-in type has not been declared as component.", usingInstanceName, pluginTypeName);
                    throw new ConfigurationException(message);
                }
                ret.add(pluginTypeName);
            }
        }
        if (ConfigurationTools.propertyValuePresent(configuration, key = String.valueOf(usingComponentType) + "." + "PluginTypes")) {
            pluginTypeNames = configuration.getList(key);
            if (ret == null) {
                ret = new HashSet();
            }
            for (String pluginTypeName : pluginTypeNames) {
                if (!this.componentInterfaces.containsKey(pluginTypeName)) {
                    throw new ConfigurationException("");
                }
                ret.add(pluginTypeName);
            }
        }
        return ret;
    }

    protected <T> T getConfiguredPlugin(SessionToken session, String usingInstanceName, Object usingInstance, String pluginTypeName, Class<T> componentType, String pluginInstanceName) throws ConfigurationException {
        super.sessionActive(session);
        try {
            T t = this.getConfiguredPlugin(session, usingInstanceName, usingInstance, pluginTypeName, componentType, pluginInstanceName, new Class[0], new Object[0]);
            return t;
        }
        finally {
            super.sessionFinished(session);
        }
    }

    protected <T> T getConfiguredPlugin(SessionToken session, String usingInstanceName, Object usingInstance, String pluginTypeName, Class<T> componentType) throws ConfigurationException {
        super.sessionActive(session);
        try {
            String instanceName = this.defaultInstances.get(pluginTypeName);
            if (instanceName == null) {
                String msg = "No default intance declared for plugin type '%1$s'.";
                throw new ConfigurationException(String.format(msg, pluginTypeName));
            }
            String pluginInstance = PluginRegistry.getSimpleInstanceName(instanceName);
            T t = this.getConfiguredPlugin(session, usingInstanceName, usingInstance, pluginTypeName, componentType, pluginInstance, new Class[0], new Object[0]);
            return t;
        }
        finally {
            super.sessionFinished(session);
        }
    }

    protected <T> T getConfiguredPlugin(SessionToken session, String usingInstanceName, Object usingInstance, String pluginTypeName, Class<T> componentType, String pluginInstanceName, Class<?>[] additionalParameterTypes, Object[] additionalParameterValues) throws ConfigurationException {
        super.sessionActive(session);
        try {
            Set<String> pluginTypes = this.declaredPluginTypes.get(usingInstanceName);
            String hierachicalPluginName = PluginRegistry.getHierarchicalInstanceName(pluginTypeName, pluginInstanceName);
            if (pluginTypes == null) {
                String msg = "No plugin types declared for the component instance '%1$s' or its type.";
                throw new ConfigurationException(String.format(msg, usingInstanceName));
            }
            if (!pluginTypes.contains(pluginTypeName)) {
                String msg = "The plugin type '%1$s' is not declared for the component instance '%2$s' or its type.";
                throw new ConfigurationException(String.format(msg, pluginTypeName, usingInstanceName));
            }
            if (!this.declaredInstances.containsKey(hierachicalPluginName)) {
                String msg = "The requested plugin instance '%1$s' of type '%2$s' is not declared.";
                throw new ConfigurationException(String.format(msg, pluginInstanceName, componentType));
            }
            Class[] parameterTypes = new Class[additionalParameterTypes.length + 1];
            parameterTypes[0] = usingInstance.getClass();
            System.arraycopy(additionalParameterTypes, 0, parameterTypes, 1, additionalParameterTypes.length);
            Object[] parameterValues = new Object[additionalParameterTypes.length + 1];
            parameterValues[0] = usingInstance;
            System.arraycopy(additionalParameterValues, 0, parameterValues, 1, additionalParameterValues.length);
            T t = this.getObjectForInstanceName(hierachicalPluginName, componentType, parameterTypes, parameterValues);
            return t;
        }
        finally {
            super.sessionFinished(session);
        }
    }
}

