/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.registry;

import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.registry.InstanceToInstanceRegistry;
import de.aristaflow.adept2.base.registry.LocalServiceRegistry;
import de.aristaflow.adept2.base.security.SecurityManager;
import de.aristaflow.adept2.base.service.ADEPT2Service;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.model.common.ModelViewerProvider;
import java.net.URI;

public class RegistryWrapper
implements Registry {
    protected final String instanceName;
    protected final LocalServiceRegistry registry;
    protected final InstanceToInstanceRegistry modelFactoryRegistry;
    protected final ModelViewerProvider modelViewerProvider;

    protected RegistryWrapper(String instanceName, LocalServiceRegistry registry, InstanceToInstanceRegistry modelFactoryRegistry, ModelViewerProvider modelViewerProvider) {
        this.instanceName = instanceName;
        this.registry = registry;
        this.modelFactoryRegistry = modelFactoryRegistry;
        this.modelViewerProvider = modelViewerProvider;
    }

    @Override
    public <T extends ADEPT2Service> T getServiceOfType(SessionToken session, String serviceTypeName, Class<T> serviceType) throws ServiceNotKnownException {
        return this.registry.getServiceForInstance(session, this.instanceName, serviceTypeName, serviceType);
    }

    @Override
    public <T> T getModelFactory(String modelFactoryName, Class<T> modelFactoryType) throws ServiceNotKnownException {
        try {
            return this.modelFactoryRegistry.getUsedObjectForInstance(this.instanceName, modelFactoryName, modelFactoryType);
        }
        catch (ConfigurationException ce) {
            throw new ServiceNotKnownException(modelFactoryName, (Throwable)ce);
        }
    }

    @Override
    public Class<?> getModelViewerClass(String pluginID) {
        return this.modelViewerProvider.getModelViewerClass(pluginID);
    }

    @Override
    public <T> T getConfiguredPlugin(SessionToken session, Object usingInstance, String pluginTypeName, Class<T> componentType) throws ServiceNotKnownException {
        try {
            return this.registry.getConfiguredPlugin(session, this.instanceName, usingInstance, pluginTypeName, componentType);
        }
        catch (ConfigurationException ce) {
            if (ce.getCause() instanceof ServiceNotKnownException) {
                throw (ServiceNotKnownException)ce.getCause();
            }
            throw new ServiceNotKnownException(pluginTypeName, (Throwable)ce);
        }
    }

    @Override
    public <T> T getConfiguredPlugin(SessionToken session, Object usingInstance, String pluginTypeName, Class<T> componentType, String pluginInstanceName) throws ServiceNotKnownException {
        try {
            return this.registry.getConfiguredPlugin(session, this.instanceName, usingInstance, pluginTypeName, componentType, pluginInstanceName);
        }
        catch (ConfigurationException ce) {
            if (ce.getCause() instanceof ServiceNotKnownException) {
                throw (ServiceNotKnownException)ce.getCause();
            }
            throw new ServiceNotKnownException(pluginTypeName, (Throwable)ce);
        }
    }

    @Override
    public <T extends ADEPT2Service> T getService(SessionToken session, String serviceName, Class<T> serviceType) throws ServiceNotKnownException {
        return this.registry.getService(session, serviceName, serviceType);
    }

    @Override
    public <T extends ADEPT2Service> T getService(SessionToken session, URI[] serviceURIs, Class<T> serviceType) throws ServiceNotKnownException {
        return this.registry.getService(session, serviceURIs, serviceType);
    }

    @Override
    public SecurityManager getSecurityManager() {
        return this.registry.getSecurityManager();
    }

    @Override
    public String getInstanceName() {
        return this.instanceName;
    }
}

