/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.registry;

import de.aristaflow.adept2.base.registry.AbstractRegistry;
import java.net.URI;

public class ServiceInformation
extends AbstractRegistry.InstanceInformation {
    protected final URI serviceURI;
    protected final String[] exportServiceInstances;
    protected final boolean publish;

    protected static ServiceInformation createExportedLocalService(String serviceType, AbstractRegistry.InstantiationMode instantiationMode, String implementationClass, String[] exportServiceInstances, boolean publish) {
        return new ServiceInformation(serviceType, instantiationMode, implementationClass, null, exportServiceInstances, publish);
    }

    protected static ServiceInformation createNonExportedLocalService(String serviceType, AbstractRegistry.InstantiationMode instantiationMode, String implementationClass) {
        return new ServiceInformation(serviceType, instantiationMode, implementationClass, null, null, false);
    }

    protected static ServiceInformation createPublicRemoteService(String serviceType) {
        return new ServiceInformation(serviceType, AbstractRegistry.InstantiationMode.SINGLETON, null, null, null, false);
    }

    protected static ServiceInformation createPrivateRemoteService(String serviceType, URI serviceURI) {
        return new ServiceInformation(serviceType, AbstractRegistry.InstantiationMode.SINGLETON, null, serviceURI, null, false);
    }

    private ServiceInformation(String serviceType, AbstractRegistry.InstantiationMode instantiationMode, String implementationClass, URI serviceURI, String[] exportServiceInstances, boolean publish) {
        super(serviceType, instantiationMode, implementationClass);
        this.serviceURI = serviceURI;
        this.exportServiceInstances = exportServiceInstances;
        this.publish = publish;
    }

    boolean isRemote() {
        return this.implementationClass == null;
    }

    boolean isPublic() {
        return this.isRemote() && this.serviceURI == null;
    }

    boolean isExportedLocal() {
        return !this.isRemote() && this.exportServiceInstances != null && this.exportServiceInstances.length > 0;
    }
}

