/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.registry;

import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.service.ADEPT2Service;
import de.aristaflow.adept2.util.NullArgumentException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

class ServiceLoadGraph {
    protected ServiceNameResolution registry;
    protected Map<String, ServiceInfo> services;
    protected List<String> totalOrder = new ArrayList<String>();
    private boolean isBuilt = false;
    protected boolean inOutDegreesValid = false;

    public ServiceLoadGraph(ServiceNameResolution registry) {
        if (registry == null) {
            throw new NullArgumentException("The parameter 'registry' must not be null!");
        }
        this.registry = registry;
        this.services = new HashMap<String, ServiceInfo>();
    }

    public void addService(String serviceName, ADEPT2Service service) {
        if (serviceName == null) {
            throw new NullArgumentException("The parameter 'serviceName' must not be null!");
        }
        if (service == null) {
            throw new NullArgumentException("The parameter 'service' must not be null!");
        }
        if (this.isBuilt()) {
            throw new IllegalStateException("The graph is already built. No more services can be added!");
        }
        if (!this.services.containsKey(serviceName)) {
            this.services.put(serviceName, new ServiceInfo(serviceName, service));
        }
    }

    public void addServices(Map<String, ADEPT2Service> services) {
        if (services == null) {
            throw new NullArgumentException("The parameter 'services' must not be null!");
        }
        if (this.isBuilt()) {
            throw new IllegalStateException("The graph is already built. No more services can be added!");
        }
        for (Map.Entry<String, ADEPT2Service> entry : services.entrySet()) {
            this.addService(entry.getKey(), entry.getValue());
        }
    }

    private boolean isBuilt() {
        return this.isBuilt;
    }

    private void build() throws ConfigurationException {
        if (this.isBuilt()) {
            return;
        }
        ArrayList<String> queue = new ArrayList<String>();
        int nextElementIndex = 0;
        queue.addAll(this.services.keySet());
        while (nextElementIndex < queue.size()) {
            String serviceName = (String)queue.get(nextElementIndex);
            ADEPT2Service service = this.services.get((Object)serviceName).service;
            String[] stringArray = service.getStartupRequiredServices();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String usedServiceType = stringArray[n2];
                String usedServiceName = this.registry.getUsedServiceNameFor(serviceName, usedServiceType);
                ADEPT2Service usedService = this.registry.getUnstartedLocalServiceObject(usedServiceName);
                if (usedService != null) {
                    this.addService(usedServiceName, usedService);
                    if (!queue.contains(usedServiceName)) {
                        queue.add(usedServiceName);
                    }
                    ServiceInfo usedServiceDepInfo = this.services.get(usedServiceName);
                    if (!usedServiceDepInfo.outEdges.contains(serviceName)) {
                        usedServiceDepInfo.outEdges.add(serviceName);
                        ++usedServiceDepInfo.tempOutDegree;
                        ServiceInfo usingServiceDepInfo = this.services.get(serviceName);
                        usingServiceDepInfo.inEdges.add(usedServiceName);
                        ++usingServiceDepInfo.tempInDegree;
                    }
                }
                ++n2;
            }
            ++nextElementIndex;
        }
        this.isBuilt = true;
        ArrayList<String> result = new ArrayList<String>(this.services.size());
        LinkedList<ServiceInfo> nullQueue = new LinkedList<ServiceInfo>();
        Collection<ServiceInfo> values = this.services.values();
        if (!this.inOutDegreesValid) {
            this.fixInOutDegrees();
        }
        this.inOutDegreesValid = false;
        for (ServiceInfo el : values) {
            if (el.tempInDegree != 0) continue;
            nullQueue.add(el);
        }
        while (!nullQueue.isEmpty()) {
            ServiceInfo fromNode = (ServiceInfo)nullQueue.poll();
            result.add(fromNode.serviceName);
            for (String edge : fromNode.outEdges) {
                ServiceInfo toNode = this.services.get(edge);
                --toNode.tempInDegree;
                if (toNode.tempInDegree != 0) continue;
                nullQueue.add(toNode);
            }
        }
        this.totalOrder = result.size() == this.services.size() ? result : null;
    }

    private void fixInOutDegrees() {
        if (this.inOutDegreesValid) {
            return;
        }
        for (Map.Entry<String, ServiceInfo> entry : this.services.entrySet()) {
            ServiceInfo serviceInfo = entry.getValue();
            serviceInfo.tempInDegree = serviceInfo.inEdges.size();
            serviceInfo.tempOutDegree = serviceInfo.outEdges.size();
        }
        this.inOutDegreesValid = true;
    }

    public int getServiceCount() throws ConfigurationException {
        if (!this.isBuilt()) {
            this.build();
        }
        return this.services.size();
    }

    public boolean containsCycle() throws ConfigurationException {
        if (!this.isBuilt()) {
            this.build();
        }
        return this.totalOrder == null;
    }

    public List<String> getAnyCycle() throws ConfigurationException {
        if (!this.containsCycle()) {
            return null;
        }
        ArrayList<String> cycle = new ArrayList<String>();
        Stack<String> currentPath = new Stack<String>();
        for (String serviceName : this.services.keySet()) {
            boolean cycleFound = this.findCycle(serviceName, currentPath);
            if (!cycleFound) continue;
            String pivot = currentPath.peek();
            String element = currentPath.pop();
            do {
                cycle.add(element);
            } while (!(element = currentPath.pop()).equals(pivot));
            cycle.add(pivot);
            break;
        }
        return cycle;
    }

    private boolean findCycle(String serviceName, Stack<String> currentPath) {
        if (currentPath.contains(serviceName)) {
            currentPath.push(serviceName);
            return true;
        }
        currentPath.push(serviceName);
        ServiceInfo serviceInfo = this.services.get(serviceName);
        for (String usingServiceName : serviceInfo.outEdges) {
            boolean cycleFound = this.findCycle(usingServiceName, currentPath);
            if (!cycleFound) continue;
            return true;
        }
        currentPath.pop();
        return false;
    }

    public List<String> getTotalOrder() throws ConfigurationException {
        if (!this.isBuilt()) {
            this.build();
        }
        if (this.containsCycle()) {
            throw new IllegalStateException("This graph contains at least one cycle!");
        }
        return this.totalOrder;
    }

    public List<String> getTopLevelServices() throws ConfigurationException {
        if (!this.isBuilt()) {
            this.build();
        }
        if (this.containsCycle()) {
            throw new IllegalStateException("This graph contains at least one cycle!");
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, ServiceInfo> entry : this.services.entrySet()) {
            ServiceInfo serviceInfo = entry.getValue();
            if (serviceInfo.outEdges.size() != 0) continue;
            result.add(serviceInfo.serviceName);
        }
        return result;
    }

    public List<String> getBottomLevelServices() throws ConfigurationException {
        if (!this.isBuilt()) {
            this.build();
        }
        if (this.containsCycle()) {
            throw new IllegalStateException("This graph contains at least one cycle!");
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, ServiceInfo> entry : this.services.entrySet()) {
            ServiceInfo serviceInfo = entry.getValue();
            if (serviceInfo.inEdges.size() != 0) continue;
            result.add(serviceInfo.serviceName);
        }
        return result;
    }

    public List<String> getUsedServicesFor(String usingServiceName) throws ConfigurationException {
        if (!this.isBuilt()) {
            this.build();
        }
        if (this.containsCycle()) {
            throw new IllegalStateException("This graph contains at least one cycle!");
        }
        ServiceInfo serviceInfo = this.services.get(usingServiceName);
        if (serviceInfo == null) {
            throw new IllegalArgumentException(String.format("The service with the name '%s' is not part of this graph!", usingServiceName));
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String usedServiceName : serviceInfo.inEdges) {
            result.add(usedServiceName);
        }
        return result;
    }

    public synchronized List<String> serviceStarted(String startedServiceName) throws ConfigurationException {
        if (!this.isBuilt()) {
            this.build();
        }
        if (this.containsCycle()) {
            throw new IllegalStateException("This graph contains at least one cycle!");
        }
        ArrayList<String> loadableServices = new ArrayList<String>();
        if (startedServiceName != null) {
            ServiceInfo serviceInfo = this.services.get(startedServiceName);
            if (serviceInfo == null) {
                throw new IllegalArgumentException(String.format("The service with the name '%s' is not part of this graph!", startedServiceName));
            }
            serviceInfo.isLoaded = true;
            for (String usingServiceName : serviceInfo.outEdges) {
                ServiceInfo usingServiceDepInfo = this.services.get(usingServiceName);
                if (usingServiceDepInfo.isLoaded) {
                    assert (false);
                    continue;
                }
                boolean allUsedServicesLoaded = true;
                for (String usedServiceName : usingServiceDepInfo.inEdges) {
                    if (this.services.get((Object)usedServiceName).isLoaded) continue;
                    allUsedServicesLoaded = false;
                    break;
                }
                if (!allUsedServicesLoaded) continue;
                loadableServices.add(usingServiceName);
            }
        } else {
            for (Map.Entry<String, ServiceInfo> entry : this.services.entrySet()) {
                if (entry.getValue().inEdges.size() != 0) continue;
                loadableServices.add(entry.getKey());
            }
        }
        return loadableServices;
    }

    private static class ServiceInfo {
        final String serviceName;
        final ADEPT2Service service;
        boolean isLoaded = false;
        Set<String> inEdges;
        Set<String> outEdges;
        int tempInDegree;
        int tempOutDegree;

        public ServiceInfo(String serviceName, ADEPT2Service service) {
            this.serviceName = serviceName;
            this.service = service;
            this.inEdges = new HashSet<String>();
            this.outEdges = new HashSet<String>();
        }
    }

    static interface ServiceNameResolution {
        public String getUsedServiceNameFor(String var1, String var2) throws ConfigurationException;

        public ADEPT2Service getUnstartedLocalServiceObject(String var1) throws ConfigurationException;
    }
}

