/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.registry;

import de.aristaflow.adept2.base.communication.ADEPT2RemoteObjectIdentifierFactory;
import de.aristaflow.adept2.base.communication.ADEPT2ServiceExport;
import de.aristaflow.adept2.base.communication.ADEPT2StubFactory;
import de.aristaflow.adept2.base.communication.CommunicationService;
import de.aristaflow.adept2.base.configuration.ADEPT2EntityURITools;
import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.configuration.ConfigurationConstants;
import de.aristaflow.adept2.base.configuration.ConfigurationDescription;
import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.configuration.Property;
import de.aristaflow.adept2.base.globalregistry.GlobalRegistry;
import de.aristaflow.adept2.base.licensing.InvalidLicenceException;
import de.aristaflow.adept2.base.licensing.LicenceManager;
import de.aristaflow.adept2.base.registry.AbstractRegistry;
import de.aristaflow.adept2.base.registry.LocalServiceRegistry;
import de.aristaflow.adept2.base.registry.ServiceInformation;
import de.aristaflow.adept2.base.registry.ServiceLoadGraph;
import de.aristaflow.adept2.base.service.ADEPT2Service;
import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.model.common.LicenceInformation;
import de.aristaflow.adept2.util.ConfigurationTools;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.NullArgumentException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.configuration.Configuration;

@ConfigurationDescription(properties={@Property(name="CallbackCommunicationService", type=Property.Type.STRING, isRequired=true, description="The simple instance name of the communication service used for callbacks."), @Property(name="Components.GlobalRegistry", type=Property.Type.STRING, isRequired=true, description="a required sub-registry"), @Property(name="GlobalRegistry.PublishService", type=Property.Type.BOOLEAN, defaultValue="False", description="The global configuration must not be published! This is validated when checking the configuration"), @Property(name="Components.CommunicationService", type=Property.Type.STRING, isRequired=true, description="a communication service that must be configured in this registry")}, validator=ConfigurationValidator.class)
public abstract class ServiceRegistry
extends LocalServiceRegistry {
    private String callbackCommunicationService;
    protected Map<String, Integer> protocolPriority;
    private Map<CommunicationService<?, ?, ?, ?>, String> uncheckedCommunicationServices = new HashMap(2);
    private final Set<String> checkedCommunicationServices = new HashSet<String>(5);
    private volatile int licIPAddress = 0;
    private volatile int licAddressMask = 0;

    protected ServiceRegistry(Configuration configuration, Registry registry) {
        super(configuration, registry);
    }

    @Override
    protected void readMetaConfiguration(Configuration registryConfiguration, String componentType, String simpleInstanceName) throws ConfigurationException {
        ServiceInformation serviceInformation;
        String instanceName = ServiceRegistry.getHierarchicalInstanceName(componentType, simpleInstanceName);
        AbstractRegistry.InstantiationMode instantiationMode = this.getInstantiationMode(componentType, simpleInstanceName, registryConfiguration);
        String key = String.valueOf(simpleInstanceName) + "." + "Implementation";
        if (ConfigurationTools.propertyValuePresent(registryConfiguration, key)) {
            String implementingClassName = registryConfiguration.getString(key);
            this.checkImplementingClassConfiguration(instanceName, implementingClassName);
            List<String> exportServiceInstances = this.getExportServiceInstances(simpleInstanceName, registryConfiguration);
            if (this.autoStartServices.contains(simpleInstanceName)) {
                this.autoStartServices.remove(simpleInstanceName);
                this.autoStartServices.add(instanceName);
            }
            if (exportServiceInstances.size() > 0) {
                boolean publish = this.getPublishService(simpleInstanceName, registryConfiguration);
                String[] expServInst = exportServiceInstances.toArray(new String[exportServiceInstances.size()]);
                serviceInformation = ServiceInformation.createExportedLocalService(componentType, instantiationMode, implementingClassName, expServInst, publish);
            } else {
                serviceInformation = ServiceInformation.createNonExportedLocalService(componentType, instantiationMode, implementingClassName);
            }
        } else {
            URI serviceURI = this.getServiceURI(simpleInstanceName, registryConfiguration);
            serviceInformation = serviceURI != null ? ServiceInformation.createPrivateRemoteService(componentType, serviceURI) : ServiceInformation.createPublicRemoteService(componentType);
        }
        this.declaredInstances.put(instanceName, serviceInformation);
        StringBuilder logMessage = new StringBuilder("Service '%1$s' ");
        if (serviceInformation.isExportedLocal()) {
            logMessage.append("to be exported and ");
            if (!serviceInformation.publish) {
                logMessage.append("not ");
            }
            logMessage.append("published in global registry.");
        } else {
            logMessage.append("not to be exported.");
        }
        this.logger.fine(String.format(logMessage.toString(), instanceName));
    }

    private List<String> getExportServiceInstances(String simpleServiceName, Configuration registryConfiguration) {
        String key = String.valueOf(simpleServiceName) + "." + "ExportVia";
        return registryConfiguration.getList(key);
    }

    private boolean getPublishService(String simpleServiceName, Configuration registryConfiguration) {
        boolean ret = false;
        String key = String.valueOf(simpleServiceName) + "." + "PublishService";
        if (ConfigurationTools.propertyValuePresent(this.configuration, key)) {
            ret = registryConfiguration.getBoolean(key);
        }
        return ret;
    }

    private URI getServiceURI(String simpleServiceName, Configuration registryConfiguration) throws ConfigurationException {
        String key = String.valueOf(simpleServiceName) + "." + "ServiceURI";
        URI ret = null;
        if (ConfigurationTools.propertyValuePresent(registryConfiguration, key)) {
            try {
                ret = new URI(registryConfiguration.getString(key));
            }
            catch (URISyntaxException use) {
                String message = String.format("The specified URI ('%1$s') for service '%2$s' has an illegal syntax in the configuration file.", registryConfiguration.getProperty(key), simpleServiceName);
                this.logger.log(Level.SEVERE, message, use);
                throw new ConfigurationException(message, use);
            }
        }
        return ret;
    }

    protected void initExportServices(SessionToken session) throws AbortServiceException {
        HashMap<String, ADEPT2Service> exportedLocalServices = new HashMap<String, ADEPT2Service>();
        for (String serviceName : this.declaredInstances.keySet()) {
            ServiceInformation serviceInformation = this.getInstanceInformation(serviceName);
            if (!serviceInformation.isExportedLocal()) continue;
            exportedLocalServices.put(serviceName, this.getLocalServiceObject(session, serviceName, ADEPT2Service.class));
        }
        ServiceLoadGraph loadGraph = new ServiceLoadGraph(new LocalServiceRegistry.ServiceNameResolution(this.sessionFactory.getChildSession(session, this.getURIs())));
        loadGraph.addServices(exportedLocalServices);
        if (loadGraph.containsCycle()) {
            StringBuilder cycle = new StringBuilder();
            for (String cyclicService : loadGraph.getAnyCycle()) {
                cycle.append('\'');
                cycle.append(cyclicService);
                cycle.append('\'');
                cycle.append(" -> ");
            }
            cycle.delete(cycle.length() - 4, cycle.length());
            String message = String.format("The services to export can not be started since they have at least one cycle in their required-dependency: %1$s", cycle);
            this.logger.severe(message);
            throw new ConfigurationException(message);
        }
        List<String> topLevelServices = loadGraph.getTopLevelServices();
        LocalServiceRegistry.ServiceStarter[] serviceStarters = new LocalServiceRegistry.ServiceStarter[topLevelServices.size()];
        final SessionToken subSession = this.sessionFactory.getChildSession(session, this.getURIs());
        int i = 0;
        while (i < topLevelServices.size()) {
            final String topLevelService = topLevelServices.get(i);
            serviceStarters[i] = new LocalServiceRegistry.ServiceStarter(){

                @Override
                public String getServiceName() {
                    return topLevelService;
                }

                @Override
                public Boolean call() throws ServiceNotKnownException {
                    ServiceRegistry.this.getService(subSession, topLevelService, ADEPT2Service.class);
                    return Boolean.TRUE;
                }
            };
            ++i;
        }
        try {
            this.syncExecute(serviceStarters);
        }
        catch (ExecutionException ee) {
            String message = String.format("An exception occurred while starting one exported or required service. Aborting start.", new Object[0]);
            this.logger.log(Level.SEVERE, message, ee.getCause());
            throw new AbortServiceException(message, ee.getCause());
        }
        this.logger.info("Initialised, started and exported all exported services.");
    }

    @Override
    protected LocalServiceRegistry.ServiceExportInformation prepareExport(SessionToken session, String serviceName, ADEPT2Service service) throws AbortServiceException {
        super.sessionActive(session);
        try {
            LocalServiceRegistry.ServiceExportInformation ret;
            ServiceInformation serviceInformation = this.getInstanceInformation(serviceName);
            if (serviceInformation.isExportedLocal()) {
                String simpleServiceName = ServiceRegistry.getSimpleInstanceName(serviceName);
                String serviceTypeName = this.getComponentType(serviceName);
                Class<?> serviceType = this.getInterfaceForComponentType(serviceTypeName);
                ADEPT2ServiceExport[] serviceExports = new ADEPT2ServiceExport[serviceInformation.exportServiceInstances.length];
                URI[] serviceURIs = new URI[serviceInformation.exportServiceInstances.length];
                int i = 0;
                while (i < serviceInformation.exportServiceInstances.length) {
                    CommunicationService<?, ?, ?, ?> communication;
                    try {
                        communication = this.getCommunicationService(session, serviceInformation.exportServiceInstances[i]);
                    }
                    catch (ServiceNotKnownException snke) {
                        if (snke.getCause() instanceof ConfigurationException) {
                            throw (ConfigurationException)snke.getCause();
                        }
                        String msg = String.format("Could not retrieve communication service '%s' since it is unknown. Strangely, this is not caused by a ConfigurationException although it should.", serviceInformation.exportServiceInstances[i]);
                        throw new ConfigurationException(msg, snke);
                    }
                    serviceExports[i] = communication.getADEPT2ServiceExport();
                    serviceURIs[i] = serviceExports[i].prepareServiceExport(serviceTypeName, simpleServiceName, serviceType);
                    ++i;
                }
                ret = new LocalServiceRegistry.ServiceExportInformation(serviceExports, serviceURIs, serviceInformation.publish);
            } else {
                ret = super.prepareExport(session, serviceName, service);
            }
            LocalServiceRegistry.ServiceExportInformation serviceExportInformation = ret;
            return serviceExportInformation;
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    protected void exportService(SessionToken session, String serviceName, ADEPT2Service service, LocalServiceRegistry.ServiceExportInformation serviceExportInformation) throws AbortServiceException {
        super.sessionActive(session);
        try {
            if (serviceExportInformation.isExported()) {
                String msg;
                String simpleServiceName = ServiceRegistry.getSimpleInstanceName(serviceName);
                String serviceTypeName = this.getComponentType(serviceName);
                Class<?> serviceType = this.getInterfaceForComponentType(serviceTypeName);
                ArrayList<URI> uriList = new ArrayList<URI>(serviceExportInformation.serviceURIs.length);
                int i = 0;
                while (i < serviceExportInformation.serviceExports.length) {
                    ADEPT2ServiceExport export = serviceExportInformation.serviceExports[i];
                    export.exportService(serviceExportInformation.serviceURIs[i], serviceType, service);
                    uriList.add(serviceExportInformation.serviceURIs[i]);
                    msg = String.format("Service '%s' is available via '%s'.", serviceName, serviceExportInformation.serviceURIs[i]);
                    this.logger.info(msg);
                    System.out.println(msg);
                    ++i;
                }
                if (serviceExportInformation.publish) {
                    this.getGlobalRegistry(session).registerService(serviceTypeName, simpleServiceName, uriList);
                    msg = String.format("Service '%s' has been published", serviceName);
                    this.logger.info(msg);
                    System.out.println(msg);
                }
            }
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    protected void unpublishService(SessionToken session, String serviceName) {
        ServiceInformation information = (ServiceInformation)this.declaredInstances.get(serviceName);
        if (information != null && information.publish) {
            String simpleServiceName = ServiceRegistry.getSimpleInstanceName(serviceName);
            String serviceTypeName = this.getComponentType(serviceName);
            this.getGlobalRegistry(session).deRegisterService(serviceTypeName, simpleServiceName);
        }
    }

    private <T extends ADEPT2Service> T getServiceStub(SessionToken session, URI serviceURI, Class<T> serviceType) throws ServiceNotKnownException {
        super.sessionActive(session);
        try {
            String communicationServiceName = serviceURI.getScheme();
            CommunicationService<?, ?, ?, ?> communication = this.getCommunicationService(session, communicationServiceName);
            ADEPT2StubFactory<ADEPT2Service> stubFactory = communication.getADEPT2ServiceStubFactory();
            this.logger.fine(String.format("Creating a stub for service '%s', with the expected type '%s', using the stub factory implementation '%s'.", serviceURI, serviceType, stubFactory));
            ADEPT2Service aDEPT2Service = (ADEPT2Service)stubFactory.getServiceStub(serviceURI, serviceType);
            return (T)aDEPT2Service;
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    protected void autoStartServices() throws AbortServiceException {
        SessionToken session = this.sessionFactory.getSessionToken(this.getURIs());
        this.getCommunicationService(session, this.callbackCommunicationService);
        try {
            this.getGlobalRegistry(session);
        }
        catch (InternalServiceException ise) {
            throw new AbortServiceException("The Global Registry is not available.", ise);
        }
        try {
            this.initLicenceManager(session);
        }
        catch (InvalidLicenceException ile) {
            throw new AbortServiceException(ile);
        }
        super.autoStartServices();
        for (String serviceName : this.declaredInstances.keySet()) {
            ServiceInformation serviceInformation = this.getInstanceInformation(serviceName);
            if (!serviceInformation.isRemote() || serviceInformation.isPublic()) continue;
            try {
                this.checkServiceURI(session, serviceInformation.serviceURI);
            }
            catch (IllegalArgumentException iae) {
                String message = String.format("The specified URI ('%s') for service '%s' has an illegal syntax in the configuration file. Shutting down registry since the service will not be available.", serviceInformation.serviceURI, serviceName);
                this.logger.log(Level.SEVERE, message, iae);
                throw new AbortServiceException(message, iae);
            }
        }
        this.initExportServices(session);
    }

    @Override
    public <T extends ADEPT2Service> T getService(SessionToken session, String serviceName, Class<T> serviceType) throws ServiceNotKnownException {
        super.sessionActive(session);
        try {
            URI[] serviceURIs;
            ServiceInformation serviceInformation = this.getInstanceInformation(serviceName);
            if (serviceInformation != null && !serviceInformation.isRemote()) {
                try {
                    this.checkSupertype(serviceName, ADEPT2Service.class, serviceType);
                }
                catch (ConfigurationException ce) {
                    String message = String.format("The requested service type interface '%1$s' is not compatible with ADEPT2Service.", serviceType);
                    this.logger.warning(message);
                    throw new IllegalArgumentException(message, ce);
                }
                T localService = super.getService(this.sessionFactory.getChildSession(session, this.getURIs()), serviceName, serviceType);
                ADEPT2Service aDEPT2Service = (ADEPT2Service)serviceType.cast(localService);
                return (T)aDEPT2Service;
            }
            if (serviceInformation != null && !serviceInformation.isPublic()) {
                serviceURIs = new URI[]{serviceInformation.serviceURI};
            } else {
                List<URI> serviceURIList = this.getGlobalRegistry(session).getService(this.getComponentType(serviceName), ServiceRegistry.getSimpleInstanceName(serviceName));
                serviceURIs = serviceURIList.toArray(new URI[serviceURIList.size()]);
            }
            T t = this.getService(session, serviceURIs, serviceType);
            return t;
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public <T extends ADEPT2Service> T getService(SessionToken session, URI[] serviceURIs, Class<T> serviceType) throws ServiceNotKnownException {
        if (serviceURIs == null || serviceURIs.length == 0 || serviceType == null) {
            String msg = "Neither of the arguments may be null. serviceURIs='%1$s', serviceType='%2$s'";
            this.logger.warning(String.format(msg, Arrays.toString(serviceURIs), serviceType));
            throw new NullArgumentException(msg);
        }
        super.sessionActive(session);
        try {
            Object ret;
            SessionToken subSession = this.sessionFactory.getChildSession(session, serviceURIs);
            URI serviceURI = this.chooseAppropriateURI(serviceURIs);
            if (serviceURI == null) {
                String msg = String.format("Can not retrieve service with URIs '%s' since there is no appropriate communication service configured for this registry.", Arrays.toString(serviceURIs));
                throw new ServiceNotKnownException(serviceURIs, msg);
            }
            this.checkServiceURI(session, serviceURI);
            this.logger.fine(String.format("Service with URI '%1$s' requested, expected type: '%2$s'", serviceURI, serviceType));
            if (serviceURI.getScheme().equals(ConfigurationConstants.CommunicationProtocol.COMM_LOCAL.getScheme())) {
                ret = super.getService(subSession, serviceURIs, serviceType);
            } else {
                String communicationServiceName;
                subSession = this.sessionFactory.getChildSession(session, serviceURIs);
                ADEPT2ServiceExport serviceExport = this.getCommunicationService(subSession, communicationServiceName = serviceURI.getScheme()).getADEPT2ServiceExport();
                if (serviceExport.isRegisteredService(serviceURI)) {
                    Class<?> exportedServiceInterface = serviceExport.getRemoteInterfaceForExportedService(serviceURI);
                    try {
                        this.checkSupertype(this.getInstanceNameFromServiceURI(serviceURI), serviceType, exportedServiceInterface);
                    }
                    catch (ConfigurationException ce) {
                        throw new ServiceNotKnownException(serviceURIs, (Throwable)ce);
                    }
                    ret = (ADEPT2Service)serviceType.cast(serviceExport.getExportedService(serviceURI));
                } else {
                    ret = this.getServiceStub(subSession, serviceURI, serviceType);
                }
            }
            T t = ret;
            return t;
        }
        finally {
            super.sessionFinished(session);
        }
    }

    @Override
    public void init(URI[] myURIs) throws AbortServiceException {
        super.init(myURIs);
        this.callbackCommunicationService = this.configuration.getString("CallbackCommunicationService");
        String propertyName = String.format("%s.%s", "Instances", "CommunicationService");
        this.protocolPriority = this.prioritiseProtocols(this.configuration.getList(propertyName));
    }

    @Override
    public void start() throws AbortServiceException {
        super.start();
    }

    @Override
    protected ServiceInformation getInstanceInformation(String instanceName) {
        ServiceInformation ret;
        try {
            ret = super.getInstanceInformation(instanceName);
        }
        catch (ConfigurationException configurationException) {
            ret = null;
        }
        return ret;
    }

    @Override
    protected <T extends ADEPT2Service> T getLocalServiceObject(SessionToken session, String serviceName, Class<T> requestedType) throws ConfigurationException {
        super.sessionActive(session);
        try {
            ServiceInformation serviceInformation = this.getInstanceInformation(serviceName);
            T ret = serviceInformation != null && !serviceInformation.isRemote() ? (T)super.getLocalServiceObject(session, serviceName, requestedType) : null;
            T t = ret;
            return t;
        }
        finally {
            super.sessionFinished(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initLicenceManager(SessionToken session) throws InvalidLicenceException, ServiceNotKnownException {
        try {
            String hierachicalInstanceName = (String)this.defaultInstances.get("LicenceManager");
            LicenceManager lMgr = this.getStartupIgnoredService(session, this.getComponentType(hierachicalInstanceName), ServiceRegistry.getSimpleInstanceName(hierachicalInstanceName), LicenceManager.class);
            ServiceInformation information = this.getInstanceInformation(hierachicalInstanceName);
            if (information != null && information.getImplementationClass() != null) {
                lMgr.setViolationShutdown(session, this);
            }
            LicenceInformation licInformation = lMgr.getLicenceInformation(session);
            this.licIPAddress = licInformation.getIPAddressLimit();
            this.licAddressMask = licInformation.getIPAddressMask();
            Set<String> set = this.checkedCommunicationServices;
            synchronized (set) {
                if (information != null && information.getImplementationClass() != null) {
                    lMgr.setViolationShutdown(session, this);
                    for (Map.Entry<CommunicationService<?, ?, ?, ?>, String> comm : this.uncheckedCommunicationServices.entrySet()) {
                        this.checkIPAddress(comm.getKey().getListeningAddress(), comm.getValue());
                        this.checkedCommunicationServices.add(comm.getValue());
                    }
                }
                this.uncheckedCommunicationServices = null;
            }
        }
        catch (ServiceNotKnownException snke) {
            AbortServiceException innerASE;
            if (snke.getCause() instanceof AbortServiceException && (innerASE = (AbortServiceException)snke.getCause()).getCause() instanceof InvalidLicenceException) {
                throw (InvalidLicenceException)innerASE.getCause();
            }
            throw snke;
        }
    }

    private void checkIPAddress(InetAddress address, String commInstance) throws InvalidLicenceException {
        if (this.licIPAddress != 0) {
            int mask = -1;
            int intAddress = 0;
            if (this.licAddressMask < 32) {
                mask = ~(-1 >>> this.licAddressMask);
            }
            byte[] byteAddress = address.getAddress();
            int i = 0;
            while (i < address.getAddress().length) {
                intAddress <<= 8;
                intAddress |= byteAddress[i] & 0xFF;
                ++i;
            }
            if ((mask & intAddress) != (mask & this.licIPAddress) && (0xFF000000 & intAddress) != 0x7F000000) {
                String msg = "Your licence is not valid for the IP address '%s' of the communication service '%s'. Aborting.";
                throw new InvalidLicenceException(String.format(msg, address, commInstance), 10000);
            }
        }
    }

    private GlobalRegistry getGlobalRegistry(SessionToken session) {
        try {
            String hierachicalInstanceName = (String)this.defaultInstances.get("GlobalRegistry");
            return this.getStartupIgnoredService(session, this.getComponentType(hierachicalInstanceName), ServiceRegistry.getSimpleInstanceName(hierachicalInstanceName), GlobalRegistry.class);
        }
        catch (ServiceNotKnownException snke) {
            String msg = "Could not retrieve global registry. This is a major problem, since we have checked its presence while starting this registry. It seems the global registry has become unavailable.";
            throw new InternalServiceException(msg, snke);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CommunicationService<?, ?, ?, ?> getCommunicationService(SessionToken session, String simpleInstanceName) throws ServiceNotKnownException {
        CommunicationService ret = this.getStartupIgnoredService(session, "CommunicationService", simpleInstanceName, CommunicationService.class);
        boolean checkNow = false;
        Set<String> set = this.checkedCommunicationServices;
        synchronized (set) {
            if (this.uncheckedCommunicationServices != null) {
                this.uncheckedCommunicationServices.put(ret, simpleInstanceName);
            } else {
                checkNow = !this.checkedCommunicationServices.contains(simpleInstanceName);
            }
        }
        if (checkNow) {
            try {
                this.checkIPAddress(ret.getListeningAddress(), simpleInstanceName);
                this.checkedCommunicationServices.add(simpleInstanceName);
            }
            catch (InvalidLicenceException ile) {
                String msg = String.format("Could not start communication service '%s' since the licence does not allow the service to listen on the configured IP-addresses '%s'. You adapt the configuration of the communication service.", simpleInstanceName, ret.getListeningAddress());
                throw new ServiceNotKnownException(msg, (Throwable)ile);
            }
        }
        return ret;
    }

    private <T extends ADEPT2Service> T getStartupIgnoredService(SessionToken session, String serviceTypeName, String simpleInstanceName, Class<T> serviceType) throws ServiceNotKnownException {
        Stack startupStack = (Stack)this.startingRequiredServices.get();
        if (startupStack != null && startupStack.peek() != null) {
            ArrayList<String> requiredServices = new ArrayList<String>(Arrays.asList((String[])startupStack.pop()));
            if (!requiredServices.contains(serviceTypeName)) {
                requiredServices.add(serviceTypeName);
            }
            startupStack.push(requiredServices.toArray(new String[requiredServices.size()]));
        }
        return this.getService(session, ServiceRegistry.getHierarchicalInstanceName(serviceTypeName, simpleInstanceName), serviceType);
    }

    protected <T extends ADEPT2Service> T getServiceForEntity(SessionToken session, URI entityURI, Class<T> serviceType) throws ServiceNotKnownException {
        String serviceInstance = ADEPT2EntityURITools.getServiceInstance(entityURI);
        return this.getService(session, serviceInstance, serviceType);
    }

    @Override
    protected void checkServiceURI(SessionToken session, URI serviceURI) throws ServiceNotKnownException {
        if (serviceURI.getScheme().equals(ConfigurationConstants.CommunicationProtocol.COMM_LOCAL.getScheme())) {
            super.checkServiceURI(session, serviceURI);
        } else {
            String communicationServiceName = serviceURI.getScheme();
            CommunicationService<?, ?, ?, ?> communicationService = this.getCommunicationService(session, communicationServiceName);
            ADEPT2RemoteObjectIdentifierFactory roiFactory = communicationService.getADEPT2RemoteObjectIdentifierFactory();
            roiFactory.checkServiceURI(serviceURI);
        }
    }

    protected Map<String, Integer> prioritiseProtocols(List<String> protocolNames) {
        HashMap<String, Integer> ret = new HashMap<String, Integer>(protocolNames.size() + 1);
        int unsupportedProtocolPriority = ConfigurationConstants.CommunicationProtocol.values().length;
        ret.put(ConfigurationConstants.CommunicationProtocol.COMM_LOCAL.getScheme(), ConfigurationConstants.CommunicationProtocol.COMM_LOCAL.ordinal());
        for (String protocol : protocolNames) {
            try {
                ConfigurationConstants.CommunicationProtocol supportedProtocol = ConfigurationConstants.CommunicationProtocol.fromString(protocol);
                ret.put(protocol, supportedProtocol.ordinal());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ret.put(protocol, unsupportedProtocolPriority++);
            }
        }
        return ret;
    }

    @Override
    protected URI chooseAppropriateURI(URI[] serviceURIs) {
        URI ret = null;
        int lowest = Integer.MAX_VALUE;
        URI[] uRIArray = serviceURIs;
        int n = serviceURIs.length;
        int n2 = 0;
        while (n2 < n) {
            int priority;
            URI uri = uRIArray[n2];
            String scheme = uri.getScheme();
            if (this.protocolPriority.containsKey(scheme) && (priority = this.protocolPriority.get(scheme).intValue()) < lowest) {
                lowest = priority;
                ret = uri;
            }
            ++n2;
        }
        return ret;
    }

    @Override
    public String getInstanceNameFromServiceURI(URI serviceURI) throws ServiceNotKnownException {
        String ret;
        if (serviceURI.getScheme().equals(ConfigurationConstants.CommunicationProtocol.COMM_LOCAL.getScheme())) {
            ret = super.getInstanceNameFromServiceURI(serviceURI);
        } else {
            String communicationServiceName = serviceURI.getScheme();
            SessionToken session = this.sessionFactory.getSessionToken(this.getURIs());
            CommunicationService<?, ?, ?, ?> communicationService = this.getCommunicationService(session, communicationServiceName);
            ADEPT2RemoteObjectIdentifierFactory roiFactory = communicationService.getADEPT2RemoteObjectIdentifierFactory();
            ret = roiFactory.getInstanceNameFromServiceURI(serviceURI);
        }
        return ret;
    }

    public static class ConfigurationValidator
    extends LocalServiceRegistry.ConfigurationValidator {
        protected void checkLicenceManager(Configuration configuration) throws ConfigurationException {
            String msg;
            String key = "LicenceManager.Implementation";
            if (ConfigurationTools.propertyValuePresent(configuration, key)) {
                key = "LicenceManager.PublishService";
                if (ConfigurationTools.propertyValuePresent(configuration, key) && configuration.getBoolean(key)) {
                    key = "LicenceManager.ExportVia";
                    if (!ConfigurationTools.propertyValuePresent(configuration, key)) {
                        this.rebukeIllegalValue(configuration, "ExportVia", "The licence manager is published and therefore needs to be exported! Set 'ExportVia' to an appropriate instance of a communication service.");
                    }
                } else {
                    Logger logger = LoggerTools.getLogger(ServiceRegistry.class);
                    logger.warning("The licence manager is not published. This does not provide licences to other services. The licence manager should be published by setting '" + key + "'to 'true'.");
                }
            }
            if (ConfigurationTools.propertyValuePresent(configuration, "LicenceManager.ServiceURI")) {
                msg = "A licence manager needs to be a local or a published service. The property 'ServiceURI' is not allowed for it.";
                this.rebukeIllegalValue(configuration, "ServiceURI", msg);
            }
            if (ConfigurationTools.propertyValuePresent(configuration, key = "Instances.LicenceManager")) {
                msg = "A licence manager must only have the anonymous instance. Remove the explicit declared one(s).";
                this.rebukeIllegalValue(configuration, key, msg);
            }
        }

        @Override
        protected void validate(Configuration configuration) throws ConfigurationException {
            String key;
            if (ConfigurationTools.propertyValuePresent(configuration, "GlobalRegistry.Implementation")) {
                if (ConfigurationTools.propertyValuePresent(configuration, "GlobalRegistry.ExportVia")) {
                    boolean publishService;
                    key = "GlobalRegistry.PublishService";
                    if (ConfigurationTools.propertyValuePresent(configuration, key) && (publishService = configuration.getBoolean(key))) {
                        this.rebukeIllegalValue(configuration, "PublishService", "global registry is an exported local service, but must not be published");
                    }
                    this.checkLicenceManager(configuration);
                } else {
                    Logger logger = LoggerTools.getLogger(ServiceRegistry.class);
                    logger.warning("The global registry is a non-exported local service. At least one service export should be provided.");
                }
            } else if (!ConfigurationTools.propertyValuePresent(configuration, "GlobalRegistry.ServiceURI")) {
                this.rebuke("Either the property 'Implementation' or 'ServiceURI' must be specified for the service 'GlobalRegistry' !");
            }
            key = "Instances.GlobalRegistry";
            if (ConfigurationTools.propertyValuePresent(configuration, key)) {
                String msg = "A global registry must only have the anonymous instance. Remove the explicit declared one(s).";
                this.rebukeIllegalValue(configuration, key, msg);
            }
            this.checkForNonExportedLocal(configuration, "CommunicationService");
            String communicationServiceInstances = configuration.getString("CallbackCommunicationService");
            String[] stringArray = ConfigurationTools.parseCSVString(communicationServiceInstances, ",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String communicationServiceInstance = stringArray[n2];
                if (!ConfigurationTools.propertyValuePresent(configuration, String.valueOf(communicationServiceInstance) + "." + "Implementation")) {
                    this.rebukeMissingValue(String.valueOf(communicationServiceInstance) + "." + "Implementation");
                }
                ++n2;
            }
        }
    }
}

