/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.registry;

import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.configuration.ConfigurationManager;
import de.aristaflow.adept2.base.configuration.SystemProperties;
import de.aristaflow.adept2.base.configuration.SystemPropertyConfigurationManager;
import de.aristaflow.adept2.base.registry.FileConfigurationManager;
import de.aristaflow.adept2.base.registry.LoggerInitialisation;
import java.io.File;
import java.util.Iterator;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;

public class StandAloneFileConfigurationManager
extends SystemPropertyConfigurationManager<String> {
    private StandAloneFileConfigurationManager(String rootConfigurationFile) throws ConfigurationException {
        super(rootConfigurationFile);
        if (this.getBootConfigurationManager() != this) {
            String msg = "The boot configuration manager has already been set and must not be created a second time. Aborting creation of it.";
            throw new ConfigurationException(msg);
        }
        Configuration loggerConfiguration = this.getRootConfiguration().subset("Logging");
        LoggerInitialisation.initialiseConsoleHandler(loggerConfiguration);
        LoggerInitialisation.initialiseFileLogging(loggerConfiguration, StandAloneFileConfigurationManager.getLogDir(), StandAloneFileConfigurationManager.getLogDirDefault());
        this.logger.info("\n---------------------------------------------------------------------\n-----------    Bootstrapping initialised successfully.    -----------\n---------------------------------------------------------------------");
    }

    @Override
    protected Configuration initFileBasedRootConfiguration(String rootConfigurationFile) throws ConfigurationException {
        CompositeConfiguration ret;
        CompositeConfiguration root = this.loadConfigurationFromFile(rootConfigurationFile);
        if (this.getEagerConfigurationLoading() || SystemProperties.getDebugConfig()) {
            ret = this.loadReferencedConfigurations((AbstractConfiguration)root);
            if (SystemProperties.getDebugConfig()) {
                StringBuilder confDump = new StringBuilder("Configuration Dump:\n");
                Iterator keys = ret.getKeys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    confDump.append(key);
                    confDump.append(" = ");
                    confDump.append(ret.getProperty(key));
                    confDump.append('\n');
                }
                this.logger.info(confDump.toString());
            }
        } else {
            ret = root;
        }
        return ret;
    }

    public static ConfigurationManager<String> initialiseConfigurationManager(String rootConfigurationFile) throws ConfigurationException {
        LoggerInitialisation.initialiseDebugLogging(StandAloneFileConfigurationManager.getDebugConfig());
        return new StandAloneFileConfigurationManager(rootConfigurationFile);
    }

    @Override
    public ConfigurationManager<? extends Configuration> createChild(Configuration configuration) throws ConfigurationException {
        String[] configDirectories = new String[this.configDirectories.size()];
        int i = 0;
        while (i < configDirectories.length) {
            configDirectories[i] = ((File)this.configDirectories.get(i)).getPath();
            ++i;
        }
        return new FileConfigurationManager(configuration, configDirectories);
    }
}

