/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.security.callbackhandler;

import de.aristaflow.adept2.base.security.AFCallbackHandler;
import de.aristaflow.adept2.base.security.callbacks.AppNameCallback;
import de.aristaflow.adept2.base.security.callbacks.OrgPositionChoiceCallback;
import de.aristaflow.adept2.base.security.callbacks.UserSessionIDCallback;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.util.ArgChecks;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class NameOrgPosSesIDAppNameHandler
implements AFCallbackHandler {
    private final String userName;
    private final Collection<QualifiedAgent> agents;
    private final String appName;
    private final String userSessionID;

    public NameOrgPosSesIDAppNameHandler(String userName, Collection<QualifiedAgent> agents, String appName, String userSessionID) {
        ArgChecks.checkForBlank(userName, "userName");
        ArgChecks.checkForEmpty(agents, "agents");
        this.userName = userName;
        for (QualifiedAgent agent : agents) {
            if (userName.equals(agent.getAgentUserName())) continue;
            String msg = "All agents must have the same user name and ID!";
            throw new IllegalArgumentException(msg);
        }
        this.agents = new ArrayList<QualifiedAgent>(agents);
        this.appName = appName;
        this.userSessionID = userSessionID;
    }

    public NameOrgPosSesIDAppNameHandler(Collection<QualifiedAgent> agents, String appName, String userSessionID) {
        this(agents.iterator().next().getAgentUserName(), agents, appName, userSessionID);
    }

    @Override
    public Callback[] handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        Callback[] callbackArray = callbacks;
        int n = callbacks.length;
        int n2 = 0;
        while (n2 < n) {
            Callback callback = callbackArray[n2];
            if (callback instanceof AppNameCallback) {
                if (this.appName != null) {
                    ((NameCallback)callback).setName(this.appName);
                }
            } else if (callback instanceof NameCallback) {
                ((NameCallback)callback).setName(this.userName);
            } else if (callback instanceof OrgPositionChoiceCallback) {
                for (QualifiedAgent agent : this.agents) {
                    ((OrgPositionChoiceCallback)callback).addSelection(agent);
                }
            } else if (callback instanceof UserSessionIDCallback && this.userSessionID != null) {
                UserSessionIDCallback usic = (UserSessionIDCallback)callback;
                for (QualifiedAgent cbAgent : usic.getAgents()) {
                    if (!this.agents.contains(cbAgent)) continue;
                    usic.setUserSessionID(cbAgent, this.userSessionID);
                }
            }
            ++n2;
        }
        return callbacks;
    }
}

