/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.security.callbacks;

import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.security.auth.callback.ChoiceCallback;

public class OrgPositionChoiceCallback
extends ChoiceCallback {
    private static final long serialVersionUID = -1475084985736873389L;
    protected final List<QualifiedAgent> agents;

    public OrgPositionChoiceCallback(List<QualifiedAgent> agents, boolean multipleOrgPosAllowed) {
        super("Please choose the organisational position(s) you want to logon for!", OrgPositionChoiceCallback.getOrgPositions(agents), 0, multipleOrgPosAllowed);
        this.agents = Collections.unmodifiableList(new ArrayList<QualifiedAgent>(agents));
    }

    public List<QualifiedAgent> getAgents() {
        return this.agents;
    }

    public void addSelection(QualifiedAgent agent) {
        int i = this.agents.indexOf(agent);
        if (i > -1) {
            int[] selected = this.getSelectedIndexes();
            if (this.allowMultipleSelections() && selected != null) {
                int[] newSelected = new int[selected.length + 1];
                System.arraycopy(selected, 0, newSelected, 0, selected.length);
                newSelected[selected.length] = i;
                this.setSelectedIndexes(newSelected);
            } else {
                this.setSelectedIndex(i);
            }
        }
    }

    public long[] getSelectedOrgPositionIDs() {
        int[] selected = super.getSelectedIndexes();
        long[] ret = new long[selected.length];
        int i = 0;
        while (i < selected.length) {
            ret[i] = this.agents.get(selected[i]).getOrgPositionID();
            ++i;
        }
        return ret;
    }

    public List<QualifiedAgent> getSelectedAgentsIDs() {
        int[] selected = super.getSelectedIndexes();
        ArrayList<QualifiedAgent> ret = new ArrayList<QualifiedAgent>(selected.length);
        int i = 0;
        while (i < selected.length) {
            ret.add(this.agents.get(selected[i]));
            ++i;
        }
        return ret;
    }

    protected static String[] getOrgPositions(List<QualifiedAgent> agents) {
        String[] ret = new String[agents.size()];
        int i = 0;
        while (i < agents.size()) {
            QualifiedAgent agent = agents.get(i);
            ret[i] = agent.getOrgPositionName();
            ++i;
        }
        return ret;
    }
}

