/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.security.callbacks;

import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.Callback;

public class UserSessionIDCallback
implements Callback,
Serializable {
    private static final long serialVersionUID = -1208269182309212102L;
    protected final List<QualifiedAgent> agents;
    protected final Map<QualifiedAgent, String> sessionIDs;

    public UserSessionIDCallback(List<QualifiedAgent> agents) {
        this.agents = Collections.unmodifiableList(agents);
        this.sessionIDs = new HashMap<QualifiedAgent, String>(agents.size());
    }

    public List<QualifiedAgent> getAgents() {
        return this.agents;
    }

    public void setUserSessionID(QualifiedAgent agent, String userSessionID) {
        if (!this.agents.contains(agent)) {
            String msg = "Cannot set the user session ID '%s' for agent '%s' since the agent is invalid with respect to this authentication.";
            throw new IllegalArgumentException(String.format(msg, userSessionID, agent));
        }
        this.sessionIDs.put(agent, userSessionID);
    }

    public String getUserSessionID(QualifiedAgent agent) {
        return this.sessionIDs.get(agent);
    }
}

