/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.service;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.configuration.ConfigurationDescription;
import de.aristaflow.adept2.base.configuration.Property;
import de.aristaflow.adept2.base.security.AuthenticationException;
import de.aristaflow.adept2.base.service.ADEPT2Service;
import de.aristaflow.adept2.base.service.DebugLogger;
import de.aristaflow.adept2.base.service.InvalidServiceStateException;
import de.aristaflow.adept2.base.service.LogService;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceAccessControlException;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SecurityTokenIntegrityException;
import de.aristaflow.adept2.base.sessionmanagement.SessionFactory;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.Pair;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Logger;
import org.apache.commons.configuration.Configuration;

@ConfigurationDescription(properties={@Property(name="CSVLogging", type=Property.Type.BOOLEAN, defaultValue="false", description="Specifies if the extensive CSV logging for debugging or performance tuning is to be used. Since this has a serious performance impact, it should not be used in production environments.")})
public abstract class AbstractADEPT2Service
implements ADEPT2Service,
LogService {
    public static final String CONF_CSV_LOGGING = "CSVLogging";
    private URI[] myURIs;
    protected final Logger logger;
    private final DebugLogger debugLogger;
    protected final String[] startupRequiredServices;
    protected final String[] runtimeRequiredServices;
    private Set<Thread> privilegedThreads;
    private final CountDownLatch started = new CountDownLatch(1);
    private volatile boolean shutdown = false;
    private final ActiveSessions activeSessions = new ActiveSessions();
    protected Registry registry;
    protected SessionFactory sessionFactory;

    public AbstractADEPT2Service(Configuration configuration, Registry registry) {
        this(configuration, registry, new String[0], new String[0]);
    }

    public AbstractADEPT2Service(Configuration configuration, Registry registry, String[] startupRequiredServices, String[] runtimeRequiredServices) {
        ArgChecks.checkForNull(configuration, "configuration");
        ArgChecks.checkForNulls(startupRequiredServices, "startupRequiredServices");
        ArgChecks.checkForNulls(runtimeRequiredServices, "runtimeRequiredServices");
        if (configuration != null && configuration.containsKey(CONF_CSV_LOGGING) && configuration.getBoolean(CONF_CSV_LOGGING)) {
            this.debugLogger = new DebugLogger(LoggerTools.getLogger(this));
            this.logger = this.debugLogger;
        } else {
            this.debugLogger = null;
            this.logger = LoggerTools.getLogger(this);
        }
        this.registry = registry;
        this.startupRequiredServices = (String[])startupRequiredServices.clone();
        this.runtimeRequiredServices = (String[])runtimeRequiredServices.clone();
        this.privilegedThreads = Collections.synchronizedSet(new HashSet());
        this.privilegeThread();
    }

    protected boolean isActive() {
        if (this.privilegedThreads.contains(Thread.currentThread())) {
            return this.started.getCount() <= 0L && !this.shutdown;
        }
        try {
            this.started.await();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return this.started.getCount() <= 0L && !this.shutdown;
        }
        return !this.shutdown;
    }

    protected boolean isShutdown() {
        return this.shutdown;
    }

    protected void activeOrInvalidServiceStateException(SessionToken session) {
        if (!(this.privilegedThreads.contains(Thread.currentThread()) || this.isActive() || this.activeSessions.isActive(session))) {
            String message = "Request refused since the service ";
            message = this.shutdown ? String.valueOf(message) + "is shut down." : String.valueOf(message) + "failed starting.";
            throw new InvalidServiceStateException(message);
        }
    }

    protected void privilegeSession(SessionToken activeSession, SessionToken newSession) {
        ArgChecks.checkForNull(activeSession, "activeSession");
        ArgChecks.checkForNull(newSession, "newSession");
        if (!this.activeSessions.isActive(activeSession)) {
            String msg = "When privileging a session, the registering session has to be active.";
            throw new IllegalArgumentException(msg);
        }
        if (newSession.getChildLevel() != 0) {
            String msg = "Only a top-level session may be registered as privileged session.";
            throw new IllegalArgumentException(msg);
        }
        this.activeSessions.privilegeSession(newSession);
    }

    public void sessionActive(SessionToken session) {
        ArgChecks.checkForNull(session, "session");
        this.sessionActive(session, null, null, null, null, null);
    }

    protected void sessionActive(SessionToken session, UUID templID, UUID baseTemplID, UUID embdTemplID, UUID instID) {
        this.sessionActive(session, templID, baseTemplID, embdTemplID, instID, null);
    }

    protected void sessionActive(SessionToken session, UUID templID, UUID embdTemplID, EBPInstanceReference ebpIR) {
        this.sessionActive(session, templID, null, embdTemplID, null, ebpIR);
    }

    private void sessionActive(SessionToken session, UUID templID, UUID baseTemplID, UUID embdTemplID, UUID instID, EBPInstanceReference ebpIR) {
        ArgChecks.checkForNull(session, "session");
        this.activeOrInvalidServiceStateException(session);
        this.activeSessions.sessionActive(session);
        if (this.csvLoggingEnabled()) {
            String instanceName = this.registry != null ? this.registry.getInstanceName() : null;
            Pair<QualifiedAgent, QualifiedAgent> agents = this.getUserCredentials(session);
            this.debugLogger.registerLogContext(session, agents.getFirst(), agents.getSecond(), null, instanceName, templID, baseTemplID, embdTemplID, instID, ebpIR);
            this.debugLogger.adaptNextSource(3);
        }
        this.logger.finer(String.format("Started session %s (top-level ID %s) in service.", session.getChildSessionID(), session.getSessionID()));
    }

    public void sessionFinished(SessionToken session) {
        ArgChecks.checkForNull(session, "session");
        if (this.csvLoggingEnabled()) {
            this.debugLogger.adaptNextSource(2);
        }
        this.logger.finer(String.format("Finished session %s (top-level ID %s) in service.", session.getChildSessionID(), session.getSessionID()));
        if (this.csvLoggingEnabled()) {
            this.debugLogger.unregisterLogContext();
        }
        this.activeSessions.sessionFinished(session);
    }

    @Override
    public String[] getStartupRequiredServices() {
        return (String[])this.startupRequiredServices.clone();
    }

    @Override
    public String[] getRuntimeRequiredServices() {
        return (String[])this.runtimeRequiredServices.clone();
    }

    @Override
    public URI[] getURIs() {
        return (URI[])this.myURIs.clone();
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    protected Registry getDependencyRegistry() {
        return this.registry;
    }

    protected SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    @Deprecated
    protected SessionToken createSessionToken() {
        return this.sessionFactory != null ? this.sessionFactory.getSessionToken(this.myURIs) : null;
    }

    protected final synchronized void privilegeThread() {
        if (this.started.getCount() > 0L || this.shutdown) {
            this.privilegedThreads.add(Thread.currentThread());
        }
    }

    @Override
    public void init(URI[] myURIs) throws AbortServiceException {
        ArgChecks.checkForNull(myURIs, "myURIs");
        this.myURIs = (URI[])myURIs.clone();
    }

    @Deprecated
    protected void init(URI[] myURIs, int agentID, int orgPositionID, String password) throws AbortServiceException {
        this.init(myURIs, (long)agentID, (long)orgPositionID, password);
    }

    protected void init(URI[] myURIs, long agentID, long orgPositionID, String password) throws AbortServiceException {
        ArgChecks.checkForNull(myURIs, "myURIs");
        this.myURIs = (URI[])myURIs.clone();
        try {
            this.sessionFactory = this.registry.getSecurityManager().authenticatePrivileged(agentID, orgPositionID, password);
        }
        catch (AuthenticationException ae) {
            String msg = String.format("Failed to authenticate at the security manager due to wrong authentication data. Check the configuration of the service '%s'", Arrays.toString(myURIs));
            throw new AbortServiceException(msg, ae);
        }
        catch (DataSourceException dse) {
            String msg = "Failed to authenticate at the security manager due to unavailability of the data.wrong authentication data.";
            throw new AbortServiceException(msg, dse);
        }
    }

    public final synchronized void signalStart() {
        this.started.countDown();
        this.privilegedThreads.clear();
    }

    @Override
    public void start() throws AbortServiceException {
    }

    public final void signalShutdown(boolean emergency) {
        this.shutdown = true;
        this.privilegeThread();
        if (emergency) {
            this.activeSessions.interruptActiveSessions(new HashSet<Thread>(this.privilegedThreads));
        } else {
            this.activeSessions.privilegeActiveSessions();
        }
    }

    @Override
    public void shutdown() {
        boolean terminated = false;
        boolean interrupted = Thread.interrupted();
        while (!terminated) {
            try {
                terminated = this.activeSessions.awaitTermination(0L);
            }
            catch (InterruptedException interruptedException) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void emergencyShutdown() {
        boolean interrupted = Thread.interrupted();
        try {
            this.activeSessions.awaitTermination(10000L);
        }
        catch (InterruptedException interruptedException) {
            this.logger.warning("Interrupted while waiting for the termination of the active sessions. Since this is an emergency shutdown we continue.");
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public boolean ping() {
        return this.started.getCount() == 0L && !this.shutdown;
    }

    @Override
    public boolean csvLoggingEnabled() {
        return this.debugLogger != null;
    }

    @Override
    public void logMethodEntry(String contextString, SessionToken session, String msg) {
        if (this.csvLoggingEnabled()) {
            this.logMethodEntry(contextString, session, msg, null, null, null, null, null, 2);
        }
    }

    @Override
    public void logMethodEntry(String contextString, SessionToken session, String msg, UUID templID, UUID baseTemplID, UUID embdTemplID, UUID instID, EBPInstanceReference ebpIR) {
        if (this.csvLoggingEnabled()) {
            this.logMethodEntry(contextString, session, msg, templID, baseTemplID, embdTemplID, instID, ebpIR, 2);
        }
    }

    private void logMethodEntry(String contextString, SessionToken session, String msg, UUID templID, UUID baseTemplID, UUID embdTemplID, UUID instID, EBPInstanceReference ebpIR, int removeElems) {
        if (this.csvLoggingEnabled()) {
            String instanceName = this.registry != null ? this.registry.getInstanceName() : null;
            QualifiedAgent tlAgent = null;
            QualifiedAgent agent = null;
            if (session != null) {
                Pair<QualifiedAgent, QualifiedAgent> agents = this.getUserCredentials(session);
                tlAgent = agents.getFirst();
                agent = agents.getSecond();
            }
            this.debugLogger.registerLogContext(session, tlAgent, agent, contextString, instanceName, templID, baseTemplID, embdTemplID, instID, ebpIR);
            this.debugLogger.adaptNextSource(removeElems + 1);
        }
        this.logger.finer(msg);
    }

    @Override
    public void changeLogContext(String contextString) {
        if (this.csvLoggingEnabled()) {
            this.changeLogContext(contextString, null, null, null, null, null, null);
        }
    }

    protected void consoleLog(String message) {
        System.out.println(String.format("Service '%s': %s", this.registry.getInstanceName(), message));
    }

    @Override
    public void changeLogContext(EBPInstanceReference ebpIR) {
        if (this.csvLoggingEnabled()) {
            this.changeLogContext(null, null, null, null, null, null, ebpIR);
        }
    }

    @Override
    public void changeLogContext(String contextString, SessionToken session, UUID templID, UUID baseTemplID, UUID embdTemplID, UUID instID, EBPInstanceReference ebpIR) {
        if (this.csvLoggingEnabled()) {
            String instanceName;
            String string = instanceName = this.registry != null ? this.registry.getInstanceName() : null;
            if (session != null) {
                Pair<QualifiedAgent, QualifiedAgent> agents = this.getUserCredentials(session);
                this.debugLogger.changeLogContext(session, agents.getFirst(), agents.getSecond(), contextString, instanceName, templID, baseTemplID, embdTemplID, instID, ebpIR);
            } else {
                this.debugLogger.changeLogContext(null, null, null, contextString, instanceName, templID, baseTemplID, embdTemplID, instID, ebpIR);
            }
        }
    }

    @Override
    public void revertLogContextChanges() {
        if (this.csvLoggingEnabled()) {
            this.debugLogger.revertLogContextChanges();
        }
    }

    @Override
    public void logMethodExit(String msg) {
        if (this.csvLoggingEnabled()) {
            this.debugLogger.adaptNextSource(2);
        }
        this.logger.finer(msg);
        if (this.csvLoggingEnabled()) {
            this.debugLogger.unregisterLogContext();
        }
    }

    protected Pair<QualifiedAgent, QualifiedAgent> getUserCredentials(SessionToken session) {
        try {
            Pair<Object, Object> ret;
            if (this.sessionFactory != null) {
                QualifiedAgent tlAgent = this.sessionFactory.checkAndGetTopLevelAgent(session);
                QualifiedAgent agent = this.sessionFactory.checkAndGetAgent(session);
                ret = new Pair<QualifiedAgent, QualifiedAgent>(tlAgent, agent);
            } else {
                ret = new Pair<Object, Object>(null, null);
            }
            return ret;
        }
        catch (SecurityTokenIntegrityException stie) {
            throw new ServiceAccessControlException("The agents could not be retrieved from the session token!", stie);
        }
    }

    protected static class ActiveSessions {
        private Map<UUID, Integer> activeSubsessions = new HashMap<UUID, Integer>();
        private final Set<UUID> privilegedSessions;
        private Map<Thread, Integer> activeThreads = new HashMap<Thread, Integer>();

        public ActiveSessions() {
            this.privilegedSessions = new HashSet<UUID>();
        }

        protected synchronized void sessionActive(SessionToken session) {
            int count;
            UUID sessionID = session.getSessionID();
            if (this.activeSubsessions.containsKey(sessionID)) {
                count = this.activeSubsessions.get(sessionID);
                this.activeSubsessions.put(sessionID, ++count);
            } else {
                this.activeSubsessions.put(sessionID, 1);
            }
            if (this.activeThreads.containsKey(Thread.currentThread())) {
                count = this.activeThreads.get(Thread.currentThread());
                this.activeThreads.put(Thread.currentThread(), ++count);
            } else {
                this.activeThreads.put(Thread.currentThread(), 1);
            }
        }

        protected synchronized boolean sessionFinished(SessionToken session) {
            int count;
            boolean ret = true;
            UUID sessionID = session.getSessionID();
            if (this.activeSubsessions.containsKey(sessionID)) {
                count = this.activeSubsessions.get(sessionID);
                if (count > 1) {
                    this.activeSubsessions.put(sessionID, --count);
                    ret = false;
                } else {
                    this.activeSubsessions.remove(sessionID);
                    this.privilegedSessions.remove(sessionID);
                }
            }
            if (this.activeThreads.containsKey(Thread.currentThread())) {
                count = this.activeThreads.get(Thread.currentThread());
                if (count > 1) {
                    this.activeThreads.put(Thread.currentThread(), --count);
                } else {
                    this.activeThreads.remove(Thread.currentThread());
                }
            }
            if (this.activeSubsessions.isEmpty() && this.activeThreads.isEmpty()) {
                this.notifyAll();
            }
            return ret;
        }

        public synchronized int getCurrentParentSessionCount() {
            return this.activeSubsessions.size();
        }

        public synchronized boolean isActive(SessionToken session) {
            return this.activeSubsessions.containsKey(session.getSessionID()) || this.privilegedSessions.contains(session.getSessionID());
        }

        public synchronized int getCurrentSessionCount() {
            int subSessionCount = 0;
            for (UUID currentSession : this.activeSubsessions.keySet()) {
                subSessionCount += this.activeSubsessions.get(currentSession).intValue();
            }
            return subSessionCount;
        }

        protected synchronized void privilegeSession(SessionToken session) {
            this.privilegedSessions.add(session.getSessionID());
        }

        public synchronized boolean awaitTermination(long timeout) throws InterruptedException {
            long endWait = timeout > 0L ? System.currentTimeMillis() + timeout : Long.MAX_VALUE;
            boolean ret = this.activeSubsessions.isEmpty() && this.activeThreads.isEmpty();
            while (!ret && System.currentTimeMillis() < endWait) {
                this.wait(timeout);
                boolean bl = ret = this.activeSubsessions.isEmpty() && this.activeThreads.isEmpty();
            }
            return ret;
        }

        public synchronized void interruptActiveSessions(Set<Thread> nonInterrupted) {
            for (Thread victim : this.activeThreads.keySet()) {
                if (nonInterrupted.contains(victim)) continue;
                victim.interrupt();
            }
        }

        public synchronized void privilegeActiveSessions() {
            this.privilegedSessions.addAll(this.activeSubsessions.keySet());
        }
    }
}

