/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.service;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.configuration.ConfigurationDescription;
import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.configuration.Property;
import de.aristaflow.adept2.base.security.AuthenticationException;
import de.aristaflow.adept2.base.security.SecurityManager;
import de.aristaflow.adept2.base.service.AbstractADEPT2Service;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceAccessControlException;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SecurityTokenIntegrityException;
import de.aristaflow.adept2.base.sessionmanagement.SessionFactory;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.util.ArrayTools;
import de.aristaflow.adept2.util.ConfigurationTools;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.Pair;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.configuration.Configuration;

@ConfigurationDescription(properties={@Property(name="ServiceAuthUserName", type=Property.Type.STRING, defaultValue="system", description=""), @Property(name="ServiceAuthOrgPosID", type=Property.Type.LONG, defaultValue="-9223372036854775808", description=""), @Property(name="ServiceAuthPassword", type=Property.Type.STRING, defaultValue="0U2iwUbaYtgCe7SDnKljb8jrEaBol//Mki1y29QydXpcOaKaGIfZEeDgWsetvf49HrGdbMCzAlOYWO7P+n+4E4TPtF2wxQI3iyGHRS5s7womb+ZgWOio/HUmuioaYb3KHFMbEetgv/MbaCxLzITL6+CYj4KVOpeGCZJCJIEld0YlbDxHH5YuDZ5ri7vuNUCUXGawIwOpArZoevhLysnAaKC5Df6Ci4bY5zKBHpz9hGcaHQ3zbR+aPv2qNlCeoV6RGSUmW6aOtXMMbr0Bq9YjQ2zyy9jG6QfPWgbT4rQWp+H1lK/xc4ILtcQZWWozYXjJarpLqa/HxQYSajj+JFrtmw==", description="")})
public abstract class AbstractAuthenticatedService
extends AbstractADEPT2Service {
    public static final String CFG_SERVICEAUTH_USERNAME = "ServiceAuthUserName";
    public static final String CFG_SERVICEAUTH_ORGPOSID = "ServiceAuthOrgPosID";
    public static final String CFG_SERVICEAUTH_PASSWORD = "ServiceAuthPassword";
    private final boolean earlyService;
    private Configuration configuration;
    private String userName;
    private long orgPositionID;
    private String password;
    private SessionFactory sessionFactory;

    protected AbstractAuthenticatedService(Configuration configuration, Registry registry) throws ConfigurationException {
        this(configuration, registry, new String[]{"OrgModelManager"}, new String[0], false);
    }

    protected AbstractAuthenticatedService(Configuration configuration, Registry registry, boolean earlyService) throws ConfigurationException {
        String[] stringArray;
        if (earlyService) {
            stringArray = new String[]{};
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "OrgModelManager";
        }
        this(configuration, registry, stringArray, new String[0], earlyService);
    }

    protected AbstractAuthenticatedService(Configuration configuration, Registry registry, String[] startupRequiredServices, String[] runtimeRequiredServices) throws ConfigurationException {
        this(configuration, registry, startupRequiredServices, runtimeRequiredServices, false);
    }

    protected AbstractAuthenticatedService(Configuration configuration, Registry registry, String[] startupRequiredServices, String[] runtimeRequiredServices, boolean earlyService) throws ConfigurationException {
        super(configuration, registry, earlyService ? startupRequiredServices : ArrayTools.join(startupRequiredServices, {"OrgModelManager"}), runtimeRequiredServices);
        this.earlyService = earlyService;
        if (registry == null) {
            this.configuration = configuration;
            this.userName = null;
            this.orgPositionID = Long.MIN_VALUE;
            this.password = null;
        } else {
            this.configuration = null;
            try {
                ConfigurationTools.parsePassword(configuration, CFG_SERVICEAUTH_PASSWORD);
            }
            catch (GeneralSecurityException gse) {
                throw new ConfigurationException("The password could not be parsed from the configuration!. Maybe it is not set.", gse);
            }
            this.setLoginCredentials(configuration);
        }
    }

    private void setLoginCredentials(Configuration configuration) {
        this.userName = configuration.getString(CFG_SERVICEAUTH_USERNAME);
        this.orgPositionID = configuration.getLong(CFG_SERVICEAUTH_ORGPOSID);
        this.password = configuration.getString(CFG_SERVICEAUTH_PASSWORD);
    }

    @Override
    public void init(URI[] serviceURIs) throws AbortServiceException {
        super.init(serviceURIs);
        if (!this.earlyService) {
            try {
                this.authenticateService();
            }
            catch (AuthenticationException ae) {
                String msg = String.format("Failed to authenticate at the security manager due to wrong authentication data. Check the configuration of the service '%s'", Arrays.toString(serviceURIs));
                throw new AbortServiceException(msg, ae);
            }
        }
    }

    protected SecurityManager getSecurityManager() {
        return this.registry.getSecurityManager();
    }

    protected void authenticateService() throws AuthenticationException, AbortServiceException {
        if (this.userName == null) {
            this.setLoginCredentials(this.configuration);
            this.configuration = null;
        }
        try {
            String pwd = ConfigurationTools.parsePassword(this.password);
            if (this.orgPositionID == Long.MIN_VALUE) {
                String servName = this.registry == null ? "BootstrapRegistry" : this.registry.getInstanceName();
                List<QualifiedAgent> orgPos = this.getSecurityManager().authenticate(this.userName, pwd);
                if (orgPos.size() > 1) {
                    String msg = "Cannot authenticate since no organisational position has been configured for agent '%s' (service: %s) and the organisational model provides %d organisational positions. Please set one in the configuration.";
                    msg = String.format(msg, this.userName, servName, orgPos.size());
                    throw new ConfigurationException(msg);
                }
                if (orgPos.size() < 1) {
                    String msg = "Cannot authenticate since the agent '%s' (service: %s) has no organisational position in the organisational model. Please adapt your model appropriately.";
                    throw new ConfigurationException(String.format(msg, this.userName, servName));
                }
                this.orgPositionID = orgPos.get(0).getOrgPositionID();
                String msg = String.format("The organisational position '%d' will be used for agent '%s' (service: %s).", this.orgPositionID, this.userName, servName);
                this.logger.finer(msg);
            }
            this.sessionFactory = this.getSecurityManager().authenticatePrivileged(this.userName, this.orgPositionID, pwd);
        }
        catch (GeneralSecurityException e) {
            throw new ConfigurationException("The password could not be parsed!", e);
        }
        catch (DataSourceException dse) {
            String msg = "Failed to authenticate at the security manager due to unavailability of the data.wrong authentication data.";
            throw new AbortServiceException(msg, dse);
        }
    }

    @Override
    protected SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    protected SessionToken createSession() {
        return this.sessionFactory != null ? this.sessionFactory.getSessionToken(this.getURIs()) : null;
    }

    protected SessionToken createChildSession(SessionToken parentSession) {
        if (this.sessionFactory == null) {
            throw new IllegalStateException();
        }
        return this.sessionFactory.getChildSession(parentSession, this.getURIs());
    }

    protected void awaitActiveSessions(boolean emergency) {
        if (emergency) {
            super.emergencyShutdown();
        } else {
            super.shutdown();
        }
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.sessionFactory = null;
    }

    @Override
    public void emergencyShutdown() {
        super.emergencyShutdown();
        this.sessionFactory = null;
    }

    @Override
    protected Pair<QualifiedAgent, QualifiedAgent> getUserCredentials(SessionToken session) {
        try {
            QualifiedAgent tlAgent = this.sessionFactory.checkAndGetTopLevelAgent(session);
            QualifiedAgent agent = this.sessionFactory.checkAndGetAgent(session);
            return new Pair<QualifiedAgent, QualifiedAgent>(tlAgent, agent);
        }
        catch (SecurityTokenIntegrityException stie) {
            throw new ServiceAccessControlException("The agents could not be retrieved from the session token!", stie);
        }
    }
}

