/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.service;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.service.AbstractADEPT2Service;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.util.ArgChecks;
import java.net.URI;
import java.util.logging.Logger;

public class AbstractSubService {
    protected final Logger logger;
    protected final String[] startupRequiredServices;
    protected final String[] runtimeRequiredServices;
    protected final AbstractADEPT2Service service;

    public AbstractSubService(AbstractADEPT2Service service) {
        this(null, null, service);
    }

    public AbstractSubService(String[] startupRequiredServices, String[] runtimeRequiredServices, AbstractADEPT2Service service) {
        ArgChecks.checkForNull(service, "service");
        this.startupRequiredServices = startupRequiredServices != null ? (String[])startupRequiredServices.clone() : new String[0];
        this.runtimeRequiredServices = runtimeRequiredServices != null ? (String[])runtimeRequiredServices.clone() : new String[0];
        this.logger = service.getLogger();
        this.service = service;
    }

    protected final void privilegeSession(SessionToken activeSession, SessionToken newSession) {
        this.service.privilegeSession(activeSession, newSession);
    }

    protected final void sessionActive(SessionToken session) {
        this.service.sessionActive(session);
    }

    protected final void sessionFinished(SessionToken session) {
        this.service.sessionFinished(session);
    }

    public final String[] getStartupRequiredServices() {
        return (String[])this.startupRequiredServices.clone();
    }

    public final String[] getRuntimeRequiredServices() {
        return (String[])this.runtimeRequiredServices.clone();
    }

    protected final URI[] getURIs() {
        return this.service.getURIs();
    }

    public void init() throws AbortServiceException {
    }

    public void start() throws AbortServiceException {
    }

    public void shutdown() {
    }

    public void emergencyShutdown() {
    }
}

