/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.service;

import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.util.types.Pair;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.UUID;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class DebugLogger
extends Logger {
    protected final Logger innerLogger;
    protected final ThreadLocal<Stack<Pair<Object[], Object[]>>> logRecordParameters;
    protected final ThreadLocal<Pair<String, String>> recordSource;

    public DebugLogger(Logger innerLogger) {
        super(innerLogger.getName(), innerLogger.getResourceBundleName());
        this.innerLogger = innerLogger;
        this.logRecordParameters = new ThreadLocal();
        this.recordSource = new ThreadLocal();
        super.setLevel(this.getEffectiveLevel(innerLogger));
    }

    @Override
    public void log(LogRecord record) {
        Stack<Pair<Object[], Object[]>> logParameterStack = this.logRecordParameters.get();
        Object[] logParameters = null;
        if (logParameterStack != null && !logParameterStack.empty()) {
            logParameters = logParameterStack.peek().getFirst();
        }
        if (logParameters == null) {
            logParameters = new Object[13];
        }
        logParameters[0] = System.nanoTime();
        record.setParameters(logParameters);
        Pair<String, String> source = this.recordSource.get();
        if (source != null) {
            record.setSourceClassName(source.getFirst());
            record.setSourceMethodName(source.getSecond());
            this.recordSource.remove();
        } else {
            record.getSourceClassName();
        }
        this.innerLogger.log(record);
    }

    protected void adaptNextSource(int stackElement) {
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        StackTraceElement caller = stackTrace[stackElement];
        Pair<String, String> source = new Pair<String, String>(caller.getClassName(), caller.getMethodName());
        this.recordSource.set(source);
    }

    public void registerLogContext(SessionToken session, QualifiedAgent tlAgent, QualifiedAgent agent, String arbString, String serviceInstName, UUID templID, UUID baseTemplID, UUID embdTemplID, UUID instID, EBPInstanceReference ebpIR) {
        Stack<Pair<Object, Object>> logParameterStack = this.logRecordParameters.get();
        if (logParameterStack == null) {
            logParameterStack = new Stack();
            this.logRecordParameters.set(logParameterStack);
        }
        Object[] logParameters = new Object[13];
        logParameterStack.push(new Pair<Object[], Object>(logParameters, null));
        this.setLogParameters(logParameters, session, tlAgent, agent, arbString, serviceInstName, templID, baseTemplID, embdTemplID, instID, ebpIR);
    }

    public void changeLogContext(SessionToken session, QualifiedAgent tlAgent, QualifiedAgent agent, String arbString, String serviceInstName, UUID templID, UUID baseTemplID, UUID embdTemplID, UUID instID, EBPInstanceReference ebpIR) {
        Stack<Pair<Object[], Object[]>> logParameterStack = this.logRecordParameters.get();
        if (logParameterStack == null || logParameterStack.empty()) {
            String sessionID = session != null ? String.format("for session %s (top-level session %s)", session.getChildSessionID(), session.getSessionID()) : "";
            String msg = "Cannot change the log record parameters '%s' since the session has not been registered yet. This is a programming error.";
            throw new InternalServiceException(String.format(msg, sessionID));
        }
        Pair<Object[], Object[]> parameterPair = logParameterStack.peek();
        if (parameterPair.getSecond() == null) {
            parameterPair = new Pair<Object[], Object[]>((Object[])parameterPair.getFirst().clone(), parameterPair.getFirst());
            logParameterStack.pop();
            logParameterStack.push(parameterPair);
        }
        this.setLogParameters(parameterPair.getFirst(), session, tlAgent, agent, arbString, serviceInstName, templID, baseTemplID, embdTemplID, instID, ebpIR);
    }

    public void revertLogContextChanges() {
        Stack<Pair<Object[], Object[]>> logParameterStack = this.logRecordParameters.get();
        if (logParameterStack == null || logParameterStack.empty()) {
            String msg = "Cannot revert the log changes since no log context has been registered yet. This is a programming error.";
            throw new InternalServiceException(msg);
        }
        Pair<Object[], Object[]> parameterPair = logParameterStack.peek();
        if (parameterPair.getSecond() != null) {
            parameterPair = new Pair<Object[], Object>(parameterPair.getSecond(), null);
            logParameterStack.pop();
            logParameterStack.push(parameterPair);
        }
    }

    public void unregisterLogContext() {
        Stack<Pair<Object[], Object[]>> logParameterStack = this.logRecordParameters.get();
        if (logParameterStack != null && !logParameterStack.empty()) {
            logParameterStack.pop();
        }
        if (logParameterStack != null && logParameterStack.empty()) {
            this.logRecordParameters.remove();
        }
    }

    protected void setLogParameters(Object[] logParameters, SessionToken session, QualifiedAgent tlAgent, QualifiedAgent agent, String arbString, String serviceInstName, UUID templID, UUID baseTemplID, UUID embdTemplID, UUID instID, EBPInstanceReference ebpIR) {
        if (session != null) {
            logParameters[3] = session;
        }
        if (tlAgent != null) {
            logParameters[4] = tlAgent;
        }
        if (agent != null) {
            logParameters[5] = agent;
        }
        if (arbString != null) {
            logParameters[2] = arbString;
        }
        if (serviceInstName != null) {
            logParameters[1] = serviceInstName;
        }
        if (templID != null) {
            logParameters[6] = templID;
        }
        if (baseTemplID == null && ebpIR != null && ebpIR.getBaseTemplateID() != null) {
            baseTemplID = ebpIR.getBaseTemplateID();
        }
        if (baseTemplID != null) {
            logParameters[7] = baseTemplID;
        }
        if (embdTemplID != null) {
            logParameters[8] = embdTemplID;
        }
        if (instID == null && ebpIR != null && ebpIR.getInstanceID() != null) {
            instID = ebpIR.getInstanceID();
        }
        if (instID != null) {
            logParameters[9] = instID;
        }
        if (ebpIR != null) {
            logParameters[10] = ebpIR.getNodeID();
            logParameters[11] = ebpIR.getNodeIteration();
            logParameters[12] = ebpIR.getType();
        }
    }

    private Level getEffectiveLevel(Logger logger) {
        Level currentLevel;
        Logger parentLogger = logger;
        do {
            currentLevel = parentLogger.getLevel();
            parentLogger = parentLogger.getParent();
        } while (currentLevel == null && parentLogger != null);
        return currentLevel;
    }

    @Override
    public ResourceBundle getResourceBundle() {
        return this.innerLogger.getResourceBundle();
    }

    @Override
    public String getResourceBundleName() {
        return this.innerLogger.getResourceBundleName();
    }

    @Override
    public void setFilter(Filter newFilter) throws SecurityException {
        this.innerLogger.setFilter(newFilter);
    }

    @Override
    public Filter getFilter() {
        return this.innerLogger.getFilter();
    }

    @Override
    public void setLevel(Level newLevel) throws SecurityException {
        this.innerLogger.setLevel(newLevel);
        super.setLevel(this.getEffectiveLevel(this.innerLogger));
    }

    @Override
    public Level getLevel() {
        return this.innerLogger.getLevel();
    }

    @Override
    public boolean isLoggable(Level level) {
        return this.innerLogger.isLoggable(level);
    }

    @Override
    public String getName() {
        return this.innerLogger.getName();
    }

    @Override
    public void addHandler(Handler handler) throws SecurityException {
        this.innerLogger.addHandler(handler);
    }

    @Override
    public synchronized void removeHandler(Handler handler) throws SecurityException {
        this.innerLogger.removeHandler(handler);
    }

    @Override
    public Handler[] getHandlers() {
        return this.innerLogger.getHandlers();
    }

    @Override
    public void setUseParentHandlers(boolean useParentHandlers) {
        this.innerLogger.setUseParentHandlers(useParentHandlers);
    }

    @Override
    public boolean getUseParentHandlers() {
        return this.innerLogger.getUseParentHandlers();
    }

    @Override
    public Logger getParent() {
        return this.innerLogger.getParent();
    }

    @Override
    public void setParent(Logger parent) {
        this.innerLogger.setParent(parent);
        super.setLevel(this.getEffectiveLevel(this.innerLogger));
    }

    public int hashCode() {
        return this.innerLogger.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof DebugLogger) {
            obj = ((DebugLogger)obj).innerLogger;
        }
        return this.innerLogger.equals(obj);
    }
}

