/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.service;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import java.net.URI;
import java.util.Arrays;

public class ServiceNotKnownException
extends AbortServiceException {
    private String serviceType;
    private String serviceInstance;

    public ServiceNotKnownException(String serviceType, String serviceInstance) {
        super(String.format("The service /%s/%s is not registered.", serviceType, serviceInstance));
        this.serviceType = serviceType;
        this.serviceInstance = serviceInstance;
    }

    public ServiceNotKnownException(String serviceType, Throwable cause) {
        super(cause);
        this.serviceType = serviceType;
    }

    public ServiceNotKnownException(URI service, String message) {
        super(message);
        this.serviceType = service.toString();
    }

    public ServiceNotKnownException(URI[] service, String message) {
        super(message);
        this.serviceType = Arrays.toString(service);
    }

    public ServiceNotKnownException(URI[] service, Throwable cause) {
        super(cause);
        this.serviceType = Arrays.toString(service);
    }

    public String getServiceType() {
        return this.serviceType;
    }
}

