/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.sessionmanagement;

import de.aristaflow.adept2.model.common.filter.UseInFilter;
import de.aristaflow.adept2.util.ArgChecks;
import java.io.Serializable;

public final class QualifiedAgent
implements Serializable {
    private static final long serialVersionUID = -7119385607111995003L;
    private final long agentID;
    private final String agentUserName;
    private final long orgPositionID;
    private final String orgPositionName;
    private final String userSessionID;

    public QualifiedAgent(long agentID, String agentUserName, long orgPositionID, String orgPositionName) {
        this(agentID, agentUserName, orgPositionID, orgPositionName, null);
    }

    public QualifiedAgent(long agentID, String agentUserName, long orgPositionID, String orgPositionName, String userSessionID) {
        ArgChecks.checkForNull(agentUserName, "agentUserName");
        ArgChecks.checkForNull(orgPositionName, "orgPositionName");
        this.agentID = agentID;
        this.agentUserName = agentUserName.intern();
        this.orgPositionID = orgPositionID;
        this.orgPositionName = orgPositionName.intern();
        this.userSessionID = userSessionID != null ? userSessionID.intern() : userSessionID;
    }

    @UseInFilter
    public long getAgentID() {
        return this.agentID;
    }

    @UseInFilter
    public String getAgentUserName() {
        return this.agentUserName;
    }

    @UseInFilter
    public long getOrgPositionID() {
        return this.orgPositionID;
    }

    @UseInFilter
    public String getOrgPositionName() {
        return this.orgPositionName;
    }

    @UseInFilter
    public String getUserSessionID() {
        return this.userSessionID;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        QualifiedAgent other = (QualifiedAgent)obj;
        return this.getAgentID() == other.getAgentID() && this.getOrgPositionID() == other.getOrgPositionID();
    }

    public int hashCode() {
        int hashCode = (int)(this.getAgentID() >>> 32) ^ (int)this.getAgentID();
        hashCode = hashCode ^ (int)(this.getOrgPositionID() >>> 32) ^ (int)this.getOrgPositionID();
        return hashCode;
    }

    public String toString() {
        return String.format("Agent[id='%s', userName='%s', orgPositionID='%s', orgPositionName='%s']", this.agentID, this.agentUserName, this.orgPositionID, this.orgPositionName);
    }
}

