/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.sessionmanagement;

import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.model.common.filter.UseInFilter;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.LocaleTools;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class RichAgent
implements Serializable {
    private static final long serialVersionUID = 7465435863450172584L;
    private final QualifiedAgent agent;
    private final String userReadableName;
    private final String mailAddress;
    private final Locale locale;
    private final HashMap<String, String> additionalAttributes;

    private static Locale parseLocale(String locale) {
        Locale ret = LocaleTools.parseLocaleString(locale);
        if (ret == null) {
            ret = Locale.getDefault();
        }
        return ret;
    }

    public RichAgent(QualifiedAgent agent, String userReadableName, String mailAddress, String locale, Map<String, String> additionalAttributes) {
        this(agent.getAgentID(), agent.getAgentUserName(), agent.getOrgPositionID(), agent.getOrgPositionName(), agent.getUserSessionID(), userReadableName, mailAddress, locale, additionalAttributes);
    }

    public RichAgent(long agentID, String agentUserName, long orgPositionID, String orgPositionName, String userSessionID, String userReadableName, String mailAddress, String locale, Map<String, String> additionalAttributes) {
        ArgChecks.checkForNull(agentUserName, "agentUserName");
        ArgChecks.checkForNull(orgPositionName, "orgPositionName");
        this.agent = new QualifiedAgent(agentID, agentUserName, orgPositionID, orgPositionName, userSessionID);
        this.userReadableName = userReadableName == null ? "".intern() : userReadableName.intern();
        this.mailAddress = mailAddress == null ? "".intern() : mailAddress.intern();
        this.locale = RichAgent.parseLocale(locale);
        this.additionalAttributes = additionalAttributes != null ? new HashMap<String, String>(additionalAttributes) : new HashMap(0);
    }

    @UseInFilter
    public QualifiedAgent getQualifiedAgent() {
        return this.agent;
    }

    @UseInFilter
    public String getUserReadableName() {
        return this.userReadableName;
    }

    @UseInFilter
    public String getMailAddress() {
        return this.mailAddress;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Map<String, String> getAdditionalAttributes() {
        return Collections.unmodifiableMap(this.additionalAttributes);
    }

    public String toString() {
        return String.format("Agent '%s' (%s)", this.userReadableName, this.mailAddress);
    }
}

