/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.sessionmanagement;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.util.locking.ReentrantLock;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class SessionLock
extends ReentrantLock<SessionToken> {
    public SessionLock(Class<? extends ReentrantLock.LockCountManager<SessionToken>> lockCountManager, boolean exclusive) throws InstantiationException, IllegalAccessException {
        super(lockCountManager, exclusive);
    }

    public static class ChildSessionIDLockCount
    implements ReentrantLock.LockCountManager<SessionToken> {
        private final Map<UUID, Integer> childUUIDLockCount = new HashMap<UUID, Integer>();
        private final Map<UUID, SessionToken> lockingSessions = new HashMap<UUID, SessionToken>();

        @Override
        public synchronized boolean hasLock(SessionToken session) {
            return this.childUUIDLockCount.containsKey(session.getChildSessionID());
        }

        @Override
        public synchronized boolean hasLocks() {
            return !this.childUUIDLockCount.isEmpty();
        }

        @Override
        public synchronized String getLockOwner() {
            String ret = "";
            if (!this.lockingSessions.isEmpty()) {
                SessionToken lockOwningSession = this.lockingSessions.values().iterator().next();
                ret = lockOwningSession.toString();
            }
            return ret;
        }

        @Override
        public synchronized int increaseAndGetLockCount(SessionToken session) {
            int ret;
            if (this.childUUIDLockCount.containsKey(session.getChildSessionID())) {
                ret = this.childUUIDLockCount.get(session.getChildSessionID());
                ++ret;
            } else {
                ret = 1;
                this.lockingSessions.put(session.getChildSessionID(), session);
            }
            this.childUUIDLockCount.put(session.getChildSessionID(), ret);
            return ret;
        }

        @Override
        public synchronized int decreaseAndGetLockCount(SessionToken session) {
            int ret = Integer.MIN_VALUE;
            if (this.childUUIDLockCount.containsKey(session.getChildSessionID())) {
                ret = this.childUUIDLockCount.get(session.getChildSessionID());
                if (--ret > 0) {
                    this.childUUIDLockCount.put(session.getChildSessionID(), ret);
                } else {
                    this.childUUIDLockCount.remove(session.getChildSessionID());
                    this.lockingSessions.remove(session.getChildSessionID());
                }
            }
            return ret;
        }
    }

    public static class SubsessionLockCount
    implements ReentrantLock.LockCountManager<SessionToken> {
        private final Map<UUID, Map<Integer, Integer>> uuidLevelLockCount = new HashMap<UUID, Map<Integer, Integer>>();
        private final Map<UUID, Map<Integer, SessionToken>> lockingSessions = new HashMap<UUID, Map<Integer, SessionToken>>();

        @Override
        public synchronized boolean hasLock(SessionToken session) {
            SessionToken parentLevelSession = null;
            if (this.lockingSessions.containsKey(session.getSessionID())) {
                Map<Integer, SessionToken> sessions = this.lockingSessions.get(session.getSessionID());
                int i = session.getChildLevel();
                while (i >= 0) {
                    parentLevelSession = sessions.get(i);
                    if (parentLevelSession != null) break;
                    --i;
                }
            }
            return parentLevelSession != null;
        }

        @Override
        public synchronized boolean hasLocks() {
            return !this.lockingSessions.isEmpty();
        }

        @Override
        public synchronized String getLockOwner() {
            String ret = "";
            if (!this.lockingSessions.isEmpty()) {
                Map<Integer, SessionToken> lockOwningSessions = this.lockingSessions.values().iterator().next();
                for (SessionToken sessionToken : lockOwningSessions.values()) {
                    if (sessionToken == null) continue;
                    ret = sessionToken.toString();
                }
            }
            return ret;
        }

        @Override
        public synchronized int increaseAndGetLockCount(SessionToken session) {
            int ret;
            Map<Object, Object> levelLockCount;
            Integer level = session.getChildLevel();
            if (this.lockingSessions.containsKey(session.getSessionID())) {
                Map<Integer, SessionToken> relatedSessions = this.lockingSessions.get(session.getSessionID());
                levelLockCount = this.uuidLevelLockCount.get(session.getSessionID());
                if (levelLockCount.containsKey(level)) {
                    ret = (Integer)levelLockCount.get(level);
                    ++ret;
                } else {
                    ret = 1;
                    relatedSessions.put(level, session);
                }
            } else {
                ret = 1;
                HashMap<Integer, SessionToken> relatedSessions = new HashMap<Integer, SessionToken>();
                levelLockCount = new HashMap();
                this.lockingSessions.put(session.getSessionID(), relatedSessions);
                this.uuidLevelLockCount.put(session.getSessionID(), levelLockCount);
                relatedSessions.put(level, session);
            }
            levelLockCount.put(level, ret);
            return ret;
        }

        @Override
        public synchronized int decreaseAndGetLockCount(SessionToken session) {
            int ret = Integer.MIN_VALUE;
            if (this.lockingSessions.containsKey(session.getSessionID())) {
                Integer level;
                Map<Integer, SessionToken> relatedSessions = this.lockingSessions.get(session.getSessionID());
                Map<Integer, Integer> levelLockCount = this.uuidLevelLockCount.get(session.getSessionID());
                if (levelLockCount.containsKey(level = Integer.valueOf(session.getChildLevel()))) {
                    ret = levelLockCount.get(level);
                    if (--ret > 0) {
                        levelLockCount.put(level, ret);
                    } else {
                        levelLockCount.remove(level);
                        relatedSessions.remove(level);
                        if (levelLockCount.isEmpty()) {
                            this.lockingSessions.remove(session.getSessionID());
                            this.uuidLevelLockCount.remove(session.getSessionID());
                        }
                    }
                }
            }
            return ret;
        }
    }

    public static class UUIDLockCount
    implements ReentrantLock.LockCountManager<SessionToken> {
        private final Map<UUID, Integer> uuidLockCount = new HashMap<UUID, Integer>();
        private final Map<UUID, SessionToken> lockingSessions = new HashMap<UUID, SessionToken>();

        @Override
        public synchronized boolean hasLock(SessionToken session) {
            return this.uuidLockCount.containsKey(session.getSessionID());
        }

        @Override
        public synchronized boolean hasLocks() {
            return !this.uuidLockCount.isEmpty();
        }

        @Override
        public synchronized String getLockOwner() {
            String ret = "";
            if (!this.lockingSessions.isEmpty()) {
                SessionToken lockOwningSession = this.lockingSessions.values().iterator().next();
                ret = lockOwningSession.toString();
            }
            return ret;
        }

        @Override
        public synchronized int increaseAndGetLockCount(SessionToken session) {
            int ret;
            if (this.uuidLockCount.containsKey(session.getSessionID())) {
                ret = this.uuidLockCount.get(session.getSessionID());
                ++ret;
            } else {
                ret = 1;
                this.lockingSessions.put(session.getSessionID(), session);
            }
            this.uuidLockCount.put(session.getSessionID(), ret);
            return ret;
        }

        @Override
        public synchronized int decreaseAndGetLockCount(SessionToken session) {
            int ret = Integer.MIN_VALUE;
            if (this.uuidLockCount.containsKey(session.getSessionID())) {
                ret = this.uuidLockCount.get(session.getSessionID());
                if (--ret > 0) {
                    this.uuidLockCount.put(session.getSessionID(), ret);
                } else {
                    this.uuidLockCount.remove(session.getSessionID());
                    this.lockingSessions.remove(session.getSessionID());
                }
            }
            return ret;
        }
    }
}

