/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.sessionmanagement;

import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SecurityTokenIntegrityException;
import de.aristaflow.adept2.util.StreamTools;
import de.aristaflow.adept2.util.UUIDTools;
import java.io.IOException;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignedObject;
import java.util.UUID;

public final class SignedSecurityToken
implements Serializable {
    private static final long serialVersionUID = -244712358306254428L;
    private byte[] signature;
    private final SecurityToken token;
    private final SignedObject signedObject;

    public SignedSecurityToken(QualifiedAgent agent, PrivateKey privateKey) throws SecurityTokenIntegrityException {
        this(agent, privateKey, false);
    }

    public SignedSecurityToken(QualifiedAgent agent, PrivateKey privateKey, boolean useSignedObject) throws SecurityTokenIntegrityException {
        try {
            this.token = new SecurityToken(agent);
            Signature sign = Signature.getInstance("MD5withRSA");
            if (useSignedObject) {
                this.signature = null;
                this.signedObject = new SignedObject(this.token, privateKey, sign);
            } else {
                sign.initSign(privateKey);
                sign.update(StreamTools.toByteArray(this.token));
                this.signature = sign.sign();
                this.signedObject = null;
            }
        }
        catch (GeneralSecurityException gse) {
            throw new SecurityTokenIntegrityException("The security token needs a RSA private key for signing. See encapsulated exception for detailed information.", gse);
        }
        catch (IOException ioe) {
            throw new SecurityTokenIntegrityException("The security token needs to be serialisable.", ioe);
        }
    }

    public UUID getID(PublicKey publicKey) throws SecurityTokenIntegrityException {
        return this.getSecurityToken(publicKey).getID();
    }

    public QualifiedAgent getQualifiedAgent(PublicKey publicKey) throws SecurityTokenIntegrityException {
        return this.getSecurityToken(publicKey).getQualifiedAgent();
    }

    public boolean hasCapability(PublicKey publicKey, String objectAccess) throws SecurityTokenIntegrityException {
        return this.getSecurityToken(publicKey).hasCapability(objectAccess);
    }

    public final void verify(PublicKey publicKey) throws SecurityTokenIntegrityException {
        try {
            boolean verified = false;
            Signature sign = Signature.getInstance("MD5withRSA");
            if (this.signature != null) {
                sign.initVerify(publicKey);
                sign.update(StreamTools.toByteArray(this.token));
                verified = sign.verify(this.signature);
            } else {
                verified = this.signedObject.verify(publicKey, sign);
            }
            if (!verified) {
                throw new SecurityTokenIntegrityException("Verification of the security token failed.");
            }
        }
        catch (GeneralSecurityException gse) {
            throw new SecurityTokenIntegrityException("Verification of the security token failed.", gse);
        }
        catch (IOException ioe) {
            throw new SecurityTokenIntegrityException("Could not verify security token due to problems with the deserialisation.", ioe);
        }
    }

    private SecurityToken getSecurityToken(PublicKey publicKey) throws SecurityTokenIntegrityException {
        SecurityToken ret;
        this.verify(publicKey);
        if (this.signature != null) {
            ret = this.token;
        } else {
            try {
                ret = (SecurityToken)this.signedObject.getObject();
            }
            catch (IOException ioe) {
                throw new SecurityTokenIntegrityException("Could not verify security token due to problems with the deserialisation.", ioe);
            }
            catch (ClassNotFoundException cnfe) {
                throw new SecurityTokenIntegrityException("Could not verify security token due to problems with the deserialisation.", cnfe);
            }
        }
        return ret;
    }

    private static final class SecurityToken
    implements Serializable {
        private static final long serialVersionUID = -6705092036351228406L;
        private final UUID id = UUIDTools.createRandomUUID();
        private final QualifiedAgent agent;

        SecurityToken(QualifiedAgent agent) {
            this.agent = agent;
        }

        UUID getID() {
            return this.id;
        }

        QualifiedAgent getQualifiedAgent() {
            return this.agent;
        }

        boolean hasCapability(String objectAccess) {
            return true;
        }
    }
}

