/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.sessionmanagement.defaultimplementation;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.base.sessionmanagement.SignedSecurityToken;
import de.aristaflow.adept2.util.NullArgumentException;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

abstract class AbstractSessionToken
implements SessionToken {
    private static final long serialVersionUID = -7192027149914514009L;
    protected final UUID childSessionID;
    protected final SignedSecurityToken securityToken;
    private final URI[] childCallingComponent;
    private final Map<String, String> additionalAttributes;

    AbstractSessionToken(UUID sessionID, SignedSecurityToken securityToken, URI[] callingComponent, Map<String, String> additionalAttributes) {
        if (sessionID == null || callingComponent == null) {
            String message = String.format("Neither of the arguments may be null. sessionID='%1$s', callingComponent='%2$s'", sessionID, Arrays.toString(callingComponent));
            throw new NullArgumentException(message);
        }
        this.childSessionID = sessionID;
        this.securityToken = securityToken;
        this.childCallingComponent = callingComponent;
        this.additionalAttributes = additionalAttributes != null ? new HashMap<String, String>(additionalAttributes) : null;
    }

    @Override
    public UUID getChildSessionID() {
        return this.childSessionID;
    }

    @Override
    public URI[] getCallingComponent() {
        SessionToken parent = this.getParentSession();
        URI[] ret = parent != this ? parent.getCallingComponent() : this.getChildCallingComponent();
        return ret;
    }

    @Override
    public URI[] getChildCallingComponent() {
        return (URI[])this.childCallingComponent.clone();
    }

    @Override
    public String getAdditionalAttributeValue(String attributeName) {
        SessionToken parent;
        String ret = null;
        if (this.additionalAttributes != null) {
            ret = this.additionalAttributes.get(attributeName);
        }
        if (ret == null && (parent = this.getParentSession()) != this) {
            ret = parent.getAdditionalAttributeValue(attributeName);
        }
        return ret;
    }

    @Override
    public SignedSecurityToken getTopLevelSecurityToken() {
        SessionToken parent = this.getParentSession();
        SignedSecurityToken ret = parent != this ? parent.getTopLevelSecurityToken() : this.getSecurityToken();
        return ret;
    }

    abstract SessionToken getParentSession();

    public String toString() {
        return String.format("%s, ID: %s (Parent-ID: %s) for %s.", this.getClass().getSimpleName(), this.getChildSessionID(), this.getSessionID(), Arrays.toString(this.childCallingComponent));
    }
}

