/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.sessionmanagement.defaultimplementation;

import de.aristaflow.adept2.base.sessionmanagement.ClientSessionFactory;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.RichAgent;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.base.sessionmanagement.SignedSecurityToken;
import de.aristaflow.adept2.base.sessionmanagement.defaultimplementation.DefaultTopLevelSessionToken;
import de.aristaflow.adept2.util.UUIDTools;
import java.net.URI;
import java.util.Map;

public final class DefaultClientSessionFactory
implements ClientSessionFactory {
    private static final long serialVersionUID = -8402068694655545364L;
    private RichAgent richAgent;
    private final SignedSecurityToken securityToken;
    private URI[] clientURIs;

    public DefaultClientSessionFactory(QualifiedAgent qualifiedAgent, SignedSecurityToken securityToken) {
        this.richAgent = new NonRichAgent(qualifiedAgent);
        this.securityToken = securityToken;
    }

    public void setAuthenticatedAgent(RichAgent richAgent) {
        if (this.richAgent instanceof NonRichAgent && richAgent != null && richAgent.getQualifiedAgent().equals(this.richAgent.getQualifiedAgent())) {
            this.richAgent = richAgent;
        }
    }

    @Override
    public RichAgent getAuthenticatedAgent() {
        return this.richAgent;
    }

    @Override
    public void setClientURIs(URI[] clientURIs) {
        if (this.clientURIs == null) {
            this.clientURIs = clientURIs;
        }
    }

    @Override
    public SessionToken getSessionToken(URI[] callingComponent) {
        return this.getSessionToken(callingComponent, null);
    }

    @Override
    public SessionToken getSessionToken(URI[] callingComponent, Map<String, String> additionalAttributes) {
        return new DefaultTopLevelSessionToken(UUIDTools.createRandomUUID(), this.securityToken, callingComponent, additionalAttributes);
    }

    @Override
    public SessionToken getSessionToken() {
        return this.getSessionToken((Map<String, String>)null);
    }

    @Override
    public SessionToken getSessionToken(Map<String, String> additionalAttributes) {
        if (this.clientURIs == null) {
            throw new IllegalStateException("The URIs are not set yet - no session token can be created!");
        }
        return this.getSessionToken(this.clientURIs, additionalAttributes);
    }

    private static final class NonRichAgent
    extends RichAgent {
        private static final long serialVersionUID = -8237302111083264430L;

        NonRichAgent(QualifiedAgent qualifiedAgent) {
            super(qualifiedAgent, "", "", "", null);
        }

        @Override
        public String toString() {
            return String.format("NonRichAgent: %s", this.getQualifiedAgent());
        }
    }
}

