/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.base.sessionmanagement.defaultimplementation;

import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SecurityTokenIntegrityException;
import de.aristaflow.adept2.base.sessionmanagement.SessionFactory;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.base.sessionmanagement.SignedSecurityToken;
import de.aristaflow.adept2.base.sessionmanagement.defaultimplementation.DefaultChildSessionToken;
import de.aristaflow.adept2.base.sessionmanagement.defaultimplementation.DefaultTopLevelSessionToken;
import de.aristaflow.adept2.util.LoggerTools;
import de.aristaflow.adept2.util.UUIDTools;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.net.URI;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;

public final class DefaultSessionFactory
implements SessionFactory {
    private static final long serialVersionUID = -6596322449533820602L;
    private SignedSecurityToken securityToken;
    private PublicKey publicKey;

    public DefaultSessionFactory(SignedSecurityToken securityToken, PublicKey publicKey) {
        this.securityToken = securityToken;
        if (publicKey == null) {
            this.restorePublicKey();
        } else {
            this.publicKey = publicKey;
        }
    }

    @Override
    public SessionToken getSessionToken(URI[] callingComponent) {
        return this.getSessionToken(callingComponent, null);
    }

    @Override
    public SessionToken getSessionToken(URI[] callingComponent, Map<String, String> additionalAttributes) {
        return this.unmarshalSessionToken(UUIDTools.createRandomUUID(), this.securityToken, callingComponent, additionalAttributes);
    }

    @Override
    public SessionToken getSubstituteSessionToken(SessionToken callerSession, SignedSecurityToken substitutedToken) throws SecurityTokenIntegrityException {
        return this.getSubstituteSessionToken(callerSession, substitutedToken, null);
    }

    @Override
    public SessionToken getSubstituteSessionToken(SessionToken callerSession, SignedSecurityToken substitutedToken, Map<String, String> additionalAttributes) throws SecurityTokenIntegrityException {
        this.checkIntegrity(callerSession);
        substitutedToken.verify(this.publicKey);
        return this.unmarshalSessionToken(UUIDTools.createRandomUUID(), substitutedToken, callerSession.getChildCallingComponent(), additionalAttributes);
    }

    @Override
    public SessionToken getChildSession(SessionToken parentSession, URI[] callingComponent) {
        return this.getChildSession(parentSession, callingComponent, null);
    }

    @Override
    public SessionToken getChildSession(SessionToken parentSession, URI[] callingComponent, Map<String, String> additionalAttributes) {
        return this.unmarshalChildSessionToken(parentSession, UUIDTools.createRandomUUID(), callingComponent, additionalAttributes);
    }

    @Override
    public SessionToken getPrivilegedChildSession(SessionToken parentSession, URI[] callingComponent) {
        return this.getPrivilegedChildSession(parentSession, callingComponent, null);
    }

    @Override
    public SessionToken getPrivilegedChildSession(SessionToken parentSession, URI[] callingComponent, Map<String, String> additionalAttributes) {
        return new DefaultChildSessionToken(parentSession, UUIDTools.createRandomUUID(), this.securityToken, callingComponent, additionalAttributes);
    }

    @Override
    public void checkIntegrity(SessionToken sessionToken) throws SecurityTokenIntegrityException {
        sessionToken.getSecurityToken().verify(this.publicKey);
    }

    @Override
    public QualifiedAgent checkAndGetAgent(SessionToken sessionToken) throws SecurityTokenIntegrityException {
        return sessionToken.getSecurityToken().getQualifiedAgent(this.publicKey);
    }

    @Override
    public QualifiedAgent checkAndGetTopLevelAgent(SessionToken sessionToken) throws SecurityTokenIntegrityException {
        return sessionToken.getTopLevelSecurityToken().getQualifiedAgent(this.publicKey);
    }

    @Override
    public SessionToken unmarshalSessionToken(UUID sessionID, SignedSecurityToken securityToken, URI[] callingComponent, Map<String, String> additionalAttributes) {
        return new DefaultTopLevelSessionToken(sessionID, securityToken, callingComponent, additionalAttributes);
    }

    @Override
    public SessionToken unmarshalChildSessionToken(SessionToken parentSession, UUID childSessionID, URI[] callingComponent, Map<String, String> additionalAttributes) {
        return new DefaultChildSessionToken(parentSession, childSessionID, callingComponent, additionalAttributes);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Object obj = null;
        while (!(obj instanceof SignedSecurityToken)) {
            try {
                obj = in.readObject();
            }
            catch (RuntimeException e) {
                String msg = "Ignore RuntimeExceptions, since there could be problems with the deserialisation of the publicKey, which is no longer needed.";
                LoggerTools.getLogger(this).log(Level.WARNING, msg, e);
            }
        }
        this.securityToken = (SignedSecurityToken)obj;
        this.restorePublicKey();
    }

    private void restorePublicKey() {
        try {
            Class<?> lsmClass = Class.forName("de.aristaflow.adept2.base.registry.BootstrapRegistry$LocalSecurityManager");
            Field modulusField = lsmClass.getDeclaredField("MODULUS");
            modulusField.setAccessible(true);
            BigInteger modulus = new BigInteger((byte[])modulusField.get(null));
            Field exponentField = lsmClass.getDeclaredField("PUBLIC_EXPONENT");
            exponentField.setAccessible(true);
            BigInteger exponent = new BigInteger((byte[])exponentField.get(null));
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            RSAPublicKeySpec keySpec = new RSAPublicKeySpec(modulus, exponent);
            this.publicKey = keyFactory.generatePublic(keySpec);
        }
        catch (ClassNotFoundException cnfe) {
            String msg = "The LocalSecurityManager could not be found for usage by reflection.";
            throw new Error(msg, cnfe);
        }
        catch (SecurityException se) {
            String msg = "The static fields modulus and exponent could not be accessed by reflection due to security reasons.";
            throw new Error(msg, se);
        }
        catch (NoSuchFieldException e) {
            String msg = "The fields MODULUS and EXPONENT are not available in the current LocalSecurityManager.";
            throw new Error(msg, e);
        }
        catch (IllegalArgumentException e) {
            String msg = "An IllegalArgumentException occurred while trying to access MODULUS and EXPONENT from the LocalSecurityManager.";
            throw new Error(msg, e);
        }
        catch (IllegalAccessException e) {
            String msg = "An IllegalAccessException occurred while trying to access MODULUS and EXPONENT from the LocalSecurityManager.";
            throw new Error(msg, e);
        }
        catch (NoSuchAlgorithmException nsae) {
            String msg = "No key factory found for RSA algorithm. Cannot restore public key.";
            throw new Error(msg, nsae);
        }
        catch (InvalidKeySpecException ikse) {
            String msg = "A public key cannot be created from the key specification therefore the SessionFactory cannot be deserialised. This is an internal error.";
            throw new Error(msg, ikse);
        }
    }
}

