/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.activityrepository.defaultimplementation;

import de.aristaflow.adept2.model.activitymodel.ATParameter;
import de.aristaflow.adept2.model.activitymodel.ATParameterTemplate;
import de.aristaflow.adept2.model.activitymodel.ActivityModelFactory;
import de.aristaflow.adept2.model.activitymodel.ActivityTemplate;
import de.aristaflow.adept2.model.activitymodel.Identifier;
import de.aristaflow.adept2.model.activitymodel.StorageActivityConfiguration;
import de.aristaflow.adept2.model.activitymodel.StorageActivityModelParameter;
import de.aristaflow.adept2.model.activitymodel.StorageActivityTemplateDefinition;
import de.aristaflow.adept2.model.activitymodel.StorageConfiguration;
import de.aristaflow.adept2.model.activitymodel.StorageConfigurationDescription;
import de.aristaflow.adept2.model.activitymodel.StorageConfigurationSet;
import de.aristaflow.adept2.model.activitymodel.StorageExecutableComponentDescription;
import de.aristaflow.adept2.model.activitymodel.StorageOperation;
import de.aristaflow.adept2.model.activitymodel.StorageParameterTemplate;
import de.aristaflow.adept2.model.common.ActivityConfiguration;
import de.aristaflow.adept2.model.common.ConfigurationDescription;
import de.aristaflow.adept2.model.common.ExecutionControlProperties;
import de.aristaflow.adept2.model.common.ParameterChangePolicy;
import de.aristaflow.adept2.model.common.State;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.CheckReport;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class ATBuilder {
    private ActivityModelFactory factory;
    private IdentifierRetrievalCallback identifierCallback;
    private StorageExecutableComponentDescription ecd;
    private StorageOperation op;
    private StorageConfigurationSet cs;
    private StorageActivityTemplateDefinition atd;
    private CheckReport checkReport;
    private boolean globalFailed;

    public ATBuilder(ActivityModelFactory factory, IdentifierRetrievalCallback identifierCallback) {
        this.factory = factory;
        this.identifierCallback = identifierCallback;
    }

    /*
     * WARNING - void declaration
     */
    public ActivityTemplate buildAT(StorageExecutableComponentDescription ecd, StorageOperation op, StorageConfigurationSet cs, StorageActivityTemplateDefinition atd, CheckReport checkReport) {
        String staffAssignmentRule;
        UUID iconID;
        String guiContextID;
        byte[] systemComponentSignature;
        String implementationClass;
        String description;
        ArgChecks.checkForNull(ecd, "ecd");
        ArgChecks.checkForNull(op, "op");
        ArgChecks.checkForNull(atd, "atd");
        String ecName = ecd.getName();
        if (!ecName.equals(op.getExecutableComponentName())) {
            throw new IllegalArgumentException();
        }
        if (!ecName.equals(atd.getExecutableComponentName())) {
            throw new IllegalArgumentException();
        }
        String opName = op.getName();
        if (!opName.equals(atd.getOperationName())) {
            throw new IllegalArgumentException();
        }
        String csName = null;
        if (cs != null && !(csName = cs.getName()).equals(atd.getConfigurationSetName())) {
            throw new IllegalArgumentException();
        }
        this.ecd = ecd;
        this.op = op;
        this.cs = cs;
        this.atd = atd;
        this.checkReport = checkReport != null ? checkReport : new CheckReport(null);
        this.globalFailed = false;
        UUID id = atd.getID();
        String name = atd.getName();
        HashMap<ActivityConstants.LocallyOverrideableActivityAttribute, ActivityConstants.ActivityModelEntityType> attributeOrigins = new HashMap<ActivityConstants.LocallyOverrideableActivityAttribute, ActivityConstants.ActivityModelEntityType>();
        if (!atd.isDescriptionInherited()) {
            description = atd.getDescription();
            attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.DESCRIPTION, ActivityConstants.ActivityModelEntityType.ATD);
        } else {
            description = op.getDescription();
            attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.DESCRIPTION, ActivityConstants.ActivityModelEntityType.OPERATION);
        }
        String developerDescription = !atd.isDeveloperDescriptionInherited() ? atd.getDeveloperDescription() : (!op.isDeveloperDescriptionInherited() ? op.getDeveloperDescription() : ecd.getDeveloperDescription());
        State state = this.combineState(null, ecd.getState());
        state = this.combineState(state, op.getState());
        state = this.combineState(state, atd.getState());
        if (cs != null) {
            state = this.combineState(state, cs.getState());
        }
        boolean runtimeArbitrary = false;
        if (!atd.isImplementationClassInherited()) {
            implementationClass = atd.getImplementationClass();
            runtimeArbitrary = true;
            attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.IMPLEMENTATION_CLASS, ActivityConstants.ActivityModelEntityType.ATD);
        } else if (!op.isImplementationClassInherited()) {
            implementationClass = op.getImplementationClass();
            attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.IMPLEMENTATION_CLASS, ActivityConstants.ActivityModelEntityType.OPERATION);
        } else {
            implementationClass = ecd.getImplementationClass();
            attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.IMPLEMENTATION_CLASS, ActivityConstants.ActivityModelEntityType.ECD);
        }
        HashMap<ActivityConstants.ActivityModelEntityType, List<String>> separatedClassPaths = new HashMap<ActivityConstants.ActivityModelEntityType, List<String>>();
        separatedClassPaths.put(ActivityConstants.ActivityModelEntityType.ECD, ecd.getClassPath());
        separatedClassPaths.put(ActivityConstants.ActivityModelEntityType.OPERATION, op.getClassPath());
        separatedClassPaths.put(ActivityConstants.ActivityModelEntityType.ATD, atd.getClassPath());
        boolean isSingleton = ecd.isSingleton();
        attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.IS_SINGLETON, ActivityConstants.ActivityModelEntityType.ECD);
        if (!op.isSingletonInherited()) {
            isSingleton = op.isSingleton();
            attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.IS_SINGLETON, ActivityConstants.ActivityModelEntityType.OPERATION);
        }
        if (!atd.isSingletonInherited()) {
            if (!runtimeArbitrary && isSingleton && !atd.isSingleton()) {
                String errMsg = "activity template definitions cannot deactivate is-singleton, only enable it";
                this.fail(Origin.ATD, null, errMsg, new String[0]);
            }
            if (atd.isSingleton()) {
                isSingleton = true;
                attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.IS_SINGLETON, ActivityConstants.ActivityModelEntityType.ATD);
            }
        }
        if (!atd.isSystemComponentInherited()) {
            systemComponentSignature = atd.getSystemComponent();
            attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.SYSTEM_COMPONENT, ActivityConstants.ActivityModelEntityType.ATD);
        } else if (!op.isSystemComponentInherited()) {
            systemComponentSignature = op.getSystemComponent();
            attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.SYSTEM_COMPONENT, ActivityConstants.ActivityModelEntityType.OPERATION);
        } else {
            systemComponentSignature = ecd.getSystemComponent();
            attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.SYSTEM_COMPONENT, ActivityConstants.ActivityModelEntityType.ECD);
        }
        if (!atd.isGUIContextIDInherited()) {
            guiContextID = atd.getGUIContextID();
            attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.GUI_CONTEXT_ID, ActivityConstants.ActivityModelEntityType.ATD);
        } else if (!op.isGUIContextIDInherited()) {
            guiContextID = op.getGUIContextID();
            attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.GUI_CONTEXT_ID, ActivityConstants.ActivityModelEntityType.OPERATION);
        } else {
            guiContextID = ecd.getGUIContextID();
            attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.GUI_CONTEXT_ID, ActivityConstants.ActivityModelEntityType.ECD);
        }
        ExecutionControlProperties ecp = ecd.getExecutionControlProperties();
        attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.EXECUTION_CONTROL_PROPERTIES, ActivityConstants.ActivityModelEntityType.ECD);
        if (!op.areExecutionControlPropertiesInterhited()) {
            ecp = op.getExecutionControlProperties();
            attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.EXECUTION_CONTROL_PROPERTIES, ActivityConstants.ActivityModelEntityType.OPERATION);
        }
        if (!atd.areExecutionControlPropertiesInterited()) {
            boolean isSuspensible = ecp.isSuspensible();
            boolean isResettable = ecp.isResettable();
            boolean isClosable = ecp.isClosable();
            ExecutionControlProperties atdEcp = atd.getExecutionControlProperties();
            if (!runtimeArbitrary) {
                String errMsg = "activity template definitions may only restrict execution control properties, not widen them: %s";
                if (!isSuspensible && atdEcp.isSuspensible()) {
                    this.fail(Origin.ATD, null, errMsg, "is-suspensible");
                }
                if (!isResettable && atdEcp.isResettable()) {
                    this.fail(Origin.ATD, null, errMsg, "is-resettable");
                }
                if (!isClosable && atdEcp.isClosable()) {
                    this.fail(Origin.ATD, null, errMsg, "is-closable");
                }
            }
            if (!atdEcp.isSuspensible()) {
                isSuspensible = false;
            }
            if (!atdEcp.isResettable()) {
                isResettable = false;
            }
            if (!atdEcp.isClosable()) {
                isClosable = false;
            }
            ecp = new ExecutionControlProperties(isSuspensible, isResettable, isClosable);
            attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.EXECUTION_CONTROL_PROPERTIES, ActivityConstants.ActivityModelEntityType.ATD);
        }
        boolean supportsViewOnly = op.supportsViewOnly();
        attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.SUPPORTS_VIEW_ONLY, ActivityConstants.ActivityModelEntityType.OPERATION);
        if (!atd.isSupportsViewOnlyInherited()) {
            if (!runtimeArbitrary && !supportsViewOnly && atd.supportsViewOnly()) {
                String errMsg = "activity template definitions cannot activate support for view-only, only disable it";
                this.fail(Origin.ATD, null, errMsg, new String[0]);
            }
            if (!atd.supportsViewOnly()) {
                supportsViewOnly = false;
                attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.SUPPORTS_VIEW_ONLY, ActivityConstants.ActivityModelEntityType.ATD);
            }
        }
        boolean supportsTestExecution = op.supportsTestExecution();
        attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.SUPPORTS_TEST_EXECUTION, ActivityConstants.ActivityModelEntityType.OPERATION);
        if (!atd.isSupportsTestExecutionInherited()) {
            if (!runtimeArbitrary && !supportsTestExecution && atd.supportsTestExecution()) {
                String errMsg = "activity template definitions cannot activate support for test-execution, only disable it";
                this.fail(Origin.ATD, null, errMsg, new String[0]);
            }
            if (!atd.supportsTestExecution()) {
                supportsTestExecution = false;
                attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.SUPPORTS_TEST_EXECUTION, ActivityConstants.ActivityModelEntityType.ATD);
            }
        }
        if (!atd.isIconIDInherited()) {
            iconID = atd.getIconID();
            attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.ICON_ID, ActivityConstants.ActivityModelEntityType.ATD);
        } else if (!op.isIconIDInherited()) {
            iconID = op.getIconID();
            attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.ICON_ID, ActivityConstants.ActivityModelEntityType.OPERATION);
        } else {
            iconID = ecd.getIconID();
            attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.ICON_ID, ActivityConstants.ActivityModelEntityType.ECD);
        }
        String licenceInformation = !atd.isLicenceInformationInherited() ? atd.getLicenceInformation() : (!op.isLicenceInformationInherited() ? op.getLicenceInformation() : ecd.getLicenceInformation());
        ArrayList<StorageConfigurationDescription> desc = new ArrayList<StorageConfigurationDescription>();
        ArrayList<Origin> descOrigins = new ArrayList<Origin>();
        desc.add(ecd.getConfigurationDescription());
        descOrigins.add(Origin.ECD);
        desc.add(op.getConfigurationDescription());
        descOrigins.add(Origin.OP);
        if (cs != null) {
            desc.add(cs.getConfigurationDescription());
            descOrigins.add(Origin.CS);
            desc.add(cs.getConfigurationDescription(ecName));
            descOrigins.add(Origin.CS_ECD);
            desc.add(cs.getConfigurationDescription(ecName, opName));
            descOrigins.add(Origin.CS_OP);
        }
        desc.add(atd.getConfigurationDescription());
        descOrigins.add(Origin.ATD);
        ConfigurationDescription configurationDescription = this.mergeConfigurationDescription(desc, descOrigins, null, false);
        ArrayList<StorageConfiguration> conf = new ArrayList<StorageConfiguration>();
        ArrayList<Origin> confOrigins = new ArrayList<Origin>();
        conf.add(op.getConfiguration());
        confOrigins.add(Origin.OP);
        if (cs != null) {
            conf.add(cs.getConfiguration());
            confOrigins.add(Origin.CS);
            conf.add(cs.getConfiguration(ecName));
            confOrigins.add(Origin.CS_ECD);
            conf.add(cs.getConfiguration(ecName, opName));
            confOrigins.add(Origin.CS_OP);
        }
        conf.add(atd.getConfiguration());
        confOrigins.add(Origin.ATD);
        ActivityConfiguration configuration = this.mergeConfiguration(conf, confOrigins, null, false, false);
        ArrayList<StorageConfiguration> conf2 = new ArrayList<StorageConfiguration>();
        ArrayList<Origin> confOrigins2 = new ArrayList<Origin>();
        conf2.add(op.getConfiguration());
        conf2.add(op.getTestConfiguration());
        confOrigins2.add(Origin.OP);
        if (cs != null) {
            conf2.add(cs.getConfiguration());
            conf2.add(cs.getTestConfiguration());
            confOrigins2.add(Origin.CS);
            conf2.add(cs.getConfiguration(ecName));
            conf2.add(cs.getTestConfiguration(ecName));
            confOrigins2.add(Origin.CS_ECD);
            conf2.add(cs.getConfiguration(ecName, opName));
            conf2.add(cs.getTestConfiguration(ecName, opName));
            confOrigins2.add(Origin.CS_OP);
        }
        conf2.add(atd.getConfiguration());
        conf2.add(atd.getTestConfiguration());
        confOrigins2.add(Origin.ATD);
        ActivityConfiguration testConfiguration = this.mergeConfiguration(conf2, confOrigins2, null, true, false);
        ParameterChangePolicy pcp = op.getParameterChangePolicy();
        if (!atd.isParameterChangePolicyInherited()) {
            if (atd.getParameterChangePolicy().ordinal() >= pcp.ordinal()) {
                pcp = atd.getParameterChangePolicy();
            } else {
                String errMsg = "activity template definitions may only restrict the parameter change policy, not widen it";
                this.fail(Origin.ATD, null, errMsg, new String[0]);
            }
        }
        HashMap parameters = new HashMap();
        ActivityConstants.AccessType[] accessTypeArray = ActivityConstants.AccessType.activityRelatedValues();
        int n = accessTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActivityConstants.AccessType accessType = accessTypeArray[n2];
            ArrayList<ATParameter> arrayList = new ArrayList<ATParameter>();
            ArrayList<Map<String, StorageActivityModelParameter>> allParameters = new ArrayList<Map<String, StorageActivityModelParameter>>();
            allParameters.add(op.getParameters(accessType));
            allParameters.add(atd.getParameters(accessType));
            List<Origin> allOrigins = Arrays.asList(Origin.OP_P, Origin.ATD_P);
            HashSet paramNames = new HashSet();
            Iterator iterator = allParameters.iterator();
            while (iterator.hasNext()) {
                Map params = (Map)iterator.next();
                paramNames.addAll(params.keySet());
            }
            ArrayList<StorageActivityModelParameter> paramsToMerge = new ArrayList<StorageActivityModelParameter>();
            ArrayList<Origin> originsToMerge = new ArrayList<Origin>();
            Iterator iterator2 = paramNames.iterator();
            while (iterator2.hasNext()) {
                String paramName = (String)iterator2.next();
                paramsToMerge.clear();
                originsToMerge.clear();
                int i = 0;
                int length = allParameters.size();
                while (i < length) {
                    Map params = (Map)allParameters.get(i);
                    if (params.containsKey(paramName)) {
                        paramsToMerge.add((StorageActivityModelParameter)params.get(paramName));
                        originsToMerge.add(allOrigins.get(i));
                    }
                    ++i;
                }
                arrayList.add(this.mergeParameter(paramsToMerge, originsToMerge));
            }
            parameters.put(accessType, arrayList);
            ++n2;
        }
        ArrayList<ATParameterTemplate> parameterTemplates = new ArrayList<ATParameterTemplate>();
        ArrayList<Map<String, StorageParameterTemplate>> allTemplates = new ArrayList<Map<String, StorageParameterTemplate>>();
        ArrayList<Origin> allOrigins = new ArrayList<Origin>();
        allTemplates.add(ecd.getParameterTemplates());
        allOrigins.add(Origin.ECD_PT);
        allTemplates.add(op.getParameterTemplates());
        allOrigins.add(Origin.OP_PT);
        if (cs != null) {
            allTemplates.add(cs.getParameterTemplates());
            allOrigins.add(Origin.CS_PT);
            allTemplates.add(cs.getParameterTemplates(ecName));
            allOrigins.add(Origin.CS_ECD_PT);
            allTemplates.add(cs.getParameterTemplates(ecName, opName));
            allOrigins.add(Origin.CS_OP_PT);
        }
        allTemplates.add(atd.getParameterTemplates());
        allOrigins.add(Origin.ATD_PT);
        HashSet templateNames = new HashSet();
        for (Map map : allTemplates) {
            templateNames.addAll(map.keySet());
        }
        ArrayList<StorageParameterTemplate> arrayList = new ArrayList<StorageParameterTemplate>();
        ArrayList<Origin> originsToMerge22 = new ArrayList<Origin>();
        for (String templateName : templateNames) {
            arrayList.clear();
            originsToMerge22.clear();
            int i = 0;
            int length = allTemplates.size();
            while (i < length) {
                Map templates = (Map)allTemplates.get(i);
                if (templates.containsKey(templateName)) {
                    arrayList.add((StorageParameterTemplate)templates.get(templateName));
                    originsToMerge22.add((Origin)((Object)allOrigins.get(i)));
                }
                ++i;
            }
            this.mergeParameterTemplate(arrayList, originsToMerge22);
            parameterTemplates.add(this.mergeParameterTemplate(arrayList, originsToMerge22));
        }
        if (!atd.isStaffAssignmentRuleInherited()) {
            staffAssignmentRule = atd.getStaffAssignmentRule();
        } else if (cs != null) {
            staffAssignmentRule = cs.getStaffAssignmentRule(ecName, opName);
            if (staffAssignmentRule == null) {
                staffAssignmentRule = cs.getStaffAssignmentRule();
            }
            if (staffAssignmentRule == null) {
                staffAssignmentRule = op.getStaffAssignmentRule();
            }
        } else {
            staffAssignmentRule = op.getStaffAssignmentRule();
        }
        HashMap<UUID, Identifier> identifiers = new HashMap<UUID, Identifier>();
        if (this.identifierCallback != null) {
            void var35_46;
            ActivityConstants.AccessType[] accessTypeArray2 = ActivityConstants.AccessType.activityRelatedValues();
            int originsToMerge22 = accessTypeArray2.length;
            boolean bl = false;
            while (var35_46 < originsToMerge22) {
                ActivityConstants.AccessType accessType = accessTypeArray2[var35_46];
                for (ATParameter param : (Collection)parameters.get((Object)accessType)) {
                    UUID identifierID = param.getIdentifierID();
                    if (identifierID.equals(ProcessConstants.UNIVERSAL_IDENTIFIER_ID) || identifiers.containsKey(identifierID)) continue;
                    identifiers.put(identifierID, this.identifierCallback.getIdentifier(identifierID));
                }
                ++var35_46;
            }
            for (ATParameterTemplate param : parameterTemplates) {
                UUID identifierID = param.getIdentifierID();
                if (identifierID == null || identifierID.equals(ProcessConstants.UNIVERSAL_IDENTIFIER_ID) || identifiers.containsKey(identifierID)) continue;
                identifiers.put(identifierID, this.identifierCallback.getIdentifier(identifierID));
            }
        }
        if (this.factory == null) {
            return null;
        }
        return this.factory.createActivityTemplate(id, ecName, opName, csName, name, description, developerDescription, state, implementationClass, separatedClassPaths, isSingleton, systemComponentSignature, guiContextID, ecp, supportsViewOnly, supportsTestExecution, iconID, attributeOrigins, licenceInformation, configurationDescription, configuration, testConfiguration, pcp, (Collection)parameters.get((Object)ActivityConstants.AccessType.READ), (Collection)parameters.get((Object)ActivityConstants.AccessType.WRITE), parameterTemplates, staffAssignmentRule, identifiers.values(), this.atd, this.atd.getUserAttributes());
    }

    public CheckReport checkAT(StorageExecutableComponentDescription ecd, StorageOperation op, StorageConfigurationSet cs, StorageActivityTemplateDefinition atd, CheckReport checkReport) {
        this.buildAT(ecd, op, cs, atd, checkReport);
        return this.checkReport;
    }

    public CheckReport getReport() {
        return this.checkReport;
    }

    private State combineState(State state1, State state2) {
        State result = state1 == State.IN_DEVELOPMENT || state2 == State.IN_DEVELOPMENT ? State.IN_DEVELOPMENT : (state1 == State.OUTDATED || state2 == State.OUTDATED ? State.OUTDATED : State.IN_PRODUCTION);
        return result;
    }

    private ATParameter mergeParameter(List<StorageActivityModelParameter> parameters, List<Origin> origins) {
        boolean isFirstParam = true;
        String name = parameters.get(0).getName();
        String description = null;
        String developerDescription = null;
        ProcessConstants.AdeptDataType dataType = null;
        String udtName = null;
        UUID identifierID = null;
        boolean isOptional = false;
        boolean isVirtual = false;
        boolean isFailure = false;
        String defaultValue = null;
        ArrayList<StorageConfigurationDescription> descToMerge = new ArrayList<StorageConfigurationDescription>();
        ArrayList<StorageConfiguration> confToMerge = new ArrayList<StorageConfiguration>();
        int i = 0;
        int count = parameters.size();
        while (i < count) {
            StorageActivityModelParameter param = parameters.get(i);
            Origin paramOrigin = origins.get(i);
            if (param == null) {
                String msg;
                if (isFirstParam) {
                    msg = "parameter cannot be removed before it is even defined";
                    this.fail(paramOrigin, name, msg, new String[0]);
                } else if (!isOptional) {
                    msg = "mandatory parameters cannot be removed";
                    this.fail(paramOrigin, name, msg, new String[0]);
                }
                isFirstParam = true;
            } else if (isFirstParam) {
                String msgTpl = "attribute missing from original parameter definition: %s";
                description = param.getDescription();
                if (param.isDescriptionInherited()) {
                    this.fail(paramOrigin, name, msgTpl, "description");
                }
                developerDescription = param.getDeveloperDescription();
                if (param.isDeveloperDescriptionInherited()) {
                    this.fail(paramOrigin, name, msgTpl, "developer description");
                }
                dataType = param.getDataType();
                udtName = param.getUDTName();
                if (param.isDataTypeInherited()) {
                    this.fail(paramOrigin, name, msgTpl, "data type / UDT name");
                }
                identifierID = param.getIdentifierID();
                if (param.isIdentifierIDInherited()) {
                    this.fail(paramOrigin, name, msgTpl, "identifier ID");
                }
                isOptional = param.isOptional();
                if (param.isOptionalInherited()) {
                    this.fail(paramOrigin, name, msgTpl, "is-optional");
                }
                isVirtual = param.isVirtual();
                if (param.isVirtualInherited()) {
                    this.fail(paramOrigin, name, msgTpl, "is-virtual");
                }
                isFailure = param.isFailure();
                if (param.isFailureInherited()) {
                    this.fail(paramOrigin, name, msgTpl, "is-failure");
                }
                defaultValue = param.getDefaultValue();
                descToMerge.clear();
                descToMerge.add(param.getConfigurationDescription());
                confToMerge.clear();
                confToMerge.add(param.getConfiguration());
                isFirstParam = false;
            } else {
                String errMsgTpl = "%s must not be overridden";
                if (!param.isDescriptionInherited()) {
                    description = param.getDescription();
                }
                if (!param.isDeveloperDescriptionInherited()) {
                    developerDescription = param.getDeveloperDescription();
                }
                if (!param.isDataTypeInherited()) {
                    this.fail(paramOrigin, name, errMsgTpl, "data type");
                }
                if (!param.isIdentifierIDInherited()) {
                    this.fail(paramOrigin, name, errMsgTpl, "identifier ID");
                }
                if (!param.isOptionalInherited()) {
                    if (param.isOptional() && !isOptional) {
                        this.fail(paramOrigin, name, "mandatory parameters cannot be overridden to be optional", new String[0]);
                    } else {
                        isOptional = param.isOptional();
                    }
                }
                if (!param.isVirtualInherited()) {
                    this.fail(paramOrigin, name, errMsgTpl, "is-virtual");
                }
                if (!param.isFailureInherited()) {
                    this.fail(paramOrigin, name, errMsgTpl, "is-failure");
                }
                if (!param.isDefaultValueInherited()) {
                    defaultValue = param.getDefaultValue();
                }
                descToMerge.add(param.getConfigurationDescription());
                confToMerge.add(param.getConfiguration());
            }
            ++i;
        }
        ConfigurationDescription configurationDescription = this.mergeConfigurationDescription(descToMerge, origins, name, false);
        ActivityConfiguration configuration = this.mergeConfiguration(confToMerge, origins, name, false, false);
        if (this.factory == null) {
            return null;
        }
        return this.factory.createATParameter(name, description, developerDescription, dataType, udtName, identifierID, isOptional, isVirtual, isFailure, defaultValue, configurationDescription, configuration, null, null);
    }

    private ATParameterTemplate mergeParameterTemplate(List<StorageParameterTemplate> parameterTemplates, List<Origin> origins) {
        String templateName = parameterTemplates.get(0).getTemplateName();
        String templateDescription = null;
        ActivityConstants.AccessType accessType = null;
        String name = null;
        String description = null;
        ProcessConstants.AdeptDataType dataType = null;
        String udtName = null;
        UUID identifierID = null;
        Boolean isOptional = null;
        Boolean isVirtual = null;
        Boolean isFailure = null;
        String defaultValue = null;
        ArrayList<StorageConfigurationDescription> descToMerge = new ArrayList<StorageConfigurationDescription>();
        ArrayList<StorageConfiguration> confToMerge = new ArrayList<StorageConfiguration>();
        int i = 0;
        int count = parameterTemplates.size();
        while (i < count) {
            StorageParameterTemplate tpl = parameterTemplates.get(i);
            Origin tplOrigin = origins.get(i);
            if (tpl == null) {
                templateDescription = null;
                accessType = null;
                name = null;
                description = null;
                dataType = null;
                udtName = null;
                identifierID = null;
                isOptional = null;
                isVirtual = null;
                isFailure = null;
                defaultValue = null;
                descToMerge.clear();
                confToMerge.clear();
            } else {
                String errMsgTpl = "set attributes must not be overridden: %s";
                if (!tpl.isTemplateDescriptionInherited()) {
                    if (templateDescription == null) {
                        templateDescription = tpl.getTemplateDescription();
                    } else {
                        this.fail(tplOrigin, templateName, errMsgTpl, "template description");
                    }
                }
                if (!tpl.isAccessTypeInherited()) {
                    if (accessType == null) {
                        accessType = tpl.getAccessType();
                    } else {
                        this.fail(tplOrigin, templateName, errMsgTpl, "access type");
                    }
                }
                if (!tpl.isNameInherited()) {
                    if (name == null) {
                        name = tpl.getName();
                    } else {
                        this.fail(tplOrigin, templateName, errMsgTpl, "name");
                    }
                }
                if (!tpl.isDescriptionInherited()) {
                    if (description == null) {
                        description = tpl.getDescription();
                    } else {
                        this.fail(tplOrigin, templateName, errMsgTpl, "description");
                    }
                }
                if (!tpl.isDataTypeInherited()) {
                    if (dataType == null) {
                        dataType = tpl.getDataType();
                        udtName = tpl.getUDTName();
                    } else {
                        this.fail(tplOrigin, templateName, errMsgTpl, "data type");
                    }
                }
                if (!tpl.isIdentifierIDInherited()) {
                    if (identifierID == null) {
                        identifierID = tpl.getIdentifierID();
                    } else {
                        this.fail(tplOrigin, templateName, errMsgTpl, "identifier ID");
                    }
                }
                if (!tpl.isOptionalInherited()) {
                    if (isOptional == null) {
                        isOptional = tpl.isOptional();
                    } else {
                        this.fail(tplOrigin, templateName, errMsgTpl, "is-optional");
                    }
                }
                if (!tpl.isVirtualInherited()) {
                    if (isVirtual == null) {
                        isVirtual = tpl.isVirtual();
                    } else {
                        this.fail(tplOrigin, templateName, errMsgTpl, "is-virtual");
                    }
                }
                if (!tpl.isFailureInherited()) {
                    if (isFailure == null) {
                        isFailure = tpl.isFailure();
                    } else {
                        this.fail(tplOrigin, templateName, errMsgTpl, "is-failure");
                    }
                }
                if (!tpl.isDefaultValueInherited()) {
                    if (defaultValue == null) {
                        defaultValue = tpl.getDefaultValue();
                    } else {
                        this.fail(tplOrigin, templateName, errMsgTpl, "default value");
                    }
                }
                descToMerge.add(tpl.getConfigurationDescription());
                confToMerge.add(tpl.getConfiguration());
            }
            ++i;
        }
        if (templateDescription == null) {
            templateDescription = "";
        }
        ConfigurationDescription configurationDescription = this.mergeConfigurationDescription(descToMerge, origins, templateName, true);
        ActivityConfiguration configuration = this.mergeConfiguration(confToMerge, origins, templateName, false, true);
        if (this.factory == null) {
            return null;
        }
        return this.factory.createATParameterTemplate(templateName, templateDescription, accessType, name, description, dataType, udtName, identifierID, isOptional, isVirtual, isFailure, defaultValue, configurationDescription, configuration, null, null);
    }

    private ConfigurationDescription mergeConfigurationDescription(List<StorageConfigurationDescription> configurationDescriptions, List<Origin> origins, String hmm, boolean setOnceStyle) {
        HashMap<String, ConfigurationDescription.ConfigurationEntry> mergedEntries = new HashMap<String, ConfigurationDescription.ConfigurationEntry>();
        int i = 0;
        int count = configurationDescriptions.size();
        while (i < count) {
            StorageConfigurationDescription desc = configurationDescriptions.get(i);
            Origin descOrigin = origins.get(i);
            Map<String, ConfigurationDescription.ConfigurationEntry> entries = desc.getEntries();
            for (Map.Entry<String, ConfigurationDescription.ConfigurationEntry> entry : entries.entrySet()) {
                String errMsg;
                ConfigurationDescription.ConfigurationEntry conf = entry.getValue();
                if (!mergedEntries.containsKey(entry.getKey())) {
                    if (conf == null) continue;
                    mergedEntries.put(entry.getKey(), conf);
                    continue;
                }
                if (setOnceStyle) {
                    String errMsgTpl = "configuration entries must not be overridden: %s";
                    this.failConfDesc(descOrigin, hmm, errMsgTpl, entry.getKey());
                    continue;
                }
                ConfigurationDescription.ConfigurationEntry oldEntry = (ConfigurationDescription.ConfigurationEntry)mergedEntries.get(entry.getKey());
                if (conf == null) {
                    if (!oldEntry.isOptional()) {
                        errMsg = "mandatory configuration entries cannot be removed in child configuration descriptions: %s";
                        this.failConfDesc(descOrigin, hmm, errMsg, entry.getKey());
                    }
                    mergedEntries.remove(entry.getKey());
                    continue;
                }
                if (conf.getDataType() != oldEntry.getDataType()) {
                    errMsg = "data type of configuration entries cannot be overridden: %s";
                    this.failConfDesc(descOrigin, hmm, errMsg, entry.getKey());
                    continue;
                }
                if (conf.isOptional() && !oldEntry.isOptional()) {
                    errMsg = "mandatory configuration entries cannot be overridden to be optional: %s";
                    this.failConfDesc(descOrigin, hmm, errMsg, entry.getKey());
                    continue;
                }
                mergedEntries.put(entry.getKey(), conf);
            }
            ++i;
        }
        if (this.factory == null) {
            return null;
        }
        return this.factory.createConfigurationDescription(mergedEntries);
    }

    private ActivityConfiguration mergeConfiguration(List<StorageConfiguration> configurations, List<Origin> origins, String hmm, boolean mergeTestConfigurations, boolean setOnceStyle) {
        if (mergeTestConfigurations && origins.size() * 2 != configurations.size()) {
            throw new IllegalArgumentException();
        }
        HashMap<String, String> mergedValues = new HashMap<String, String>();
        HashMap<String, String> mergedFromParam = new HashMap<String, String>();
        HashMap<String, String> mergedFromConfig = new HashMap<String, String>();
        HashSet<String> mergedFixed = new HashSet<String>();
        HashMap<String, String> mergedConfigID = new HashMap<String, String>();
        HashSet mergedEntryNames = new HashSet();
        int i = 0;
        int count = configurations.size();
        while (i < count) {
            Map<Object, Object> fromConfig;
            Map<Object, Object> fromParam;
            StorageConfiguration conf = configurations.get(i);
            Origin confOrigin = origins.get(i / 2);
            boolean isTestConf = i % 2 == 1;
            Map<String, String> values = conf.getValues();
            if (conf instanceof StorageActivityConfiguration) {
                StorageActivityConfiguration aConf = (StorageActivityConfiguration)conf;
                fromParam = aConf.getFromInputParameters();
                fromConfig = aConf.getFromProcessConfigurations();
            } else {
                fromParam = Collections.emptyMap();
                fromConfig = Collections.emptyMap();
            }
            Set<Object> fixed = !isTestConf ? conf.getFixedForChildren() : Collections.emptySet();
            HashSet<Object> entryNames = new HashSet<Object>();
            entryNames.addAll(values.keySet());
            entryNames.addAll(fromParam.keySet());
            entryNames.addAll(fromConfig.keySet());
            for (String string : entryNames) {
                String value;
                String msg;
                if (mergedEntryNames.contains(string) && setOnceStyle) {
                    String errMsgTpl = "configuration entries must not be overridden: %s";
                    this.failConf(confOrigin, hmm, isTestConf, errMsgTpl, string);
                }
                int occurrences = 0;
                if (values.containsKey(string)) {
                    ++occurrences;
                }
                if (fromParam.containsKey(string)) {
                    ++occurrences;
                }
                if (fromConfig.containsKey(string)) {
                    ++occurrences;
                }
                if (occurrences > 1) {
                    msg = "more than one source for the value of entry '%s' was specified";
                    this.failConf(confOrigin, hmm, isTestConf, msg, string);
                }
                if (!isTestConf && mergedFixed.contains(string)) {
                    msg = "The entry '%s' cannot be overridden because it was fixed in a parent configuration.";
                    this.failConf(confOrigin, hmm, isTestConf, msg, string);
                    continue;
                }
                mergedValues.remove(string);
                mergedFromParam.remove(string);
                mergedFromConfig.remove(string);
                if (values.containsKey(string)) {
                    value = values.get(string);
                    if (value != null) {
                        mergedValues.put(string, value);
                    }
                } else if (fromParam.containsKey(string)) {
                    value = (String)fromParam.get(string);
                    if (value != null) {
                        mergedFromParam.put(string, value);
                    }
                } else {
                    value = (String)fromConfig.get(string);
                    if (value != null) {
                        mergedFromConfig.put(string, value);
                    }
                }
                mergedConfigID.put(string, this.toConfID(confOrigin, mergeTestConfigurations && isTestConf));
            }
            mergedEntryNames.addAll(entryNames);
            Iterator<Object> iterator = fixed.iterator();
            while (iterator.hasNext()) {
                String entryNameFixed = (String)iterator.next();
                if (mergedEntryNames.contains(entryNameFixed)) continue;
                String msg = "The entry '%s' is fixed but never defined here or in a parent configuration.";
                this.failConf(confOrigin, hmm, isTestConf, msg, entryNameFixed);
                iterator.remove();
            }
            mergedFixed.addAll(fixed);
            ++i;
        }
        if (this.factory == null) {
            return null;
        }
        return this.factory.createActivityConfiguration(mergedValues, mergedFromParam, mergedFromConfig, mergedFixed);
    }

    private boolean fail(Origin origin, String hmm, String msg, String ... args) {
        msg = String.format(msg, args);
        msg = String.format("%s: %s", this.getOriginText(origin, hmm), msg);
        this.checkReport.addReportEntry(null, CheckReport.ResultType.FAILURE, msg, new URI[0]);
        this.globalFailed = true;
        return true;
    }

    private boolean failConfDesc(Origin origin, String hmm, String msg, String ... args) {
        msg = String.format(msg, args);
        msg = String.format("%s > Configuration Description: %s", this.getOriginText(origin, hmm), msg);
        this.checkReport.addReportEntry(null, CheckReport.ResultType.FAILURE, msg, new URI[0]);
        this.globalFailed = true;
        return true;
    }

    private boolean failConf(Origin origin, String hmm, boolean isTestConf, String msg, String ... args) {
        msg = String.format(msg, args);
        msg = !isTestConf ? String.format("%s > Configuration: %s", this.getOriginText(origin, hmm), msg) : String.format("%s > Test Configuration: %s", this.getOriginText(origin, hmm), msg);
        this.checkReport.addReportEntry(null, CheckReport.ResultType.FAILURE, msg, new URI[0]);
        this.globalFailed = true;
        return true;
    }

    private String getOriginText(Origin origin, String hmm) {
        StringBuilder result = new StringBuilder();
        if (origin.cs()) {
            result.append("CS '").append(this.cs.getName()).append("'");
        }
        if (origin.ecd()) {
            if (result.length() > 0) {
                result.append(" > ");
            }
            result.append("ECD '").append(this.ecd.getName()).append("'");
        }
        if (origin.op()) {
            result.append(" > Operation '").append(this.op.getName()).append("'");
        }
        if (origin.atd()) {
            result.append(" > ATD '").append(this.atd.getName()).append("'");
        }
        if (origin.p()) {
            result.append(" > Parameter '").append(hmm).append("'");
        }
        if (origin.pt()) {
            result.append(" > Parameter Template '").append(hmm).append("'");
        }
        return result.toString();
    }

    private String toConfID(Origin origin, boolean test) {
        switch (origin) {
            case ECD_PT: {
                return "ParameterTemplate of ExecutableComponentDescription";
            }
            case OP: {
                return test ? "Test of Operation" : "Operation";
            }
            case OP_P: {
                return "Parameter of Operation";
            }
            case OP_PT: {
                return "ParameterTemplate of Operation";
            }
            case CS: {
                return test ? "Test of ConfigurationSet" : "ConfigurationSet";
            }
            case CS_PT: {
                return "ParameterTemplate of ConfigurationSet";
            }
            case CS_ECD: {
                return test ? "Test of ExecutableComponentDescription of ConfigurationSet" : "ExecutableComponentDescription of ConfigurationSet";
            }
            case CS_ECD_PT: {
                return "ParameterTemplate of ExecutableComponentDescription of ConfigurationSet";
            }
            case CS_OP: {
                return test ? "Test of Operation of ConfigurationSet" : "Operation of ConfigurationSet";
            }
            case CS_OP_PT: {
                return "ParameterTemplate of Operation of ConfigurationSet";
            }
            case ATD: {
                return test ? "Test of ActivityTemplateDefinition" : "ActivityTemplateDefinition";
            }
            case ATD_P: {
                return "Parameter of ActivityTemplateDefinition";
            }
            case ATD_PT: {
                return "ParameterTemplate of ActivityTemplateDefinition";
            }
        }
        throw new AssertionError();
    }

    public static interface IdentifierRetrievalCallback {
        public Identifier getIdentifier(UUID var1);
    }

    private static enum Origin {
        ECD(true, false, false, false, false, false),
        ECD_PT(true, false, false, false, false, true),
        OP(true, true, false, false, false, false),
        OP_PT(true, true, false, false, false, true),
        OP_P(true, true, false, false, true, false),
        CS(false, false, true, false, false, false),
        CS_PT(false, false, true, false, false, true),
        CS_ECD(true, false, true, false, false, false),
        CS_ECD_PT(true, false, true, false, false, true),
        CS_OP(true, true, true, false, false, false),
        CS_OP_PT(true, true, true, false, false, true),
        ATD(true, true, false, true, false, false),
        ATD_PT(true, true, false, true, false, true),
        ATD_P(true, true, false, true, true, false);

        private boolean ecd;
        private boolean op;
        private boolean cs;
        private boolean atd;
        private boolean p;
        private boolean pt;

        private Origin(boolean ecd, boolean op, boolean cs, boolean atd, boolean p, boolean pt) {
            this.ecd = ecd;
            this.op = op;
            this.cs = cs;
            this.atd = atd;
            this.p = p;
            this.pt = pt;
        }

        public boolean ecd() {
            return this.ecd;
        }

        public boolean op() {
            return this.op;
        }

        public boolean cs() {
            return this.cs;
        }

        public boolean atd() {
            return this.atd;
        }

        public boolean p() {
            return this.p;
        }

        public boolean pt() {
            return this.pt;
        }
    }
}

