/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.activityrepository.defaultimplementation;

import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.DefaultActivityRepository;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.storage.ActivityRepositoryStorage;
import de.aristaflow.adept2.model.activitymodel.ActivityModelFactory;
import de.aristaflow.adept2.model.activitymodel.StorageActivityConfiguration;
import de.aristaflow.adept2.model.activitymodel.StorageActivityModelParameter;
import de.aristaflow.adept2.model.activitymodel.StorageActivityTemplateDefinition;
import de.aristaflow.adept2.model.activitymodel.StorageConfigurationDescription;
import de.aristaflow.adept2.model.activitymodel.StorageParameterTemplate;
import de.aristaflow.adept2.model.common.ConfigurationDescription;
import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.common.State;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Logger;

abstract class AbstractManager {
    private final DefaultActivityRepository ar;

    protected AbstractManager(DefaultActivityRepository activityRepository) {
        ArgChecks.checkForNull(activityRepository, "activityRepository");
        this.ar = activityRepository;
    }

    Logger getLogger() {
        return this.ar.getLogger();
    }

    ActivityModelFactory getModelFactory() {
        return this.ar.getModelFactory();
    }

    ActivityRepositoryStorage getStorage() {
        return this.ar.getStorage();
    }

    QualifiedAgent getAgentFrom(SessionToken session) {
        return this.ar.getAgentFrom(session);
    }

    void sessionActive(SessionToken session) {
        this.ar.sessionActive(session);
    }

    void sessionFinished(SessionToken session) {
        this.ar.sessionFinished(session);
    }

    boolean isECDChanged(SessionToken session, String ecName, long branch) {
        return this.getStorage().getECDStorage().getDevelopmentECD(session, ecName, branch).getState() == State.IN_DEVELOPMENT;
    }

    boolean isOpChanged(SessionToken session, String ecName, String opName, long branch) {
        return this.getStorage().getOpStorage().getDevelopmentOperation(session, ecName, opName, branch).getState() == State.IN_DEVELOPMENT;
    }

    boolean isCSChanged(SessionToken session, String csName, long branch) {
        return this.getStorage().getCSStorage().getDevelopmentCS(session, csName, branch).getState() == State.IN_DEVELOPMENT;
    }

    static boolean areEqual(StorageActivityTemplateDefinition atd1, StorageActivityTemplateDefinition atd2) {
        if (!AbstractManager.areEqual(atd1.getExecutableComponentName(), atd2.getExecutableComponentName())) {
            return false;
        }
        if (!AbstractManager.areEqual(atd1.getOperationName(), atd2.getOperationName())) {
            return false;
        }
        if (!AbstractManager.areEqual(atd1.getConfigurationSetName(), atd2.getConfigurationSetName())) {
            return false;
        }
        if (!AbstractManager.areEqual(atd1.getName(), atd2.getName())) {
            return false;
        }
        if (!AbstractManager.areEqual(atd1.getDescription(), atd2.getDescription())) {
            return false;
        }
        if (!AbstractManager.areEqual(atd1.getDeveloperDescription(), atd2.getDeveloperDescription())) {
            return false;
        }
        if (!AbstractManager.areEqual(atd1.getImplementationClass(), atd2.getImplementationClass())) {
            return false;
        }
        if (!atd1.getClassPath().equals(atd2.getClassPath())) {
            return false;
        }
        if (atd1.isSingletonInherited() != atd2.isSingletonInherited() || atd1.isSingleton() != atd2.isSingleton()) {
            return false;
        }
        if (atd1.isSystemComponentInherited() != atd2.isSystemComponentInherited() || !AbstractManager.areEqual(atd1.getSystemComponent(), atd2.getSystemComponent())) {
            return false;
        }
        if (!AbstractManager.areEqual(atd1.getGUIContextID(), atd2.getGUIContextID())) {
            return false;
        }
        if (!AbstractManager.areEqual(atd1.getExecutionControlProperties(), atd2.getExecutionControlProperties())) {
            return false;
        }
        if (atd1.isSupportsViewOnlyInherited() != atd2.isSupportsViewOnlyInherited() || atd1.supportsViewOnly() != atd2.supportsViewOnly()) {
            return false;
        }
        if (atd1.isSupportsTestExecutionInherited() != atd2.isSupportsTestExecutionInherited() || atd1.supportsTestExecution() != atd2.supportsTestExecution()) {
            return false;
        }
        if (!AbstractManager.areEqual(atd1.getIconID(), atd2.getIconID())) {
            return false;
        }
        if (!AbstractManager.areEqual(atd1.getLicenceInformation(), atd2.getLicenceInformation())) {
            return false;
        }
        if (!AbstractManager.areEqualCD(atd1.getConfigurationDescription(), atd2.getConfigurationDescription())) {
            return false;
        }
        if (!AbstractManager.areEqualAC(atd1.getConfiguration(), atd2.getConfiguration())) {
            return false;
        }
        if (!AbstractManager.areEqualAC(atd1.getTestConfiguration(), atd2.getTestConfiguration())) {
            return false;
        }
        if (!AbstractManager.areEqual((Object)atd1.getParameterChangePolicy(), (Object)atd2.getParameterChangePolicy())) {
            return false;
        }
        if (!AbstractManager.areEqualP(atd1.getParameters(ActivityConstants.AccessType.READ), atd2.getParameters(ActivityConstants.AccessType.READ))) {
            return false;
        }
        if (!AbstractManager.areEqualP(atd1.getParameters(ActivityConstants.AccessType.WRITE), atd2.getParameters(ActivityConstants.AccessType.WRITE))) {
            return false;
        }
        if (!AbstractManager.areEqualPT(atd1.getParameterTemplates(), atd2.getParameterTemplates())) {
            return false;
        }
        if (!AbstractManager.areEqual(atd1.getStaffAssignmentRule(), atd2.getStaffAssignmentRule())) {
            return false;
        }
        if (!AbstractManager.areEqualPD(atd1, atd2)) {
            return false;
        }
        return atd1.getUserAttributes().equals(atd2.getUserAttributes());
    }

    static boolean areEqualCD(StorageConfigurationDescription desc1, StorageConfigurationDescription desc2) {
        Map<String, ConfigurationDescription.ConfigurationEntry> entries1 = desc1.getEntries();
        Map<String, ConfigurationDescription.ConfigurationEntry> entries2 = desc2.getEntries();
        if (!entries1.keySet().equals(entries2.keySet())) {
            return false;
        }
        for (String entryName : entries1.keySet()) {
            ConfigurationDescription.ConfigurationEntry entry1 = entries1.get(entryName);
            ConfigurationDescription.ConfigurationEntry entry2 = entries2.get(entryName);
            if (entry1 == null && entry2 == null) continue;
            if (entry1 == null || entry2 == null) {
                return false;
            }
            if (entry1.getName().equals(entry2.getName()) && entry1.getDescription().equals(entry2.getDescription()) && entry1.getDataType() == entry2.getDataType() && entry1.isOptional() == entry2.isOptional() && Arrays.equals(entry1.getRestrictions(), entry2.getRestrictions())) continue;
            return false;
        }
        return true;
    }

    static boolean areEqualAC(StorageActivityConfiguration conf1, StorageActivityConfiguration conf2) {
        if (!conf1.getFixedForChildren().equals(conf2.getFixedForChildren())) {
            return false;
        }
        if (!conf1.getValues().equals(conf2.getValues())) {
            return false;
        }
        if (!conf1.getFromInputParameters().equals(conf2.getFromInputParameters())) {
            return false;
        }
        return conf1.getFromProcessConfigurations().equals(conf2.getFromProcessConfigurations());
    }

    static boolean areEqualP(Map<String, StorageActivityModelParameter> params1, Map<String, StorageActivityModelParameter> params2) {
        if (!params1.keySet().equals(params2.keySet())) {
            return false;
        }
        for (String paramName : params1.keySet()) {
            StorageActivityModelParameter param1 = params1.get(paramName);
            StorageActivityModelParameter param2 = params2.get(paramName);
            if (param1 == null && param2 == null) continue;
            if (param1 == null || param2 == null) {
                return false;
            }
            if (!AbstractManager.areEqual(param1.getName(), param2.getName())) {
                return false;
            }
            if (!AbstractManager.areEqual(param1.getDescription(), param2.getDescription())) {
                return false;
            }
            if (!AbstractManager.areEqual(param1.getDeveloperDescription(), param2.getDeveloperDescription())) {
                return false;
            }
            if (!AbstractManager.areEqual((Object)param1.getDataType(), (Object)param2.getDataType())) {
                return false;
            }
            if (!AbstractManager.areEqual(param1.getUDTName(), param2.getUDTName())) {
                return false;
            }
            if (!AbstractManager.areEqual(param1.getIdentifierID(), param2.getIdentifierID())) {
                return false;
            }
            if (param1.isOptionalInherited() != param2.isOptionalInherited() || param1.isOptional() != param2.isOptional()) {
                return false;
            }
            if (param1.isVirtualInherited() != param2.isVirtualInherited() || param1.isVirtual() != param2.isVirtual()) {
                return false;
            }
            if (param1.isFailureInherited() != param2.isFailureInherited() || param1.isFailure() != param2.isFailure()) {
                return false;
            }
            if (!AbstractManager.areEqual(param1.getDefaultValue(), param2.getDefaultValue())) {
                return false;
            }
            if (!AbstractManager.areEqualCD(param1.getConfigurationDescription(), param2.getConfigurationDescription())) {
                return false;
            }
            if (!AbstractManager.areEqualAC(param1.getConfiguration(), param2.getConfiguration())) {
                return false;
            }
            if (!AbstractManager.areEqualPD(param1, param2)) {
                return false;
            }
            if (param1.getUserAttributes().equals(param2.getUserAttributes())) continue;
            return false;
        }
        return true;
    }

    static boolean areEqualPT(Map<String, StorageParameterTemplate> params1, Map<String, StorageParameterTemplate> params2) {
        if (!params1.keySet().equals(params2.keySet())) {
            return false;
        }
        for (String paramName : params1.keySet()) {
            StorageParameterTemplate param1 = params1.get(paramName);
            StorageParameterTemplate param2 = params2.get(paramName);
            if (param1 == null && param2 == null) continue;
            if (param1 == null || param2 == null) {
                return false;
            }
            if (!AbstractManager.areEqual(param1.getTemplateName(), param2.getTemplateName())) {
                return false;
            }
            if (!AbstractManager.areEqual(param1.getTemplateDescription(), param2.getTemplateDescription())) {
                return false;
            }
            if (!AbstractManager.areEqual(param1.getName(), param2.getName())) {
                return false;
            }
            if (!AbstractManager.areEqual(param1.getDescription(), param2.getDescription())) {
                return false;
            }
            if (!AbstractManager.areEqual((Object)param1.getDataType(), (Object)param2.getDataType())) {
                return false;
            }
            if (!AbstractManager.areEqual(param1.getUDTName(), param2.getUDTName())) {
                return false;
            }
            if (!AbstractManager.areEqual(param1.getIdentifierID(), param2.getIdentifierID())) {
                return false;
            }
            if (!AbstractManager.areEqual(param1.isOptional(), param2.isOptional())) {
                return false;
            }
            if (!AbstractManager.areEqual(param1.isVirtual(), param2.isVirtual())) {
                return false;
            }
            if (!AbstractManager.areEqual(param1.isFailure(), param2.isFailure())) {
                return false;
            }
            if (!AbstractManager.areEqual(param1.getDefaultValue(), param2.getDefaultValue())) {
                return false;
            }
            if (!AbstractManager.areEqualCD(param1.getConfigurationDescription(), param2.getConfigurationDescription())) {
                return false;
            }
            if (!AbstractManager.areEqual(param1.getConfiguration(), param2.getConfiguration())) {
                return false;
            }
            if (!AbstractManager.areEqualPD(param1, param2)) {
                return false;
            }
            if (param1.getUserAttributes().equals(param2.getUserAttributes())) continue;
            return false;
        }
        return true;
    }

    static boolean areEqualPD(PluginDataContainer pdc1, PluginDataContainer pdc2) {
        if (!pdc1.getSupportedPlugins().equals(pdc2.getSupportedPlugins())) {
            return false;
        }
        Map<String, PluginData> pds1 = pdc1.getPluginDatas();
        Map<String, PluginData> pds2 = pdc2.getPluginDatas();
        if (!pds1.keySet().equals(pds2.keySet())) {
            return false;
        }
        for (String paramName : pds1.keySet()) {
            PluginData pd1 = pds1.get(paramName);
            PluginData pd2 = pds2.get(paramName);
            if (!pd1.getPluginID().equals(pd2.getPluginID())) {
                return false;
            }
            if (pd1.getPluginData().equals(pd2.getPluginData())) continue;
            return false;
        }
        return true;
    }

    static boolean areEqual(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 != null) {
            return obj1.equals(obj2);
        }
        return obj2.equals(obj1);
    }
}

