/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.activityrepository.defaultimplementation;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.service.ADEPT2ServiceException;
import de.aristaflow.adept2.base.service.AbstractADEPT2Service;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceAccessControlException;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SecurityTokenIntegrityException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.activityrepository.ActivityRepository;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.ATBuilder;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.DefaultActivityTemplateDefinitionManager;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.DefaultConfigurationSetManager;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.DefaultExecutableComponentDescriptionManager;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.DefaultIconManager;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.DefaultIdentifierManager;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.DefaultOperationManager;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.DefaultResourceManager;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.DefaultRevisionManager;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.sql.SQLActivityRepositoryStorage;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.storage.ActivityRepositoryStorage;
import de.aristaflow.adept2.model.activitymodel.ATDReference;
import de.aristaflow.adept2.model.activitymodel.ActivityModelFactory;
import de.aristaflow.adept2.model.activitymodel.ActivityTemplate;
import de.aristaflow.adept2.model.activitymodel.Identifier;
import de.aristaflow.adept2.model.activitymodel.InheritanceConflictException;
import de.aristaflow.adept2.model.activitymodel.RevisionConflictException;
import de.aristaflow.adept2.model.activitymodel.StorageActivityTemplateDefinition;
import de.aristaflow.adept2.model.activitymodel.StorageConfigurationSet;
import de.aristaflow.adept2.model.activitymodel.StorageExecutableComponentDescription;
import de.aristaflow.adept2.model.activitymodel.StorageOperation;
import de.aristaflow.adept2.model.common.Branch;
import de.aristaflow.adept2.model.common.Revision;
import de.aristaflow.adept2.model.common.State;
import de.aristaflow.adept2.model.globals.SystemIdentifier;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.UnknownEntityException;
import java.net.URI;
import java.util.ArrayList;
import java.util.UUID;
import java.util.logging.Level;
import org.apache.commons.configuration.Configuration;

public class DefaultActivityRepository
extends AbstractADEPT2Service
implements ActivityRepository {
    private Configuration configuration;
    private ActivityRepositoryStorage storage;
    private ActivityModelFactory modelFactory;
    private DefaultRevisionManager revisionManager;
    private DefaultIdentifierManager identifierManager;
    private DefaultExecutableComponentDescriptionManager ecdManager;
    private DefaultOperationManager operationManager;
    private DefaultConfigurationSetManager csManager;
    private DefaultActivityTemplateDefinitionManager atdManager;
    private DefaultResourceManager resourceManager;
    private DefaultIconManager iconManager;

    public DefaultActivityRepository(Configuration configuration, Registry registry) {
        super(configuration, registry, new String[]{"JDBCDataSource"}, new String[0]);
        this.configuration = configuration;
    }

    @Override
    public void init(URI[] serviceURIs) throws AbortServiceException {
        this.init(serviceURIs, -2, -2, "password");
        SessionToken initSession = this.createSessionToken();
        this.storage = new SQLActivityRepositoryStorage(this.configuration, this.getDependencyRegistry(), initSession);
        this.modelFactory = this.getDependencyRegistry().getModelFactory("ActivityModelFactory", ActivityModelFactory.class);
        this.revisionManager = new DefaultRevisionManager(this);
        this.identifierManager = new DefaultIdentifierManager(this);
        this.ecdManager = new DefaultExecutableComponentDescriptionManager(this);
        this.operationManager = new DefaultOperationManager(this);
        this.csManager = new DefaultConfigurationSetManager(this);
        this.atdManager = new DefaultActivityTemplateDefinitionManager(this);
        this.iconManager = new DefaultIconManager(this);
        this.resourceManager = new DefaultResourceManager(this);
        try {
            DefaultIdentifierManager im = this.getIdentifierManager();
            ArrayList<Identifier> missingIdentifiers = new ArrayList<Identifier>();
            SystemIdentifier[] systemIdentifierArray = SystemIdentifier.getSystemIdentifiers();
            int n = systemIdentifierArray.length;
            int n2 = 0;
            while (n2 < n) {
                SystemIdentifier sysIdentifier = systemIdentifierArray[n2];
                Identifier identifier = this.getModelFactory().createIdentifier(sysIdentifier.id(), sysIdentifier.name(), sysIdentifier.description(), 0L, State.IN_DEVELOPMENT, null, null);
                try {
                    im.getLatestIdentifier(initSession, sysIdentifier.id());
                }
                catch (UnknownEntityException unknownEntityException) {
                    missingIdentifiers.add(identifier);
                }
                ++n2;
            }
            if (missingIdentifiers.size() > 0) {
                String msg;
                String comment = "[system] adding system identifiers";
                Branch branch = this.getRevisionManager().createBranch(initSession, comment);
                for (Identifier identifier : missingIdentifiers) {
                    im.storeDevelopmentIdentifier(initSession, identifier, branch.getBranch());
                }
                try {
                    this.getRevisionManager().releaseBranch(initSession, branch.getBranch(), null);
                }
                catch (InheritanceConflictException ex) {
                    msg = "An error occured while checking/creating the identifiers predefined by the system.";
                    this.logger.log(Level.SEVERE, msg, ex);
                }
                catch (RevisionConflictException ex) {
                    msg = "An error occured while checking/creating the identifiers predefined by the system.";
                    this.logger.log(Level.SEVERE, msg, ex);
                }
            }
        }
        catch (ADEPT2ServiceException ex) {
            String msg = "An error occured while checking/creating the identifiers predefined by the system.";
            this.logger.log(Level.SEVERE, msg, ex);
        }
        this.configuration = null;
    }

    @Override
    public void sessionActive(SessionToken session) {
        this.getStorage().startSession(session);
        super.sessionActive(session);
    }

    @Override
    public void sessionFinished(SessionToken session) {
        super.sessionFinished(session);
        this.getStorage().endSession(session);
    }

    ActivityModelFactory getModelFactory() {
        return this.modelFactory;
    }

    ActivityRepositoryStorage getStorage() {
        return this.storage;
    }

    QualifiedAgent getAgentFrom(SessionToken session) {
        try {
            return this.sessionFactory.checkAndGetAgent(session);
        }
        catch (SecurityTokenIntegrityException stie) {
            throw new ServiceAccessControlException("The designated session token failed the verification!", stie);
        }
    }

    @Override
    public DefaultRevisionManager getRevisionManager() {
        return this.revisionManager;
    }

    @Override
    public DefaultExecutableComponentDescriptionManager getECDManager() {
        return this.ecdManager;
    }

    @Override
    public DefaultOperationManager getOperationManager() {
        return this.operationManager;
    }

    @Override
    public DefaultConfigurationSetManager getCSManager() {
        return this.csManager;
    }

    @Override
    public DefaultActivityTemplateDefinitionManager getATDManager() {
        return this.atdManager;
    }

    @Override
    public DefaultIdentifierManager getIdentifierManager() {
        return this.identifierManager;
    }

    @Override
    public DefaultResourceManager getResourceManager() {
        return this.resourceManager;
    }

    @Override
    public DefaultIconManager getIconManager() {
        return this.iconManager;
    }

    @Override
    public ActivityTemplate getLatestActivityTemplate(SessionToken session, String ecName, String operationName, String atdName) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(ecName, "ecName");
        ArgChecks.checkForNull(operationName, "operationName");
        ArgChecks.checkForNull(atdName, "atdName");
        this.sessionActive(session);
        try {
            Revision revisionObj = this.getRevisionManager().getLatestRevision(session);
            long revision = revisionObj.getRevision();
            ActivityTemplate activityTemplate = this.getActivityTemplateRevision(session, ecName, operationName, atdName, revision);
            return activityTemplate;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public ActivityTemplate getActivityTemplateRevision(final SessionToken session, String ecName, String operationName, String atdName, final long revision) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(ecName, "ecName");
        ArgChecks.checkForNull(operationName, "operationName");
        ArgChecks.checkForNull(atdName, "atdName");
        this.sessionActive(session);
        try {
            StorageExecutableComponentDescription ecd = this.getStorage().getECDStorage().getECDRevision(session, ecName, revision);
            StorageOperation op = this.getStorage().getOpStorage().getOperationRevision(session, ecName, operationName, revision);
            StorageActivityTemplateDefinition atd = this.getStorage().getATDStorage().getATDRevision(session, ecName, operationName, atdName, revision);
            StorageConfigurationSet cs = atd.getConfigurationSetName() == null ? null : this.getStorage().getCSStorage().getCSRevision(session, atd.getConfigurationSetName(), revision);
            ATBuilder atBuilder = new ATBuilder(this.getModelFactory(), new ATBuilder.IdentifierRetrievalCallback(){

                @Override
                public Identifier getIdentifier(UUID id) {
                    return DefaultActivityRepository.this.getStorage().getIdentifierStorage().getIdentifierRevision(session, id, revision);
                }
            });
            ActivityTemplate activityTemplate = atBuilder.buildAT(ecd, op, cs, atd, null);
            return activityTemplate;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public ActivityTemplate getDevelopmentActivityTemplate(final SessionToken session, String ecName, String operationName, String atdName, final long branch) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(ecName, "ecName");
        ArgChecks.checkForNull(operationName, "operationName");
        ArgChecks.checkForNull(atdName, "atdName");
        this.sessionActive(session);
        try {
            StorageExecutableComponentDescription ecd = this.getStorage().getECDStorage().getDevelopmentECD(session, ecName, branch);
            StorageOperation op = this.getStorage().getOpStorage().getDevelopmentOperation(session, ecName, operationName, branch);
            StorageActivityTemplateDefinition atd = this.getStorage().getATDStorage().getDevelopmentATD(session, ecName, operationName, atdName, branch);
            StorageConfigurationSet cs = atd.getConfigurationSetName() == null ? null : this.getStorage().getCSStorage().getDevelopmentCS(session, atd.getConfigurationSetName(), branch);
            ATBuilder atBuilder = new ATBuilder(this.getModelFactory(), new ATBuilder.IdentifierRetrievalCallback(){

                @Override
                public Identifier getIdentifier(UUID id) {
                    return DefaultActivityRepository.this.getStorage().getIdentifierStorage().getDevelopmentIdentifier(session, id, branch);
                }
            });
            ActivityTemplate at = atBuilder.buildAT(ecd, op, cs, atd, null);
            at.setUserAttributeValue("fromDevelopmentBranch", Long.toString(branch));
            ActivityTemplate activityTemplate = at;
            return activityTemplate;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public ActivityTemplate getActivityTemplate(SessionToken session, UUID atID) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(atID, "atID");
        this.sessionActive(session);
        try {
            ATDReference atdRef = this.getStorage().getATDStorage().getATDReference(session, atID);
            String ecName = atdRef.getExecutableComponentName();
            String opName = atdRef.getOperationName();
            String atdName = atdRef.getName();
            ActivityTemplate result = atdRef.getState() == State.IN_DEVELOPMENT ? this.getDevelopmentActivityTemplate(session, ecName, opName, atdName, atdRef.getBranch()) : this.getActivityTemplateRevision(session, ecName, opName, atdName, atdRef.getRevision());
            ActivityTemplate activityTemplate = result;
            return activityTemplate;
        }
        finally {
            this.sessionFinished(session);
        }
    }
}

