/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.activityrepository.defaultimplementation;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.activityrepository.ActivityTemplateDefinitionManager;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.AbstractManager;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.DefaultActivityRepository;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.storage.ATDStorage;
import de.aristaflow.adept2.model.activitymodel.ATDReference;
import de.aristaflow.adept2.model.activitymodel.ActivityTemplateDefinition;
import de.aristaflow.adept2.model.activitymodel.ConfigurationSet;
import de.aristaflow.adept2.model.activitymodel.ExecutableComponentDescription;
import de.aristaflow.adept2.model.activitymodel.Operation;
import de.aristaflow.adept2.model.activitymodel.StorageActivityTemplateDefinition;
import de.aristaflow.adept2.model.activitymodel.StorageConfigurationSet;
import de.aristaflow.adept2.model.activitymodel.StorageExecutableComponentDescription;
import de.aristaflow.adept2.model.activitymodel.StorageOperation;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.UnknownEntityException;
import java.util.Collection;
import java.util.List;
import java.util.UUID;

public class DefaultActivityTemplateDefinitionManager
extends AbstractManager
implements ActivityTemplateDefinitionManager {
    public DefaultActivityTemplateDefinitionManager(DefaultActivityRepository activityRepository) {
        super(activityRepository);
    }

    @Override
    public ATDReference getATDReference(SessionToken session, UUID atID) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(atID, "atID");
        this.sessionActive(session);
        try {
            ATDReference aTDReference = this.getStorage().getATDStorage().getATDReference(session, atID);
            return aTDReference;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public Collection<ATDReference> getLatestATDReferencesOfOperation(SessionToken session, String ecName, String operationName, boolean productionOnly) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(ecName, "ecName");
        ArgChecks.checkForNull(operationName, "operationName");
        this.sessionActive(session);
        try {
            Collection<ATDReference> collection = this.getStorage().getATDStorage().getLatestATDsOfOperation(session, ecName, operationName, productionOnly);
            return collection;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public Collection<ATDReference> getLatestATDReferencesOfCS(SessionToken session, String csName, boolean productionOnly) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(csName, "csName");
        this.sessionActive(session);
        try {
            Collection<ATDReference> collection = this.getStorage().getATDStorage().getLatestATDsOfCS(session, csName, productionOnly);
            return collection;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public ATDReference getLatestATDReference(SessionToken session, String ecName, String operationName, String atdName) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(ecName, "ecName");
        ArgChecks.checkForNull(operationName, "operationName");
        ArgChecks.checkForNull(atdName, "atdName");
        this.sessionActive(session);
        try {
            ATDReference aTDReference = this.getStorage().getATDStorage().getLatestATDReference(session, ecName, operationName, atdName);
            return aTDReference;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public ActivityTemplateDefinition getLatestATD(SessionToken session, String ecName, String operationName, String atdName) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(ecName, "ecName");
        ArgChecks.checkForNull(operationName, "operationName");
        ArgChecks.checkForNull(atdName, "atdName");
        this.sessionActive(session);
        try {
            ActivityTemplateDefinition atd;
            StorageExecutableComponentDescription secd = this.getStorage().getECDStorage().getLatestECD(session, ecName);
            StorageOperation sop = this.getStorage().getOpStorage().getLatestOperation(session, ecName, operationName);
            StorageActivityTemplateDefinition satd = this.getStorage().getATDStorage().getLatestATD(session, ecName, operationName, atdName);
            StorageConfigurationSet scs = null;
            if (satd.getConfigurationSetName() != null) {
                scs = this.getStorage().getCSStorage().getLatestCS(session, satd.getConfigurationSetName());
            }
            ExecutableComponentDescription ecd = this.getModelFactory().convertExecutableComponentDescription(secd);
            Operation op = this.getModelFactory().convertOperation(ecd, sop);
            ConfigurationSet cs = null;
            if (scs != null) {
                cs = this.getModelFactory().convertConfigurationSet(scs);
            }
            ActivityTemplateDefinition activityTemplateDefinition = atd = this.getModelFactory().convertActivityTemplateDefinition(op, cs, satd);
            return activityTemplateDefinition;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public List<ATDReference> getATDReferenceRevisions(SessionToken session, String ecName, String operationName, String atdName) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(ecName, "ecName");
        ArgChecks.checkForNull(operationName, "operationName");
        ArgChecks.checkForNull(atdName, "atdName");
        this.sessionActive(session);
        try {
            List<ATDReference> list = this.getStorage().getATDStorage().getATDRevisionHistory(session, ecName, operationName, atdName);
            return list;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public Collection<ATDReference> getATDReferencesRevisionOfOperation(SessionToken session, String ecName, String operationName, long revision) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(ecName, "ecName");
        ArgChecks.checkForNull(operationName, "operationName");
        ArgChecks.checkForNegative(revision, "revision");
        this.sessionActive(session);
        try {
            Collection<ATDReference> collection = this.getStorage().getATDStorage().getATDsOfOperationRevision(session, ecName, operationName, revision);
            return collection;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public Collection<ATDReference> getATDReferencesRevisionOfCS(SessionToken session, String csName, long revision) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(csName, "csName");
        ArgChecks.checkForNegative(revision, "revision");
        this.sessionActive(session);
        try {
            Collection<ATDReference> collection = this.getStorage().getATDStorage().getATDsOfCSRevision(session, csName, revision);
            return collection;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public ActivityTemplateDefinition getATDRevision(SessionToken session, String ecName, String operationName, String atdName, long revision) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(ecName, "ecName");
        ArgChecks.checkForNull(operationName, "operationName");
        ArgChecks.checkForNull(atdName, "atdName");
        ArgChecks.checkForNegative(revision, "revision");
        this.sessionActive(session);
        try {
            ActivityTemplateDefinition atd;
            StorageExecutableComponentDescription secd = this.getStorage().getECDStorage().getECDRevision(session, ecName, revision);
            StorageOperation sop = this.getStorage().getOpStorage().getOperationRevision(session, ecName, operationName, revision);
            StorageActivityTemplateDefinition satd = this.getStorage().getATDStorage().getATDRevision(session, ecName, operationName, atdName, revision);
            StorageConfigurationSet scs = null;
            if (satd.getConfigurationSetName() != null) {
                scs = this.getStorage().getCSStorage().getCSRevision(session, satd.getConfigurationSetName(), revision);
            }
            ExecutableComponentDescription ecd = this.getModelFactory().convertExecutableComponentDescription(secd);
            Operation op = this.getModelFactory().convertOperation(ecd, sop);
            ConfigurationSet cs = null;
            if (scs != null) {
                cs = this.getModelFactory().convertConfigurationSet(scs);
            }
            ActivityTemplateDefinition activityTemplateDefinition = atd = this.getModelFactory().convertActivityTemplateDefinition(op, cs, satd);
            return activityTemplateDefinition;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public Collection<ATDReference> getDevelopmentATDReferencesOfOperation(SessionToken session, String ecName, String operationName, long branch) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(ecName, "ecName");
        ArgChecks.checkForNull(operationName, "operationName");
        ArgChecks.checkForNegative(branch, "branch");
        this.sessionActive(session);
        try {
            Collection<ATDReference> collection = this.getStorage().getATDStorage().getDevelopmentATDsOfOperation(session, ecName, operationName, branch, false);
            return collection;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public Collection<ATDReference> getDevelopmentATDReferencesOfCS(SessionToken session, String csName, long branch) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(csName, "csName");
        ArgChecks.checkForNegative(branch, "branch");
        this.sessionActive(session);
        try {
            Collection<ATDReference> collection = this.getStorage().getATDStorage().getDevelopmentATDsOfCS(session, csName, branch, false);
            return collection;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public ActivityTemplateDefinition getDevelopmentATD(SessionToken session, String ecName, String operationName, String atdName, long branch) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(ecName, "ecName");
        ArgChecks.checkForNull(operationName, "operationName");
        ArgChecks.checkForNull(atdName, "atdName");
        ArgChecks.checkForNegative(branch, "branch");
        this.sessionActive(session);
        try {
            ActivityTemplateDefinition atd;
            StorageExecutableComponentDescription secd = this.getStorage().getECDStorage().getDevelopmentECD(session, ecName, branch);
            StorageOperation sop = this.getStorage().getOpStorage().getDevelopmentOperation(session, ecName, operationName, branch);
            StorageActivityTemplateDefinition satd = this.getStorage().getATDStorage().getDevelopmentATD(session, ecName, operationName, atdName, branch);
            StorageConfigurationSet scs = null;
            if (satd.getConfigurationSetName() != null) {
                scs = this.getStorage().getCSStorage().getDevelopmentCS(session, satd.getConfigurationSetName(), branch);
            }
            ExecutableComponentDescription ecd = this.getModelFactory().convertExecutableComponentDescription(secd);
            Operation op = this.getModelFactory().convertOperation(ecd, sop);
            ConfigurationSet cs = null;
            if (scs != null) {
                cs = this.getModelFactory().convertConfigurationSet(scs);
            }
            ActivityTemplateDefinition activityTemplateDefinition = atd = this.getModelFactory().convertActivityTemplateDefinition(op, cs, satd);
            return activityTemplateDefinition;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public void storeDevelopmentATD(SessionToken session, StorageActivityTemplateDefinition atd, long branch) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(atd, "atd");
        ArgChecks.checkForNegative(branch, "branch");
        this.sessionActive(session);
        try {
            this.getStorage().startTransaction(session);
            atd.setID(UUID.randomUUID());
            this.getStorage().getATDStorage().storeDevelopmentATD(session, atd, branch);
            this.getStorage().finishTransaction(session);
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public void importDevelopmentATD(SessionToken session, StorageActivityTemplateDefinition atd, long branch) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(atd, "atd");
        ArgChecks.checkForNegative(branch, "branch");
        this.sessionActive(session);
        try {
            this.getStorage().startTransaction(session);
            this.getStorage().getATDStorage().storeDevelopmentATD(session, atd, branch);
            this.getStorage().finishTransaction(session);
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public void revertDevelopmentATD(SessionToken session, String ecName, String operationName, String atdName, long branch) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(ecName, "ecName");
        ArgChecks.checkForNull(operationName, "operationName");
        ArgChecks.checkForNull(atdName, "atdName");
        ArgChecks.checkForNegative(branch, "branch");
        this.sessionActive(session);
        try {
            this.getStorage().startTransaction(session);
            ATDStorage atdStorage = this.getStorage().getATDStorage();
            atdStorage.revertDevelopmentATD(session, ecName, operationName, atdName, branch);
            try {
                StorageActivityTemplateDefinition atd = atdStorage.getDevelopmentATD(session, ecName, operationName, atdName, branch);
                boolean hasChangedParent = this.isECDChanged(session, ecName, branch);
                if (!hasChangedParent) {
                    hasChangedParent = this.isOpChanged(session, ecName, operationName, branch);
                }
                if (!hasChangedParent && atd.getConfigurationSetName() != null) {
                    hasChangedParent = this.isCSChanged(session, atd.getConfigurationSetName(), branch);
                }
                if (hasChangedParent) {
                    atd.setID(UUID.randomUUID());
                    atdStorage.storeDevelopmentATD(session, atd, branch);
                }
            }
            catch (UnknownEntityException unknownEntityException) {}
            this.getStorage().finishTransaction(session);
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public CheckReport simulateUpdateOfDevelopmentATD(SessionToken session, String ecName, String operationName, String atdName, long branch) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(ecName, "ecName");
        ArgChecks.checkForNull(operationName, "operationName");
        ArgChecks.checkForNull(atdName, "atdName");
        ArgChecks.checkForNegative(branch, "branch");
        this.sessionActive(session);
        try {
            throw new UnsupportedOperationException("not yet implemented");
        }
        catch (Throwable throwable) {
            this.sessionFinished(session);
            throw throwable;
        }
    }

    @Override
    public void outdateATD(SessionToken session, String ecName, String operationName, String atdName) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(ecName, "ecName");
        ArgChecks.checkForNull(operationName, "operationName");
        ArgChecks.checkForNull(atdName, "atdName");
        this.sessionActive(session);
        try {
            this.getStorage().startTransaction(session);
            this.getStorage().getATDStorage().outdateATD(session, ecName, operationName, atdName);
            this.getStorage().finishTransaction(session);
        }
        finally {
            this.sessionFinished(session);
        }
    }
}

