/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.activityrepository.defaultimplementation;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.activityrepository.ConfigurationSetManager;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.AbstractManager;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.DefaultActivityRepository;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.storage.ATDStorage;
import de.aristaflow.adept2.model.activitymodel.ATDReference;
import de.aristaflow.adept2.model.activitymodel.CSReference;
import de.aristaflow.adept2.model.activitymodel.ConfigurationSet;
import de.aristaflow.adept2.model.activitymodel.StorageActivityTemplateDefinition;
import de.aristaflow.adept2.model.activitymodel.StorageConfigurationSet;
import de.aristaflow.adept2.model.common.Branch;
import de.aristaflow.adept2.model.common.State;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.UnknownEntityException;
import java.util.Collection;
import java.util.List;
import java.util.UUID;

public class DefaultConfigurationSetManager
extends AbstractManager
implements ConfigurationSetManager {
    public DefaultConfigurationSetManager(DefaultActivityRepository activityRepository) {
        super(activityRepository);
    }

    @Override
    public Collection<CSReference> getLatestCSReferences(SessionToken session, boolean productionOnly) {
        ArgChecks.checkForNull(session, "session");
        this.sessionActive(session);
        try {
            Collection<CSReference> collection = this.getStorage().getCSStorage().getLatestCSs(session, productionOnly);
            return collection;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public CSReference getLatestCSReference(SessionToken session, String csName) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(csName, "csName");
        this.sessionActive(session);
        try {
            CSReference cSReference = this.getStorage().getCSStorage().getLatestCSReference(session, csName);
            return cSReference;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public ConfigurationSet getLatestCS(SessionToken session, String csName) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(csName, "csName");
        this.sessionActive(session);
        try {
            ConfigurationSet cs;
            StorageConfigurationSet scs = this.getStorage().getCSStorage().getLatestCS(session, csName);
            ConfigurationSet configurationSet = cs = this.getModelFactory().convertConfigurationSet(scs);
            return configurationSet;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public List<CSReference> getCSReferenceRevisions(SessionToken session, String csName) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(csName, "csName");
        this.sessionActive(session);
        try {
            List<CSReference> list = this.getStorage().getCSStorage().getCSRevisionHistory(session, csName);
            return list;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public Collection<CSReference> getCSReferencesRevision(SessionToken session, long revision) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNegative(revision, "revision");
        this.sessionActive(session);
        try {
            Collection<CSReference> collection = this.getStorage().getCSStorage().getCSsOfRevision(session, revision);
            return collection;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public ConfigurationSet getCSRevision(SessionToken session, String csName, long revision) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(csName, "csName");
        ArgChecks.checkForNegative(revision, "revision");
        this.sessionActive(session);
        try {
            ConfigurationSet cs;
            StorageConfigurationSet scs = this.getStorage().getCSStorage().getCSRevision(session, csName, revision);
            ConfigurationSet configurationSet = cs = this.getModelFactory().convertConfigurationSet(scs);
            return configurationSet;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public Collection<CSReference> getDevelopmentCSReferences(SessionToken session, long branch) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNegative(branch, "branch");
        this.sessionActive(session);
        try {
            Collection<CSReference> collection = this.getStorage().getCSStorage().getDevelopmentCSs(session, branch, false);
            return collection;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public ConfigurationSet getDevelopmentCS(SessionToken session, String csName, long branch) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(csName, "csName");
        ArgChecks.checkForNegative(branch, "branch");
        this.sessionActive(session);
        try {
            ConfigurationSet cs;
            StorageConfigurationSet scs = this.getStorage().getCSStorage().getDevelopmentCS(session, csName, branch);
            ConfigurationSet configurationSet = cs = this.getModelFactory().convertConfigurationSet(scs);
            return configurationSet;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public void storeDevelopmentCS(SessionToken session, StorageConfigurationSet cs, long branch) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(cs, "cs");
        ArgChecks.checkForNegative(branch, "branch");
        this.sessionActive(session);
        try {
            this.getStorage().startTransaction(session);
            this.getStorage().getCSStorage().storeDevelopmentCS(session, cs, branch);
            this.getStorage().finishTransaction(session);
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public void revertDevelopmentCS(SessionToken session, String csName, long branch) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(csName, "csName");
        ArgChecks.checkForNegative(branch, "branch");
        this.sessionActive(session);
        try {
            boolean csExistsAsReleased;
            this.getStorage().startTransaction(session);
            StorageConfigurationSet cs = this.getStorage().getCSStorage().getDevelopmentCS(session, csName, branch);
            if (cs.getState() != State.IN_DEVELOPMENT) {
                return;
            }
            Branch branchObj = this.getStorage().getRevisionStorage().getBranchData(session, branch);
            long baseRevision = branchObj.getBaseRevision().getRevision();
            try {
                this.getStorage().getCSStorage().getCSRevision(session, csName, baseRevision);
                csExistsAsReleased = true;
            }
            catch (UnknownEntityException unknownEntityException) {
                csExistsAsReleased = false;
            }
            ATDStorage atdStorage = this.getStorage().getATDStorage();
            if (!csExistsAsReleased) {
                Collection<ATDReference> atdsOfCs = atdStorage.getDevelopmentATDsOfCS(session, csName, branch, true);
                for (ATDReference atdRef : atdsOfCs) {
                    atdStorage.revertDevelopmentATD(session, atdRef.getExecutableComponentName(), atdRef.getOperationName(), atdRef.getName(), branch);
                }
            } else {
                Collection<ATDReference> atdsOfOp = atdStorage.getDevelopmentATDsOfCS(session, csName, branch, false);
                for (ATDReference atdRef : atdsOfOp) {
                    String ecName = atdRef.getExecutableComponentName();
                    String opName = atdRef.getOperationName();
                    String atdName = atdRef.getName();
                    boolean hasChangedParent = this.isECDChanged(session, ecName, branch);
                    if (!hasChangedParent) {
                        hasChangedParent = this.isOpChanged(session, ecName, opName, branch);
                    }
                    StorageActivityTemplateDefinition atd = atdStorage.getDevelopmentATD(session, ecName, opName, atdName, branch);
                    if (hasChangedParent) {
                        atd.setID(UUID.randomUUID());
                        atdStorage.storeDevelopmentATD(session, atd, branch);
                        continue;
                    }
                    StorageActivityTemplateDefinition baseATD = atdStorage.getATDRevision(session, ecName, opName, atdName, baseRevision);
                    if (DefaultConfigurationSetManager.areEqual(atd, baseATD)) {
                        atdStorage.revertDevelopmentATD(session, ecName, opName, atdName, branch);
                        continue;
                    }
                    atd.setID(UUID.randomUUID());
                    atdStorage.storeDevelopmentATD(session, atd, branch);
                }
            }
            this.getStorage().getCSStorage().revertDevelopmentCS(session, csName, branch);
            this.getStorage().finishTransaction(session);
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public CheckReport simulateUpdateOfDevelopmentCS(SessionToken session, String csName, long branch) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(csName, "csName");
        ArgChecks.checkForNegative(branch, "branch");
        this.sessionActive(session);
        try {
            throw new UnsupportedOperationException("not yet implemented");
        }
        catch (Throwable throwable) {
            this.sessionFinished(session);
            throw throwable;
        }
    }

    @Override
    public void outdateCS(SessionToken session, String csName) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(csName, "csName");
        this.sessionActive(session);
        try {
            this.getStorage().startTransaction(session);
            this.getStorage().getCSStorage().outdateCS(session, csName);
            this.getStorage().finishTransaction(session);
        }
        finally {
            this.sessionFinished(session);
        }
    }
}

