/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.activityrepository.defaultimplementation;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.activityrepository.ExecutableComponentDescriptionManager;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.AbstractManager;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.DefaultActivityRepository;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.storage.ATDStorage;
import de.aristaflow.adept2.model.activitymodel.ATDReference;
import de.aristaflow.adept2.model.activitymodel.ECDReference;
import de.aristaflow.adept2.model.activitymodel.ExecutableComponentDescription;
import de.aristaflow.adept2.model.activitymodel.OperationReference;
import de.aristaflow.adept2.model.activitymodel.StorageActivityTemplateDefinition;
import de.aristaflow.adept2.model.activitymodel.StorageExecutableComponentDescription;
import de.aristaflow.adept2.model.common.Branch;
import de.aristaflow.adept2.model.common.State;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.UnknownEntityException;
import java.util.Collection;
import java.util.List;
import java.util.UUID;

public class DefaultExecutableComponentDescriptionManager
extends AbstractManager
implements ExecutableComponentDescriptionManager {
    public DefaultExecutableComponentDescriptionManager(DefaultActivityRepository activityRepository) {
        super(activityRepository);
    }

    @Override
    public Collection<ECDReference> getLatestECDReferences(SessionToken session, boolean productionOnly) {
        ArgChecks.checkForNull(session, "session");
        this.sessionActive(session);
        try {
            Collection<ECDReference> collection = this.getStorage().getECDStorage().getLatestECDs(session, productionOnly);
            return collection;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public ECDReference getLatestECDReference(SessionToken session, String ecName) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(ecName, "ecName");
        this.sessionActive(session);
        try {
            ECDReference eCDReference = this.getStorage().getECDStorage().getLatestECDReference(session, ecName);
            return eCDReference;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public ExecutableComponentDescription getLatestECD(SessionToken session, String ecName) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(ecName, "ecName");
        this.sessionActive(session);
        try {
            ExecutableComponentDescription ecd;
            StorageExecutableComponentDescription secd = this.getStorage().getECDStorage().getLatestECD(session, ecName);
            ExecutableComponentDescription executableComponentDescription = ecd = this.getModelFactory().convertExecutableComponentDescription(secd);
            return executableComponentDescription;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public List<ECDReference> getECDReferenceRevisions(SessionToken session, String ecName) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(ecName, "ecName");
        this.sessionActive(session);
        try {
            List<ECDReference> list = this.getStorage().getECDStorage().getECDRevisionHistory(session, ecName);
            return list;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public Collection<ECDReference> getECDReferencesRevision(SessionToken session, long revision) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNegative(revision, "revision");
        this.sessionActive(session);
        try {
            Collection<ECDReference> collection = this.getStorage().getECDStorage().getECDsOfRevision(session, revision);
            return collection;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public ExecutableComponentDescription getECDRevision(SessionToken session, String ecName, long revision) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(ecName, "ecName");
        ArgChecks.checkForNegative(revision, "revision");
        this.sessionActive(session);
        try {
            ExecutableComponentDescription ecd;
            StorageExecutableComponentDescription secd = this.getStorage().getECDStorage().getECDRevision(session, ecName, revision);
            ExecutableComponentDescription executableComponentDescription = ecd = this.getModelFactory().convertExecutableComponentDescription(secd);
            return executableComponentDescription;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public Collection<ECDReference> getDevelopmentECDReferences(SessionToken session, long branch) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNegative(branch, "branch");
        this.sessionActive(session);
        try {
            Collection<ECDReference> collection = this.getStorage().getECDStorage().getDevelopmentECDs(session, branch, false);
            return collection;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public ExecutableComponentDescription getDevelopmentECD(SessionToken session, String ecName, long branch) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(ecName, "ecName");
        ArgChecks.checkForNegative(branch, "branch");
        this.sessionActive(session);
        try {
            ExecutableComponentDescription ecd;
            StorageExecutableComponentDescription secd = this.getStorage().getECDStorage().getDevelopmentECD(session, ecName, branch);
            ExecutableComponentDescription executableComponentDescription = ecd = this.getModelFactory().convertExecutableComponentDescription(secd);
            return executableComponentDescription;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public void storeDevelopmentECD(SessionToken session, StorageExecutableComponentDescription ecd, long branch) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(ecd, "ecd");
        ArgChecks.checkForNegative(branch, "branch");
        this.sessionActive(session);
        try {
            this.getStorage().startTransaction(session);
            this.getStorage().getECDStorage().storeDevelopmentECD(session, ecd, branch);
            ATDStorage atdStor = this.getStorage().getATDStorage();
            String ecName = ecd.getName();
            for (OperationReference opRef : this.getStorage().getOpStorage().getDevelopmentOperationsOfECD(session, ecName, branch, false)) {
                String opName = opRef.getName();
                for (ATDReference atdRef : atdStor.getDevelopmentATDsOfOperation(session, ecName, opName, branch, false)) {
                    StorageActivityTemplateDefinition atd = atdStor.getDevelopmentATD(session, ecName, opName, atdRef.getName(), branch);
                    atd.setID(UUID.randomUUID());
                    atdStor.storeDevelopmentATD(session, atd, branch);
                }
            }
            this.getStorage().finishTransaction(session);
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public void revertDevelopmentECD(SessionToken session, String ecName, long branch) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(ecName, "ecName");
        ArgChecks.checkForNegative(branch, "branch");
        this.sessionActive(session);
        try {
            boolean ecdExistsAsReleased;
            this.getStorage().startTransaction(session);
            StorageExecutableComponentDescription ecd = this.getStorage().getECDStorage().getDevelopmentECD(session, ecName, branch);
            if (ecd.getState() != State.IN_DEVELOPMENT) {
                return;
            }
            Branch branchObj = this.getStorage().getRevisionStorage().getBranchData(session, branch);
            long baseRevision = branchObj.getBaseRevision().getRevision();
            try {
                this.getStorage().getECDStorage().getECDRevision(session, ecName, baseRevision);
                ecdExistsAsReleased = true;
            }
            catch (UnknownEntityException unknownEntityException) {
                ecdExistsAsReleased = false;
            }
            ATDStorage atdStorage = this.getStorage().getATDStorage();
            if (!ecdExistsAsReleased) {
                Collection<OperationReference> opsOfEcd = this.getStorage().getOpStorage().getDevelopmentOperationsOfECD(session, ecName, branch, true);
                for (OperationReference opRef : opsOfEcd) {
                    String opName = opRef.getName();
                    Collection<ATDReference> atdsOfOp = atdStorage.getDevelopmentATDsOfOperation(session, ecName, opName, branch, true);
                    for (ATDReference atdRef : atdsOfOp) {
                        atdStorage.revertDevelopmentATD(session, ecName, opName, atdRef.getName(), branch);
                    }
                    this.getStorage().getOpStorage().revertDevelopmentOperation(session, ecName, opRef.getName(), branch);
                }
            } else {
                Collection<OperationReference> opsOfEcd = this.getStorage().getOpStorage().getDevelopmentOperationsOfECD(session, ecName, branch, false);
                for (OperationReference opRef : opsOfEcd) {
                    boolean opChanged = opRef.getState() == State.IN_DEVELOPMENT;
                    String opName = opRef.getName();
                    Collection<ATDReference> atdsOfOp = atdStorage.getDevelopmentATDsOfOperation(session, ecName, opName, branch, false);
                    for (ATDReference atdRef : atdsOfOp) {
                        boolean hasChangedParent = opChanged;
                        if (!hasChangedParent && atdRef.getConfigurationSetName() != null) {
                            hasChangedParent = this.isCSChanged(session, atdRef.getConfigurationSetName(), branch);
                        }
                        String atdName = atdRef.getName();
                        StorageActivityTemplateDefinition atd = atdStorage.getDevelopmentATD(session, ecName, opName, atdName, branch);
                        if (hasChangedParent) {
                            atd.setID(UUID.randomUUID());
                            atdStorage.storeDevelopmentATD(session, atd, branch);
                            continue;
                        }
                        StorageActivityTemplateDefinition baseATD = atdStorage.getATDRevision(session, ecName, opName, atdName, baseRevision);
                        if (DefaultExecutableComponentDescriptionManager.areEqual(atd, baseATD)) {
                            atdStorage.revertDevelopmentATD(session, ecName, opName, atdName, branch);
                            continue;
                        }
                        atd.setID(UUID.randomUUID());
                        atdStorage.storeDevelopmentATD(session, atd, branch);
                    }
                }
            }
            this.getStorage().getECDStorage().revertDevelopmentECD(session, ecName, branch);
            this.getStorage().finishTransaction(session);
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public CheckReport simulateUpdateOfDevelopmentECD(SessionToken session, String ecName, long branch) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(ecName, "ecName");
        ArgChecks.checkForNegative(branch, "branch");
        this.sessionActive(session);
        try {
            throw new UnsupportedOperationException("not yet implemented");
        }
        catch (Throwable throwable) {
            this.sessionFinished(session);
            throw throwable;
        }
    }

    @Override
    public void outdateECD(SessionToken session, String ecName) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(ecName, "ecName");
        this.sessionActive(session);
        try {
            this.getStorage().startTransaction(session);
            this.getStorage().getECDStorage().outdateECD(session, ecName);
            this.getStorage().finishTransaction(session);
        }
        finally {
            this.sessionFinished(session);
        }
    }
}

