/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.activityrepository.defaultimplementation;

import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.activityrepository.IconManager;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.AbstractManager;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.DefaultActivityRepository;
import de.aristaflow.adept2.model.activitymodel.ChangeableIconDescriptor;
import de.aristaflow.adept2.model.common.IconDescriptor;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.CheckReport;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.MemoryCacheImageInputStream;

public class DefaultIconManager
extends AbstractManager
implements IconManager {
    public DefaultIconManager(DefaultActivityRepository activityRepository) {
        super(activityRepository);
    }

    @Override
    public Collection<IconDescriptor> getLatestIconDescriptors(SessionToken session, boolean productionOnly) {
        ArgChecks.checkForNull(session, "session");
        this.sessionActive(session);
        try {
            Collection<IconDescriptor> collection = this.getStorage().getIconStorage().getLatestIcons(session, productionOnly);
            return collection;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public IconDescriptor getLatestIconDescriptor(SessionToken session, UUID iconID) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(iconID, "iconID");
        this.sessionActive(session);
        try {
            IconDescriptor iconDescriptor = this.getStorage().getIconStorage().getLatestIconDescriptor(session, iconID);
            return iconDescriptor;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public byte[] getLatestIcon(SessionToken session, UUID iconID, IconDescriptor.Dimension dimension) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(iconID, "iconID");
        ArgChecks.checkForNull(dimension, "dimension");
        this.sessionActive(session);
        try {
            byte[] byArray = this.getStorage().getIconStorage().getLatestIcon(session, iconID, dimension);
            return byArray;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public List<IconDescriptor> getIconDescriptorRevisions(SessionToken session, UUID iconID) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(iconID, "iconID");
        this.sessionActive(session);
        try {
            List<IconDescriptor> list = this.getStorage().getIconStorage().getIconRevisionHistory(session, iconID);
            return list;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public Collection<IconDescriptor> getIconDescriptorsRevision(SessionToken session, long revision) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNegative(revision, "revision");
        this.sessionActive(session);
        try {
            Collection<IconDescriptor> collection = this.getStorage().getIconStorage().getIconsOfRevision(session, revision);
            return collection;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public IconDescriptor getIconDescriptorRevision(SessionToken session, UUID iconID, long revision) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(iconID, "iconID");
        ArgChecks.checkForNegative(revision, "revision");
        this.sessionActive(session);
        try {
            IconDescriptor iconDescriptor = this.getStorage().getIconStorage().getIconDescriptorRevision(session, iconID, revision);
            return iconDescriptor;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public byte[] getIconRevision(SessionToken session, UUID iconID, IconDescriptor.Dimension dimension, long revision) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(iconID, "iconID");
        ArgChecks.checkForNull(dimension, "dimension");
        ArgChecks.checkForNegative(revision, "revision");
        this.sessionActive(session);
        try {
            byte[] byArray = this.getStorage().getIconStorage().getIconRevision(session, iconID, dimension, revision);
            return byArray;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public Collection<ChangeableIconDescriptor> getDevelopmentIconDescriptors(SessionToken session, long branch) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNegative(branch, "branch");
        this.sessionActive(session);
        try {
            Collection<ChangeableIconDescriptor> collection = this.getStorage().getIconStorage().getDevelopmentIcons(session, branch, false);
            return collection;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public ChangeableIconDescriptor getDevelopmentIconDescriptor(SessionToken session, UUID iconID, long branch) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(iconID, "iconID");
        ArgChecks.checkForNegative(branch, "branch");
        this.sessionActive(session);
        try {
            ChangeableIconDescriptor changeableIconDescriptor = this.getStorage().getIconStorage().getDevelopmentIconDescriptor(session, iconID, branch);
            return changeableIconDescriptor;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public byte[] getDevelopmentIcon(SessionToken session, UUID iconID, IconDescriptor.Dimension dimension, long branch) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(iconID, "iconID");
        ArgChecks.checkForNull(dimension, "dimension");
        ArgChecks.checkForNegative(branch, "branch");
        this.sessionActive(session);
        try {
            byte[] byArray = this.getStorage().getIconStorage().getDevelopmentIcon(session, iconID, dimension, branch);
            return byArray;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public void storeDevelopmentIconDescriptor(SessionToken session, IconDescriptor iconDescriptor, long branch) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(iconDescriptor, "iconDescriptor");
        ArgChecks.checkForNegative(branch, "branch");
        this.sessionActive(session);
        try {
            this.getStorage().startTransaction(session);
            this.getStorage().getIconStorage().storeDevelopmentIconDescriptor(session, iconDescriptor, branch);
            this.getStorage().finishTransaction(session);
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public void addDevelopmentIcon(SessionToken session, UUID iconID, byte[] icon, long branch) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(iconID, "iconID");
        ArgChecks.checkForNull(icon, "icon");
        ArgChecks.checkForNegative(branch, "branch");
        this.sessionActive(session);
        try {
            Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName("png");
            if (!readers.hasNext()) {
                String msg = "An image reader for 'png' is required but none is registered!";
                this.getLogger().severe(msg);
                throw new InternalServiceException(msg);
            }
            ImageReader reader = readers.next();
            MemoryCacheImageInputStream imageIn = new MemoryCacheImageInputStream(new ByteArrayInputStream(icon));
            reader.setInput(imageIn, true, true);
            try {
                int width = reader.getWidth(0);
                int height = reader.getHeight(0);
                reader.dispose();
                this.getStorage().getIconStorage().addDevelopmentIcon(session, iconID, icon, new IconDescriptor.Dimension(width, height), branch);
            }
            catch (IOException ex) {
                String msg = "The icon does not seem to be a valid PNG image!";
                throw new IllegalArgumentException(msg, ex);
            }
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public void removeDevelopmentIcon(SessionToken session, UUID iconID, IconDescriptor.Dimension dimension, long branch) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(iconID, "iconID");
        ArgChecks.checkForNull(dimension, "dimension");
        ArgChecks.checkForNegative(branch, "branch");
        this.sessionActive(session);
        try {
            this.getStorage().getIconStorage().removeDevelopmentIcon(session, iconID, dimension, branch);
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public void revertDevelopmentIcon(SessionToken session, UUID iconID, long branch) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(iconID, "iconID");
        ArgChecks.checkForNegative(branch, "branch");
        this.sessionActive(session);
        try {
            this.getStorage().startTransaction(session);
            this.getStorage().getIconStorage().revertDevelopmentIcon(session, iconID, branch);
            this.getStorage().finishTransaction(session);
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public CheckReport simulateUpdateOfDevelopmentIcon(SessionToken session, UUID iconID, long branch) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(iconID, "iconID");
        ArgChecks.checkForNegative(branch, "branch");
        this.sessionActive(session);
        try {
            throw new UnsupportedOperationException("not yet implemented");
        }
        catch (Throwable throwable) {
            this.sessionFinished(session);
            throw throwable;
        }
    }

    @Override
    public void outdateIcon(SessionToken session, UUID iconID) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(iconID, "iconID");
        this.sessionActive(session);
        try {
            this.getStorage().startTransaction(session);
            this.getStorage().getIconStorage().outdateIcon(session, iconID);
            this.getStorage().finishTransaction(session);
        }
        finally {
            this.sessionFinished(session);
        }
    }
}

