/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.activityrepository.defaultimplementation;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.activityrepository.IdentifierManager;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.AbstractManager;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.DefaultActivityRepository;
import de.aristaflow.adept2.model.activitymodel.Identifier;
import de.aristaflow.adept2.model.globals.SystemIdentifier;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.CheckReport;
import java.util.Collection;
import java.util.List;
import java.util.UUID;

public class DefaultIdentifierManager
extends AbstractManager
implements IdentifierManager {
    public DefaultIdentifierManager(DefaultActivityRepository activityRepository) {
        super(activityRepository);
    }

    @Override
    public Collection<Identifier> getLatestIdentifiers(SessionToken session, boolean productionOnly) {
        ArgChecks.checkForNull(session, "session");
        this.sessionActive(session);
        try {
            Collection<Identifier> collection = this.getStorage().getIdentifierStorage().getLatestIdentifiers(session, productionOnly);
            return collection;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public Identifier getLatestIdentifier(SessionToken session, UUID identifierID) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(identifierID, "identifierID");
        this.sessionActive(session);
        try {
            Identifier identifier = this.getStorage().getIdentifierStorage().getLatestIdentifier(session, identifierID);
            return identifier;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public List<Identifier> getIdentifierRevisions(SessionToken session, UUID identifierID) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(identifierID, "identifierID");
        this.sessionActive(session);
        try {
            List<Identifier> list = this.getStorage().getIdentifierStorage().getIdentifierRevisionHistory(session, identifierID);
            return list;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public Collection<Identifier> getIdentifiersRevision(SessionToken session, long revision) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNegative(revision, "revision");
        this.sessionActive(session);
        try {
            Collection<Identifier> collection = this.getStorage().getIdentifierStorage().getIdentifiersOfRevision(session, revision);
            return collection;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public Identifier getIdentifierRevision(SessionToken session, UUID identifierID, long revision) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(identifierID, "identifierID");
        ArgChecks.checkForNegative(revision, "revision");
        this.sessionActive(session);
        try {
            Identifier identifier = this.getStorage().getIdentifierStorage().getIdentifierRevision(session, identifierID, revision);
            return identifier;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public Collection<Identifier> getDevelopmentIdentifiers(SessionToken session, long branch) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNegative(branch, "branch");
        this.sessionActive(session);
        try {
            Collection<Identifier> collection = this.getStorage().getIdentifierStorage().getDevelopmentIdentifiers(session, branch, false);
            return collection;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public Identifier getDevelopmentIdentifier(SessionToken session, UUID identifierID, long branch) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(identifierID, "identifierID");
        ArgChecks.checkForNegative(branch, "branch");
        this.sessionActive(session);
        try {
            Identifier identifier = this.getStorage().getIdentifierStorage().getDevelopmentIdentifier(session, identifierID, branch);
            return identifier;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public void storeDevelopmentIdentifier(SessionToken session, Identifier identifier, long branch) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(identifier, "identifier");
        ArgChecks.checkForNegative(branch, "branch");
        this.sessionActive(session);
        try {
            this.getStorage().startTransaction(session);
            this.getStorage().getIdentifierStorage().storeDevelopmentIdentifier(session, identifier, branch);
            this.getStorage().finishTransaction(session);
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public void revertDevelopmentIdentifier(SessionToken session, UUID identifierID, long branch) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(identifierID, "identifierID");
        ArgChecks.checkForNegative(branch, "branch");
        this.sessionActive(session);
        try {
            this.getStorage().startTransaction(session);
            this.getStorage().getIdentifierStorage().revertDevelopmentIdentifier(session, identifierID, branch);
            this.getStorage().finishTransaction(session);
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public CheckReport simulateUpdateOfDevelopmentIdentifier(SessionToken session, UUID identifierID, long branch) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(identifierID, "identifierID");
        ArgChecks.checkForNegative(branch, "branch");
        this.sessionActive(session);
        try {
            throw new UnsupportedOperationException("not yet implemented");
        }
        catch (Throwable throwable) {
            this.sessionFinished(session);
            throw throwable;
        }
    }

    @Override
    public void outdateIdentifier(SessionToken session, UUID identifierID) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(identifierID, "identifierID");
        this.sessionActive(session);
        try {
            if (SystemIdentifier.isSystemIdentifier(identifierID)) {
                String msg = "System identifiers cannot be outdated!";
                throw new IllegalArgumentException(msg);
            }
            this.getStorage().startTransaction(session);
            this.getStorage().getIdentifierStorage().outdateIdentifier(session, identifierID);
            this.getStorage().finishTransaction(session);
        }
        finally {
            this.sessionFinished(session);
        }
    }
}

