/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.activityrepository.defaultimplementation;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.activityrepository.OperationManager;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.AbstractManager;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.DefaultActivityRepository;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.storage.ATDStorage;
import de.aristaflow.adept2.model.activitymodel.ATDReference;
import de.aristaflow.adept2.model.activitymodel.ExecutableComponentDescription;
import de.aristaflow.adept2.model.activitymodel.Operation;
import de.aristaflow.adept2.model.activitymodel.OperationReference;
import de.aristaflow.adept2.model.activitymodel.StorageActivityTemplateDefinition;
import de.aristaflow.adept2.model.activitymodel.StorageExecutableComponentDescription;
import de.aristaflow.adept2.model.activitymodel.StorageOperation;
import de.aristaflow.adept2.model.common.Branch;
import de.aristaflow.adept2.model.common.State;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.UnknownEntityException;
import java.util.Collection;
import java.util.List;
import java.util.UUID;

public class DefaultOperationManager
extends AbstractManager
implements OperationManager {
    public DefaultOperationManager(DefaultActivityRepository activityRepository) {
        super(activityRepository);
    }

    @Override
    public Collection<OperationReference> getLatestOperationReferencesOfECD(SessionToken session, String ecName, boolean productionOnly) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(ecName, "ecName");
        this.sessionActive(session);
        try {
            Collection<OperationReference> collection = this.getStorage().getOpStorage().getLatestOperationReferencesOfECD(session, ecName, productionOnly);
            return collection;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public OperationReference getLatestOperationReference(SessionToken session, String ecName, String operationName) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(ecName, "ecName");
        ArgChecks.checkForNull(operationName, "operationName");
        this.sessionActive(session);
        try {
            OperationReference operationReference = this.getStorage().getOpStorage().getLatestOperationReference(session, ecName, operationName);
            return operationReference;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public Operation getLatestOperation(SessionToken session, String ecName, String operationName) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(ecName, "ecName");
        ArgChecks.checkForNull(operationName, "operationName");
        this.sessionActive(session);
        try {
            Operation op;
            StorageExecutableComponentDescription secd = this.getStorage().getECDStorage().getLatestECD(session, ecName);
            StorageOperation sop = this.getStorage().getOpStorage().getLatestOperation(session, ecName, operationName);
            ExecutableComponentDescription ecd = this.getModelFactory().convertExecutableComponentDescription(secd);
            Operation operation = op = this.getModelFactory().convertOperation(ecd, sop);
            return operation;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public List<OperationReference> getOperationReferenceRevisions(SessionToken session, String ecName, String operationName) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(ecName, "ecName");
        ArgChecks.checkForNull(operationName, "operationName");
        this.sessionActive(session);
        try {
            List<OperationReference> list = this.getStorage().getOpStorage().getOperationRevisionHistory(session, ecName, operationName);
            return list;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public Collection<OperationReference> getOperationReferencesRevisionOfECD(SessionToken session, String ecName, long revision) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(ecName, "ecName");
        ArgChecks.checkForNegative(revision, "revision");
        this.sessionActive(session);
        try {
            Collection<OperationReference> collection = this.getStorage().getOpStorage().getOperationsOfECDRevision(session, ecName, revision);
            return collection;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public Operation getOperationRevision(SessionToken session, String ecName, String operationName, long revision) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(ecName, "ecName");
        ArgChecks.checkForNull(operationName, "operationName");
        ArgChecks.checkForNegative(revision, "revision");
        this.sessionActive(session);
        try {
            Operation op;
            StorageExecutableComponentDescription secd = this.getStorage().getECDStorage().getECDRevision(session, ecName, revision);
            StorageOperation sop = this.getStorage().getOpStorage().getOperationRevision(session, ecName, operationName, revision);
            ExecutableComponentDescription ecd = this.getModelFactory().convertExecutableComponentDescription(secd);
            Operation operation = op = this.getModelFactory().convertOperation(ecd, sop);
            return operation;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public Collection<OperationReference> getDevelopmentOperationReferencesOfECD(SessionToken session, String ecName, long branch) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(ecName, "ecName");
        ArgChecks.checkForNegative(branch, "branch");
        this.sessionActive(session);
        try {
            Collection<OperationReference> collection = this.getStorage().getOpStorage().getDevelopmentOperationsOfECD(session, ecName, branch, false);
            return collection;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public Operation getDevelopmentOperation(SessionToken session, String ecName, String operationName, long branch) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(ecName, "ecName");
        ArgChecks.checkForNull(operationName, "operationName");
        ArgChecks.checkForNegative(branch, "branch");
        this.sessionActive(session);
        try {
            Operation op;
            StorageExecutableComponentDescription secd = this.getStorage().getECDStorage().getDevelopmentECD(session, ecName, branch);
            StorageOperation sop = this.getStorage().getOpStorage().getDevelopmentOperation(session, ecName, operationName, branch);
            ExecutableComponentDescription ecd = this.getModelFactory().convertExecutableComponentDescription(secd);
            Operation operation = op = this.getModelFactory().convertOperation(ecd, sop);
            return operation;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public void storeDevelopmentOperation(SessionToken session, StorageOperation operation, long branch) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(operation, "operation");
        ArgChecks.checkForNegative(branch, "branch");
        this.sessionActive(session);
        try {
            this.getStorage().startTransaction(session);
            this.getStorage().getOpStorage().storeDevelopmentOperation(session, operation, branch);
            ATDStorage atdStor = this.getStorage().getATDStorage();
            String ecName = operation.getExecutableComponentName();
            String opName = operation.getName();
            for (ATDReference atdRef : atdStor.getDevelopmentATDsOfOperation(session, ecName, opName, branch, false)) {
                StorageActivityTemplateDefinition atd = atdStor.getDevelopmentATD(session, ecName, opName, atdRef.getName(), branch);
                atd.setID(UUID.randomUUID());
                atdStor.storeDevelopmentATD(session, atd, branch);
            }
            this.getStorage().finishTransaction(session);
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public void revertDevelopmentOperation(SessionToken session, String ecName, String operationName, long branch) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(ecName, "ecName");
        ArgChecks.checkForNull(operationName, "operationName");
        ArgChecks.checkForNegative(branch, "branch");
        this.sessionActive(session);
        try {
            boolean opExistsAsReleased;
            this.getStorage().startTransaction(session);
            StorageOperation operation = this.getStorage().getOpStorage().getDevelopmentOperation(session, ecName, operationName, branch);
            if (operation.getState() != State.IN_DEVELOPMENT) {
                return;
            }
            Branch branchObj = this.getStorage().getRevisionStorage().getBranchData(session, branch);
            long baseRevision = branchObj.getBaseRevision().getRevision();
            try {
                this.getStorage().getOpStorage().getOperationRevision(session, ecName, operationName, baseRevision);
                opExistsAsReleased = true;
            }
            catch (UnknownEntityException unknownEntityException) {
                opExistsAsReleased = false;
            }
            ATDStorage atdStorage = this.getStorage().getATDStorage();
            if (!opExistsAsReleased) {
                Collection<ATDReference> atdsOfOp = atdStorage.getDevelopmentATDsOfOperation(session, ecName, operationName, branch, true);
                for (ATDReference atdRef : atdsOfOp) {
                    atdStorage.revertDevelopmentATD(session, ecName, operationName, atdRef.getName(), branch);
                }
            } else {
                boolean ecdChanged = this.isECDChanged(session, ecName, branch);
                Collection<ATDReference> atdsOfOp = atdStorage.getDevelopmentATDsOfOperation(session, ecName, operationName, branch, false);
                for (ATDReference atdRef : atdsOfOp) {
                    boolean hasChangedParent = ecdChanged;
                    if (!hasChangedParent && atdRef.getConfigurationSetName() != null) {
                        hasChangedParent = this.isCSChanged(session, atdRef.getConfigurationSetName(), branch);
                    }
                    String atdName = atdRef.getName();
                    StorageActivityTemplateDefinition atd = atdStorage.getDevelopmentATD(session, ecName, operationName, atdName, branch);
                    if (hasChangedParent) {
                        atd.setID(UUID.randomUUID());
                        atdStorage.storeDevelopmentATD(session, atd, branch);
                        continue;
                    }
                    StorageActivityTemplateDefinition baseATD = atdStorage.getATDRevision(session, ecName, operationName, atdName, baseRevision);
                    if (DefaultOperationManager.areEqual(atd, baseATD)) {
                        atdStorage.revertDevelopmentATD(session, ecName, operationName, atdName, branch);
                        continue;
                    }
                    atd.setID(UUID.randomUUID());
                    atdStorage.storeDevelopmentATD(session, atd, branch);
                }
            }
            this.getStorage().getOpStorage().revertDevelopmentOperation(session, ecName, operationName, branch);
            this.getStorage().finishTransaction(session);
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public CheckReport simulateUpdateOfDevelopmentOperation(SessionToken session, String ecName, String operationName, long branch) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public void outdateOperation(SessionToken session, String ecName, String operationName) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(ecName, "ecName");
        ArgChecks.checkForNull(operationName, "operationName");
        this.sessionActive(session);
        try {
            this.getStorage().startTransaction(session);
            this.getStorage().getOpStorage().outdateOperation(session, ecName, operationName);
            this.getStorage().finishTransaction(session);
        }
        finally {
            this.sessionFinished(session);
        }
    }
}

