/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.activityrepository.defaultimplementation;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.activityrepository.ResourceManager;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.AbstractManager;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.DefaultActivityRepository;
import de.aristaflow.adept2.model.activitymodel.ChangeableResourceDescriptor;
import de.aristaflow.adept2.model.common.ResourceDescriptor;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.CheckReport;
import java.util.Collection;
import java.util.List;
import java.util.UUID;

public class DefaultResourceManager
extends AbstractManager
implements ResourceManager {
    public DefaultResourceManager(DefaultActivityRepository activityRepository) {
        super(activityRepository);
    }

    @Override
    public Collection<ResourceDescriptor> getLatestResourceDescriptors(SessionToken session, boolean productionOnly) {
        ArgChecks.checkForNull(session, "session");
        this.sessionActive(session);
        try {
            Collection<ResourceDescriptor> collection = this.getStorage().getResourceStorage().getLatestResources(session, productionOnly);
            return collection;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public ResourceDescriptor getLatestResourceDescriptor(SessionToken session, UUID resourceID) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(resourceID, "resourceID");
        this.sessionActive(session);
        try {
            ResourceDescriptor resourceDescriptor = this.getStorage().getResourceStorage().getLatestResourceDescriptor(session, resourceID);
            return resourceDescriptor;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public byte[] getLatestResource(SessionToken session, UUID resourceID) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(resourceID, "resourceID");
        this.sessionActive(session);
        try {
            byte[] byArray = this.getStorage().getResourceStorage().getLatestResource(session, resourceID);
            return byArray;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public List<ResourceDescriptor> getResourceDescriptorRevisions(SessionToken session, UUID resourceID) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(resourceID, "resourceID");
        this.sessionActive(session);
        try {
            List<ResourceDescriptor> list = this.getStorage().getResourceStorage().getResourceRevisionHistory(session, resourceID);
            return list;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public Collection<ResourceDescriptor> getResourceDescriptorsRevision(SessionToken session, long revision) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNegative(revision, "revision");
        this.sessionActive(session);
        try {
            Collection<ResourceDescriptor> collection = this.getStorage().getResourceStorage().getResourcesOfRevision(session, revision);
            return collection;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public ResourceDescriptor getResourceDescriptorRevision(SessionToken session, UUID resourceID, long revision) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(resourceID, "resourceID");
        ArgChecks.checkForNegative(revision, "revision");
        this.sessionActive(session);
        try {
            ResourceDescriptor resourceDescriptor = this.getStorage().getResourceStorage().getResourceDescriptorRevision(session, resourceID, revision);
            return resourceDescriptor;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public byte[] getResourceRevision(SessionToken session, UUID resourceID, long revision) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(resourceID, "resourceID");
        ArgChecks.checkForNegative(revision, "revision");
        this.sessionActive(session);
        try {
            byte[] byArray = this.getStorage().getResourceStorage().getResourceRevision(session, resourceID, revision);
            return byArray;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public Collection<ChangeableResourceDescriptor> getDevelopmentResourceDescriptors(SessionToken session, long branch) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNegative(branch, "branch");
        this.sessionActive(session);
        try {
            Collection<ChangeableResourceDescriptor> collection = this.getStorage().getResourceStorage().getDevelopmentResources(session, branch, false);
            return collection;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public ChangeableResourceDescriptor getDevelopmentResourceDescriptor(SessionToken session, UUID resourceID, long branch) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(resourceID, "resourceID");
        ArgChecks.checkForNegative(branch, "branch");
        this.sessionActive(session);
        try {
            ChangeableResourceDescriptor changeableResourceDescriptor = this.getStorage().getResourceStorage().getDevelopmentResourceDescriptor(session, resourceID, branch);
            return changeableResourceDescriptor;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public byte[] getDevelopmentResource(SessionToken session, UUID resourceID, long branch) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(resourceID, "resourceID");
        ArgChecks.checkForNegative(branch, "branch");
        this.sessionActive(session);
        try {
            byte[] byArray = this.getStorage().getResourceStorage().getDevelopmentResource(session, resourceID, branch);
            return byArray;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public void storeDevelopmentResourceDescriptor(SessionToken session, ResourceDescriptor resourceDescriptor, byte[] resource, long branch) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(resourceDescriptor, "resourceDescriptor");
        ArgChecks.checkForNegative(branch, "branch");
        this.sessionActive(session);
        try {
            this.getStorage().startTransaction(session);
            this.getStorage().getResourceStorage().storeDevelopmentResourceDescriptor(session, resourceDescriptor, resource, branch);
            this.getStorage().finishTransaction(session);
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public void revertDevelopmentResource(SessionToken session, UUID resourceID, long branch) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(resourceID, "resourceID");
        ArgChecks.checkForNegative(branch, "branch");
        this.sessionActive(session);
        try {
            this.getStorage().startTransaction(session);
            this.getStorage().getResourceStorage().revertDevelopmentResource(session, resourceID, branch);
            this.getStorage().finishTransaction(session);
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public CheckReport simulateUpdateOfDevelopmentResource(SessionToken session, UUID resourceID, long branch) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(resourceID, "resourceID");
        ArgChecks.checkForNegative(branch, "branch");
        this.sessionActive(session);
        try {
            throw new UnsupportedOperationException("not yet implemented");
        }
        catch (Throwable throwable) {
            this.sessionFinished(session);
            throw throwable;
        }
    }

    @Override
    public void outdateResource(SessionToken session, UUID resourceID) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(resourceID, "resourceID");
        this.sessionActive(session);
        try {
            this.getStorage().startTransaction(session);
            this.getStorage().getResourceStorage().outdateResource(session, resourceID);
            this.getStorage().finishTransaction(session);
        }
        finally {
            this.sessionFinished(session);
        }
    }
}

