/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.activityrepository.defaultimplementation;

import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.activityrepository.RevisionManager;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.AbstractManager;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.DefaultActivityRepository;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.InheritanceConsistencyChecker;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.storage.ATDStorage;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.storage.CSStorage;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.storage.ECDStorage;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.storage.IconStorage;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.storage.IdentifierStorage;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.storage.OpStorage;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.storage.ResourceStorage;
import de.aristaflow.adept2.model.activitymodel.ATDReference;
import de.aristaflow.adept2.model.activitymodel.CSReference;
import de.aristaflow.adept2.model.activitymodel.ECDReference;
import de.aristaflow.adept2.model.activitymodel.Identifier;
import de.aristaflow.adept2.model.activitymodel.InheritanceConflictException;
import de.aristaflow.adept2.model.activitymodel.OperationReference;
import de.aristaflow.adept2.model.activitymodel.RevisionConflictException;
import de.aristaflow.adept2.model.common.Branch;
import de.aristaflow.adept2.model.common.IconDescriptor;
import de.aristaflow.adept2.model.common.ResourceDescriptor;
import de.aristaflow.adept2.model.common.Revision;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.CheckReport;
import java.net.URI;
import java.util.Collection;

public class DefaultRevisionManager
extends AbstractManager
implements RevisionManager {
    public DefaultRevisionManager(DefaultActivityRepository activityRepository) {
        super(activityRepository);
    }

    @Override
    public Revision getLatestRevision(SessionToken session) {
        ArgChecks.checkForNull(session, "session");
        this.sessionActive(session);
        try {
            Revision revision = this.getStorage().getRevisionStorage().getLatestRevisionData(session);
            return revision;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public Revision getRevisionData(SessionToken session, long revisionNo) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNegative(revisionNo, "revisionNo");
        this.sessionActive(session);
        try {
            Revision revision = this.getStorage().getRevisionStorage().getRevisionData(session, revisionNo);
            return revision;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public Collection<Branch> getAllBranches(SessionToken session) {
        ArgChecks.checkForNull(session, "session");
        this.sessionActive(session);
        try {
            Collection<Branch> collection = this.getStorage().getRevisionStorage().getAllBranches(session);
            return collection;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public Branch getBranchData(SessionToken session, long branch) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNegative(branch, "branch");
        this.sessionActive(session);
        try {
            Branch branch2 = this.getStorage().getRevisionStorage().getBranchData(session, branch);
            return branch2;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public Branch createBranch(SessionToken session, String comment) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(comment, "comment");
        this.sessionActive(session);
        try {
            this.getStorage().startTransaction(session);
            QualifiedAgent creationAgent = this.getAgentFrom(session);
            Branch result = this.getStorage().getRevisionStorage().createBranch(session, System.currentTimeMillis(), creationAgent, comment);
            this.getStorage().finishTransaction(session);
            Branch branch = result;
            return branch;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public CheckReport updateBranch(SessionToken session, long branch, boolean force) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNegative(branch, "branch");
        this.sessionActive(session);
        try {
            Branch branchObj = this.getBranchData(session, branch);
            CheckReport report = new CheckReport(null);
            if (branchObj.getBaseRevision().getRevision() == this.getLatestRevision(session).getRevision()) {
                String msg = "The base revision is already the latest revision.";
                report.addReportEntry(null, CheckReport.ResultType.OK, msg, new URI[0]);
                CheckReport checkReport = report;
                return checkReport;
            }
            boolean conflictsDetected = false;
            if (!force) {
                report.addReportEntry(null, CheckReport.ResultType.WARNING, "Version conflict checks are not yet implemented!", new URI[0]);
                conflictsDetected = true;
            }
            if (force || !conflictsDetected) {
                this.getStorage().startTransaction(session);
                long newBaseRevision = this.getLatestRevision(session).getRevision();
                this.getStorage().getIdentifierStorage().updateDevelopmentIdentifiers(session, branch, newBaseRevision);
                this.getStorage().getECDStorage().updateDevelopmentECDs(session, branch, newBaseRevision);
                this.getStorage().getOpStorage().updateDevelopmentOperations(session, branch, newBaseRevision);
                this.getStorage().getCSStorage().updateDevelopmentCSs(session, branch, newBaseRevision);
                this.getStorage().getATDStorage().updateDevelopmentATDs(session, branch, newBaseRevision);
                this.getStorage().getResourceStorage().updateDevelopmentResources(session, branch, newBaseRevision);
                this.getStorage().getIconStorage().updateDevelopmentIcons(session, branch, newBaseRevision);
                QualifiedAgent modificationAgent = this.getAgentFrom(session);
                this.getStorage().getRevisionStorage().updateBranchData(session, branch, newBaseRevision, System.currentTimeMillis(), modificationAgent, branchObj.getComment());
                this.getStorage().finishTransaction(session);
            }
            CheckReport checkReport = report;
            return checkReport;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public CheckReport checkBranch(SessionToken session, long branch) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNegative(branch, "branch");
        this.sessionActive(session);
        try {
            CheckReport report = new CheckReport(null);
            Branch branchObj = this.getStorage().getRevisionStorage().getBranchData(session, branch);
            Revision latestRevObj = this.getStorage().getRevisionStorage().getLatestRevisionData(session);
            if (latestRevObj.getRevision() > branchObj.getBaseRevision().getRevision()) {
                String msg = "The results of this report may not be exact since the base revision is not up-to-date. Please update it to the latest revision.";
                report.addReportEntry(null, CheckReport.ResultType.WARNING, msg, new URI[0]);
            }
            InheritanceConsistencyChecker checker = new InheritanceConsistencyChecker(session, this.getModelFactory(), this.getStorage(), branch);
            checker.check(report);
            CheckReport checkReport = report;
            return checkReport;
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public void releaseBranch(SessionToken session, long branch, String comment) throws RevisionConflictException, InheritanceConflictException {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNegative(branch, "branch");
        this.sessionActive(session);
        try {
            CheckReport report;
            Branch branchObj = this.getStorage().getRevisionStorage().getBranchData(session, branch);
            Revision baseRevision = branchObj.getBaseRevision();
            Revision latestRevision = this.getStorage().getRevisionStorage().getLatestRevisionData(session);
            if (latestRevision.getRevision() > baseRevision.getRevision() && (report = this.updateBranch(session, branch, false)).getCheckResult() == CheckReport.ResultType.FAILURE) {
                throw new RevisionConflictException(baseRevision, latestRevision);
            }
            report = this.checkBranch(session, branch);
            if (report.getCheckResult() == CheckReport.ResultType.FAILURE) {
                throw new InheritanceConflictException();
            }
            this.getStorage().startTransaction(session);
            long timestamp = System.currentTimeMillis();
            if (comment == null) {
                comment = branchObj.getComment();
            }
            Revision newRevisionObj = this.getStorage().getRevisionStorage().createRevision(session, timestamp, this.getAgentFrom(session), comment);
            long newRevision = newRevisionObj.getRevision();
            IdentifierStorage idStorage = this.getStorage().getIdentifierStorage();
            for (Identifier identifier : idStorage.getDevelopmentIdentifiers(session, branch, true)) {
                idStorage.outdateIdentifier(session, identifier.getID());
            }
            idStorage.releaseDevelopmentIdentifiers(session, branch, newRevision);
            ECDStorage ecdStorage = this.getStorage().getECDStorage();
            for (ECDReference ecdRef : ecdStorage.getDevelopmentECDs(session, branch, true)) {
                ecdStorage.outdateECD(session, ecdRef.getName());
            }
            ecdStorage.releaseDevelopmentECDs(session, branch, newRevision);
            OpStorage opStorage = this.getStorage().getOpStorage();
            for (OperationReference opRef : opStorage.getChangedDevelopmentOperations(session, branch)) {
                opStorage.outdateOperation(session, opRef.getExecutableComponentName(), opRef.getName());
            }
            opStorage.releaseDevelopmentOperations(session, branch, newRevision);
            CSStorage csStorage = this.getStorage().getCSStorage();
            for (CSReference csRef : csStorage.getDevelopmentCSs(session, branch, true)) {
                csStorage.outdateCS(session, csRef.getName());
            }
            csStorage.releaseDevelopmentCSs(session, branch, newRevision);
            ATDStorage atdStorage = this.getStorage().getATDStorage();
            for (ATDReference atdRef : atdStorage.getChangedDevelopmentATDs(session, branch)) {
                atdStorage.outdateATD(session, atdRef.getExecutableComponentName(), atdRef.getOperationName(), atdRef.getName());
            }
            atdStorage.releaseDevelopmentATDs(session, branch, newRevision);
            ResourceStorage resStorage = this.getStorage().getResourceStorage();
            for (ResourceDescriptor resourceDescriptor : resStorage.getDevelopmentResources(session, branch, true)) {
                resStorage.outdateResource(session, resourceDescriptor.getID());
            }
            resStorage.releaseDevelopmentResources(session, branch, newRevision);
            IconStorage iconStorage = this.getStorage().getIconStorage();
            for (IconDescriptor iconDescriptor : iconStorage.getDevelopmentIcons(session, branch, true)) {
                iconStorage.outdateIcon(session, iconDescriptor.getID());
            }
            iconStorage.releaseDevelopmentIcons(session, branch, newRevision);
            this.getStorage().getRevisionStorage().deleteBranch(session, branch);
            this.getStorage().finishTransaction(session);
        }
        finally {
            this.sessionFinished(session);
        }
    }

    @Override
    public void removeBranch(SessionToken session, long branch) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNegative(branch, "branch");
        this.sessionActive(session);
        try {
            this.getStorage().startTransaction(session);
            this.getStorage().getRevisionStorage().deleteBranch(session, branch);
            this.getStorage().finishTransaction(session);
        }
        finally {
            this.sessionFinished(session);
        }
    }
}

