/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.activityrepository.defaultimplementation;

import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.ATBuilder;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.storage.ATDStorage;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.storage.ActivityRepositoryStorage;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.storage.CSStorage;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.storage.ECDStorage;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.storage.OpStorage;
import de.aristaflow.adept2.model.activitymodel.ATDReference;
import de.aristaflow.adept2.model.activitymodel.ActivityModelFactory;
import de.aristaflow.adept2.model.activitymodel.CSReference;
import de.aristaflow.adept2.model.activitymodel.ECDReference;
import de.aristaflow.adept2.model.activitymodel.OperationReference;
import de.aristaflow.adept2.model.activitymodel.StorageActivityTemplateDefinition;
import de.aristaflow.adept2.model.activitymodel.StorageConfigurationSet;
import de.aristaflow.adept2.model.activitymodel.StorageExecutableComponentDescription;
import de.aristaflow.adept2.model.activitymodel.StorageOperation;
import de.aristaflow.adept2.model.common.State;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.CheckReport;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

class InheritanceConsistencyChecker {
    private SessionToken session;
    private ActivityModelFactory amf;
    private long branchNo;
    private ECDStorage ecdStorage;
    private OpStorage opStorage;
    private CSStorage csStorage;
    private ATDStorage atdStorage;
    private ATBuilder atBuilder;
    private CheckReport checkReport;
    private Map<String, StorageExecutableComponentDescription> cachedECDs = new HashMap<String, StorageExecutableComponentDescription>();
    private Map<OpKey, StorageOperation> cachedOps = new HashMap<OpKey, StorageOperation>();
    private Map<String, StorageConfigurationSet> cachedCSs = new HashMap<String, StorageConfigurationSet>();
    private Set<OpKey> checkedOps = new HashSet<OpKey>();
    private Set<ATDKey> checkedATDs = new HashSet<ATDKey>();

    public InheritanceConsistencyChecker(SessionToken session, ActivityModelFactory amf, ActivityRepositoryStorage storage, long branchNo) {
        this.session = session;
        this.amf = amf;
        this.branchNo = branchNo;
        this.ecdStorage = storage.getECDStorage();
        this.opStorage = storage.getOpStorage();
        this.csStorage = storage.getCSStorage();
        this.atdStorage = storage.getATDStorage();
        this.atBuilder = new ATBuilder(null, null);
    }

    public CheckReport check(CheckReport checkReport) {
        this.checkReport = checkReport == null ? new CheckReport(null) : checkReport;
        Collection<ECDReference> changedECDs = this.ecdStorage.getDevelopmentECDs(this.session, this.branchNo, true);
        for (ECDReference ecdRef : changedECDs) {
            String ecName = ecdRef.getName();
            this.checkECD(ecName);
        }
        Collection<OperationReference> changedOps = this.opStorage.getChangedDevelopmentOperations(this.session, this.branchNo);
        for (OperationReference opRef : changedOps) {
            this.checkOp(opRef.getExecutableComponentName(), opRef.getName());
        }
        Collection<CSReference> changedCSs = this.csStorage.getDevelopmentCSs(this.session, this.branchNo, true);
        for (CSReference csRef : changedCSs) {
            String csName = csRef.getName();
            StorageConfigurationSet cs = this.csStorage.getDevelopmentCS(this.session, csName, this.branchNo);
            this.checkCS(cs);
        }
        Collection<ATDReference> changedATDs = this.atdStorage.getChangedDevelopmentATDs(this.session, this.branchNo);
        for (ATDReference atdRef : changedATDs) {
            this.checkATD(atdRef.getExecutableComponentName(), atdRef.getOperationName(), atdRef.getName());
        }
        if (this.checkReport.getCheckResult() == CheckReport.ResultType.OK) {
            String msg = "No problems detected.";
            this.checkReport.addReportEntry(null, CheckReport.ResultType.OK, msg, new URI[0]);
        }
        return this.checkReport;
    }

    private void checkECD(String ecName) {
        Collection<OperationReference> affectedOps = this.opStorage.getDevelopmentOperationsOfECD(this.session, ecName, this.branchNo, false);
        for (OperationReference opRef : affectedOps) {
            this.checkOp(opRef.getExecutableComponentName(), opRef.getName());
        }
    }

    private void checkOp(String ecName, String opName) {
        OpKey opKey = new OpKey(ecName, opName);
        if (this.checkedOps.contains(opKey)) {
            return;
        }
        this.checkedOps.add(opKey);
        Collection<ATDReference> affectedATDs = this.atdStorage.getDevelopmentATDsOfOperation(this.session, ecName, opName, this.branchNo, false);
        if (affectedATDs.size() == 0) {
            this.checkATD(this.createDummyATD(ecName, opName));
        } else {
            for (ATDReference atdRef : affectedATDs) {
                this.checkATD(atdRef.getExecutableComponentName(), atdRef.getOperationName(), atdRef.getName());
            }
        }
    }

    private void checkCS(StorageConfigurationSet cs) {
        String csName = cs.getName();
        Collection<ATDReference> affectedATDs = this.atdStorage.getDevelopmentATDsOfCS(this.session, csName, this.branchNo, false);
        for (ATDReference atdRef : affectedATDs) {
            this.checkATD(atdRef.getExecutableComponentName(), atdRef.getOperationName(), atdRef.getName());
        }
    }

    private void checkATD(String ecName, String opName, String atdName) {
        ATDKey atdKey = new ATDKey(ecName, opName, atdName);
        if (this.checkedATDs.contains(atdKey)) {
            return;
        }
        this.checkedATDs.add(atdKey);
        StorageActivityTemplateDefinition atd = this.atdStorage.getDevelopmentATD(this.session, ecName, opName, atdName, this.branchNo);
        this.checkATD(atd);
    }

    private void checkATD(StorageActivityTemplateDefinition atd) {
        StorageExecutableComponentDescription ecd = this.getECD(atd.getExecutableComponentName());
        StorageOperation op = this.getOp(atd.getExecutableComponentName(), atd.getOperationName());
        StorageConfigurationSet cs = null;
        if (atd.getConfigurationSetName() != null) {
            cs = this.getCS(atd.getConfigurationSetName());
        }
        this.atBuilder.checkAT(ecd, op, cs, atd, this.checkReport);
    }

    private StorageExecutableComponentDescription getECD(String ecName) {
        StorageExecutableComponentDescription ecd = this.cachedECDs.get(ecName);
        if (ecd == null) {
            ecd = this.ecdStorage.getDevelopmentECD(this.session, ecName, this.branchNo);
            this.cachedECDs.put(ecd.getName(), ecd);
        }
        return ecd;
    }

    private StorageOperation getOp(String ecName, String opName) {
        OpKey opKey = new OpKey(ecName, opName);
        StorageOperation op = this.cachedOps.get(opKey);
        if (op == null) {
            op = this.opStorage.getDevelopmentOperation(this.session, opKey.ecName, opKey.opName, this.branchNo);
            this.cachedOps.put(opKey, op);
        }
        return op;
    }

    private StorageConfigurationSet getCS(String csName) {
        StorageConfigurationSet cs = this.cachedCSs.get(csName);
        if (cs == null) {
            cs = this.csStorage.getDevelopmentCS(this.session, csName, this.branchNo);
            this.cachedCSs.put(cs.getName(), cs);
        }
        return cs;
    }

    private StorageActivityTemplateDefinition createDummyATD(String ecName, String opName) {
        return this.amf.createStorageActivityTemplateDefinition(ecName, opName, null, UUID.randomUUID(), "dummy", null, null, 0L, State.OUTDATED, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    private static class ATDKey {
        public final String ecName;
        public final String opName;
        public final String atdName;

        ATDKey(String ecName, String opName, String atdName) {
            ArgChecks.checkForNull(ecName, "ecName");
            ArgChecks.checkForNull(opName, "opName");
            ArgChecks.checkForNull(atdName, "atdName");
            this.ecName = ecName;
            this.opName = opName;
            this.atdName = atdName;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ATDKey)) {
                return false;
            }
            ATDKey otherATDKey = (ATDKey)obj;
            return this.ecName.equals(otherATDKey.ecName) && this.opName.equals(otherATDKey.opName) && this.atdName.equals(otherATDKey.atdName);
        }

        public int hashCode() {
            return this.ecName.hashCode() ^ this.opName.hashCode() ^ this.atdName.hashCode();
        }
    }

    private static class OpKey {
        public final String ecName;
        public final String opName;

        OpKey(String ecName, String opName) {
            ArgChecks.checkForNull(ecName, "ecName");
            ArgChecks.checkForNull(opName, "opName");
            this.ecName = ecName;
            this.opName = opName;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OpKey)) {
                return false;
            }
            OpKey otherOpKey = (OpKey)obj;
            return this.ecName.equals(otherOpKey.ecName) && this.opName.equals(otherOpKey.opName);
        }

        public int hashCode() {
            return this.ecName.hashCode() ^ this.opName.hashCode();
        }
    }
}

