/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.activityrepository.defaultimplementation.sql;

import de.aristaflow.adept2.base.dbaccess.ExtendedConnection;
import de.aristaflow.adept2.base.dbaccess.JDBCTools;
import de.aristaflow.adept2.base.service.DataConsistencyException;
import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.sql.Queries;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.sql.SQLActivityRepositoryStorage;
import de.aristaflow.adept2.model.activitymodel.ActivityModelFactory;
import de.aristaflow.adept2.model.activitymodel.StorageActivityConfiguration;
import de.aristaflow.adept2.model.activitymodel.StorageActivityModelParameter;
import de.aristaflow.adept2.model.activitymodel.StorageConfiguration;
import de.aristaflow.adept2.model.activitymodel.StorageConfigurationDescription;
import de.aristaflow.adept2.model.activitymodel.StorageParameterTemplate;
import de.aristaflow.adept2.model.activitymodel.xml.ActivityModelXMLExport;
import de.aristaflow.adept2.model.activitymodel.xml.ActivityModelXMLImport;
import de.aristaflow.adept2.model.common.Branch;
import de.aristaflow.adept2.model.common.ExecutionControlProperties;
import de.aristaflow.adept2.model.common.ParameterChangePolicy;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.common.State;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.StringTools;
import de.aristaflow.adept2.util.xml.XMLFormatException;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

abstract class AbstractSQLSubStorage {
    private SQLActivityRepositoryStorage storage;
    static final String STRING_NULL = "$AR_NULL$";
    static final String STRING_EMPTY = "$AR_EMPTY$";

    AbstractSQLSubStorage(SQLActivityRepositoryStorage storage) {
        ArgChecks.checkForNull(storage, "storage");
        this.storage = storage;
    }

    SQLActivityRepositoryStorage getStorage() {
        return this.storage;
    }

    ActivityModelFactory getModelFactory() {
        return this.getStorage().getModelFactory();
    }

    ExtendedConnection getConnection(SessionToken session) {
        return this.getStorage().getConnection(session);
    }

    static void checkName(String name) {
        char[] cArray = ActivityConstants.DISALLOWED_NAME_CHARACTERS;
        int n = ActivityConstants.DISALLOWED_NAME_CHARACTERS.length;
        int n2 = 0;
        while (n2 < n) {
            char illegal = cArray[n2];
            if (name.indexOf(illegal) > -1) {
                String msg = "The name must not contain '%s' characters!";
                msg = String.format(msg, Character.valueOf(illegal));
                throw new IllegalArgumentException(msg);
            }
            ++n2;
        }
    }

    void ensureRevisionExists(SessionToken session, long revisionNo) {
        this.getStorage().getRevisionStorage().getRevisionData(session, revisionNo);
    }

    void ensureBranchExists(SessionToken session, long branchNo) {
        this.getStorage().getRevisionStorage().getBranchData(session, branchNo);
    }

    Map<ActivityConstants.AccessType, Map<String, StorageActivityModelParameter>> retrieveParameters(SessionToken session, String refIDColumn, long refID) throws SQLException {
        HashMap<ActivityConstants.AccessType, Map<String, StorageActivityModelParameter>> hashMap;
        ArgChecks.checkForNull(session, "session");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(Queries.ParameterQuery.RETRIEVE(refIDColumn));
            pstmt.setLong(1, refID);
            rs = pstmt.executeQuery();
            HashMap<ActivityConstants.AccessType, Map<String, StorageActivityModelParameter>> result = new HashMap<ActivityConstants.AccessType, Map<String, StorageActivityModelParameter>>();
            result.put(ActivityConstants.AccessType.READ, new HashMap());
            result.put(ActivityConstants.AccessType.WRITE, new HashMap());
            while (rs.next()) {
                boolean removed = rs.getBoolean("removed");
                ActivityConstants.AccessType accessType = this.getAccessType(rs, "accessType");
                if (removed) {
                    String name = rs.getString("name");
                    ((Map)result.get((Object)accessType)).put(name, null);
                    continue;
                }
                StorageActivityModelParameter param = this.readParameter(rs);
                ((Map)result.get((Object)accessType)).put(param.getName(), param);
            }
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            hashMap = result;
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly((Statement)pstmt, rs);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return hashMap;
    }

    void updateParameters(SessionToken session, String refIDColumn, long refID, Map<String, StorageActivityModelParameter> inputParams, Map<String, StorageActivityModelParameter> outputParams) throws SQLException {
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        try {
            pstmt = con.prepareStatement(Queries.ParameterQuery.DELETE(refIDColumn));
            pstmt.setLong(1, refID);
            pstmt.executeUpdate();
            pstmt = JDBCTools.close(pstmt);
            pstmt = con.prepareStatement(Queries.ParameterQuery.CREATE(refIDColumn));
            HashMap<ActivityConstants.AccessType, Map<String, StorageActivityModelParameter>> allParameters = new HashMap<ActivityConstants.AccessType, Map<String, StorageActivityModelParameter>>();
            allParameters.put(ActivityConstants.AccessType.READ, inputParams);
            allParameters.put(ActivityConstants.AccessType.WRITE, outputParams);
            for (Map.Entry entry : allParameters.entrySet()) {
                Map params = (Map)entry.getValue();
                for (Map.Entry paramEntry : params.entrySet()) {
                    StorageActivityModelParameter param = (StorageActivityModelParameter)paramEntry.getValue();
                    int col = 0;
                    pstmt.setLong(++col, refID);
                    this.setAccessType(pstmt, ++col, (ActivityConstants.AccessType)((Object)entry.getKey()));
                    pstmt.setString(++col, (String)paramEntry.getKey());
                    if (param != null) {
                        pstmt.setBoolean(++col, false);
                        this.setString(pstmt, ++col, param.getDescription(), param.isDescriptionInherited());
                        this.setString(pstmt, ++col, param.getDeveloperDescription(), param.isDeveloperDescriptionInherited());
                        this.setDataType(pstmt, ++col, param.isDataTypeInherited() ? null : param.getDataType());
                        this.setString(pstmt, ++col, param.getUDTName(), param.isDataTypeInherited());
                        ++col;
                        col = this.setUUID(pstmt, col, param.isIdentifierIDInherited() ? null : param.getIdentifierID());
                        this.setBoolean(pstmt, ++col, param.isOptional(), param.isOptionalInherited());
                        this.setBoolean(pstmt, ++col, param.isVirtual(), param.isVirtualInherited());
                        this.setBoolean(pstmt, ++col, param.isFailure(), param.isFailureInherited());
                        this.setString(pstmt, ++col, param.getDefaultValue(), param.isDefaultValueInherited());
                        this.setConfigurationDescription(pstmt, ++col, param.getConfigurationDescription());
                        this.setConfiguration(pstmt, ++col, param.getConfiguration());
                        this.setPluginData(pstmt, ++col, param);
                        this.setUserAttributes(pstmt, ++col, param.getUserAttributes());
                    } else {
                        pstmt.setBoolean(++col, true);
                        pstmt.setString(++col, null);
                        pstmt.setString(++col, null);
                        this.setDataType(pstmt, ++col, null);
                        pstmt.setString(++col, null);
                        ++col;
                        col = this.setUUID(pstmt, col, null);
                        pstmt.setNull(++col, -7);
                        pstmt.setNull(++col, -7);
                        pstmt.setNull(++col, -7);
                        pstmt.setString(++col, null);
                        this.setConfigurationDescription(pstmt, ++col, null);
                        this.setConfiguration(pstmt, ++col, null);
                        this.setPluginData(pstmt, ++col, null);
                        this.setUserAttributes(pstmt, ++col, null);
                    }
                    pstmt.executeUpdate();
                }
            }
            pstmt = JDBCTools.close(pstmt);
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(pstmt);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)pstmt);
    }

    private StorageActivityModelParameter readParameter(ResultSet rs) throws SQLException {
        String name = rs.getString("name");
        String description = this.getString(rs, "description");
        String devDescription = this.getString(rs, "devDescription");
        ProcessConstants.AdeptDataType dataType = this.getDataType(rs, "dataType");
        String udtName = this.getString(rs, "udtName");
        UUID identifierID = this.getUUID(rs, "identifierID");
        Boolean isOptional = this.getBoolean(rs, "isOptional");
        Boolean isVirtual = this.getBoolean(rs, "isVirtual");
        Boolean isFailure = this.getBoolean(rs, "isFailure");
        String defaultValue = this.getString(rs, "defaultValue");
        StorageConfigurationDescription confDesc = this.getConfigurationDescription(rs, "configurationDescription");
        StorageActivityConfiguration conf = this.getActivityConfiguration(rs, "configuration");
        PluginDataContainer pluginData = this.getPluginData(rs);
        Map<String, String> userAttributes = this.getUserAttributes(rs);
        return this.getModelFactory().createStorageParameter(name, description, devDescription, dataType, udtName, identifierID, isOptional, isVirtual, isFailure, defaultValue, confDesc, conf, pluginData, userAttributes);
    }

    void deleteParameters(SessionToken session, String refIDColumn, long refID) throws SQLException {
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        try {
            pstmt = con.prepareStatement(Queries.ParameterQuery.DELETE(refIDColumn));
            pstmt.setLong(1, refID);
            pstmt.executeUpdate();
            pstmt = JDBCTools.close(pstmt);
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(pstmt);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)pstmt);
    }

    Map<String, StorageParameterTemplate> retrieveParameterTemplates(SessionToken session, String[] refColumns, Object ... refValues) throws SQLException {
        HashMap<String, StorageParameterTemplate> hashMap;
        ArgChecks.checkForNull(session, "session");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(Queries.ParameterTemplateQuery.RETRIEVE(refColumns));
            int col = 0;
            Object[] objectArray = refValues;
            int n = refValues.length;
            int n2 = 0;
            while (n2 < n) {
                Object value = objectArray[n2];
                this.setObject(pstmt, ++col, value);
                ++n2;
            }
            rs = pstmt.executeQuery();
            HashMap<String, StorageParameterTemplate> result = new HashMap<String, StorageParameterTemplate>();
            while (rs.next()) {
                boolean removed = rs.getBoolean("removed");
                if (removed) {
                    String name = rs.getString("templateName");
                    result.put(name, null);
                    continue;
                }
                StorageParameterTemplate tpl = this.readParameterTemplate(rs);
                result.put(tpl.getTemplateName(), tpl);
            }
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            hashMap = result;
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly((Statement)pstmt, rs);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return hashMap;
    }

    void updateParameterTemplates(SessionToken session, Map<String, StorageParameterTemplate> parameterTemplates, String[] refColumns, Object ... refValues) throws SQLException {
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        try {
            pstmt = con.prepareStatement(Queries.ParameterTemplateQuery.DELETE(refColumns));
            int col = 0;
            Object[] objectArray = refValues;
            int n = refValues.length;
            int n2 = 0;
            while (n2 < n) {
                Object value = objectArray[n2];
                this.setObject(pstmt, ++col, value);
                ++n2;
            }
            pstmt.executeUpdate();
            pstmt = JDBCTools.close(pstmt);
            pstmt = con.prepareStatement(Queries.ParameterTemplateQuery.CREATE(refColumns));
            for (Map.Entry<String, StorageParameterTemplate> tplEntry : parameterTemplates.entrySet()) {
                StorageParameterTemplate tpl = tplEntry.getValue();
                col = 0;
                Object[] objectArray2 = refValues;
                int n3 = refValues.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object value = objectArray2[n4];
                    this.setObject(pstmt, ++col, value);
                    ++n4;
                }
                pstmt.setString(++col, tplEntry.getKey());
                if (tpl != null) {
                    pstmt.setBoolean(++col, false);
                    this.setString(pstmt, ++col, tpl.getTemplateDescription(), tpl.isTemplateDescriptionInherited());
                    this.setAccessType(pstmt, ++col, tpl.isAccessTypeInherited() ? null : tpl.getAccessType());
                    this.setString(pstmt, ++col, tpl.getName(), tpl.isNameInherited());
                    this.setString(pstmt, ++col, tpl.getDescription(), tpl.isDescriptionInherited());
                    this.setDataType(pstmt, ++col, tpl.isDataTypeInherited() ? null : tpl.getDataType());
                    pstmt.setString(++col, tpl.isDataTypeInherited() ? null : tpl.getUDTName());
                    ++col;
                    col = this.setUUID(pstmt, col, tpl.isIdentifierIDInherited() ? null : tpl.getIdentifierID());
                    this.setBoolean(pstmt, ++col, tpl.isOptional(), tpl.isOptionalInherited());
                    this.setBoolean(pstmt, ++col, tpl.isVirtual(), tpl.isVirtualInherited());
                    this.setBoolean(pstmt, ++col, tpl.isFailure(), tpl.isFailureInherited());
                    this.setString(pstmt, ++col, tpl.getDefaultValue(), tpl.isDefaultValueInherited());
                    this.setConfigurationDescription(pstmt, ++col, tpl.getConfigurationDescription());
                    this.setConfiguration(pstmt, ++col, tpl.getConfiguration());
                    this.setPluginData(pstmt, ++col, tpl);
                    this.setUserAttributes(pstmt, ++col, tpl.getUserAttributes());
                } else {
                    pstmt.setBoolean(++col, true);
                    pstmt.setString(++col, null);
                    this.setAccessType(pstmt, ++col, null);
                    pstmt.setString(++col, null);
                    pstmt.setString(++col, null);
                    this.setDataType(pstmt, ++col, null);
                    pstmt.setString(++col, null);
                    ++col;
                    col = this.setUUID(pstmt, col, null);
                    pstmt.setNull(++col, -7);
                    pstmt.setNull(++col, -7);
                    pstmt.setNull(++col, -7);
                    pstmt.setString(++col, null);
                    this.setConfigurationDescription(pstmt, ++col, null);
                    this.setConfiguration(pstmt, ++col, null);
                    this.setPluginData(pstmt, ++col, null);
                    this.setUserAttributes(pstmt, ++col, null);
                }
                pstmt.executeUpdate();
            }
            pstmt = JDBCTools.close(pstmt);
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(pstmt);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)pstmt);
    }

    private StorageParameterTemplate readParameterTemplate(ResultSet rs) throws SQLException {
        String templateName = rs.getString("templateName");
        String templateDescription = this.getString(rs, "templateDescription");
        String name = this.getString(rs, "name");
        String description = this.getString(rs, "description");
        ProcessConstants.AdeptDataType dataType = this.getDataType(rs, "dataType");
        String udtName = rs.getString("udtName");
        UUID identifierID = this.getUUID(rs, "identifierID");
        ActivityConstants.AccessType accessType = this.getAccessType(rs, "accessType");
        Boolean isOptional = this.getBoolean(rs, "isOptional");
        Boolean isVirtual = this.getBoolean(rs, "isVirtual");
        Boolean isFailure = this.getBoolean(rs, "isFailure");
        String defaultValue = this.getString(rs, "defaultValue");
        StorageConfigurationDescription confDesc = this.getConfigurationDescription(rs, "configurationDescription");
        StorageConfiguration conf = this.getConfiguration(rs, "configuration");
        PluginDataContainer pluginData = this.getPluginData(rs);
        Map<String, String> userAttributes = this.getUserAttributes(rs);
        return this.getModelFactory().createStorageParameterTemplate(templateName, templateDescription, accessType, name, description, dataType, udtName, identifierID, isOptional, isVirtual, isFailure, defaultValue, confDesc, conf, pluginData, userAttributes);
    }

    void deleteParameterTemplates(SessionToken session, String[] refColumns, Object ... refValues) throws SQLException {
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        try {
            pstmt = con.prepareStatement(Queries.ParameterTemplateQuery.DELETE(refColumns));
            int col = 0;
            Object[] objectArray = refValues;
            int n = refValues.length;
            int n2 = 0;
            while (n2 < n) {
                Object value = objectArray[n2];
                this.setObject(pstmt, ++col, value);
                ++n2;
            }
            pstmt.executeUpdate();
            pstmt = JDBCTools.close(pstmt);
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(pstmt);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)pstmt);
    }

    Boolean getBoolean(ResultSet rs, String columnName) throws SQLException {
        Boolean result = rs.getBoolean(columnName);
        if (rs.wasNull()) {
            result = null;
        }
        return result;
    }

    void setBoolean(PreparedStatement pstmt, int parameterIndex, Boolean bool, boolean isInherited) throws SQLException {
        if (isInherited) {
            pstmt.setNull(parameterIndex, 16);
        } else if (bool != null) {
            pstmt.setBoolean(parameterIndex, bool);
        } else {
            pstmt.setNull(parameterIndex, 16);
        }
    }

    UUID getUUID(ResultSet rs, String columnNamePrefix) throws SQLException {
        long hi = rs.getLong(String.valueOf(columnNamePrefix) + "_hi");
        if (rs.wasNull()) {
            return null;
        }
        long lo = rs.getLong(String.valueOf(columnNamePrefix) + "_lo");
        if (rs.wasNull()) {
            return null;
        }
        return new UUID(hi, lo);
    }

    int setUUID(PreparedStatement pstmt, int parameterIndex, UUID id) throws SQLException {
        int col = parameterIndex - 1;
        if (id != null) {
            pstmt.setLong(++col, id.getMostSignificantBits());
            pstmt.setLong(++col, id.getLeastSignificantBits());
        } else {
            pstmt.setNull(++col, -5);
            pstmt.setNull(++col, -5);
        }
        return col;
    }

    ActivityConstants.AccessType getAccessType(ResultSet rs, String columnName) throws SQLException {
        ActivityConstants.AccessType result;
        byte value = rs.getByte(columnName);
        if (rs.wasNull()) {
            result = null;
        } else if (value == 0) {
            result = ActivityConstants.AccessType.READ;
        } else if (value == 1) {
            result = ActivityConstants.AccessType.WRITE;
        } else {
            String msg = "The database contained an illegal value that could not be mapped to AccessType.READ or AccessType.WRITE: " + value;
            throw new DataConsistencyException(msg);
        }
        return result;
    }

    void setAccessType(PreparedStatement pstmt, int parameterIndex, ActivityConstants.AccessType accessType) throws SQLException {
        if (accessType == null) {
            pstmt.setNull(parameterIndex, -6);
        } else if (accessType == ActivityConstants.AccessType.READ) {
            pstmt.setByte(parameterIndex, (byte)0);
        } else {
            pstmt.setByte(parameterIndex, (byte)1);
        }
    }

    ProcessConstants.AdeptDataType getDataType(ResultSet rs, String columnName) throws SQLException {
        ProcessConstants.AdeptDataType result;
        byte value = rs.getByte(columnName);
        if (rs.wasNull()) {
            result = null;
        } else {
            result = ProcessConstants.AdeptDataType.valueOf(value);
            if (result == null) {
                String msg = "The database contained an illegal value that could not be mapped to an AdeptDataType: " + value;
                throw new DataConsistencyException(msg);
            }
        }
        return result;
    }

    void setDataType(PreparedStatement pstmt, int parameterIndex, ProcessConstants.AdeptDataType dataType) throws SQLException {
        if (dataType == null) {
            pstmt.setNull(parameterIndex, -6);
        } else {
            pstmt.setByte(parameterIndex, (byte)dataType.getCode());
        }
    }

    void setBranch(PreparedStatement pstmt, int parameterIndex, Branch branch) throws SQLException {
        if (branch != null) {
            pstmt.setLong(parameterIndex, branch.getBranch());
        } else {
            pstmt.setNull(parameterIndex, -5);
        }
    }

    State getState(ResultSet rs) throws SQLException {
        byte value = rs.getByte("state");
        return State.valueOf(value);
    }

    void setState(PreparedStatement pstmt, int parameterIndex, State state) throws SQLException {
        pstmt.setByte(parameterIndex, state.getCode());
    }

    byte[] getSystemComponentSignature(ResultSet rs, String columnName) throws SQLException {
        return rs.getBytes(columnName);
    }

    void setSystemComponentSignature(PreparedStatement pstmt, int parameterIndex, byte[] systemComponentSignature, boolean isInherited) throws SQLException {
        if (isInherited) {
            pstmt.setBytes(parameterIndex, null);
        } else if (systemComponentSignature == null) {
            pstmt.setBytes(parameterIndex, new byte[0]);
        } else {
            pstmt.setBytes(parameterIndex, systemComponentSignature);
        }
    }

    List<String> getClassPath(ResultSet rs, String columnName) throws SQLException {
        ArrayList<String> result;
        String value = rs.getString(columnName);
        if (value == null || value.trim().equals("")) {
            result = new ArrayList<String>(0);
        } else {
            String[] classPathElems = value.split("\\n");
            result = new ArrayList(classPathElems.length);
            String[] stringArray = classPathElems;
            int n = classPathElems.length;
            int n2 = 0;
            while (n2 < n) {
                String classPathElem = stringArray[n2];
                result.add(classPathElem);
                ++n2;
            }
        }
        return result;
    }

    void setClassPath(PreparedStatement pstmt, int parameterIndex, List<String> classPath) throws SQLException {
        String value = classPath != null && classPath.size() > 0 ? StringTools.join("\n", classPath) : null;
        pstmt.setString(parameterIndex, value);
    }

    ExecutionControlProperties getECP(ResultSet rs, String columnName) throws SQLException {
        byte value = rs.getByte(columnName);
        if (rs.wasNull()) {
            return null;
        }
        boolean isSuspensible = (value & 1) > 0;
        boolean isResettable = (value & 2) > 0;
        boolean isClosable = (value & 4) > 0;
        return new ExecutionControlProperties(isSuspensible, isResettable, isClosable);
    }

    void setECP(PreparedStatement pstmt, int parameterIndex, ExecutionControlProperties ecp) throws SQLException {
        if (ecp == null) {
            pstmt.setNull(parameterIndex, -6);
        } else {
            byte value = 0;
            if (ecp.isSuspensible()) {
                value = (byte)(value | 1);
            }
            if (ecp.isResettable()) {
                value = (byte)(value | 2);
            }
            if (ecp.isClosable()) {
                value = (byte)(value | 4);
            }
            pstmt.setByte(parameterIndex, value);
        }
    }

    StorageConfigurationDescription getConfigurationDescription(ResultSet rs, String columnName) throws SQLException {
        StorageConfigurationDescription result;
        byte[] value = rs.getBytes(columnName);
        if (value == null) {
            result = null;
        } else {
            try {
                result = new ActivityModelXMLImport(this.getModelFactory()).configurationDescriptionFromXML(value);
            }
            catch (XMLFormatException ex) {
                String msg = "The deserialisation of the configuration description failed!";
                throw new DataConsistencyException(msg, ex);
            }
            catch (IOException ex) {
                String msg = "The deserialisation of the configuration description failed!";
                throw new InternalServiceException(msg, ex);
            }
        }
        return result;
    }

    void setConfigurationDescription(PreparedStatement pstmt, int parameterIndex, StorageConfigurationDescription configurationDescription) throws SQLException {
        byte[] value;
        if (configurationDescription != null) {
            try {
                value = new ActivityModelXMLExport().configurationDescriptionToBytes(configurationDescription);
            }
            catch (IOException iOException) {
                String msg = "The serialisation of the configuration description failed!";
                throw new InternalServiceException(msg);
            }
        } else {
            value = null;
        }
        pstmt.setBytes(parameterIndex, value);
    }

    StorageConfiguration getConfiguration(ResultSet rs, String columnName) throws SQLException {
        StorageConfiguration result;
        byte[] value = rs.getBytes(columnName);
        if (value == null) {
            result = null;
        } else {
            try {
                result = new ActivityModelXMLImport(this.getModelFactory()).configurationFromXML(value);
            }
            catch (XMLFormatException xMLFormatException) {
                String msg = "The deserialisation of the configuration failed!";
                throw new DataConsistencyException(msg);
            }
            catch (IOException iOException) {
                String msg = "The deserialisation of the configuration failed!";
                throw new InternalServiceException(msg);
            }
        }
        return result;
    }

    void setConfiguration(PreparedStatement pstmt, int parameterIndex, StorageConfiguration configuration) throws SQLException {
        byte[] value;
        if (configuration != null) {
            try {
                value = new ActivityModelXMLExport().configurationToBytes(configuration);
            }
            catch (IOException ex) {
                String msg = "The serialisation of the configuration failed!";
                throw new InternalServiceException(msg, ex);
            }
        } else {
            value = null;
        }
        pstmt.setBytes(parameterIndex, value);
    }

    StorageActivityConfiguration getActivityConfiguration(ResultSet rs, String columnName) throws SQLException {
        StorageActivityConfiguration result;
        byte[] value = rs.getBytes(columnName);
        if (value == null) {
            result = null;
        } else {
            try {
                result = new ActivityModelXMLImport(this.getModelFactory()).activityConfigurationFromXML(value);
            }
            catch (XMLFormatException xMLFormatException) {
                String msg = "The deserialisation of the activity configuration failed!";
                throw new DataConsistencyException(msg);
            }
            catch (IOException iOException) {
                String msg = "The deserialisation of the activity configuration failed!";
                throw new InternalServiceException(msg);
            }
        }
        return result;
    }

    void setActivityConfiguration(PreparedStatement pstmt, int parameterIndex, StorageActivityConfiguration configuration) throws SQLException {
        byte[] value;
        if (configuration != null) {
            try {
                value = new ActivityModelXMLExport().activityConfigurationToBytes(configuration);
            }
            catch (IOException ex) {
                String msg = "The serialisation of the activity configuration failed!";
                throw new InternalServiceException(msg, ex);
            }
        } else {
            value = null;
        }
        pstmt.setBytes(parameterIndex, value);
    }

    ParameterChangePolicy getParameterChangePolicy(ResultSet rs, String columnName) throws SQLException {
        ParameterChangePolicy result;
        byte value = rs.getByte(columnName);
        if (rs.wasNull()) {
            result = null;
        } else {
            result = ParameterChangePolicy.valueOf(value);
            if (result == null) {
                String msg = "The database contained an illegal value that could not be mapped to an AdeptDataType: " + value;
                throw new DataConsistencyException(msg);
            }
        }
        return result;
    }

    void setParameterChangePolicy(PreparedStatement pstmt, int parameterIndex, ParameterChangePolicy pcp) throws SQLException {
        if (pcp == null) {
            pstmt.setNull(parameterIndex, -6);
        } else {
            pstmt.setByte(parameterIndex, pcp.getCode());
        }
    }

    PluginDataContainer getPluginData(ResultSet rs) throws SQLException {
        PluginDataContainer result;
        byte[] value = rs.getBytes("pluginData");
        if (value == null) {
            result = null;
        } else {
            try {
                result = new ActivityModelXMLImport(this.getModelFactory()).pluginDataFromXML(value);
            }
            catch (XMLFormatException xMLFormatException) {
                String msg = "The deserialisation of the plug-in data failed!";
                throw new DataConsistencyException(msg);
            }
            catch (IOException iOException) {
                String msg = "The deserialisation of the plug-in data failed!";
                throw new InternalServiceException(msg);
            }
        }
        return result;
    }

    void setPluginData(PreparedStatement pstmt, int parameterIndex, PluginDataContainer pluginData) throws SQLException {
        byte[] value;
        if (pluginData != null) {
            try {
                value = new ActivityModelXMLExport().pluginDataToBytes(pluginData);
            }
            catch (IOException ex) {
                String msg = "The serialisation of the plug-in data failed!";
                throw new InternalServiceException(msg, ex);
            }
        } else {
            value = null;
        }
        pstmt.setBytes(parameterIndex, value);
    }

    Map<String, String> getUserAttributes(ResultSet rs) throws SQLException {
        Map<String, String> result;
        byte[] value = rs.getBytes("userAttributes");
        if (value == null) {
            result = null;
        } else {
            try {
                result = new ActivityModelXMLImport(this.getModelFactory()).userAttributesFromXML(value);
            }
            catch (XMLFormatException xMLFormatException) {
                String msg = "The deserialisation of the user attributes failed!";
                throw new DataConsistencyException(msg);
            }
            catch (IOException iOException) {
                String msg = "The deserialisation of the user attributes failed!";
                throw new InternalServiceException(msg);
            }
        }
        return result;
    }

    void setUserAttributes(PreparedStatement pstmt, int parameterIndex, Map<String, String> userAttributes) throws SQLException {
        byte[] value;
        if (userAttributes != null && userAttributes.size() > 0) {
            try {
                value = new ActivityModelXMLExport().userAttributesToBytes(userAttributes);
            }
            catch (IOException ex) {
                String msg = "The serialisation of the user attributes failed!";
                throw new InternalServiceException(msg, ex);
            }
        } else {
            value = null;
        }
        pstmt.setBytes(parameterIndex, value);
    }

    String getStringNN(ResultSet rs, String columnName) throws SQLException {
        String value = rs.getString(columnName);
        if (value == null) {
            value = "";
        }
        return value;
    }

    boolean getStringExplicitNull(ResultSet rs, String columnName) throws SQLException {
        String value = rs.getString(columnName);
        return STRING_NULL.equals(value);
    }

    String getString(ResultSet rs, String columnName) throws SQLException {
        String value = rs.getString(columnName);
        String result = value == null ? null : (STRING_NULL.equals(value) ? null : (STRING_EMPTY.equals(value) ? "" : value.replace("$$", "$")));
        return result;
    }

    void setString(PreparedStatement pstmt, int parameterIndex, String string, boolean isInherited) throws SQLException {
        String value = isInherited ? null : (string == null ? STRING_NULL : ("".equals(string) ? STRING_EMPTY : string.replace("$", "$$")));
        pstmt.setString(parameterIndex, value);
    }

    private void setObject(PreparedStatement pstmt, int parameterIndex, Object object) throws SQLException {
        if (object != null) {
            pstmt.setObject(parameterIndex, object);
        } else {
            pstmt.setObject(parameterIndex, null, pstmt.getParameterMetaData().getParameterType(parameterIndex));
        }
    }
}

