/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.activityrepository.defaultimplementation.sql;

import de.aristaflow.adept2.model.common.State;
import de.aristaflow.adept2.util.StringTools;

final class Queries {
    private Queries() {
    }

    static final class ATDQuery {
        private static final String[] REF_COLUMNS = new String[]{"ecName", "opName", "configurationSetName", "id_hi", "id_lo", "name", "description", "devDescription", "revision", "branch", "state", "iconID_hi", "iconID_lo", "pluginData", "userAttributes"};
        private static final String[] COLUMNS = new String[]{"ID_", "ecName", "opName", "configurationSetName", "id_hi", "id_lo", "name", "description", "devDescription", "revision", "branch", "state", "implementationClass", "classPath", "isSingleton", "sysCompSignature", "guiContextID", "executionControlProperties", "supportsViewOnly", "supportsTestExecution", "iconID_hi", "iconID_lo", "licence", "configurationDescription", "configuration", "testConfiguration", "parameterChangePolicy", "staffAssignmentRule", "pluginData", "userAttributes"};
        private static final String[] KEY_COLUMNS = new String[]{"ecName", "opName", "name"};
        private static final String WHERE = String.format("%s = ? AND %s = ? AND %s = ?", "ecName", "opName", "name");
        private static final String WHERE_OP = String.format("%s = ? AND %s = ?", "ecName", "opName");
        private static final String WHERE_CS = String.format("%s = ?", "configurationSetName");
        static final String getATDReference = String.format("SELECT %s FROM %s WHERE %s = ? AND %s = ?", StringTools.join(", ", REF_COLUMNS), "AR_ATDs", "id_hi", "id_lo");
        static final String getLatestATDsOfOperation = CommonQuery.GET_ALL_LATEST("AR_ATDs", WHERE_OP, REF_COLUMNS, KEY_COLUMNS);
        static final String getLatestATDsOfOperation_prodOnly = CommonQuery.GET_ALL_LATEST_PROD("AR_ATDs", WHERE_OP, REF_COLUMNS, KEY_COLUMNS);
        static final String getLatestATDsOfCS = CommonQuery.GET_ALL_LATEST("AR_ATDs", WHERE_CS, REF_COLUMNS, KEY_COLUMNS);
        static final String getLatestATDsOfCS_prodOnly = CommonQuery.GET_ALL_LATEST_PROD("AR_ATDs", WHERE_CS, REF_COLUMNS, KEY_COLUMNS);
        static final String getLatestATDReference = CommonQuery.GET_LATEST("AR_ATDs", WHERE, REF_COLUMNS);
        static final String getLatestATD = CommonQuery.GET_LATEST("AR_ATDs", WHERE, COLUMNS);
        static final String getATDRevisionHistory = CommonQuery.GET_REV_HISTORY("AR_ATDs", WHERE, REF_COLUMNS);
        static final String getATDsOfOperationRevision = CommonQuery.GET_ALL_REV("AR_ATDs", WHERE_OP, REF_COLUMNS, KEY_COLUMNS);
        static final String getATDsOfCSRevision = CommonQuery.GET_ALL_REV("AR_ATDs", WHERE_CS, REF_COLUMNS, KEY_COLUMNS);
        static final String getATDRevision = CommonQuery.GET_REV("AR_ATDs", WHERE, COLUMNS);
        static final String getDevelopmentATDsOfOperation_changedOnly = CommonQuery.GET_ALL_DEV_ONLY("AR_ATDs", WHERE_OP, REF_COLUMNS);
        static final String getDevelopmentATDsOfCS_changedOnly = CommonQuery.GET_ALL_DEV_ONLY("AR_ATDs", WHERE_CS, REF_COLUMNS);
        static final String getChangedDevelopmentATDs = CommonQuery.GET_ALL_DEV_ONLY("AR_ATDs", null, REF_COLUMNS);
        static final String storeDevelopmentATD_insert = CommonQuery.STORE_DEV_INSERT("AR_ATDs", COLUMNS);
        static final String storeDevelopmentATD_update = CommonQuery.STORE_DEV_UPDATE_INTID("AR_ATDs", COLUMNS);
        static final String revertDevelopmentATD = CommonQuery.REVERT("AR_ATDs", WHERE);
        static final String updateDevelopmentATDs = CommonQuery.UPDATE_ALL("AR_ATDs");
        static final String releaseDevelopmentATDs = CommonQuery.RELEASE_ALL("AR_ATDs");
        static final String outdateATD = CommonQuery.OUTDATE("AR_ATDs", WHERE);
        static final String atdIdInBranch = CommonQuery.ID_IN_BRANCH("AR_ATDs", WHERE);

        static String getDevelopmentATDsOfOperation(String exceptKeyword) {
            return CommonQuery.GET_ALL_DEV("AR_ATDs", WHERE_OP, REF_COLUMNS, KEY_COLUMNS, exceptKeyword);
        }

        static String getDevelopmentATDsOfCS(String exceptKeyword) {
            return CommonQuery.GET_ALL_DEV("AR_ATDs", WHERE_CS, REF_COLUMNS, KEY_COLUMNS, exceptKeyword);
        }

        static String getDevelopmentATD(String exceptKeyword) {
            return CommonQuery.GET_DEV("AR_ATDs", WHERE, COLUMNS, KEY_COLUMNS, exceptKeyword);
        }

        private ATDQuery() {
        }
    }

    static final class BranchQuery {
        private static String[] COLUMNS = new String[]{"branchNo", "baseRevision", "creationTime", "creationAgentID", "creationAgentUserName", "creationAgentOrgposID", "creationAgentOrgposName", "modificationTime", "modificationAgentID", "modificationAgentUserName", "modificationAgentOrgposID", "modificationAgentOrgposName", "comment_"};
        private static String[] UPDATABLE_COLUMNS = new String[]{"baseRevision", "modificationTime", "modificationAgentID", "modificationAgentUserName", "modificationAgentOrgposID", "modificationAgentOrgposName", "comment_"};
        static final String retrieveAllBranches = String.format("SELECT %s FROM %s", StringTools.join(", ", COLUMNS), "AR_Branches");
        static final String createBranch = String.format("INSERT INTO %s (%s) VALUES (%s)", "AR_Branches", StringTools.join(", ", COLUMNS), StringTools.repeat("?", ", ", COLUMNS.length));
        static final String retrieveBranchData = String.format("SELECT %s FROM %s WHERE %s = ?", StringTools.join(", ", COLUMNS), "AR_Branches", "branchNo");
        static final String updateBranchData = String.format("UPDATE %s SET %s WHERE %s = ?", "AR_Branches", StringTools.join(", ", StringTools.surround("SET ", " = ?", UPDATABLE_COLUMNS)), "branchNo");
        static final String deleteBranch = String.format("DELETE FROM %s WHERE %s = ?", "AR_Branches", "branchNo");

        private BranchQuery() {
        }
    }

    static final class CSQuery {
        private static final String[] REF_COLUMNS = new String[]{"name", "devDescription", "revision", "state", "pluginData", "userAttributes"};
        private static final String[] COLUMNS = new String[]{"ID_", "name", "devDescription", "revision", "branch", "state", "pluginData", "userAttributes"};
        private static final String[] KEY_COLUMNS = new String[]{"name"};
        private static final String WHERE = String.format("%s = ?", "name");
        static final String getLatestCSs = CommonQuery.GET_ALL_LATEST("AR_CSs", null, REF_COLUMNS, KEY_COLUMNS);
        static final String getLatestCSs_prodOnly = CommonQuery.GET_ALL_LATEST_PROD("AR_CSs", null, REF_COLUMNS, KEY_COLUMNS);
        static final String getLatestCSReference = CommonQuery.GET_LATEST("AR_CSs", WHERE, REF_COLUMNS);
        static final String getLatestCS = CommonQuery.GET_LATEST("AR_CSs", WHERE, COLUMNS);
        static final String getCSRevisionHistory = CommonQuery.GET_REV_HISTORY("AR_CSs", WHERE, REF_COLUMNS);
        static final String getCSsOfRevision = CommonQuery.GET_ALL_REV("AR_CSs", null, REF_COLUMNS, KEY_COLUMNS);
        static final String getCSRevision = CommonQuery.GET_REV("AR_CSs", WHERE, COLUMNS);
        static final String getDevelopmentCSs_changedOnly = CommonQuery.GET_ALL_DEV_ONLY("AR_CSs", null, REF_COLUMNS);
        static final String storeDevelopmentCS_insert = CommonQuery.STORE_DEV_INSERT("AR_CSs", COLUMNS);
        static final String storeDevelopmentCS_update = CommonQuery.STORE_DEV_UPDATE_INTID("AR_CSs", COLUMNS);
        static final String revertDevelopmentCS = CommonQuery.REVERT("AR_CSs", WHERE);
        static final String updateDevelopmentCSs = CommonQuery.UPDATE_ALL("AR_CSs");
        static final String releaseDevelopmentCSs = CommonQuery.RELEASE_ALL("AR_CSs");
        static final String outdateCS = CommonQuery.OUTDATE("AR_CSs", WHERE);
        static final String csIdInBranch = CommonQuery.ID_IN_BRANCH("AR_CSs", WHERE);

        static String getDevelopmentCSs(String exceptKeyword) {
            return CommonQuery.GET_ALL_DEV("AR_CSs", null, REF_COLUMNS, KEY_COLUMNS, exceptKeyword);
        }

        static final String getDevelopmentCS(String exceptKeyword) {
            return CommonQuery.GET_DEV("AR_CSs", WHERE, COLUMNS, KEY_COLUMNS, exceptKeyword);
        }

        private CSQuery() {
        }
    }

    static final class CS_EntryQuery {
        private static final String[] COLUMNS = new String[]{"ecName", "opName", "configurationDescription", "configuration", "testConfiguration", "staffAssignmentRule"};

        static String RETRIEVE_ENTRIES() {
            return String.format("SELECT * FROM %s WHERE %s = ? ORDER BY (CASE WHEN %s IS NULL THEN 0 ELSE 1 END) DESC, (CASE WHEN %s IS NULL THEN 0 ELSE 1 END) DESC", "AR_CSs_Entries", "csID", "ecName", "opName");
        }

        static String DELETE_ENTRIES() {
            return String.format("DELETE FROM %s WHERE %s = ?", "AR_CSs_Entries", "csID");
        }

        static String DELETE_ENTRIES_PARAMETERTEMPLATES() {
            return String.format("DELETE FROM %s WHERE %s = ?", "AR_ParameterTemplates", "csID");
        }

        static String CREATE_ENTRY() {
            return String.format("INSERT INTO %s (%s, %s) VALUES (?, %s)", "AR_CSs_Entries", "csID", StringTools.join(", ", COLUMNS), StringTools.repeat("?", ", ", COLUMNS.length));
        }

        private CS_EntryQuery() {
        }
    }

    static final class CommonQuery {
        static String GET_ALL_LATEST(String table, String parentWhere, String[] resultColumns, String[] keyColumns) {
            parentWhere = parentWhere == null || parentWhere.equals("") ? "" : " AND " + parentWhere;
            return String.format("SELECT %1$s FROM %2$s ent JOIN (  SELECT %3$s, MAX(revision) AS revision FROM %2$s WHERE branch IS NULL %5$s GROUP BY %3$s) sub ON %4$s AND ent.revision = sub.revision WHERE branch IS NULL", StringTools.join(", ", StringTools.prefix("ent.", resultColumns)), table, StringTools.join(", ", keyColumns), StringTools.join(" AND ", StringTools.join(" = ", new String[][]{StringTools.prefix("ent.", keyColumns), StringTools.prefix("sub.", keyColumns)})), parentWhere);
        }

        static String GET_ALL_LATEST_PROD(String table, String parentWhere, String[] resultColumns, String[] keyColumns) {
            return String.format(String.valueOf(CommonQuery.GET_ALL_LATEST(table, parentWhere, resultColumns, keyColumns)) + " AND state = %d", State.IN_PRODUCTION.getCode());
        }

        static String GET_LATEST(String table, String where, String[] resultColumns) {
            return String.format("SELECT %1$s FROM %2$s WHERE %3$s AND revision = (SELECT MAX(revision) FROM %2$s WHERE %3$s AND branch IS NULL) AND branch IS NULL", StringTools.join(", ", resultColumns), table, where);
        }

        static String GET_REV_HISTORY(String table, String where, String[] resultColumns) {
            return String.format("SELECT %s FROM %s WHERE %s AND branch IS NULL ORDER BY revision DESC", StringTools.join(", ", resultColumns), table, where);
        }

        static String GET_ALL_REV(String table, String parentWhere, String[] resultColumns, String[] keyColumns) {
            parentWhere = parentWhere == null || parentWhere.equals("") ? "" : " AND " + parentWhere;
            return String.format("SELECT %1$s FROM %2$s ent JOIN (  SELECT %3$s, MAX(revision) AS revision FROM %2$s WHERE revision <= ? AND branch IS NULL %5$s GROUP BY %3$s) sub ON %4$s AND ent.revision = sub.revision WHERE branch IS NULL", StringTools.join(", ", StringTools.prefix("ent.", resultColumns)), table, StringTools.join(", ", keyColumns), StringTools.join(" AND ", StringTools.join(" = ", new String[][]{StringTools.prefix("ent.", keyColumns), StringTools.prefix("sub.", keyColumns)})), parentWhere);
        }

        static String GET_REV(String table, String where, String[] resultColumns) {
            return String.format("SELECT %1$s FROM %2$s WHERE %3$s AND revision = (SELECT MAX(revision) FROM %2$s WHERE %3$s AND (revision = ? OR revision < ?) AND branch IS NULL) AND branch IS NULL", StringTools.join(", ", resultColumns), table, where);
        }

        static String GET_ALL_DEV(String table, String parentWhere, String[] resultColumns, String[] keyColumns, String exceptKeyword) {
            parentWhere = parentWhere == null || parentWhere.equals("") ? "" : " AND " + parentWhere;
            return String.format("SELECT %1$s FROM %2$s ent JOIN  (SELECT %6$s, MAX(b.revision) AS revision FROM    (SELECT DISTINCT %5$s FROM %2$s WHERE branch IS NULL %9$s     %10$s     SELECT %5$s FROM %2$s WHERE branch = ? %9$s) a   JOIN %2$s b ON %7$s   WHERE b.revision <= ?   GROUP BY %6$s) c  ON %8$s AND ent.revision = c.revision  WHERE ent.branch IS NULL UNION ALL SELECT %3$s FROM %2$s WHERE branch = ? %9$s", StringTools.join(", ", StringTools.prefix("ent.", resultColumns)), table, StringTools.join(", ", resultColumns), null, StringTools.join(", ", keyColumns), StringTools.join(", ", StringTools.prefix("a.", keyColumns)), StringTools.join(" AND ", StringTools.join(" = ", new String[][]{StringTools.prefix("a.", keyColumns), StringTools.prefix("b.", keyColumns)})), StringTools.join(" AND ", StringTools.join(" = ", new String[][]{StringTools.prefix("ent.", keyColumns), StringTools.prefix("c.", keyColumns)})), parentWhere, exceptKeyword);
        }

        static String GET_DEV(String table, String where, String[] resultColumns, String[] keyColumns, String exceptKeyword) {
            return String.format("SELECT %1$s FROM %2$s ent JOIN  (SELECT %6$s, MAX(b.revision) AS revision FROM    (SELECT DISTINCT %5$s FROM %2$s WHERE %4$s AND branch IS NULL     %9$s     SELECT %5$s FROM %2$s WHERE %4$s AND branch = ?) a   JOIN %2$s b ON %7$s   WHERE b.revision <= ?   GROUP BY %6$s) c  ON %8$s AND ent.revision = c.revision  WHERE ent.branch IS NULL UNION ALL SELECT %3$s FROM %2$s WHERE %4$s AND branch = ?", StringTools.join(", ", StringTools.prefix("ent.", resultColumns)), table, StringTools.join(", ", resultColumns), where, StringTools.join(", ", keyColumns), StringTools.join(", ", StringTools.prefix("a.", keyColumns)), StringTools.join(" AND ", StringTools.join(" = ", new String[][]{StringTools.prefix("a.", keyColumns), StringTools.prefix("b.", keyColumns)})), StringTools.join(" AND ", StringTools.join(" = ", new String[][]{StringTools.prefix("ent.", keyColumns), StringTools.prefix("c.", keyColumns)})), exceptKeyword);
        }

        static String GET_ALL_DEV_ONLY(String table, String parentWhere, String[] resultColumns) {
            parentWhere = parentWhere == null || parentWhere.equals("") ? "" : " AND " + parentWhere;
            return String.format("SELECT %s FROM %s WHERE branch = ? %s", StringTools.join(", ", resultColumns), table, parentWhere);
        }

        static String STORE_DEV_INSERT(String table, String[] columns) {
            return String.format("INSERT INTO %s (%s) VALUES (%s)", table, StringTools.join(", ", columns), StringTools.repeat("?", ", ", columns.length));
        }

        static String STORE_DEV_UPDATE_INTID(String table, String[] columns) {
            return String.format("UPDATE %s SET %s WHERE %s = ?", table, StringTools.join(", ", StringTools.suffix(" = ?", columns)), "ID_");
        }

        static String STORE_DEV_UPDATE_KEYS(String table, String[] columns, String where) {
            return String.format("UPDATE %s SET %s WHERE branch = ? AND %s", table, StringTools.join(", ", StringTools.suffix(" = ?", columns)), where);
        }

        static String REVERT(String table, String where) {
            return String.format("DELETE FROM %s WHERE branch = ? AND %s", table, where);
        }

        static String RELEASE_ALL(String table) {
            return String.format("UPDATE %s SET branch = null, revision = ?, state = %d WHERE branch = ?", table, State.IN_PRODUCTION.getCode());
        }

        static String UPDATE_ALL(String table) {
            return String.format("UPDATE %s SET revision = ? WHERE branch = ?", table);
        }

        static String OUTDATE(String table, String where) {
            return String.format("UPDATE %s SET state = %d WHERE state = %d AND branch IS NULL AND %s", table, State.OUTDATED.getCode(), State.IN_PRODUCTION.getCode(), where);
        }

        static String CHANGED_IN_BRANCH(String table, String where) {
            return String.format("SELECT COUNT(*) FROM %s WHERE %s AND branch = ?", table, where);
        }

        static String ID_IN_BRANCH(String table, String where) {
            return String.format("SELECT %s FROM %s WHERE %s AND branch = ?", "ID_", table, where);
        }

        private CommonQuery() {
        }
    }

    static final class ECDQuery {
        private static final String[] REF_COLUMNS = new String[]{"name", "devDescription", "revision", "state", "iconID_hi", "iconID_lo", "pluginData", "userAttributes"};
        private static final String[] COLUMNS = new String[]{"ID_", "name", "devDescription", "revision", "branch", "state", "implementationClass", "classPath", "isSingleton", "sysCompSignature", "guiContextID", "executionControlProperties", "iconID_hi", "iconID_lo", "licence", "configurationDescription", "pluginData", "userAttributes"};
        private static final String[] KEY_COLUMNS = new String[]{"name"};
        private static final String WHERE = String.format("%s = ?", "name");
        static final String getLatestECDs = CommonQuery.GET_ALL_LATEST("AR_ECDs", null, REF_COLUMNS, KEY_COLUMNS);
        static final String getLatestECDs_prodOnly = CommonQuery.GET_ALL_LATEST_PROD("AR_ECDs", null, REF_COLUMNS, KEY_COLUMNS);
        static final String getLatestECDReference = CommonQuery.GET_LATEST("AR_ECDs", WHERE, REF_COLUMNS);
        static final String getLatestECD = CommonQuery.GET_LATEST("AR_ECDs", WHERE, COLUMNS);
        static final String getECDRevisionHistory = CommonQuery.GET_REV_HISTORY("AR_ECDs", WHERE, REF_COLUMNS);
        static final String getECDsOfRevision = CommonQuery.GET_ALL_REV("AR_ECDs", null, REF_COLUMNS, KEY_COLUMNS);
        static final String getECDRevision = CommonQuery.GET_REV("AR_ECDs", WHERE, COLUMNS);
        static final String getDevelopmentECDs_changedOnly = CommonQuery.GET_ALL_DEV_ONLY("AR_ECDs", null, REF_COLUMNS);
        static final String storeDevelopmentECD_insert = CommonQuery.STORE_DEV_INSERT("AR_ECDs", COLUMNS);
        static final String storeDevelopmentECD_update = CommonQuery.STORE_DEV_UPDATE_INTID("AR_ECDs", COLUMNS);
        static final String revertDevelopmentECD = CommonQuery.REVERT("AR_ECDs", WHERE);
        static final String updateDevelopmentECDs = CommonQuery.UPDATE_ALL("AR_ECDs");
        static final String releaseDevelopmentECDs = CommonQuery.RELEASE_ALL("AR_ECDs");
        static final String outdateECD = CommonQuery.OUTDATE("AR_ECDs", WHERE);
        static final String ecdIdInBranch = CommonQuery.ID_IN_BRANCH("AR_ECDs", WHERE);

        static String getDevelopmentECDs(String exceptKeyword) {
            return CommonQuery.GET_ALL_DEV("AR_ECDs", null, REF_COLUMNS, KEY_COLUMNS, exceptKeyword);
        }

        static String getDevelopmentECD(String exceptKeyword) {
            return CommonQuery.GET_DEV("AR_ECDs", WHERE, COLUMNS, KEY_COLUMNS, exceptKeyword);
        }

        private ECDQuery() {
        }
    }

    static final class IconQuery {
        private static final String[] COLUMNS = new String[]{"ID_", "id_hi", "id_lo", "name", "description", "revision", "branch", "state", "pluginData", "userAttributes"};
        private static final String[] DATA_COLUMNS = new String[]{"iconID", "width", "height", "data"};
        private static final String[] KEY_COLUMNS = new String[]{"id_hi", "id_lo"};
        private static final String WHERE = String.format("%s = ? AND %s = ?", "id_hi", "id_lo");
        static final String getLatestIcons = IconQuery.GET_DESCRIPTOR(CommonQuery.GET_ALL_LATEST("AR_Icons", null, COLUMNS, KEY_COLUMNS));
        static final String getLatestIcons_prodOnly = IconQuery.GET_DESCRIPTOR(CommonQuery.GET_ALL_LATEST_PROD("AR_Icons", null, COLUMNS, KEY_COLUMNS));
        static final String getLatestIconDescriptor = IconQuery.GET_DESCRIPTOR(CommonQuery.GET_LATEST("AR_Icons", WHERE, COLUMNS));
        static final String getLatestIcon = IconQuery.GET_DATA(CommonQuery.GET_LATEST("AR_Icons", WHERE, COLUMNS));
        static final String getIconRevisionHistory = IconQuery.GET_DESCRIPTOR(CommonQuery.GET_REV_HISTORY("AR_Icons", WHERE, COLUMNS));
        static final String getIconsOfRevision = IconQuery.GET_DESCRIPTOR(CommonQuery.GET_ALL_REV("AR_Icons", null, COLUMNS, KEY_COLUMNS));
        static final String getIconDescriptorRevision = IconQuery.GET_DESCRIPTOR(CommonQuery.GET_REV("AR_Icons", WHERE, COLUMNS));
        static final String getIconRevision = IconQuery.GET_DATA(CommonQuery.GET_REV("AR_Icons", WHERE, COLUMNS));
        static final String getDevelopmentIcons_changedOnly = CommonQuery.GET_ALL_DEV_ONLY("AR_Icons", null, COLUMNS);
        static final String storeDevelopmentIconDescriptor_insert = CommonQuery.STORE_DEV_INSERT("AR_Icons", COLUMNS);
        static final String storeDevelopmentIconDescriptor_update = CommonQuery.STORE_DEV_UPDATE_INTID("AR_Icons", COLUMNS);
        static final String addDevelopmentIcon = CommonQuery.STORE_DEV_INSERT("AR_Icons_Data", DATA_COLUMNS);
        static final String removeDevelopmentIcon = String.format("DELETE FROM %s WHERE %s = ? AND width = ? AND height = ?", "AR_Icons", "iconID");
        static final String revertDevelopmentIcon = CommonQuery.REVERT("AR_Icons", WHERE);
        static final String updateDevelopmentIcons = CommonQuery.UPDATE_ALL("AR_Icons");
        static final String releaseDevelopmentIcons = CommonQuery.RELEASE_ALL("AR_Icons");
        static final String outdateIcon = CommonQuery.OUTDATE("AR_Icons", WHERE);
        static final String iconChangedInBranch = CommonQuery.CHANGED_IN_BRANCH("AR_Icons", WHERE);
        static final String iconIdInBranch = CommonQuery.ID_IN_BRANCH("AR_Icons", WHERE);

        static String getDevelopmentIcons(String exceptKeyword) {
            return IconQuery.GET_DESCRIPTOR(CommonQuery.GET_ALL_DEV("AR_Icons", null, COLUMNS, KEY_COLUMNS, exceptKeyword));
        }

        static String getDevelopmentIconDescriptor(String exceptKeyword) {
            return IconQuery.GET_DESCRIPTOR(CommonQuery.GET_DEV("AR_Icons", WHERE, COLUMNS, KEY_COLUMNS, exceptKeyword));
        }

        static String getDevelopmentIcon(String exceptKeyword) {
            return IconQuery.GET_DATA(CommonQuery.GET_DEV("AR_Icons", WHERE, COLUMNS, KEY_COLUMNS, exceptKeyword));
        }

        private static String GET_DESCRIPTOR(String query) {
            return String.format("SELECT %s, data.width, data.height FROM (%s) descr LEFT JOIN %s data ON descr.%s = data.%s ORDER BY %s ASC, width * height DESC, width DESC", StringTools.join(", ", StringTools.prefix("descr.", COLUMNS)), query, "AR_Icons_Data", "ID_", "iconID", "ID_");
        }

        private static String GET_DATA(String query) {
            return String.format("SELECT data FROM (%s) descr JOIN %s data ON descr.%s = data.%s WHERE width = ? AND height = ?", query, "AR_Icons_Data", "ID_", "iconID");
        }

        private IconQuery() {
        }
    }

    static final class IdentifierQuery {
        private static final String[] COLUMNS = new String[]{"id_hi", "id_lo", "name", "description", "revision", "branch", "state", "pluginData", "userAttributes"};
        private static final String[] KEY_COLUMNS = new String[]{"id_hi", "id_lo"};
        private static final String WHERE = String.format("%s = ? AND %s = ?", "id_hi", "id_lo");
        static final String getLatestIdentifiers = CommonQuery.GET_ALL_LATEST("AR_Identifiers", null, COLUMNS, KEY_COLUMNS);
        static final String getLatestIdentifiers_prodOnly = CommonQuery.GET_ALL_LATEST_PROD("AR_Identifiers", null, COLUMNS, KEY_COLUMNS);
        static final String getLatestIdentifier = CommonQuery.GET_LATEST("AR_Identifiers", WHERE, COLUMNS);
        static final String getIdentifierRevisionHistory = CommonQuery.GET_REV_HISTORY("AR_Identifiers", WHERE, COLUMNS);
        static final String getIdentifiersOfRevision = CommonQuery.GET_ALL_REV("AR_Identifiers", null, COLUMNS, KEY_COLUMNS);
        static final String getIdentifierRevision = CommonQuery.GET_REV("AR_Identifiers", WHERE, COLUMNS);
        static final String getDevelopmentIdentifiers_changedOnly = CommonQuery.GET_ALL_DEV_ONLY("AR_Identifiers", null, COLUMNS);
        static final String storeDevelopmentIdentifier_insert = CommonQuery.STORE_DEV_INSERT("AR_Identifiers", COLUMNS);
        static final String storeDevelopmentIdentifier_update = CommonQuery.STORE_DEV_UPDATE_KEYS("AR_Identifiers", COLUMNS, WHERE);
        static final String revertDevelopmentIdentifier = CommonQuery.REVERT("AR_Identifiers", WHERE);
        static final String updateDevelopmentIdentifiers = CommonQuery.UPDATE_ALL("AR_Identifiers");
        static final String releaseDevelopmentIdentifiers = CommonQuery.RELEASE_ALL("AR_Identifiers");
        static final String outdateIdentifier = CommonQuery.OUTDATE("AR_Identifiers", WHERE);
        static final String identifierChangedInBranch = CommonQuery.CHANGED_IN_BRANCH("AR_Identifiers", WHERE);

        static String getDevelopmentIdentifiers(String exceptKeyword) {
            return CommonQuery.GET_ALL_DEV("AR_Identifiers", null, COLUMNS, KEY_COLUMNS, exceptKeyword);
        }

        static String getDevelopmentIdentifier(String exceptKeyword) {
            return CommonQuery.GET_DEV("AR_Identifiers", WHERE, COLUMNS, KEY_COLUMNS, exceptKeyword);
        }

        private IdentifierQuery() {
        }
    }

    static final class OpQuery {
        private static final String[] REF_COLUMNS = new String[]{"ecName", "name", "description", "devDescription", "revision", "state", "iconID_hi", "iconID_lo", "pluginData", "userAttributes"};
        private static final String[] COLUMNS = new String[]{"ID_", "ecName", "name", "description", "devDescription", "revision", "branch", "state", "implementationClass", "classPath", "isSingleton", "sysCompSignature", "guiContextID", "executionControlProperties", "supportsViewOnly", "supportsTestExecution", "iconID_hi", "iconID_lo", "licence", "configurationDescription", "configuration", "testConfiguration", "parameterChangePolicy", "staffAssignmentRule", "pluginData", "userAttributes"};
        private static final String[] KEY_COLUMNS = new String[]{"ecName", "name"};
        private static final String WHERE = String.format("%s = ? AND %s = ?", "ecName", "name");
        private static final String WHERE_ECD = String.format("%s = ?", "ecName");
        static final String getLatestOperations = CommonQuery.GET_ALL_LATEST("AR_Operations", WHERE_ECD, REF_COLUMNS, KEY_COLUMNS);
        static final String getLatestOperations_prodOnly = CommonQuery.GET_ALL_LATEST_PROD("AR_Operations", WHERE_ECD, REF_COLUMNS, KEY_COLUMNS);
        static final String getLatestOperationReference = CommonQuery.GET_LATEST("AR_Operations", WHERE, REF_COLUMNS);
        static final String getLatestOperation = CommonQuery.GET_LATEST("AR_Operations", WHERE, COLUMNS);
        static final String getOperationRevisionHistory = CommonQuery.GET_REV_HISTORY("AR_Operations", WHERE, REF_COLUMNS);
        static final String getOperationsOfECDRevision = CommonQuery.GET_ALL_REV("AR_Operations", WHERE_ECD, REF_COLUMNS, KEY_COLUMNS);
        static final String getOperationRevision = CommonQuery.GET_REV("AR_Operations", WHERE, COLUMNS);
        static final String getDevelopmentOperationsOfECD_changedOnly = CommonQuery.GET_ALL_DEV_ONLY("AR_Operations", WHERE_ECD, REF_COLUMNS);
        static final String getChangedDevelopmentOperations = CommonQuery.GET_ALL_DEV_ONLY("AR_Operations", null, REF_COLUMNS);
        static final String storeDevelopmentOperation_insert = CommonQuery.STORE_DEV_INSERT("AR_Operations", COLUMNS);
        static final String storeDevelopmentOperation_update = CommonQuery.STORE_DEV_UPDATE_INTID("AR_Operations", COLUMNS);
        static final String revertDevelopmentOperation = CommonQuery.REVERT("AR_Operations", WHERE);
        static final String updateDevelopmentOperations = CommonQuery.UPDATE_ALL("AR_Operations");
        static final String releaseDevelopmentOperations = CommonQuery.RELEASE_ALL("AR_Operations");
        static final String outdateOperation = CommonQuery.OUTDATE("AR_Operations", WHERE);
        static final String opIdInBranch = CommonQuery.ID_IN_BRANCH("AR_Operations", WHERE);

        static String getDevelopmentOperationsOfECD(String exceptKeyword) {
            return CommonQuery.GET_ALL_DEV("AR_Operations", WHERE_ECD, REF_COLUMNS, KEY_COLUMNS, exceptKeyword);
        }

        static String getDevelopmentOperation(String exceptKeyword) {
            return CommonQuery.GET_DEV("AR_Operations", WHERE, COLUMNS, KEY_COLUMNS, exceptKeyword);
        }

        private OpQuery() {
        }
    }

    static final class ParameterQuery {
        private static final String[] COLUMNS = new String[]{"accessType", "name", "removed", "description", "devDescription", "dataType", "udtName", "identifierID_hi", "identifierID_lo", "isOptional", "isVirtual", "isFailure", "defaultValue", "configurationDescription", "configuration", "pluginData", "userAttributes"};

        static String RETRIEVE(String refIDColumn) {
            return String.format("SELECT * FROM %s WHERE %s = ?", "AR_Parameters", refIDColumn);
        }

        static String DELETE(String refIDColumn) {
            return String.format("DELETE FROM %s WHERE %s = ?", "AR_Parameters", refIDColumn);
        }

        static String CREATE(String refIDColumn) {
            return String.format("INSERT INTO %s (%s, %s) VALUES (?, %s)", "AR_Parameters", refIDColumn, StringTools.join(", ", COLUMNS), StringTools.repeat("?", ", ", COLUMNS.length));
        }

        private ParameterQuery() {
        }
    }

    static final class ParameterTemplateQuery {
        private static final String[] COLUMNS = new String[]{"templateName", "removed", "templateDescription", "accessType", "name", "description", "dataType", "udtName", "identifierID_hi", "identifierID_lo", "isOptional", "isVirtual", "isFailure", "defaultValue", "configurationDescription", "configuration", "pluginData", "userAttributes"};

        static String RETRIEVE(String[] refColumns) {
            return String.format("SELECT * FROM %s WHERE %s", "AR_ParameterTemplates", StringTools.join(" AND ", StringTools.suffix(" = ?", refColumns)));
        }

        static String DELETE(String[] refColumns) {
            return String.format("DELETE FROM %s WHERE %s", "AR_ParameterTemplates", StringTools.join(" AND ", StringTools.suffix(" = ?", refColumns)));
        }

        static String CREATE(String[] refColumns) {
            return String.format("INSERT INTO %s (%s, %s) VALUES (%s, %s)", "AR_ParameterTemplates", StringTools.join(", ", refColumns), StringTools.join(", ", COLUMNS), StringTools.repeat("?", ", ", refColumns.length), StringTools.repeat("?", ", ", COLUMNS.length));
        }

        private ParameterTemplateQuery() {
        }
    }

    static final class ResourceQuery {
        private static final String[] COLUMNS = new String[]{"id_hi", "id_lo", "name", "description", "data", "revision", "branch", "state", "pluginData", "userAttributes"};
        private static final String[] COLUMNS_UPDATE = new String[]{"id_hi", "id_lo", "name", "description", "revision", "branch", "state", "pluginData", "userAttributes"};
        private static final String[] COLUMNS_UPDATE_DATA = new String[]{"data"};
        private static final String[] KEY_COLUMNS = new String[]{"id_hi", "id_lo"};
        private static final String WHERE = String.format("%s = ? AND %s = ?", "id_hi", "id_lo");
        static final String getLatestResources = CommonQuery.GET_ALL_LATEST("AR_Resources", null, COLUMNS, KEY_COLUMNS);
        static final String getLatestResources_prodOnly = CommonQuery.GET_ALL_LATEST_PROD("AR_Resources", null, COLUMNS, KEY_COLUMNS);
        static final String getLatestResource = CommonQuery.GET_LATEST("AR_Resources", WHERE, COLUMNS);
        static final String getResourceRevisionHistory = CommonQuery.GET_REV_HISTORY("AR_Resources", WHERE, COLUMNS);
        static final String getResourcesOfRevision = CommonQuery.GET_ALL_REV("AR_Resources", null, COLUMNS, KEY_COLUMNS);
        static final String getResourceRevision = CommonQuery.GET_REV("AR_Resources", WHERE, COLUMNS);
        static final String getDevelopmentResources_changedOnly = CommonQuery.GET_ALL_DEV_ONLY("AR_Resources", null, COLUMNS);
        static final String storeDevelopmentResource_insert = CommonQuery.STORE_DEV_INSERT("AR_Resources", COLUMNS);
        static final String storeDevelopmentResource_update = CommonQuery.STORE_DEV_UPDATE_KEYS("AR_Resources", COLUMNS_UPDATE, WHERE);
        static final String storeDevelopmentResource_updateData = CommonQuery.STORE_DEV_UPDATE_KEYS("AR_Resources", COLUMNS_UPDATE_DATA, WHERE);
        static final String revertDevelopmentResource = CommonQuery.REVERT("AR_Resources", WHERE);
        static final String updateDevelopmentResources = CommonQuery.UPDATE_ALL("AR_Resources");
        static final String releaseDevelopmentResources = CommonQuery.RELEASE_ALL("AR_Resources");
        static final String outdateResource = CommonQuery.OUTDATE("AR_Resources", WHERE);
        static final String resourceChangedInBranch = CommonQuery.CHANGED_IN_BRANCH("AR_Resources", WHERE);

        static String getDevelopmentResources(String exceptKeyword) {
            return CommonQuery.GET_ALL_DEV("AR_Resources", null, COLUMNS, KEY_COLUMNS, exceptKeyword);
        }

        static String getDevelopmentResource(String exceptKeyword) {
            return CommonQuery.GET_DEV("AR_Resources", WHERE, COLUMNS, KEY_COLUMNS, exceptKeyword);
        }

        private ResourceQuery() {
        }
    }

    static final class RevisionQuery {
        private static String[] COLUMNS = new String[]{"revisionNo", "timestamp_", "agentID", "agentUserName", "agentOrgposID", "agentOrgposName", "comment_"};
        static final String createRevision = String.format("INSERT INTO %s (%s) VALUES (%s)", "AR_Revisions", StringTools.join(", ", COLUMNS), StringTools.repeat("?", ", ", COLUMNS.length));
        static final String retrieveRevisionData = String.format("SELECT %s FROM %s WHERE %s = ?", StringTools.join(", ", COLUMNS), "AR_Revisions", "revisionNo");
        static final String getLatestRevisionData = String.format("SELECT %1$s FROM %2$s WHERE %3$s = (SELECT MAX(%3$s) FROM %2$s)", StringTools.join(", ", COLUMNS), "AR_Revisions", "revisionNo");

        private RevisionQuery() {
        }
    }
}

