/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.activityrepository.defaultimplementation.sql;

import de.aristaflow.adept2.base.dbaccess.ExtendedConnection;
import de.aristaflow.adept2.base.dbaccess.JDBCTools;
import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.sql.AbstractSQLSubStorage;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.sql.Columns;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.sql.Queries;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.sql.SQLActivityRepositoryStorage;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.storage.ATDStorage;
import de.aristaflow.adept2.model.activitymodel.ATDReference;
import de.aristaflow.adept2.model.activitymodel.StorageActivityConfiguration;
import de.aristaflow.adept2.model.activitymodel.StorageActivityModelParameter;
import de.aristaflow.adept2.model.activitymodel.StorageActivityTemplateDefinition;
import de.aristaflow.adept2.model.activitymodel.StorageConfigurationDescription;
import de.aristaflow.adept2.model.activitymodel.StorageParameterTemplate;
import de.aristaflow.adept2.model.common.Branch;
import de.aristaflow.adept2.model.common.ExecutionControlProperties;
import de.aristaflow.adept2.model.common.ParameterChangePolicy;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.common.Revision;
import de.aristaflow.adept2.model.common.State;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.UnknownEntityException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;

class SQLATDStorage
extends AbstractSQLSubStorage
implements ATDStorage {
    SQLATDStorage(SQLActivityRepositoryStorage storage) {
        super(storage);
    }

    @Override
    public ATDReference getATDReference(SessionToken session, UUID id) {
        ATDReference aTDReference;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(id, "id");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(Queries.ATDQuery.getATDReference);
            int col = 0;
            this.setUUID(pstmt, ++col, id);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                throw this.newEntityNotExistingException(id);
            }
            ATDReference result = this.readATDReference(rs);
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            aTDReference = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly((Statement)pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return aTDReference;
    }

    @Override
    public Collection<ATDReference> getLatestATDsOfOperation(SessionToken session, String ecName, String opName, boolean productionOnly) {
        ArrayList<ATDReference> arrayList;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(ecName, "ecName");
        ArgChecks.checkForNull(opName, "opName");
        this.getStorage().getOpStorage().ensureOperationExists(session, ecName, opName);
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            String query = productionOnly ? Queries.ATDQuery.getLatestATDsOfOperation_prodOnly : Queries.ATDQuery.getLatestATDsOfOperation;
            pstmt = con.prepareStatement(query);
            int col = 0;
            pstmt.setString(++col, ecName);
            pstmt.setString(++col, opName);
            rs = pstmt.executeQuery();
            ArrayList<ATDReference> result = new ArrayList<ATDReference>();
            while (rs.next()) {
                result.add(this.readATDReference(rs));
            }
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            arrayList = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return arrayList;
    }

    @Override
    public Collection<ATDReference> getLatestATDsOfCS(SessionToken session, String csName, boolean productionOnly) {
        ArrayList<ATDReference> arrayList;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(csName, "csName");
        this.getStorage().getCSStorage().ensureCSExists(session, csName);
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            String query = productionOnly ? Queries.ATDQuery.getLatestATDsOfCS_prodOnly : Queries.ATDQuery.getLatestATDsOfCS;
            pstmt = con.prepareStatement(query);
            int col = 0;
            pstmt.setString(++col, csName);
            rs = pstmt.executeQuery();
            ArrayList<ATDReference> result = new ArrayList<ATDReference>();
            while (rs.next()) {
                result.add(this.readATDReference(rs));
            }
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            arrayList = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return arrayList;
    }

    @Override
    public ATDReference getLatestATDReference(SessionToken session, String ecName, String opName, String atdName) {
        ATDReference aTDReference;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(ecName, "ecName");
        ArgChecks.checkForNull(opName, "opName");
        ArgChecks.checkForNull(atdName, "atdName");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(Queries.ATDQuery.getLatestATDReference);
            int col = 0;
            pstmt.setString(++col, ecName);
            pstmt.setString(++col, opName);
            pstmt.setString(++col, atdName);
            pstmt.setString(++col, ecName);
            pstmt.setString(++col, opName);
            pstmt.setString(++col, atdName);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                throw this.newEntityNotExistingException(ecName, opName, atdName);
            }
            ATDReference result = this.readATDReference(rs);
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            aTDReference = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly((Statement)pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return aTDReference;
    }

    @Override
    public StorageActivityTemplateDefinition getLatestATD(SessionToken session, String ecName, String opName, String atdName) {
        StorageActivityTemplateDefinition storageActivityTemplateDefinition;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(ecName, "ecName");
        ArgChecks.checkForNull(opName, "opName");
        ArgChecks.checkForNull(atdName, "atdName");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(Queries.ATDQuery.getLatestATD);
            int col = 0;
            pstmt.setString(++col, ecName);
            pstmt.setString(++col, opName);
            pstmt.setString(++col, atdName);
            pstmt.setString(++col, ecName);
            pstmt.setString(++col, opName);
            pstmt.setString(++col, atdName);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                throw this.newEntityNotExistingException(ecName, opName, atdName);
            }
            StorageActivityTemplateDefinition result = this.readATD(session, rs);
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            storageActivityTemplateDefinition = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly((Statement)pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return storageActivityTemplateDefinition;
    }

    @Override
    public List<ATDReference> getATDRevisionHistory(SessionToken session, String ecName, String opName, String atdName) {
        ArrayList<ATDReference> arrayList;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(ecName, "ecName");
        ArgChecks.checkForNull(opName, "opName");
        ArgChecks.checkForNull(atdName, "atdName");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(Queries.ATDQuery.getATDRevisionHistory);
            int col = 0;
            pstmt.setString(++col, ecName);
            pstmt.setString(++col, opName);
            pstmt.setString(++col, atdName);
            rs = pstmt.executeQuery();
            ArrayList<ATDReference> result = new ArrayList<ATDReference>();
            while (rs.next()) {
                result.add(this.readATDReference(rs));
            }
            if (result.isEmpty()) {
                throw this.newEntityNotExistingException(ecName, opName, atdName);
            }
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            arrayList = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly((Statement)pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return arrayList;
    }

    @Override
    public Collection<ATDReference> getATDsOfOperationRevision(SessionToken session, String ecName, String opName, long revisionNo) {
        ArrayList<ATDReference> arrayList;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(ecName, "ecName");
        ArgChecks.checkForNull(opName, "opName");
        ArgChecks.checkForNegative(revisionNo, "revisionNo");
        this.ensureRevisionExists(session, revisionNo);
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(Queries.ATDQuery.getATDsOfOperationRevision);
            int col = 0;
            pstmt.setLong(++col, revisionNo);
            pstmt.setString(++col, ecName);
            pstmt.setString(++col, opName);
            rs = pstmt.executeQuery();
            ArrayList<ATDReference> result = new ArrayList<ATDReference>();
            while (rs.next()) {
                result.add(this.readATDReference(rs));
            }
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            arrayList = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly((Statement)pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return arrayList;
    }

    @Override
    public Collection<ATDReference> getATDsOfCSRevision(SessionToken session, String csName, long revisionNo) {
        ArrayList<ATDReference> arrayList;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(csName, "csName");
        ArgChecks.checkForNegative(revisionNo, "revisionNo");
        this.ensureRevisionExists(session, revisionNo);
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(Queries.ATDQuery.getATDsOfCSRevision);
            int col = 0;
            pstmt.setLong(++col, revisionNo);
            pstmt.setString(++col, csName);
            rs = pstmt.executeQuery();
            ArrayList<ATDReference> result = new ArrayList<ATDReference>();
            while (rs.next()) {
                result.add(this.readATDReference(rs));
            }
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            arrayList = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly((Statement)pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return arrayList;
    }

    @Override
    public StorageActivityTemplateDefinition getATDRevision(SessionToken session, String ecName, String opName, String atdName, long revisionNo) {
        StorageActivityTemplateDefinition storageActivityTemplateDefinition;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(ecName, "ecName");
        ArgChecks.checkForNull(opName, "opName");
        ArgChecks.checkForNull(atdName, "atdName");
        ArgChecks.checkForNegative(revisionNo, "revisionNo");
        this.ensureRevisionExists(session, revisionNo);
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(Queries.ATDQuery.getATDRevision);
            int col = 0;
            pstmt.setString(++col, ecName);
            pstmt.setString(++col, opName);
            pstmt.setString(++col, atdName);
            pstmt.setString(++col, ecName);
            pstmt.setString(++col, opName);
            pstmt.setString(++col, atdName);
            pstmt.setLong(++col, revisionNo);
            pstmt.setLong(++col, revisionNo);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                throw this.newEntityNotExistingException(ecName, opName, atdName, revisionNo);
            }
            StorageActivityTemplateDefinition result = this.readATD(session, rs);
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            storageActivityTemplateDefinition = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly((Statement)pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return storageActivityTemplateDefinition;
    }

    @Override
    public Collection<ATDReference> getDevelopmentATDsOfOperation(SessionToken session, String ecName, String opName, long branchNo, boolean changedOnly) {
        ArrayList<ATDReference> arrayList;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(ecName, "ecName");
        ArgChecks.checkForNull(opName, "opName");
        ArgChecks.checkForNegative(branchNo, "branchNo");
        Branch branch = this.getStorage().getRevisionStorage().getBranchData(session, branchNo);
        this.getStorage().getOpStorage().ensureOperationExists(session, ecName, opName, branchNo);
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            if (changedOnly) {
                pstmt = con.prepareStatement(Queries.ATDQuery.getDevelopmentATDsOfOperation_changedOnly);
                int col = 0;
                pstmt.setLong(++col, branchNo);
                pstmt.setString(++col, ecName);
                pstmt.setString(++col, opName);
            } else {
                String query = Queries.ATDQuery.getDevelopmentATDsOfOperation(con.getEXCEPTKeyword());
                pstmt = con.prepareStatement(query);
                int col = 0;
                pstmt.setString(++col, ecName);
                pstmt.setString(++col, opName);
                pstmt.setLong(++col, branchNo);
                pstmt.setString(++col, ecName);
                pstmt.setString(++col, opName);
                pstmt.setLong(++col, branch.getBaseRevision().getRevision());
                pstmt.setLong(++col, branchNo);
                pstmt.setString(++col, ecName);
                pstmt.setString(++col, opName);
            }
            rs = pstmt.executeQuery();
            ArrayList<ATDReference> result = new ArrayList<ATDReference>();
            while (rs.next()) {
                result.add(this.readATDReference(rs));
            }
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            arrayList = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return arrayList;
    }

    @Override
    public Collection<ATDReference> getDevelopmentATDsOfCS(SessionToken session, String csName, long branchNo, boolean changedOnly) {
        ArrayList<ATDReference> arrayList;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(csName, "csName");
        ArgChecks.checkForNegative(branchNo, "branchNo");
        Branch branch = this.getStorage().getRevisionStorage().getBranchData(session, branchNo);
        this.getStorage().getCSStorage().ensureCSExists(session, csName, branchNo);
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            if (changedOnly) {
                pstmt = con.prepareStatement(Queries.ATDQuery.getDevelopmentATDsOfCS_changedOnly);
                int col = 0;
                pstmt.setLong(++col, branchNo);
                pstmt.setString(++col, csName);
            } else {
                String query = Queries.ATDQuery.getDevelopmentATDsOfCS(con.getEXCEPTKeyword());
                pstmt = con.prepareStatement(query);
                int col = 0;
                pstmt.setString(++col, csName);
                pstmt.setLong(++col, branchNo);
                pstmt.setString(++col, csName);
                pstmt.setLong(++col, branch.getBaseRevision().getRevision());
                pstmt.setLong(++col, branchNo);
                pstmt.setString(++col, csName);
            }
            rs = pstmt.executeQuery();
            ArrayList<ATDReference> result = new ArrayList<ATDReference>();
            while (rs.next()) {
                result.add(this.readATDReference(rs));
            }
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            arrayList = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return arrayList;
    }

    @Override
    public Collection<ATDReference> getChangedDevelopmentATDs(SessionToken session, long branchNo) {
        ArrayList<ATDReference> arrayList;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNegative(branchNo, "branchNo");
        this.ensureBranchExists(session, branchNo);
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(Queries.ATDQuery.getChangedDevelopmentATDs);
            int col = 0;
            pstmt.setLong(++col, branchNo);
            rs = pstmt.executeQuery();
            ArrayList<ATDReference> result = new ArrayList<ATDReference>();
            while (rs.next()) {
                result.add(this.readATDReference(rs));
            }
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            arrayList = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly((Statement)pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return arrayList;
    }

    @Override
    public StorageActivityTemplateDefinition getDevelopmentATD(SessionToken session, String ecName, String opName, String atdName, long branchNo) {
        StorageActivityTemplateDefinition storageActivityTemplateDefinition;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(ecName, "ecName");
        ArgChecks.checkForNull(opName, "opName");
        ArgChecks.checkForNull(atdName, "atdName");
        ArgChecks.checkForNegative(branchNo, "branchNo");
        Branch branch = this.getStorage().getRevisionStorage().getBranchData(session, branchNo);
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(Queries.ATDQuery.getDevelopmentATD(con.getEXCEPTKeyword()));
            int col = 0;
            pstmt.setString(++col, ecName);
            pstmt.setString(++col, opName);
            pstmt.setString(++col, atdName);
            pstmt.setString(++col, ecName);
            pstmt.setString(++col, opName);
            pstmt.setString(++col, atdName);
            pstmt.setLong(++col, branchNo);
            pstmt.setLong(++col, branch.getBaseRevision().getRevision());
            pstmt.setString(++col, ecName);
            pstmt.setString(++col, opName);
            pstmt.setString(++col, atdName);
            pstmt.setLong(++col, branchNo);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                throw this.newEntityNotExistingExceptionDev(ecName, opName, atdName, branchNo);
            }
            StorageActivityTemplateDefinition result = this.readATD(session, rs);
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            storageActivityTemplateDefinition = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return storageActivityTemplateDefinition;
    }

    @Override
    public void storeDevelopmentATD(SessionToken session, StorageActivityTemplateDefinition atd, long branchNo) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(atd, "atd");
        SQLATDStorage.checkName(atd.getName());
        ArgChecks.checkForNegative(branchNo, "branchNo");
        String ecName = atd.getExecutableComponentName();
        String opName = atd.getOperationName();
        String csName = atd.getConfigurationSetName();
        Branch branch = this.getStorage().getRevisionStorage().getBranchData(session, branchNo);
        this.getStorage().getOpStorage().ensureOperationExists(session, ecName, opName, branchNo);
        if (csName != null) {
            this.getStorage().getCSStorage().ensureCSExists(session, csName, branchNo);
        }
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        try {
            try {
                long _id = this.atdIdInBranch(con, ecName, opName, atd.getName(), branchNo);
                if (_id >= 0L) {
                    pstmt = con.prepareStatement(Queries.ATDQuery.storeDevelopmentATD_update);
                    int col = 0;
                    ++col;
                    col = this.writeATD(pstmt, col, atd, _id, branch.getBaseRevision(), branch, State.IN_DEVELOPMENT);
                    pstmt.setLong(++col, _id);
                } else {
                    _id = con.nextID("AR_AtdID");
                    pstmt = con.prepareStatement(Queries.ATDQuery.storeDevelopmentATD_insert);
                    int col = 0;
                    this.writeATD(pstmt, ++col, atd, _id, branch.getBaseRevision(), branch, State.IN_DEVELOPMENT);
                }
                pstmt.executeUpdate();
                this.updateParameters(session, "atdID", _id, atd.getParameters(ActivityConstants.AccessType.READ), atd.getParameters(ActivityConstants.AccessType.WRITE));
                this.updateParameterTemplates(session, atd.getParameterTemplates(), Columns.ParameterTemplateColumn._ATD_REF_KEYS, _id);
                pstmt = JDBCTools.close(pstmt);
            }
            catch (SQLException ex) {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(pstmt);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)pstmt);
    }

    @Override
    public void revertDevelopmentATD(SessionToken session, String ecName, String opName, String atdName, long branchNo) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(ecName, "ecName");
        ArgChecks.checkForNull(opName, "opName");
        ArgChecks.checkForNull(atdName, "atdName");
        ArgChecks.checkForNegative(branchNo, "branchNo");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        try {
            try {
                long _id = this.atdIdInBranch(con, ecName, opName, atdName, branchNo);
                if (_id >= 0L) {
                    pstmt = con.prepareStatement(Queries.ATDQuery.revertDevelopmentATD);
                    int col = 0;
                    pstmt.setLong(++col, branchNo);
                    pstmt.setString(++col, ecName);
                    pstmt.setString(++col, opName);
                    pstmt.setString(++col, atdName);
                    pstmt.executeUpdate();
                    pstmt = JDBCTools.close(pstmt);
                    this.deleteParameters(session, "atdID", _id);
                    this.deleteParameterTemplates(session, new String[]{"atdID"}, _id);
                }
            }
            catch (SQLException ex) {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
        }
        finally {
            JDBCTools.closeQuietly(pstmt);
        }
    }

    @Override
    public void updateDevelopmentATDs(SessionToken session, long branchNo, long newBaseRevisionNo) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNegative(branchNo, "branchNo");
        ArgChecks.checkForNegative(newBaseRevisionNo, "newBaseRevisionNo");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        try {
            try {
                pstmt = con.prepareStatement(Queries.ATDQuery.updateDevelopmentATDs);
                int col = 0;
                pstmt.setLong(++col, newBaseRevisionNo);
                pstmt.setLong(++col, branchNo);
                pstmt.executeUpdate();
                pstmt = JDBCTools.close(pstmt);
            }
            catch (SQLException ex) {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(pstmt);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)pstmt);
    }

    @Override
    public void releaseDevelopmentATDs(SessionToken session, long branchNo, long newRevisionNo) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNegative(branchNo, "branchNo");
        ArgChecks.checkForNegative(newRevisionNo, "newRevisionNo");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        try {
            try {
                pstmt = con.prepareStatement(Queries.ATDQuery.releaseDevelopmentATDs);
                int col = 0;
                pstmt.setLong(++col, newRevisionNo);
                pstmt.setLong(++col, branchNo);
                pstmt.executeUpdate();
                pstmt = JDBCTools.close(pstmt);
            }
            catch (SQLException ex) {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(pstmt);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)pstmt);
    }

    @Override
    public void outdateATD(SessionToken session, String ecName, String opName, String atdName) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(ecName, "ecName");
        ArgChecks.checkForNull(opName, "opName");
        ArgChecks.checkForNull(atdName, "atdName");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        try {
            try {
                pstmt = con.prepareStatement(Queries.ATDQuery.outdateATD);
                int col = 0;
                pstmt.setString(++col, ecName);
                pstmt.setString(++col, opName);
                pstmt.setString(++col, atdName);
                pstmt.executeUpdate();
                pstmt = JDBCTools.close(pstmt);
            }
            catch (SQLException ex) {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(pstmt);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)pstmt);
    }

    void ensureATDExists(SessionToken session, String ecName, String opName, String atdName) {
        this.getLatestATDReference(session, ecName, opName, atdName);
    }

    void ensureATDExists(SessionToken session, String ecName, String opName, String atdName, long branchNo) {
        this.getDevelopmentATD(session, ecName, opName, atdName, branchNo);
    }

    private UnknownEntityException newEntityNotExistingException(UUID id) {
        String msg = "The Activity Template with ID '%s' does not exist (as released, outdated or in any branch)!";
        msg = String.format(msg, id);
        return new UnknownEntityException(msg);
    }

    private UnknownEntityException newEntityNotExistingException(String ecName, String opName, String atdName) {
        String msg = "The Activity Template '%s' of Operation '%s' of Executable Component Description '%s' does not exist (as released or outdated)!";
        msg = String.format(msg, atdName, opName, ecName);
        return new UnknownEntityException(msg);
    }

    private UnknownEntityException newEntityNotExistingExceptionDev(String ecName, String opName, String atdName, long branchNo) {
        String msg = "The Activity Template '%s' of Operation '%s' of Executable Component Description '%s' does not exist (as released, outdated or in branch #%d)!";
        msg = String.format(msg, atdName, opName, ecName, branchNo);
        return new UnknownEntityException(msg);
    }

    private UnknownEntityException newEntityNotExistingException(String ecName, String opName, String atdName, long revisionNo) {
        String msg = "The Activity Template '%s' of Operation '%s' of Executable Component Description '%s' does not exist in revision #%d!";
        msg = String.format(msg, atdName, opName, ecName, revisionNo);
        return new UnknownEntityException(msg);
    }

    private long atdIdInBranch(Connection con, String ecName, String opName, String atdName, long branchNo) throws SQLException {
        long l;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(Queries.ATDQuery.atdIdInBranch);
            int col = 0;
            pstmt.setString(++col, ecName);
            pstmt.setString(++col, opName);
            pstmt.setString(++col, atdName);
            pstmt.setLong(++col, branchNo);
            rs = pstmt.executeQuery();
            long result = rs.next() ? rs.getLong(1) : -1L;
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            l = result;
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly((Statement)pstmt, rs);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return l;
    }

    private ATDReference readATDReference(ResultSet rs) throws SQLException {
        String ecName = rs.getString("ecName");
        String opName = rs.getString("opName");
        String csName = rs.getString("configurationSetName");
        UUID id = this.getUUID(rs, "id");
        String name = rs.getString("name");
        String description = this.getStringNN(rs, "description");
        String devDescription = this.getStringNN(rs, "devDescription");
        long revisionNo = rs.getLong("revision");
        long branchNo = rs.getLong("branch");
        if (rs.wasNull()) {
            branchNo = -1L;
        }
        State state = this.getState(rs);
        UUID iconID = this.getUUID(rs, "iconID");
        PluginDataContainer pluginData = this.getPluginData(rs);
        Map<String, String> userAttributes = this.getUserAttributes(rs);
        return this.getModelFactory().createATDReference(id, ecName, opName, csName, name, description, devDescription, revisionNo, branchNo, state, iconID, pluginData, userAttributes);
    }

    private StorageActivityTemplateDefinition readATD(SessionToken session, ResultSet rs) throws SQLException {
        String ecName = rs.getString("ecName");
        String opName = rs.getString("opName");
        String csName = rs.getString("configurationSetName");
        UUID id = this.getUUID(rs, "id");
        String name = rs.getString("name");
        String description = this.getString(rs, "description");
        String developerDescription = this.getString(rs, "devDescription");
        long revisionNo = rs.getLong("revision");
        State state = this.getState(rs);
        String implementationClass = this.getString(rs, "implementationClass");
        List<String> classPath = this.getClassPath(rs, "classPath");
        Boolean isSingleton = this.getBoolean(rs, "isSingleton");
        byte[] systemComponentSignature = this.getSystemComponentSignature(rs, "sysCompSignature");
        String guiContextID = this.getString(rs, "guiContextID");
        ExecutionControlProperties ecp = this.getECP(rs, "executionControlProperties");
        Boolean supportsViewOnly = this.getBoolean(rs, "supportsViewOnly");
        Boolean supportsTestExecution = this.getBoolean(rs, "supportsTestExecution");
        UUID iconID = this.getUUID(rs, "iconID");
        String licenceInformation = this.getString(rs, "licence");
        StorageConfigurationDescription confDesc = this.getConfigurationDescription(rs, "configurationDescription");
        StorageActivityConfiguration conf = this.getActivityConfiguration(rs, "configuration");
        StorageActivityConfiguration testConf = this.getActivityConfiguration(rs, "testConfiguration");
        ParameterChangePolicy pcp = this.getParameterChangePolicy(rs, "parameterChangePolicy");
        long _id = rs.getLong("ID_");
        Map<ActivityConstants.AccessType, Map<String, StorageActivityModelParameter>> parameters = this.retrieveParameters(session, "atdID", _id);
        Map<String, StorageParameterTemplate> paramTemplates = this.retrieveParameterTemplates(session, Columns.ParameterTemplateColumn._ATD_REF_KEYS, _id);
        String sar = this.getString(rs, "staffAssignmentRule");
        PluginDataContainer pluginData = this.getPluginData(rs);
        Map<String, String> userAttributes = this.getUserAttributes(rs);
        return this.getModelFactory().createStorageActivityTemplateDefinition(ecName, opName, csName, id, name, description, developerDescription, revisionNo, state, implementationClass, classPath, isSingleton, systemComponentSignature, guiContextID, ecp, supportsViewOnly, supportsTestExecution, iconID, licenceInformation, confDesc, conf, testConf, pcp, parameters.get((Object)ActivityConstants.AccessType.READ), parameters.get((Object)ActivityConstants.AccessType.WRITE), paramTemplates, sar, pluginData, userAttributes);
    }

    private int writeATD(PreparedStatement pstmt, int firstColumn, StorageActivityTemplateDefinition atd, long _id, Revision revision, Branch branch, State state) throws SQLException {
        int col = firstColumn - 1;
        pstmt.setLong(++col, _id);
        pstmt.setString(++col, atd.getExecutableComponentName());
        pstmt.setString(++col, atd.getOperationName());
        pstmt.setString(++col, atd.getConfigurationSetName());
        ++col;
        col = this.setUUID(pstmt, col, atd.getID());
        pstmt.setString(++col, atd.getName());
        this.setString(pstmt, ++col, atd.getDescription(), atd.isDescriptionInherited());
        this.setString(pstmt, ++col, atd.getDeveloperDescription(), atd.isDeveloperDescriptionInherited());
        pstmt.setLong(++col, revision.getRevision());
        this.setBranch(pstmt, ++col, branch);
        this.setState(pstmt, ++col, state);
        this.setString(pstmt, ++col, atd.getImplementationClass(), atd.isImplementationClassInherited());
        this.setClassPath(pstmt, ++col, atd.getClassPath());
        this.setBoolean(pstmt, ++col, atd.isSingleton(), atd.isSingletonInherited());
        this.setSystemComponentSignature(pstmt, ++col, atd.getSystemComponent(), atd.isSystemComponentInherited());
        this.setString(pstmt, ++col, atd.getGUIContextID(), atd.isGUIContextIDInherited());
        this.setECP(pstmt, ++col, atd.areExecutionControlPropertiesInterited() ? null : atd.getExecutionControlProperties());
        this.setBoolean(pstmt, ++col, atd.supportsViewOnly(), atd.isSupportsViewOnlyInherited());
        this.setBoolean(pstmt, ++col, atd.supportsTestExecution(), atd.isSupportsTestExecutionInherited());
        ++col;
        col = this.setUUID(pstmt, col, atd.isIconIDInherited() ? null : atd.getIconID());
        this.setString(pstmt, ++col, atd.getLicenceInformation(), atd.isLicenceInformationInherited());
        this.setConfigurationDescription(pstmt, ++col, atd.getConfigurationDescription());
        this.setActivityConfiguration(pstmt, ++col, atd.getConfiguration());
        this.setActivityConfiguration(pstmt, ++col, atd.getTestConfiguration());
        this.setParameterChangePolicy(pstmt, ++col, atd.isParameterChangePolicyInherited() ? null : atd.getParameterChangePolicy());
        this.setString(pstmt, ++col, atd.getStaffAssignmentRule(), atd.isStaffAssignmentRuleInherited());
        this.setPluginData(pstmt, ++col, atd);
        this.setUserAttributes(pstmt, ++col, atd.getUserAttributes());
        return col;
    }
}

