/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.activityrepository.defaultimplementation.sql;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.dbaccess.ExtendedConnection;
import de.aristaflow.adept2.base.dbaccess.JDBCDataSource;
import de.aristaflow.adept2.base.dbaccess.SQLTools;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.sql.SQLATDStorage;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.sql.SQLCSStorage;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.sql.SQLECDStorage;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.sql.SQLIconStorage;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.sql.SQLIdentifierStorage;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.sql.SQLOpStorage;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.sql.SQLResourceStorage;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.sql.SQLRevisionStorage;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.storage.ActivityRepositoryStorage;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.storage.IconStorage;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.storage.IdentifierStorage;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.storage.ResourceStorage;
import de.aristaflow.adept2.core.internal.SQLSessionManager;
import org.apache.commons.configuration.Configuration;

public class SQLActivityRepositoryStorage
extends ActivityRepositoryStorage {
    private SQLSessionManager sessionManager;
    private SQLRevisionStorage revisonStorage;
    private SQLIdentifierStorage identifierStorage;
    private SQLECDStorage ecdStorage;
    private SQLOpStorage opStorage;
    private SQLCSStorage csStorage;
    private SQLATDStorage atdStorage;
    private SQLResourceStorage resourceStorage;
    private SQLIconStorage iconStorage;

    public SQLActivityRepositoryStorage(Configuration config, Registry dependencyRegistry, SessionToken initSession) throws AbortServiceException {
        super(config, dependencyRegistry, initSession);
        JDBCDataSource dataSource = dependencyRegistry.getServiceOfType(initSession, "JDBCDataSource", JDBCDataSource.class);
        this.sessionManager = new SQLSessionManager(dataSource);
        this.sessionManager.startSession(initSession);
        try {
            try {
                this.sessionManager.startTransaction(initSession);
                ExtendedConnection con = this.sessionManager.getConnection(initSession);
                if (!con.tableExists("AR_Resources")) {
                    SQLTools.runSQLScript(con, SQLActivityRepositoryStorage.class.getResourceAsStream("sqlscripts/ar-create.sql"));
                }
                this.sessionManager.finishTransaction(initSession);
            }
            catch (Exception ex) {
                String msg = "An error occured while trying to verify/create the database structure.";
                throw new AbortServiceException(msg, ex);
            }
        }
        finally {
            this.sessionManager.endSession(initSession);
        }
        this.revisonStorage = new SQLRevisionStorage(this);
        this.identifierStorage = new SQLIdentifierStorage(this);
        this.ecdStorage = new SQLECDStorage(this);
        this.opStorage = new SQLOpStorage(this);
        this.csStorage = new SQLCSStorage(this);
        this.atdStorage = new SQLATDStorage(this);
        this.resourceStorage = new SQLResourceStorage(this);
        this.iconStorage = new SQLIconStorage(this);
    }

    @Override
    public SQLRevisionStorage getRevisionStorage() {
        return this.revisonStorage;
    }

    @Override
    public IdentifierStorage getIdentifierStorage() {
        return this.identifierStorage;
    }

    @Override
    public SQLECDStorage getECDStorage() {
        return this.ecdStorage;
    }

    @Override
    public SQLOpStorage getOpStorage() {
        return this.opStorage;
    }

    @Override
    public SQLCSStorage getCSStorage() {
        return this.csStorage;
    }

    @Override
    public SQLATDStorage getATDStorage() {
        return this.atdStorage;
    }

    @Override
    public ResourceStorage getResourceStorage() {
        return this.resourceStorage;
    }

    @Override
    public IconStorage getIconStorage() {
        return this.iconStorage;
    }

    @Override
    public void startSession(SessionToken session) {
        this.sessionManager.startSession(session);
    }

    @Override
    public void endSession(SessionToken session) {
        this.sessionManager.endSession(session);
    }

    @Override
    public void startTransaction(SessionToken session) {
        this.sessionManager.startTransaction(session);
    }

    @Override
    public void finishTransaction(SessionToken session) {
        this.sessionManager.finishTransaction(session);
    }

    ExtendedConnection getConnection(SessionToken session) {
        return this.sessionManager.getConnection(session);
    }
}

