/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.activityrepository.defaultimplementation.sql;

import de.aristaflow.adept2.base.dbaccess.ExtendedConnection;
import de.aristaflow.adept2.base.dbaccess.JDBCTools;
import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.sql.AbstractSQLSubStorage;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.sql.Columns;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.sql.Queries;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.sql.SQLActivityRepositoryStorage;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.storage.CSStorage;
import de.aristaflow.adept2.model.activitymodel.CSReference;
import de.aristaflow.adept2.model.activitymodel.StorageActivityConfiguration;
import de.aristaflow.adept2.model.activitymodel.StorageConfiguration;
import de.aristaflow.adept2.model.activitymodel.StorageConfigurationDescription;
import de.aristaflow.adept2.model.activitymodel.StorageConfigurationSet;
import de.aristaflow.adept2.model.activitymodel.StorageParameterTemplate;
import de.aristaflow.adept2.model.common.Branch;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.common.Revision;
import de.aristaflow.adept2.model.common.State;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.UnknownEntityException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class SQLCSStorage
extends AbstractSQLSubStorage
implements CSStorage {
    public SQLCSStorage(SQLActivityRepositoryStorage storage) {
        super(storage);
    }

    @Override
    public Collection<CSReference> getLatestCSs(SessionToken session, boolean productionOnly) {
        ArrayList<CSReference> arrayList;
        ArgChecks.checkForNull(session, "session");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            String query = productionOnly ? Queries.CSQuery.getLatestCSs_prodOnly : Queries.CSQuery.getLatestCSs;
            pstmt = con.prepareStatement(query);
            rs = pstmt.executeQuery();
            ArrayList<CSReference> result = new ArrayList<CSReference>();
            while (rs.next()) {
                result.add(this.readCSReference(rs));
            }
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            arrayList = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return arrayList;
    }

    @Override
    public CSReference getLatestCSReference(SessionToken session, String csName) {
        CSReference cSReference;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(csName, "csName");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(Queries.CSQuery.getLatestCSReference);
            int col = 0;
            pstmt.setString(++col, csName);
            pstmt.setString(++col, csName);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                throw this.newEntityNotExistingException(csName);
            }
            CSReference result = this.readCSReference(rs);
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            cSReference = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly((Statement)pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return cSReference;
    }

    @Override
    public StorageConfigurationSet getLatestCS(SessionToken session, String csName) {
        StorageConfigurationSet storageConfigurationSet;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(csName, "csName");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(Queries.CSQuery.getLatestCS);
            int col = 0;
            pstmt.setString(++col, csName);
            pstmt.setString(++col, csName);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                throw this.newEntityNotExistingException(csName);
            }
            StorageConfigurationSet result = this.readCS(session, rs);
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            storageConfigurationSet = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly((Statement)pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return storageConfigurationSet;
    }

    @Override
    public List<CSReference> getCSRevisionHistory(SessionToken session, String csName) {
        ArrayList<CSReference> arrayList;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(csName, "csName");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(Queries.CSQuery.getCSRevisionHistory);
            pstmt.setString(1, csName);
            rs = pstmt.executeQuery();
            ArrayList<CSReference> result = new ArrayList<CSReference>();
            while (rs.next()) {
                result.add(this.readCSReference(rs));
            }
            if (result.isEmpty()) {
                throw this.newEntityNotExistingException(csName);
            }
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            arrayList = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly((Statement)pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return arrayList;
    }

    @Override
    public Collection<CSReference> getCSsOfRevision(SessionToken session, long revisionNo) {
        ArrayList<CSReference> arrayList;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNegative(revisionNo, "revisionNo");
        this.ensureRevisionExists(session, revisionNo);
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(Queries.CSQuery.getCSsOfRevision);
            int col = 0;
            pstmt.setLong(++col, revisionNo);
            rs = pstmt.executeQuery();
            ArrayList<CSReference> result = new ArrayList<CSReference>();
            while (rs.next()) {
                result.add(this.readCSReference(rs));
            }
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            arrayList = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly((Statement)pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return arrayList;
    }

    @Override
    public StorageConfigurationSet getCSRevision(SessionToken session, String csName, long revisionNo) {
        StorageConfigurationSet storageConfigurationSet;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(csName, "csName");
        ArgChecks.checkForNegative(revisionNo, "revisionNo");
        this.ensureRevisionExists(session, revisionNo);
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(Queries.CSQuery.getCSRevision);
            int col = 0;
            pstmt.setString(++col, csName);
            pstmt.setString(++col, csName);
            pstmt.setLong(++col, revisionNo);
            pstmt.setLong(++col, revisionNo);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                throw this.newEntityNotExistingException(csName, revisionNo);
            }
            StorageConfigurationSet result = this.readCS(session, rs);
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            storageConfigurationSet = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly((Statement)pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return storageConfigurationSet;
    }

    @Override
    public Collection<CSReference> getDevelopmentCSs(SessionToken session, long branchNo, boolean changedOnly) {
        ArrayList<CSReference> arrayList;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNegative(branchNo, "branchNo");
        Branch branch = this.getStorage().getRevisionStorage().getBranchData(session, branchNo);
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            if (changedOnly) {
                pstmt = con.prepareStatement(Queries.CSQuery.getDevelopmentCSs_changedOnly);
                int col = 0;
                pstmt.setLong(++col, branchNo);
            } else {
                String query = Queries.CSQuery.getDevelopmentCSs(con.getEXCEPTKeyword());
                pstmt = con.prepareStatement(query);
                int col = 0;
                pstmt.setLong(++col, branchNo);
                pstmt.setLong(++col, branch.getBaseRevision().getRevision());
                pstmt.setLong(++col, branchNo);
            }
            rs = pstmt.executeQuery();
            ArrayList<CSReference> result = new ArrayList<CSReference>();
            while (rs.next()) {
                result.add(this.readCSReference(rs));
            }
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            arrayList = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return arrayList;
    }

    @Override
    public StorageConfigurationSet getDevelopmentCS(SessionToken session, String csName, long branchNo) {
        StorageConfigurationSet storageConfigurationSet;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(csName, "csName");
        ArgChecks.checkForNegative(branchNo, "branchNo");
        Branch branch = this.getStorage().getRevisionStorage().getBranchData(session, branchNo);
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(Queries.CSQuery.getDevelopmentCS(con.getEXCEPTKeyword()));
            int col = 0;
            pstmt.setString(++col, csName);
            pstmt.setString(++col, csName);
            pstmt.setLong(++col, branchNo);
            pstmt.setLong(++col, branch.getBaseRevision().getRevision());
            pstmt.setString(++col, csName);
            pstmt.setLong(++col, branchNo);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                throw this.newEntityNotExistingExceptionDev(csName, branchNo);
            }
            StorageConfigurationSet result = this.readCS(session, rs);
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            storageConfigurationSet = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return storageConfigurationSet;
    }

    @Override
    public void storeDevelopmentCS(SessionToken session, StorageConfigurationSet cs, long branchNo) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(cs, "cs");
        SQLCSStorage.checkName(cs.getName());
        ArgChecks.checkForNegative(branchNo, "branchNo");
        Branch branch = this.getStorage().getRevisionStorage().getBranchData(session, branchNo);
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        try {
            try {
                long _id = this.csIdInBranch(con, cs.getName(), branchNo);
                if (_id >= 0L) {
                    pstmt = con.prepareStatement(Queries.CSQuery.storeDevelopmentCS_update);
                    int col = 0;
                    ++col;
                    col = this.writeCS(pstmt, col, cs, _id, branch.getBaseRevision(), branch, State.IN_DEVELOPMENT);
                    pstmt.setLong(++col, _id);
                } else {
                    _id = con.nextID("AR_CsID");
                    pstmt = con.prepareStatement(Queries.CSQuery.storeDevelopmentCS_insert);
                    int col = 0;
                    this.writeCS(pstmt, ++col, cs, _id, branch.getBaseRevision(), branch, State.IN_DEVELOPMENT);
                }
                pstmt.executeUpdate();
                this.updateEntries(session, cs, _id);
                pstmt = JDBCTools.close(pstmt);
            }
            catch (SQLException ex) {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(pstmt);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)pstmt);
    }

    @Override
    public void revertDevelopmentCS(SessionToken session, String csName, long branchNo) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(csName, "csName");
        ArgChecks.checkForNegative(branchNo, "branchNo");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        try {
            try {
                long _id = this.csIdInBranch(con, csName, branchNo);
                if (_id >= 0L) {
                    pstmt = con.prepareStatement(Queries.CSQuery.revertDevelopmentCS);
                    int col = 0;
                    pstmt.setLong(++col, branchNo);
                    pstmt.setString(++col, csName);
                    pstmt.executeUpdate();
                    pstmt = JDBCTools.close(pstmt);
                    this.deleteParameterTemplates(session, new String[]{"csID"}, _id);
                }
            }
            catch (SQLException ex) {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
        }
        finally {
            JDBCTools.closeQuietly(pstmt);
        }
    }

    @Override
    public void updateDevelopmentCSs(SessionToken session, long branchNo, long newBaseRevisionNo) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNegative(branchNo, "branchNo");
        ArgChecks.checkForNegative(newBaseRevisionNo, "newBaseRevisionNo");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        try {
            try {
                pstmt = con.prepareStatement(Queries.CSQuery.updateDevelopmentCSs);
                int col = 0;
                pstmt.setLong(++col, newBaseRevisionNo);
                pstmt.setLong(++col, branchNo);
                pstmt.executeUpdate();
                pstmt = JDBCTools.close(pstmt);
            }
            catch (SQLException ex) {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(pstmt);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)pstmt);
    }

    @Override
    public void releaseDevelopmentCSs(SessionToken session, long branchNo, long newRevisionNo) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNegative(branchNo, "branchNo");
        ArgChecks.checkForNegative(newRevisionNo, "newRevisionNo");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        try {
            try {
                pstmt = con.prepareStatement(Queries.CSQuery.releaseDevelopmentCSs);
                int col = 0;
                pstmt.setLong(++col, newRevisionNo);
                pstmt.setLong(++col, branchNo);
                pstmt.executeUpdate();
                pstmt = JDBCTools.close(pstmt);
            }
            catch (SQLException ex) {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(pstmt);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)pstmt);
    }

    @Override
    public void outdateCS(SessionToken session, String csName) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(csName, "csName");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        try {
            try {
                pstmt = con.prepareStatement(Queries.CSQuery.outdateCS);
                pstmt.setString(1, csName);
                pstmt.executeUpdate();
                pstmt = JDBCTools.close(pstmt);
            }
            catch (SQLException ex) {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(pstmt);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)pstmt);
    }

    void ensureCSExists(SessionToken session, String csName) {
        this.getLatestCSReference(session, csName);
    }

    void ensureCSExists(SessionToken session, String csName, long branchNo) {
        this.getDevelopmentCS(session, csName, branchNo);
    }

    private UnknownEntityException newEntityNotExistingException(String csName) {
        String msg = "The Configuration Set '%s' does not exist (as released or outdated)!";
        msg = String.format(msg, csName);
        return new UnknownEntityException(msg);
    }

    private UnknownEntityException newEntityNotExistingExceptionDev(String csName, long branchNo) {
        String msg = "The Configuration Set '%s' does not exist (as released, outdated or in branch #%d)!";
        msg = String.format(msg, csName, branchNo);
        return new UnknownEntityException(msg);
    }

    private UnknownEntityException newEntityNotExistingException(String csName, long revisionNo) {
        String msg = "The Configuration Set '%s' does not exist in revision #%d!";
        msg = String.format(msg, csName, revisionNo);
        return new UnknownEntityException(msg);
    }

    private long csIdInBranch(Connection con, String csName, long branchNo) throws SQLException {
        long l;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(Queries.CSQuery.csIdInBranch);
            pstmt.setString(1, csName);
            pstmt.setLong(2, branchNo);
            rs = pstmt.executeQuery();
            long result = rs.next() ? rs.getLong(1) : -1L;
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            l = result;
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly((Statement)pstmt, rs);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return l;
    }

    private CSReference readCSReference(ResultSet rs) throws SQLException {
        String name = rs.getString("name");
        String devDescription = this.getStringNN(rs, "devDescription");
        long revisionNo = rs.getLong("revision");
        State state = this.getState(rs);
        PluginDataContainer pluginData = this.getPluginData(rs);
        Map<String, String> userAttributes = this.getUserAttributes(rs);
        return this.getModelFactory().createCSReference(name, devDescription, revisionNo, state, null, pluginData, userAttributes);
    }

    private StorageConfigurationSet readCS(SessionToken session, ResultSet rs) throws SQLException {
        String name = rs.getString("name");
        String devDescription = this.getString(rs, "devDescription");
        long revisionNo = rs.getLong("revision");
        State state = this.getState(rs);
        PluginDataContainer pluginData = this.getPluginData(rs);
        Map<String, String> userAttributes = this.getUserAttributes(rs);
        StorageConfigurationSet result = this.getModelFactory().createStorageConfigurationSet(name, devDescription, revisionNo, state, pluginData, userAttributes);
        this.retrieveEntries(session, result, rs.getLong("ID_"));
        return result;
    }

    private int writeCS(PreparedStatement pstmt, int firstColumn, StorageConfigurationSet cs, long _id, Revision revision, Branch branch, State state) throws SQLException {
        int col = firstColumn - 1;
        pstmt.setLong(++col, _id);
        pstmt.setString(++col, cs.getName());
        pstmt.setString(++col, cs.getDeveloperDescription());
        pstmt.setLong(++col, revision.getRevision());
        this.setBranch(pstmt, ++col, branch);
        this.setState(pstmt, ++col, state);
        this.setPluginData(pstmt, ++col, cs);
        this.setUserAttributes(pstmt, ++col, cs.getUserAttributes());
        return col;
    }

    private void retrieveEntries(SessionToken session, StorageConfigurationSet cs, long csID) throws SQLException {
        ArgChecks.checkForNull(session, "session");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(Queries.CS_EntryQuery.RETRIEVE_ENTRIES());
            pstmt.setLong(1, csID);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String sar;
                Map<String, StorageParameterTemplate> parameterTemplates;
                StorageConfiguration testConf;
                StorageConfiguration conf;
                StorageConfigurationDescription confDesc;
                String ecName = rs.getString("ecName");
                String opName = rs.getString("opName");
                if (ecName == null && opName == null) {
                    confDesc = this.getConfigurationDescription(rs, "configurationDescription");
                    conf = this.getConfiguration(rs, "configuration");
                    testConf = this.getConfiguration(rs, "testConfiguration");
                    parameterTemplates = this.retrieveParameterTemplates(session, Columns.ParameterTemplateColumn._CS_REF_KEYS, csID, null, null);
                    sar = rs.getString("staffAssignmentRule");
                    cs.setConfigurationDescription(confDesc);
                    cs.setConfiguration(conf);
                    cs.setTestConfiguration(testConf);
                    cs.setParameterTemplates(parameterTemplates);
                    cs.setStaffAssignmentRule(sar);
                    continue;
                }
                if (ecName != null && opName == null) {
                    confDesc = this.getConfigurationDescription(rs, "configurationDescription");
                    conf = this.getConfiguration(rs, "configuration");
                    testConf = this.getConfiguration(rs, "testConfiguration");
                    parameterTemplates = this.retrieveParameterTemplates(session, Columns.ParameterTemplateColumn._CS_REF_KEYS, csID, ecName, null);
                    rs.getString("staffAssignmentRule");
                    cs.setConfigurationDescription(confDesc, ecName);
                    cs.setConfiguration(conf, ecName);
                    cs.setTestConfiguration(testConf, ecName);
                    cs.setParameterTemplates(parameterTemplates, ecName);
                    continue;
                }
                if (ecName != null && opName != null) {
                    cs.addOperation(ecName, opName);
                    confDesc = this.getConfigurationDescription(rs, "configurationDescription");
                    conf = this.getActivityConfiguration(rs, "configuration");
                    testConf = this.getActivityConfiguration(rs, "testConfiguration");
                    parameterTemplates = this.retrieveParameterTemplates(session, Columns.ParameterTemplateColumn._CS_REF_KEYS, csID, ecName, opName);
                    sar = rs.getString("staffAssignmentRule");
                    cs.setConfigurationDescription(confDesc, ecName, opName);
                    cs.setConfiguration((StorageActivityConfiguration)conf, ecName, opName);
                    cs.setTestConfiguration((StorageActivityConfiguration)testConf, ecName, opName);
                    cs.setParameterTemplates(parameterTemplates, ecName, opName);
                    cs.setStaffAssignmentRule(sar, ecName, opName);
                    continue;
                }
                String msg = "Illegal configuration set entry encountered in database.";
                this.getStorage().getLogger().severe(msg);
            }
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly((Statement)pstmt, rs);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
    }

    void updateEntries(SessionToken session, StorageConfigurationSet cs, long csID) throws SQLException {
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        try {
            pstmt = con.prepareStatement(Queries.CS_EntryQuery.DELETE_ENTRIES());
            pstmt.setLong(1, csID);
            pstmt.executeUpdate();
            pstmt = JDBCTools.close(pstmt);
            pstmt = con.prepareStatement(Queries.CS_EntryQuery.DELETE_ENTRIES_PARAMETERTEMPLATES());
            pstmt.setLong(1, csID);
            pstmt.executeUpdate();
            pstmt = JDBCTools.close(pstmt);
            pstmt = con.prepareStatement(Queries.CS_EntryQuery.CREATE_ENTRY());
            int col = 0;
            pstmt.setLong(++col, csID);
            pstmt.setString(++col, null);
            pstmt.setString(++col, null);
            this.setConfigurationDescription(pstmt, ++col, cs.getConfigurationDescription());
            this.setConfiguration(pstmt, ++col, cs.getConfiguration());
            this.setConfiguration(pstmt, ++col, cs.getTestConfiguration());
            pstmt.setString(++col, cs.getStaffAssignmentRule());
            pstmt.executeUpdate();
            this.updateParameterTemplates(session, cs.getParameterTemplates(), Columns.ParameterTemplateColumn._CS_REF_KEYS, csID, null, null);
            Map<String, Collection<String>> allOpNames = cs.getOperationNames();
            for (Map.Entry<String, Collection<String>> ecEntry : allOpNames.entrySet()) {
                col = 1;
                String ecName = ecEntry.getKey();
                pstmt.setString(++col, ecName);
                pstmt.setString(++col, null);
                this.setConfigurationDescription(pstmt, ++col, cs.getConfigurationDescription(ecName));
                this.setConfiguration(pstmt, ++col, cs.getConfiguration(ecName));
                this.setConfiguration(pstmt, ++col, cs.getTestConfiguration(ecName));
                pstmt.setString(++col, null);
                pstmt.executeUpdate();
                this.updateParameterTemplates(session, cs.getParameterTemplates(ecName), Columns.ParameterTemplateColumn._CS_REF_KEYS, csID, ecName, null);
                for (String opName : ecEntry.getValue()) {
                    col = 2;
                    pstmt.setString(++col, opName);
                    this.setConfigurationDescription(pstmt, ++col, cs.getConfigurationDescription(ecName, opName));
                    this.setActivityConfiguration(pstmt, ++col, cs.getConfiguration(ecName, opName));
                    this.setActivityConfiguration(pstmt, ++col, cs.getTestConfiguration(ecName, opName));
                    pstmt.setString(++col, cs.getStaffAssignmentRule(ecName, opName));
                    pstmt.executeUpdate();
                    this.updateParameterTemplates(session, cs.getParameterTemplates(ecName, opName), Columns.ParameterTemplateColumn._CS_REF_KEYS, csID, ecName, opName);
                }
            }
            pstmt = JDBCTools.close(pstmt);
        }
        finally {
            JDBCTools.closeQuietly((Statement)pstmt);
        }
    }
}

