/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.activityrepository.defaultimplementation.sql;

import de.aristaflow.adept2.base.dbaccess.ExtendedConnection;
import de.aristaflow.adept2.base.dbaccess.JDBCTools;
import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.sql.AbstractSQLSubStorage;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.sql.Columns;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.sql.Queries;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.sql.SQLActivityRepositoryStorage;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.storage.ECDStorage;
import de.aristaflow.adept2.model.activitymodel.ECDReference;
import de.aristaflow.adept2.model.activitymodel.StorageConfigurationDescription;
import de.aristaflow.adept2.model.activitymodel.StorageExecutableComponentDescription;
import de.aristaflow.adept2.model.activitymodel.StorageParameterTemplate;
import de.aristaflow.adept2.model.common.Branch;
import de.aristaflow.adept2.model.common.ExecutionControlProperties;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.common.Revision;
import de.aristaflow.adept2.model.common.State;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.UnknownEntityException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;

class SQLECDStorage
extends AbstractSQLSubStorage
implements ECDStorage {
    SQLECDStorage(SQLActivityRepositoryStorage storage) {
        super(storage);
    }

    @Override
    public Collection<ECDReference> getLatestECDs(SessionToken session, boolean productionOnly) {
        ArrayList<ECDReference> arrayList;
        ArgChecks.checkForNull(session, "session");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            String query = productionOnly ? Queries.ECDQuery.getLatestECDs_prodOnly : Queries.ECDQuery.getLatestECDs;
            pstmt = con.prepareStatement(query);
            rs = pstmt.executeQuery();
            ArrayList<ECDReference> result = new ArrayList<ECDReference>();
            while (rs.next()) {
                result.add(this.readECDReference(rs));
            }
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            arrayList = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return arrayList;
    }

    @Override
    public ECDReference getLatestECDReference(SessionToken session, String ecName) {
        ECDReference eCDReference;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(ecName, "ecName");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(Queries.ECDQuery.getLatestECDReference);
            int col = 0;
            pstmt.setString(++col, ecName);
            pstmt.setString(++col, ecName);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                throw this.newEntityNotExistingException(ecName);
            }
            ECDReference result = this.readECDReference(rs);
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            eCDReference = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly((Statement)pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return eCDReference;
    }

    @Override
    public StorageExecutableComponentDescription getLatestECD(SessionToken session, String ecName) {
        StorageExecutableComponentDescription storageExecutableComponentDescription;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(ecName, "ecName");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(Queries.ECDQuery.getLatestECD);
            int col = 0;
            pstmt.setString(++col, ecName);
            pstmt.setString(++col, ecName);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                throw this.newEntityNotExistingException(ecName);
            }
            StorageExecutableComponentDescription result = this.readECD(session, rs);
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            storageExecutableComponentDescription = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly((Statement)pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return storageExecutableComponentDescription;
    }

    @Override
    public List<ECDReference> getECDRevisionHistory(SessionToken session, String ecName) {
        ArrayList<ECDReference> arrayList;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(ecName, "ecName");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(Queries.ECDQuery.getECDRevisionHistory);
            int col = 0;
            pstmt.setString(++col, ecName);
            rs = pstmt.executeQuery();
            ArrayList<ECDReference> result = new ArrayList<ECDReference>();
            while (rs.next()) {
                result.add(this.readECDReference(rs));
            }
            if (result.isEmpty()) {
                throw this.newEntityNotExistingException(ecName);
            }
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            arrayList = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly((Statement)pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return arrayList;
    }

    @Override
    public Collection<ECDReference> getECDsOfRevision(SessionToken session, long revisionNo) {
        ArrayList<ECDReference> arrayList;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNegative(revisionNo, "revisionNo");
        this.ensureRevisionExists(session, revisionNo);
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(Queries.ECDQuery.getECDsOfRevision);
            int col = 0;
            pstmt.setLong(++col, revisionNo);
            rs = pstmt.executeQuery();
            ArrayList<ECDReference> result = new ArrayList<ECDReference>();
            while (rs.next()) {
                result.add(this.readECDReference(rs));
            }
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            arrayList = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly((Statement)pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return arrayList;
    }

    @Override
    public StorageExecutableComponentDescription getECDRevision(SessionToken session, String ecName, long revisionNo) {
        StorageExecutableComponentDescription storageExecutableComponentDescription;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(ecName, "ecName");
        ArgChecks.checkForNegative(revisionNo, "revisionNo");
        this.ensureRevisionExists(session, revisionNo);
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(Queries.ECDQuery.getECDRevision);
            int col = 0;
            pstmt.setString(++col, ecName);
            pstmt.setString(++col, ecName);
            pstmt.setLong(++col, revisionNo);
            pstmt.setLong(++col, revisionNo);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                throw this.newEntityNotExistingException(ecName, revisionNo);
            }
            StorageExecutableComponentDescription result = this.readECD(session, rs);
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            storageExecutableComponentDescription = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly((Statement)pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return storageExecutableComponentDescription;
    }

    @Override
    public Collection<ECDReference> getDevelopmentECDs(SessionToken session, long branchNo, boolean changedOnly) {
        ArrayList<ECDReference> arrayList;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNegative(branchNo, "branchNo");
        Branch branch = this.getStorage().getRevisionStorage().getBranchData(session, branchNo);
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            if (changedOnly) {
                pstmt = con.prepareStatement(Queries.ECDQuery.getDevelopmentECDs_changedOnly);
                int col = 0;
                pstmt.setLong(++col, branchNo);
            } else {
                String query = Queries.ECDQuery.getDevelopmentECDs(con.getEXCEPTKeyword());
                pstmt = con.prepareStatement(query);
                int col = 0;
                pstmt.setLong(++col, branchNo);
                pstmt.setLong(++col, branch.getBaseRevision().getRevision());
                pstmt.setLong(++col, branchNo);
            }
            rs = pstmt.executeQuery();
            ArrayList<ECDReference> result = new ArrayList<ECDReference>();
            while (rs.next()) {
                result.add(this.readECDReference(rs));
            }
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            arrayList = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return arrayList;
    }

    @Override
    public StorageExecutableComponentDescription getDevelopmentECD(SessionToken session, String ecName, long branchNo) {
        StorageExecutableComponentDescription storageExecutableComponentDescription;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(ecName, "ecName");
        ArgChecks.checkForNegative(branchNo, "branchNo");
        Branch branch = this.getStorage().getRevisionStorage().getBranchData(session, branchNo);
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(Queries.ECDQuery.getDevelopmentECD(con.getEXCEPTKeyword()));
            int col = 0;
            pstmt.setString(++col, ecName);
            pstmt.setString(++col, ecName);
            pstmt.setLong(++col, branchNo);
            pstmt.setLong(++col, branch.getBaseRevision().getRevision());
            pstmt.setString(++col, ecName);
            pstmt.setLong(++col, branchNo);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                throw this.newEntityNotExistingExceptionDev(ecName, branchNo);
            }
            StorageExecutableComponentDescription result = this.readECD(session, rs);
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            storageExecutableComponentDescription = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return storageExecutableComponentDescription;
    }

    @Override
    public void storeDevelopmentECD(SessionToken session, StorageExecutableComponentDescription ecd, long branchNo) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(ecd, "ecd");
        SQLECDStorage.checkName(ecd.getName());
        ArgChecks.checkForNegative(branchNo, "branchNo");
        Branch branch = this.getStorage().getRevisionStorage().getBranchData(session, branchNo);
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        try {
            try {
                long _id = this.ecdIdInBranch(con, ecd.getName(), branchNo);
                if (_id >= 0L) {
                    pstmt = con.prepareStatement(Queries.ECDQuery.storeDevelopmentECD_update);
                    int col = 0;
                    ++col;
                    col = this.writeECD(pstmt, col, ecd, _id, branch.getBaseRevision(), branch, State.IN_DEVELOPMENT);
                    pstmt.setLong(++col, _id);
                } else {
                    _id = con.nextID("AR_EcdID");
                    pstmt = con.prepareStatement(Queries.ECDQuery.storeDevelopmentECD_insert);
                    int col = 0;
                    this.writeECD(pstmt, ++col, ecd, _id, branch.getBaseRevision(), branch, State.IN_DEVELOPMENT);
                }
                pstmt.executeUpdate();
                this.updateParameterTemplates(session, ecd.getParameterTemplates(), Columns.ParameterTemplateColumn._ECD_REF_KEYS, _id);
                pstmt = JDBCTools.close(pstmt);
            }
            catch (SQLException ex) {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(pstmt);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)pstmt);
    }

    @Override
    public void revertDevelopmentECD(SessionToken session, String ecName, long branchNo) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(ecName, "ecName");
        ArgChecks.checkForNegative(branchNo, "branchNo");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        try {
            try {
                long _id = this.ecdIdInBranch(con, ecName, branchNo);
                if (_id >= 0L) {
                    pstmt = con.prepareStatement(Queries.ECDQuery.revertDevelopmentECD);
                    int col = 0;
                    pstmt.setLong(++col, branchNo);
                    pstmt.setString(++col, ecName);
                    pstmt.executeUpdate();
                    pstmt = JDBCTools.close(pstmt);
                    this.deleteParameterTemplates(session, new String[]{"ecdID"}, _id);
                }
            }
            catch (SQLException ex) {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
        }
        finally {
            JDBCTools.closeQuietly(pstmt);
        }
    }

    @Override
    public void updateDevelopmentECDs(SessionToken session, long branchNo, long newBaseRevisionNo) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNegative(branchNo, "branchNo");
        ArgChecks.checkForNegative(newBaseRevisionNo, "newBaseRevisionNo");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        try {
            try {
                pstmt = con.prepareStatement(Queries.ECDQuery.updateDevelopmentECDs);
                int col = 0;
                pstmt.setLong(++col, newBaseRevisionNo);
                pstmt.setLong(++col, branchNo);
                pstmt.executeUpdate();
                pstmt = JDBCTools.close(pstmt);
            }
            catch (SQLException ex) {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(pstmt);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)pstmt);
    }

    @Override
    public void releaseDevelopmentECDs(SessionToken session, long branchNo, long newRevisionNo) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNegative(branchNo, "branchNo");
        ArgChecks.checkForNegative(newRevisionNo, "newRevisionNo");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        try {
            try {
                pstmt = con.prepareStatement(Queries.ECDQuery.releaseDevelopmentECDs);
                int col = 0;
                pstmt.setLong(++col, newRevisionNo);
                pstmt.setLong(++col, branchNo);
                pstmt.executeUpdate();
                pstmt = JDBCTools.close(pstmt);
            }
            catch (SQLException ex) {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(pstmt);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)pstmt);
    }

    @Override
    public void outdateECD(SessionToken session, String ecName) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(ecName, "ecName");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        try {
            try {
                pstmt = con.prepareStatement(Queries.ECDQuery.outdateECD);
                int col = 0;
                pstmt.setString(++col, ecName);
                pstmt.executeUpdate();
                pstmt = JDBCTools.close(pstmt);
            }
            catch (SQLException ex) {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(pstmt);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)pstmt);
    }

    void ensureECDExists(SessionToken session, String ecName) {
        this.getLatestECDReference(session, ecName);
    }

    void ensureECDExists(SessionToken session, String ecName, long branchNo) {
        this.getDevelopmentECD(session, ecName, branchNo);
    }

    private UnknownEntityException newEntityNotExistingException(String ecName) {
        String msg = "The Executable Component Description '%s' does not exist (as released or outdated)!";
        msg = String.format(msg, ecName);
        return new UnknownEntityException(msg);
    }

    private UnknownEntityException newEntityNotExistingExceptionDev(String ecName, long branchNo) {
        String msg = "The Executable Component Description '%s' does not exist (as released, outdated or in branch #%d)!";
        msg = String.format(msg, ecName, branchNo);
        return new UnknownEntityException(msg);
    }

    private UnknownEntityException newEntityNotExistingException(String ecName, long revisionNo) {
        String msg = "The Executable Component Description '%s' does not exist in revision #%d!";
        msg = String.format(msg, ecName, revisionNo);
        return new UnknownEntityException(msg);
    }

    private long ecdIdInBranch(Connection con, String ecName, long branchNo) throws SQLException {
        long l;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(Queries.ECDQuery.ecdIdInBranch);
            pstmt.setString(1, ecName);
            pstmt.setLong(2, branchNo);
            rs = pstmt.executeQuery();
            long result = rs.next() ? rs.getLong(1) : -1L;
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            l = result;
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly((Statement)pstmt, rs);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return l;
    }

    private ECDReference readECDReference(ResultSet rs) throws SQLException {
        String name = rs.getString("name");
        String devDescription = this.getStringNN(rs, "devDescription");
        long revisionNo = rs.getLong("revision");
        State state = this.getState(rs);
        UUID iconID = this.getUUID(rs, "iconID");
        PluginDataContainer pluginData = this.getPluginData(rs);
        Map<String, String> userAttributes = this.getUserAttributes(rs);
        return this.getModelFactory().createECDReference(name, devDescription, revisionNo, state, iconID, pluginData, userAttributes);
    }

    private StorageExecutableComponentDescription readECD(SessionToken session, ResultSet rs) throws SQLException {
        String name = rs.getString("name");
        String devDescription = this.getStringNN(rs, "devDescription");
        long revisionNo = rs.getLong("revision");
        State state = this.getState(rs);
        String implementationClass = this.getStringNN(rs, "implementationClass");
        List<String> classPath = this.getClassPath(rs, "classPath");
        boolean isSingleton = rs.getBoolean("isSingleton");
        byte[] systemComponentSignature = this.getSystemComponentSignature(rs, "sysCompSignature");
        String guiContextID = rs.getString("guiContextID");
        ExecutionControlProperties ecp = this.getECP(rs, "executionControlProperties");
        UUID iconID = this.getUUID(rs, "iconID");
        String licenceInformation = this.getStringNN(rs, "licence");
        StorageConfigurationDescription confDesc = this.getConfigurationDescription(rs, "configurationDescription");
        Collection<StorageParameterTemplate> paramTemplates = this.retrieveParameterTemplates(session, Columns.ParameterTemplateColumn._ECD_REF_KEYS, rs.getLong("ID_")).values();
        PluginDataContainer pluginData = this.getPluginData(rs);
        Map<String, String> userAttributes = this.getUserAttributes(rs);
        return this.getModelFactory().createStorageExecutableComponentDescription(name, devDescription, revisionNo, state, implementationClass, classPath, isSingleton, systemComponentSignature, guiContextID, ecp, iconID, licenceInformation, confDesc, paramTemplates, pluginData, userAttributes);
    }

    private int writeECD(PreparedStatement pstmt, int firstColumn, StorageExecutableComponentDescription ecd, long _id, Revision revision, Branch branch, State state) throws SQLException {
        int col = firstColumn - 1;
        pstmt.setLong(++col, _id);
        pstmt.setString(++col, ecd.getName());
        pstmt.setString(++col, ecd.getDeveloperDescription());
        pstmt.setLong(++col, revision.getRevision());
        this.setBranch(pstmt, ++col, branch);
        this.setState(pstmt, ++col, state);
        pstmt.setString(++col, ecd.getImplementationClass());
        this.setClassPath(pstmt, ++col, ecd.getClassPath());
        pstmt.setBoolean(++col, ecd.isSingleton());
        this.setSystemComponentSignature(pstmt, ++col, ecd.getSystemComponent(), false);
        pstmt.setString(++col, ecd.getGUIContextID());
        this.setECP(pstmt, ++col, ecd.getExecutionControlProperties());
        ++col;
        col = this.setUUID(pstmt, col, ecd.getIconID());
        pstmt.setString(++col, ecd.getLicenceInformation());
        this.setConfigurationDescription(pstmt, ++col, ecd.getConfigurationDescription());
        this.setPluginData(pstmt, ++col, ecd);
        this.setUserAttributes(pstmt, ++col, ecd.getUserAttributes());
        return col;
    }
}

