/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.activityrepository.defaultimplementation.sql;

import de.aristaflow.adept2.base.dbaccess.ExtendedConnection;
import de.aristaflow.adept2.base.dbaccess.JDBCTools;
import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.sql.AbstractSQLSubStorage;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.sql.Queries;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.sql.SQLActivityRepositoryStorage;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.storage.IconStorage;
import de.aristaflow.adept2.model.activitymodel.ChangeableIconDescriptor;
import de.aristaflow.adept2.model.common.Branch;
import de.aristaflow.adept2.model.common.IconDescriptor;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.common.Revision;
import de.aristaflow.adept2.model.common.State;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.UnknownEntityException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class SQLIconStorage
extends AbstractSQLSubStorage
implements IconStorage {
    public SQLIconStorage(SQLActivityRepositoryStorage storage) {
        super(storage);
    }

    @Override
    public Collection<IconDescriptor> getLatestIcons(SessionToken session, boolean productionOnly) {
        ArrayList<IconDescriptor> arrayList;
        ArgChecks.checkForNull(session, "session");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            String query = productionOnly ? Queries.IconQuery.getLatestIcons_prodOnly : Queries.IconQuery.getLatestIcons;
            pstmt = con.prepareStatement(query);
            rs = pstmt.executeQuery();
            ArrayList<IconDescriptor> result = new ArrayList<IconDescriptor>();
            if (rs.next()) {
                do {
                    result.add(this.readIconDescriptor(rs));
                } while (!rs.isAfterLast());
            }
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            arrayList = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return arrayList;
    }

    @Override
    public IconDescriptor getLatestIconDescriptor(SessionToken session, UUID id) {
        IconDescriptor iconDescriptor;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(id, "id");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(Queries.IconQuery.getLatestIconDescriptor);
            int col = 0;
            ++col;
            col = this.setUUID(pstmt, col, id);
            this.setUUID(pstmt, ++col, id);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                throw this.newEntityNotExistingException(id, false);
            }
            IconDescriptor result = this.readIconDescriptor(rs);
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            iconDescriptor = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly((Statement)pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return iconDescriptor;
    }

    @Override
    public byte[] getLatestIcon(SessionToken session, UUID id, IconDescriptor.Dimension dimension) {
        byte[] byArray;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(id, "id");
        ArgChecks.checkForNull(dimension, "dimension");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(Queries.IconQuery.getLatestIcon);
            int col = 0;
            ++col;
            col = this.setUUID(pstmt, col, id);
            ++col;
            col = this.setUUID(pstmt, col, id);
            pstmt.setInt(++col, dimension.width);
            pstmt.setInt(++col, dimension.height);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                throw this.newEntityNotExistingException(id, true);
            }
            byte[] result = this.readIcon(rs);
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            byArray = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly((Statement)pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return byArray;
    }

    @Override
    public List<IconDescriptor> getIconRevisionHistory(SessionToken session, UUID id) {
        ArrayList<IconDescriptor> arrayList;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(id, "id");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            ArrayList<IconDescriptor> result;
            pstmt = con.prepareStatement(Queries.IconQuery.getIconRevisionHistory);
            int col = 0;
            this.setUUID(pstmt, ++col, id);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                result = new ArrayList<IconDescriptor>();
                do {
                    result.add(this.readIconDescriptor(rs));
                } while (!rs.isAfterLast());
            } else {
                throw this.newEntityNotExistingException(id, false);
            }
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            arrayList = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly((Statement)pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return arrayList;
    }

    @Override
    public Collection<IconDescriptor> getIconsOfRevision(SessionToken session, long revisionNo) {
        ArrayList<IconDescriptor> arrayList;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNegative(revisionNo, "revisionNo");
        this.ensureRevisionExists(session, revisionNo);
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(Queries.IconQuery.getIconsOfRevision);
            int col = 0;
            pstmt.setLong(++col, revisionNo);
            rs = pstmt.executeQuery();
            ArrayList<IconDescriptor> result = new ArrayList<IconDescriptor>();
            if (rs.next()) {
                do {
                    result.add(this.readIconDescriptor(rs));
                } while (!rs.isAfterLast());
            }
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            arrayList = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly((Statement)pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return arrayList;
    }

    @Override
    public IconDescriptor getIconDescriptorRevision(SessionToken session, UUID id, long revisionNo) {
        IconDescriptor iconDescriptor;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(id, "id");
        ArgChecks.checkForNegative(revisionNo, "revisionNo");
        this.ensureRevisionExists(session, revisionNo);
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(Queries.IconQuery.getIconDescriptorRevision);
            int col = 0;
            ++col;
            col = this.setUUID(pstmt, col, id);
            ++col;
            col = this.setUUID(pstmt, col, id);
            pstmt.setLong(++col, revisionNo);
            pstmt.setLong(++col, revisionNo);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                throw this.newEntityNotExistingException(id, revisionNo, false);
            }
            IconDescriptor result = this.readIconDescriptor(rs);
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            iconDescriptor = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly((Statement)pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return iconDescriptor;
    }

    @Override
    public byte[] getIconRevision(SessionToken session, UUID id, IconDescriptor.Dimension dimension, long revisionNo) {
        byte[] byArray;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(id, "id");
        ArgChecks.checkForNull(dimension, "dimension");
        ArgChecks.checkForNegative(revisionNo, "revisionNo");
        this.ensureRevisionExists(session, revisionNo);
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(Queries.IconQuery.getIconRevision);
            int col = 0;
            ++col;
            col = this.setUUID(pstmt, col, id);
            ++col;
            col = this.setUUID(pstmt, col, id);
            pstmt.setLong(++col, revisionNo);
            pstmt.setLong(++col, revisionNo);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                throw this.newEntityNotExistingException(id, revisionNo, true);
            }
            byte[] result = this.readIcon(rs);
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            byArray = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly((Statement)pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return byArray;
    }

    @Override
    public Collection<ChangeableIconDescriptor> getDevelopmentIcons(SessionToken session, long branchNo, boolean changedOnly) {
        ArrayList<ChangeableIconDescriptor> arrayList;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNegative(branchNo, "branchNo");
        Branch branch = this.getStorage().getRevisionStorage().getBranchData(session, branchNo);
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            int col;
            if (changedOnly) {
                pstmt = con.prepareStatement(Queries.IconQuery.getDevelopmentIcons_changedOnly);
                col = 0;
                pstmt.setLong(++col, branchNo);
            } else {
                pstmt = con.prepareStatement(Queries.IconQuery.getDevelopmentIcon(con.getEXCEPTKeyword()));
                col = 0;
                pstmt.setLong(++col, branchNo);
                pstmt.setLong(++col, branch.getBaseRevision().getRevision());
                pstmt.setLong(++col, branchNo);
            }
            rs = pstmt.executeQuery();
            ArrayList<ChangeableIconDescriptor> result = new ArrayList<ChangeableIconDescriptor>();
            if (rs.next()) {
                do {
                    result.add(this.readChangeableIconDescriptor(rs));
                } while (!rs.isAfterLast());
            }
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            arrayList = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return arrayList;
    }

    @Override
    public ChangeableIconDescriptor getDevelopmentIconDescriptor(SessionToken session, UUID id, long branchNo) {
        ChangeableIconDescriptor changeableIconDescriptor;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(id, "id");
        ArgChecks.checkForNegative(branchNo, "branchNo");
        Branch branch = this.getStorage().getRevisionStorage().getBranchData(session, branchNo);
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(Queries.ResourceQuery.getDevelopmentResource(con.getEXCEPTKeyword()));
            int col = 0;
            ++col;
            col = this.setUUID(pstmt, col, id);
            ++col;
            col = this.setUUID(pstmt, col, id);
            pstmt.setLong(++col, branchNo);
            pstmt.setLong(++col, branch.getBaseRevision().getRevision());
            ++col;
            col = this.setUUID(pstmt, col, id);
            pstmt.setLong(++col, branchNo);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                throw this.newEntityNotExistingExceptionDev(id, branchNo, false);
            }
            ChangeableIconDescriptor result = this.readChangeableIconDescriptor(rs);
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            changeableIconDescriptor = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return changeableIconDescriptor;
    }

    @Override
    public byte[] getDevelopmentIcon(SessionToken session, UUID id, IconDescriptor.Dimension dimension, long branchNo) {
        byte[] byArray;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(id, "id");
        ArgChecks.checkForNull(dimension, "dimension");
        ArgChecks.checkForNegative(branchNo, "branchNo");
        Branch branch = this.getStorage().getRevisionStorage().getBranchData(session, branchNo);
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(Queries.IconQuery.getDevelopmentIcon(con.getEXCEPTKeyword()));
            int col = 0;
            ++col;
            col = this.setUUID(pstmt, col, id);
            ++col;
            col = this.setUUID(pstmt, col, id);
            pstmt.setLong(++col, branchNo);
            pstmt.setLong(++col, branch.getBaseRevision().getRevision());
            ++col;
            col = this.setUUID(pstmt, col, id);
            pstmt.setLong(++col, branchNo);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                throw this.newEntityNotExistingExceptionDev(id, branchNo, true);
            }
            byte[] result = this.readIcon(rs);
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            byArray = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return byArray;
    }

    @Override
    public void storeDevelopmentIconDescriptor(SessionToken session, IconDescriptor descriptor, long branchNo) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(descriptor, "descriptor");
        ArgChecks.checkForNegative(branchNo, "branchNo");
        Branch branch = this.getStorage().getRevisionStorage().getBranchData(session, branchNo);
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        try {
            try {
                long _id = this.iconIdInBranch(con, descriptor.getID(), branchNo);
                if (_id >= 0L) {
                    pstmt = con.prepareStatement(Queries.IconQuery.storeDevelopmentIconDescriptor_update);
                    int col = 0;
                    ++col;
                    col = this.writeIconDescriptor(pstmt, col, descriptor, _id, branch.getBaseRevision(), branch, State.IN_DEVELOPMENT);
                    pstmt.setLong(++col, _id);
                } else {
                    ArrayList<IconDescriptor.Dimension> iconDims = new ArrayList<IconDescriptor.Dimension>();
                    ArrayList<byte[]> iconDatas = new ArrayList<byte[]>();
                    try {
                        ChangeableIconDescriptor newDescriptor = this.getDevelopmentIconDescriptor(session, descriptor.getID(), branchNo);
                        IconDescriptor.Dimension[] dimensionArray = newDescriptor.getDimensions();
                        int n = dimensionArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IconDescriptor.Dimension dim = dimensionArray[n2];
                            byte[] data = this.getDevelopmentIcon(session, descriptor.getID(), dim, branchNo);
                            iconDims.add(dim);
                            iconDatas.add(data);
                            ++n2;
                        }
                    }
                    catch (UnknownEntityException unknownEntityException) {}
                    _id = con.nextID("AR_IconID");
                    pstmt = con.prepareStatement(Queries.IconQuery.storeDevelopmentIconDescriptor_insert);
                    int col = 0;
                    this.writeIconDescriptor(pstmt, ++col, descriptor, _id, branch.getBaseRevision(), branch, State.IN_DEVELOPMENT);
                    if (!iconDims.isEmpty()) {
                        int i = 0;
                        int length = iconDims.size();
                        while (i < length) {
                            IconDescriptor.Dimension dim = (IconDescriptor.Dimension)iconDims.get(i);
                            byte[] data = (byte[])iconDatas.get(i);
                            this.addDevelopmentIcon(session, descriptor.getID(), data, dim, branchNo);
                            ++i;
                        }
                    }
                }
                pstmt.executeUpdate();
                pstmt = JDBCTools.close(pstmt);
            }
            catch (SQLException ex) {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(pstmt);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)pstmt);
    }

    @Override
    public void addDevelopmentIcon(SessionToken session, UUID id, byte[] icon, IconDescriptor.Dimension dimension, long branchNo) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(id, "id");
        ArgChecks.checkForNull(icon, "icon");
        ArgChecks.checkForNull(dimension, "dimension");
        ArgChecks.checkForNegative(branchNo, "branchNo");
        this.ensureBranchExists(session, branchNo);
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        try {
            try {
                ChangeableIconDescriptor descriptor = this.getDevelopmentIconDescriptor(session, id, branchNo);
                if (Arrays.asList(descriptor.getDimensions()).contains(dimension)) {
                    String msg = "An icon with an identical size is already stored!";
                    throw new IllegalArgumentException(msg);
                }
                long _id = this.iconIdInBranch(con, id, branchNo);
                if (_id < 0L) {
                    this.storeDevelopmentIconDescriptor(session, descriptor, branchNo);
                    _id = this.iconIdInBranch(con, id, branchNo);
                }
                pstmt = con.prepareStatement(Queries.IconQuery.addDevelopmentIcon);
                int col = 0;
                pstmt.setLong(++col, _id);
                pstmt.setInt(++col, dimension.width);
                pstmt.setInt(++col, dimension.height);
                pstmt.setBytes(++col, icon);
                pstmt.executeUpdate();
                pstmt = JDBCTools.close(pstmt);
            }
            catch (SQLException ex) {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(pstmt);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)pstmt);
    }

    @Override
    public void removeDevelopmentIcon(SessionToken session, UUID id, IconDescriptor.Dimension dimension, long branchNo) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(id, "id");
        ArgChecks.checkForNull(dimension, "dimension");
        ArgChecks.checkForNegative(branchNo, "branchNo");
        this.ensureBranchExists(session, branchNo);
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        try {
            try {
                ChangeableIconDescriptor descriptor = this.getDevelopmentIconDescriptor(session, id, branchNo);
                if (!Arrays.asList(descriptor.getDimensions()).contains(dimension)) {
                    String msg = "An icon with the specified dimension does not exist!";
                    throw new UnknownEntityException(msg);
                }
                long _id = this.iconIdInBranch(con, id, branchNo);
                if (_id < 0L) {
                    this.storeDevelopmentIconDescriptor(session, descriptor, branchNo);
                    _id = this.iconIdInBranch(con, id, branchNo);
                }
                pstmt = con.prepareStatement(Queries.IconQuery.removeDevelopmentIcon);
                int col = 0;
                pstmt.setLong(++col, _id);
                pstmt.setInt(++col, dimension.width);
                pstmt.setInt(++col, dimension.height);
                pstmt.executeUpdate();
                pstmt = JDBCTools.close(pstmt);
            }
            catch (SQLException ex) {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(pstmt);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)pstmt);
    }

    @Override
    public void revertDevelopmentIcon(SessionToken session, UUID id, long branchNo) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(id, "id");
        ArgChecks.checkForNegative(branchNo, "branchNo");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        try {
            try {
                pstmt = con.prepareStatement(Queries.IconQuery.revertDevelopmentIcon);
                int col = 0;
                pstmt.setLong(++col, branchNo);
                this.setUUID(pstmt, ++col, id);
                pstmt.executeUpdate();
                pstmt = JDBCTools.close(pstmt);
            }
            catch (SQLException ex) {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(pstmt);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)pstmt);
    }

    @Override
    public void updateDevelopmentIcons(SessionToken session, long branchNo, long newBaseRevisionNo) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNegative(branchNo, "branchNo");
        ArgChecks.checkForNegative(newBaseRevisionNo, "newBaseRevisionNo");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        try {
            try {
                pstmt = con.prepareStatement(Queries.IconQuery.updateDevelopmentIcons);
                int col = 0;
                pstmt.setLong(++col, newBaseRevisionNo);
                pstmt.setLong(++col, branchNo);
                pstmt.executeUpdate();
                pstmt = JDBCTools.close(pstmt);
            }
            catch (SQLException ex) {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(pstmt);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)pstmt);
    }

    @Override
    public void releaseDevelopmentIcons(SessionToken session, long branchNo, long newRevisionNo) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNegative(branchNo, "branchNo");
        ArgChecks.checkForNegative(newRevisionNo, "newRevisionNo");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        try {
            try {
                pstmt = con.prepareStatement(Queries.IconQuery.releaseDevelopmentIcons);
                int col = 0;
                pstmt.setLong(++col, newRevisionNo);
                pstmt.setLong(++col, branchNo);
                pstmt.executeUpdate();
                pstmt = JDBCTools.close(pstmt);
            }
            catch (SQLException ex) {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(pstmt);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)pstmt);
    }

    @Override
    public void outdateIcon(SessionToken session, UUID id) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(id, "id");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        try {
            try {
                pstmt = con.prepareStatement(Queries.IconQuery.outdateIcon);
                int col = 0;
                this.setUUID(pstmt, ++col, id);
                pstmt.executeUpdate();
                pstmt = JDBCTools.close(pstmt);
            }
            catch (SQLException ex) {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(pstmt);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)pstmt);
    }

    void ensureIconExists(SessionToken session, UUID id) {
        this.getLatestIconDescriptor(session, id);
    }

    void ensureIconExists(SessionToken session, UUID id, long branchNo) {
        this.getDevelopmentIconDescriptor(session, id, branchNo);
    }

    private UnknownEntityException newEntityNotExistingException(UUID id, boolean data) {
        String msg = data ? "The Icon '%s' or the requested dimension do not exist (as released or outdated)!" : "The Icon '%s' does not exist (as released or outdated)!";
        msg = String.format(msg, id);
        return new UnknownEntityException(msg);
    }

    private UnknownEntityException newEntityNotExistingExceptionDev(UUID id, long branchNo, boolean data) {
        String msg = data ? "The Icon '%s' or the requested dimension do not exist (as released, outdated or in branch #%d)!" : "The Icon '%s' does not exist (as released, outdated or in branch #%d)!";
        msg = String.format(msg, id, branchNo);
        return new UnknownEntityException(msg);
    }

    private UnknownEntityException newEntityNotExistingException(UUID id, long revisionNo, boolean data) {
        String msg = data ? "The Icon '%s' or the requested dimension do not exist in revision #%d!" : "The Icon '%s' does not exist in revision #%d!";
        msg = String.format(msg, id, revisionNo);
        return new UnknownEntityException(msg);
    }

    private boolean iconChangedInBranch(Connection con, UUID id, long branchNo) throws SQLException {
        boolean bl;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(Queries.IconQuery.iconChangedInBranch);
            int col = 0;
            ++col;
            col = this.setUUID(pstmt, col, id);
            pstmt.setLong(++col, branchNo);
            rs = pstmt.executeQuery();
            rs.next();
            boolean result = rs.getInt(1) > 0;
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            bl = result;
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly((Statement)pstmt, rs);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return bl;
    }

    private long iconIdInBranch(Connection con, UUID id, long branchNo) throws SQLException {
        long l;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(Queries.IconQuery.iconIdInBranch);
            int col = 0;
            ++col;
            col = this.setUUID(pstmt, col, id);
            pstmt.setLong(++col, branchNo);
            rs = pstmt.executeQuery();
            long result = rs.next() ? rs.getLong(1) : -1L;
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            l = result;
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly((Statement)pstmt, rs);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return l;
    }

    private IconDescriptor readIconDescriptor(ResultSet rs) throws SQLException {
        UUID id = this.getUUID(rs, "id");
        String name = rs.getString("name");
        String description = this.getStringNN(rs, "description");
        long revisionNo = rs.getLong("revision");
        State state = this.getState(rs);
        PluginDataContainer pluginData = this.getPluginData(rs);
        Map<String, String> userAttributes = this.getUserAttributes(rs);
        ArrayList<IconDescriptor.Dimension> dimensionsList = new ArrayList<IconDescriptor.Dimension>();
        do {
            int width = rs.getInt("width");
            if (rs.wasNull()) break;
            int height = rs.getInt("height");
            dimensionsList.add(new IconDescriptor.Dimension(width, height));
        } while (rs.next() && this.getUUID(rs, "id").equals(id));
        IconDescriptor.Dimension[] dimensions = dimensionsList.toArray(new IconDescriptor.Dimension[dimensionsList.size()]);
        return this.getModelFactory().createIconDescriptor(id, name, description, dimensions, revisionNo, state, pluginData, userAttributes);
    }

    private ChangeableIconDescriptor readChangeableIconDescriptor(ResultSet rs) throws SQLException {
        UUID id = this.getUUID(rs, "id");
        String name = rs.getString("name");
        String description = this.getStringNN(rs, "description");
        long revisionNo = rs.getLong("revision");
        State state = this.getState(rs);
        PluginDataContainer pluginData = this.getPluginData(rs);
        Map<String, String> userAttributes = this.getUserAttributes(rs);
        ArrayList<IconDescriptor.Dimension> dimensionsList = new ArrayList<IconDescriptor.Dimension>();
        do {
            int width = rs.getInt("width");
            int height = rs.getInt("height");
            dimensionsList.add(new IconDescriptor.Dimension(width, height));
        } while (rs.next() && this.getUUID(rs, "id").equals(id));
        IconDescriptor.Dimension[] dimensions = dimensionsList.toArray(new IconDescriptor.Dimension[dimensionsList.size()]);
        return this.getModelFactory().createChangeableIconDescriptor(id, name, description, dimensions, revisionNo, state, pluginData, userAttributes);
    }

    private byte[] readIcon(ResultSet rs) throws SQLException {
        return rs.getBytes("data");
    }

    private int writeIconDescriptor(PreparedStatement pstmt, int firstColumn, IconDescriptor descriptor, long _id, Revision revision, Branch branch, State state) throws SQLException {
        int col = firstColumn - 1;
        pstmt.setLong(++col, _id);
        ++col;
        col = this.setUUID(pstmt, col, descriptor.getID());
        pstmt.setString(++col, descriptor.getName());
        pstmt.setString(++col, descriptor.getDescription());
        pstmt.setLong(++col, revision.getRevision());
        this.setBranch(pstmt, ++col, branch);
        this.setState(pstmt, ++col, state);
        this.setPluginData(pstmt, ++col, descriptor);
        this.setUserAttributes(pstmt, ++col, descriptor.getUserAttributes());
        return col;
    }
}

