/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.activityrepository.defaultimplementation.sql;

import de.aristaflow.adept2.base.dbaccess.ExtendedConnection;
import de.aristaflow.adept2.base.dbaccess.JDBCTools;
import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.sql.AbstractSQLSubStorage;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.sql.Queries;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.sql.SQLActivityRepositoryStorage;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.storage.IdentifierStorage;
import de.aristaflow.adept2.model.activitymodel.Identifier;
import de.aristaflow.adept2.model.common.Branch;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.common.Revision;
import de.aristaflow.adept2.model.common.State;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.UnknownEntityException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class SQLIdentifierStorage
extends AbstractSQLSubStorage
implements IdentifierStorage {
    public SQLIdentifierStorage(SQLActivityRepositoryStorage storage) {
        super(storage);
    }

    @Override
    public Collection<Identifier> getLatestIdentifiers(SessionToken session, boolean productionOnly) {
        ArrayList<Identifier> arrayList;
        ArgChecks.checkForNull(session, "session");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            String query = productionOnly ? Queries.IdentifierQuery.getLatestIdentifiers_prodOnly : Queries.IdentifierQuery.getLatestIdentifiers;
            pstmt = con.prepareStatement(query);
            rs = pstmt.executeQuery();
            ArrayList<Identifier> result = new ArrayList<Identifier>();
            while (rs.next()) {
                result.add(this.readIdentifier(rs));
            }
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            arrayList = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return arrayList;
    }

    @Override
    public Identifier getLatestIdentifier(SessionToken session, UUID id) {
        Identifier identifier;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(id, "id");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(Queries.IdentifierQuery.getLatestIdentifier);
            int col = 0;
            ++col;
            col = this.setUUID(pstmt, col, id);
            this.setUUID(pstmt, ++col, id);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                throw this.newEntityNotExistingException(id);
            }
            Identifier result = this.readIdentifier(rs);
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            identifier = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly((Statement)pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return identifier;
    }

    @Override
    public List<Identifier> getIdentifierRevisionHistory(SessionToken session, UUID id) {
        ArrayList<Identifier> arrayList;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(id, "id");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(Queries.IdentifierQuery.getIdentifierRevisionHistory);
            int col = 0;
            this.setUUID(pstmt, ++col, id);
            rs = pstmt.executeQuery();
            ArrayList<Identifier> result = new ArrayList<Identifier>();
            while (rs.next()) {
                result.add(this.readIdentifier(rs));
            }
            if (result.isEmpty()) {
                throw this.newEntityNotExistingException(id);
            }
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            arrayList = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly((Statement)pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return arrayList;
    }

    @Override
    public Collection<Identifier> getIdentifiersOfRevision(SessionToken session, long revisionNo) {
        ArrayList<Identifier> arrayList;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNegative(revisionNo, "revisionNo");
        this.ensureRevisionExists(session, revisionNo);
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(Queries.IdentifierQuery.getIdentifiersOfRevision);
            pstmt.setLong(1, revisionNo);
            rs = pstmt.executeQuery();
            ArrayList<Identifier> result = new ArrayList<Identifier>();
            while (rs.next()) {
                result.add(this.readIdentifier(rs));
            }
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            arrayList = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly((Statement)pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return arrayList;
    }

    @Override
    public Identifier getIdentifierRevision(SessionToken session, UUID id, long revisionNo) {
        Identifier identifier;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(id, "id");
        ArgChecks.checkForNegative(revisionNo, "revisionNo");
        this.ensureRevisionExists(session, revisionNo);
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(Queries.IdentifierQuery.getIdentifierRevision);
            int col = 0;
            ++col;
            col = this.setUUID(pstmt, col, id);
            ++col;
            col = this.setUUID(pstmt, col, id);
            pstmt.setLong(++col, revisionNo);
            pstmt.setLong(++col, revisionNo);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                throw this.newEntityNotExistingException(id, revisionNo);
            }
            Identifier result = this.readIdentifier(rs);
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            identifier = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly((Statement)pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return identifier;
    }

    @Override
    public Collection<Identifier> getDevelopmentIdentifiers(SessionToken session, long branchNo, boolean changedOnly) {
        ArrayList<Identifier> arrayList;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNegative(branchNo, "branchNo");
        Branch branch = this.getStorage().getRevisionStorage().getBranchData(session, branchNo);
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            if (changedOnly) {
                pstmt = con.prepareStatement(Queries.IdentifierQuery.getDevelopmentIdentifiers_changedOnly);
                int col = 0;
                pstmt.setLong(++col, branchNo);
            } else {
                String query = Queries.IdentifierQuery.getDevelopmentIdentifiers(con.getEXCEPTKeyword());
                pstmt = con.prepareStatement(query);
                int col = 0;
                pstmt.setLong(++col, branchNo);
                pstmt.setLong(++col, branch.getBaseRevision().getRevision());
                pstmt.setLong(++col, branchNo);
            }
            rs = pstmt.executeQuery();
            ArrayList<Identifier> result = new ArrayList<Identifier>();
            while (rs.next()) {
                result.add(this.readIdentifier(rs));
            }
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            arrayList = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return arrayList;
    }

    @Override
    public Identifier getDevelopmentIdentifier(SessionToken session, UUID id, long branchNo) {
        Identifier identifier;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(id, "id");
        ArgChecks.checkForNegative(branchNo, "branchNo");
        Branch branch = this.getStorage().getRevisionStorage().getBranchData(session, branchNo);
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(Queries.IdentifierQuery.getDevelopmentIdentifier(con.getEXCEPTKeyword()));
            int col = 0;
            ++col;
            col = this.setUUID(pstmt, col, id);
            ++col;
            col = this.setUUID(pstmt, col, id);
            pstmt.setLong(++col, branchNo);
            pstmt.setLong(++col, branch.getBaseRevision().getRevision());
            ++col;
            col = this.setUUID(pstmt, col, id);
            pstmt.setLong(++col, branchNo);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                throw this.throwEntityNotExistingExceptionDev(id, branchNo);
            }
            Identifier result = this.readIdentifier(rs);
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            identifier = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return identifier;
    }

    @Override
    public void storeDevelopmentIdentifier(SessionToken session, Identifier identifier, long branchNo) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(identifier, "identifier");
        ArgChecks.checkForNegative(branchNo, "branchNo");
        Branch branch = this.getStorage().getRevisionStorage().getBranchData(session, branchNo);
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        try {
            try {
                if (this.identifierChangedInBranch(con, identifier.getID(), branchNo)) {
                    pstmt = con.prepareStatement(Queries.IdentifierQuery.storeDevelopmentIdentifier_update);
                    int col = 0;
                    ++col;
                    col = this.writeIdentifier(pstmt, col, identifier, branch.getBaseRevision(), branch, State.IN_DEVELOPMENT);
                    pstmt.setLong(++col, branchNo);
                    this.setUUID(pstmt, ++col, identifier.getID());
                } else {
                    pstmt = con.prepareStatement(Queries.IdentifierQuery.storeDevelopmentIdentifier_insert);
                    int col = 0;
                    this.writeIdentifier(pstmt, ++col, identifier, branch.getBaseRevision(), branch, State.IN_DEVELOPMENT);
                }
                pstmt.executeUpdate();
                pstmt = JDBCTools.close(pstmt);
            }
            catch (SQLException ex) {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(pstmt);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)pstmt);
    }

    @Override
    public void revertDevelopmentIdentifier(SessionToken session, UUID id, long branchNo) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(id, "id");
        ArgChecks.checkForNegative(branchNo, "branchNo");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        try {
            try {
                pstmt = con.prepareStatement(Queries.IdentifierQuery.revertDevelopmentIdentifier);
                int col = 0;
                pstmt.setLong(++col, branchNo);
                this.setUUID(pstmt, ++col, id);
                pstmt.executeUpdate();
                pstmt = JDBCTools.close(pstmt);
            }
            catch (SQLException ex) {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(pstmt);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)pstmt);
    }

    @Override
    public void updateDevelopmentIdentifiers(SessionToken session, long branchNo, long newBaseRevisionNo) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNegative(branchNo, "branchNo");
        ArgChecks.checkForNegative(newBaseRevisionNo, "newBaseRevisionNo");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        try {
            try {
                pstmt = con.prepareStatement(Queries.IdentifierQuery.updateDevelopmentIdentifiers);
                int col = 0;
                pstmt.setLong(++col, newBaseRevisionNo);
                pstmt.setLong(++col, branchNo);
                pstmt.executeUpdate();
                pstmt = JDBCTools.close(pstmt);
            }
            catch (SQLException ex) {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(pstmt);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)pstmt);
    }

    @Override
    public void releaseDevelopmentIdentifiers(SessionToken session, long branchNo, long newRevisionNo) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNegative(branchNo, "branchNo");
        ArgChecks.checkForNegative(newRevisionNo, "newRevisionNo");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        try {
            try {
                pstmt = con.prepareStatement(Queries.IdentifierQuery.releaseDevelopmentIdentifiers);
                int col = 0;
                pstmt.setLong(++col, newRevisionNo);
                pstmt.setLong(++col, branchNo);
                pstmt.executeUpdate();
                pstmt = JDBCTools.close(pstmt);
            }
            catch (SQLException ex) {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(pstmt);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)pstmt);
    }

    @Override
    public void outdateIdentifier(SessionToken session, UUID id) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(id, "id");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        try {
            try {
                pstmt = con.prepareStatement(Queries.IdentifierQuery.outdateIdentifier);
                int col = 0;
                this.setUUID(pstmt, ++col, id);
                pstmt.executeUpdate();
                pstmt = JDBCTools.close(pstmt);
            }
            catch (SQLException ex) {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(pstmt);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)pstmt);
    }

    void ensureIdentifierExists(SessionToken session, UUID id) {
        this.getLatestIdentifier(session, id);
    }

    void ensureIdentifierExists(SessionToken session, UUID id, long branchNo) {
        this.getDevelopmentIdentifier(session, id, branchNo);
    }

    private UnknownEntityException newEntityNotExistingException(UUID id) {
        String msg = "The Identifier '%s' does not exist!";
        msg = String.format(msg, id);
        return new UnknownEntityException(msg);
    }

    private UnknownEntityException throwEntityNotExistingExceptionDev(UUID id, long branchNo) {
        String msg = "The Identifier '%s' does not exist (as released, outdated or in branch #%d)!";
        msg = String.format(msg, id, branchNo);
        return new UnknownEntityException(msg);
    }

    private UnknownEntityException newEntityNotExistingException(UUID id, long revisionNo) {
        String msg = "The Identifier '%s' does not exist in revision #%d!";
        msg = String.format(msg, id, revisionNo);
        return new UnknownEntityException(msg);
    }

    private boolean identifierChangedInBranch(Connection con, UUID id, long branchNo) throws SQLException {
        boolean bl;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(Queries.IdentifierQuery.identifierChangedInBranch);
            int col = 0;
            ++col;
            col = this.setUUID(pstmt, col, id);
            pstmt.setLong(++col, branchNo);
            rs = pstmt.executeQuery();
            rs.next();
            boolean result = rs.getInt(1) > 0;
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            bl = result;
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly((Statement)pstmt, rs);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return bl;
    }

    private Identifier readIdentifier(ResultSet rs) throws SQLException {
        UUID id = this.getUUID(rs, "id");
        String name = rs.getString("name");
        String description = this.getStringNN(rs, "description");
        long revisionNo = rs.getLong("revision");
        State state = this.getState(rs);
        PluginDataContainer pluginData = this.getPluginData(rs);
        Map<String, String> userAttributes = this.getUserAttributes(rs);
        return this.getModelFactory().createIdentifier(id, name, description, revisionNo, state, pluginData, userAttributes);
    }

    private int writeIdentifier(PreparedStatement pstmt, int firstColumn, Identifier identifier, Revision revision, Branch branch, State state) throws SQLException {
        int col = firstColumn - 1;
        ++col;
        col = this.setUUID(pstmt, col, identifier.getID());
        pstmt.setString(++col, identifier.getName());
        pstmt.setString(++col, identifier.getDescription());
        pstmt.setLong(++col, revision.getRevision());
        this.setBranch(pstmt, ++col, branch);
        this.setState(pstmt, ++col, state);
        this.setPluginData(pstmt, ++col, identifier);
        this.setUserAttributes(pstmt, ++col, identifier.getUserAttributes());
        return col;
    }
}

