/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.activityrepository.defaultimplementation.sql;

import de.aristaflow.adept2.base.dbaccess.ExtendedConnection;
import de.aristaflow.adept2.base.dbaccess.JDBCTools;
import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.sql.AbstractSQLSubStorage;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.sql.Columns;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.sql.Queries;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.sql.SQLActivityRepositoryStorage;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.storage.OpStorage;
import de.aristaflow.adept2.model.activitymodel.OperationReference;
import de.aristaflow.adept2.model.activitymodel.StorageActivityConfiguration;
import de.aristaflow.adept2.model.activitymodel.StorageActivityModelParameter;
import de.aristaflow.adept2.model.activitymodel.StorageConfigurationDescription;
import de.aristaflow.adept2.model.activitymodel.StorageOperation;
import de.aristaflow.adept2.model.activitymodel.StorageParameterTemplate;
import de.aristaflow.adept2.model.common.Branch;
import de.aristaflow.adept2.model.common.ExecutionControlProperties;
import de.aristaflow.adept2.model.common.ParameterChangePolicy;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.common.Revision;
import de.aristaflow.adept2.model.common.State;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.UnknownEntityException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;

class SQLOpStorage
extends AbstractSQLSubStorage
implements OpStorage {
    SQLOpStorage(SQLActivityRepositoryStorage storage) {
        super(storage);
    }

    @Override
    public Collection<OperationReference> getLatestOperationReferencesOfECD(SessionToken session, String ecName, boolean productionOnly) {
        ArrayList<OperationReference> arrayList;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(ecName, "ecName");
        this.getStorage().getECDStorage().ensureECDExists(session, ecName);
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            String query = productionOnly ? Queries.OpQuery.getLatestOperations_prodOnly : Queries.OpQuery.getLatestOperations;
            pstmt = con.prepareStatement(query);
            pstmt.setString(1, ecName);
            rs = pstmt.executeQuery();
            ArrayList<OperationReference> result = new ArrayList<OperationReference>();
            while (rs.next()) {
                result.add(this.readOperationReference(rs));
            }
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            arrayList = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return arrayList;
    }

    @Override
    public OperationReference getLatestOperationReference(SessionToken session, String ecName, String opName) {
        OperationReference operationReference;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(ecName, "ecName");
        ArgChecks.checkForNull(opName, "opName");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(Queries.OpQuery.getLatestOperationReference);
            int col = 0;
            pstmt.setString(++col, ecName);
            pstmt.setString(++col, opName);
            pstmt.setString(++col, ecName);
            pstmt.setString(++col, opName);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                throw this.newEntityNotExistingException(ecName, opName);
            }
            OperationReference result = this.readOperationReference(rs);
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            operationReference = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly((Statement)pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return operationReference;
    }

    @Override
    public StorageOperation getLatestOperation(SessionToken session, String ecName, String opName) {
        StorageOperation storageOperation;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(ecName, "ecName");
        ArgChecks.checkForNull(opName, "opName");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(Queries.OpQuery.getLatestOperation);
            int col = 0;
            pstmt.setString(++col, ecName);
            pstmt.setString(++col, opName);
            pstmt.setString(++col, ecName);
            pstmt.setString(++col, opName);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                throw this.newEntityNotExistingException(ecName, opName);
            }
            StorageOperation result = this.readOperation(session, rs);
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            storageOperation = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly((Statement)pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return storageOperation;
    }

    @Override
    public List<OperationReference> getOperationRevisionHistory(SessionToken session, String ecName, String opName) {
        ArrayList<OperationReference> arrayList;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(ecName, "ecName");
        ArgChecks.checkForNull(opName, "opName");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(Queries.OpQuery.getOperationRevisionHistory);
            pstmt.setString(1, ecName);
            pstmt.setString(2, opName);
            rs = pstmt.executeQuery();
            ArrayList<OperationReference> result = new ArrayList<OperationReference>();
            while (rs.next()) {
                result.add(this.readOperationReference(rs));
            }
            if (result.isEmpty()) {
                throw this.newEntityNotExistingException(ecName, opName);
            }
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            arrayList = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly((Statement)pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return arrayList;
    }

    @Override
    public Collection<OperationReference> getOperationsOfECDRevision(SessionToken session, String ecName, long revisionNo) {
        ArrayList<OperationReference> arrayList;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(ecName, "ecName");
        ArgChecks.checkForNegative(revisionNo, "revisionNo");
        this.ensureRevisionExists(session, revisionNo);
        this.getStorage().getECDStorage().ensureECDExists(session, ecName);
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(Queries.OpQuery.getOperationsOfECDRevision);
            int col = 0;
            pstmt.setLong(++col, revisionNo);
            pstmt.setString(++col, ecName);
            rs = pstmt.executeQuery();
            ArrayList<OperationReference> result = new ArrayList<OperationReference>();
            while (rs.next()) {
                result.add(this.readOperationReference(rs));
            }
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            arrayList = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly((Statement)pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return arrayList;
    }

    @Override
    public StorageOperation getOperationRevision(SessionToken session, String ecName, String opName, long revisionNo) {
        StorageOperation storageOperation;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(ecName, "ecName");
        ArgChecks.checkForNull(opName, "opName");
        ArgChecks.checkForNegative(revisionNo, "revisionNo");
        this.ensureRevisionExists(session, revisionNo);
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(Queries.OpQuery.getOperationRevision);
            int col = 0;
            pstmt.setString(++col, ecName);
            pstmt.setString(++col, opName);
            pstmt.setString(++col, ecName);
            pstmt.setString(++col, opName);
            pstmt.setLong(++col, revisionNo);
            pstmt.setLong(++col, revisionNo);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                throw this.newEntityNotExistingException(ecName, opName, revisionNo);
            }
            StorageOperation result = this.readOperation(session, rs);
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            storageOperation = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly((Statement)pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return storageOperation;
    }

    @Override
    public Collection<OperationReference> getDevelopmentOperationsOfECD(SessionToken session, String ecName, long branchNo, boolean changedOnly) {
        ArrayList<OperationReference> arrayList;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(ecName, "ecName");
        ArgChecks.checkForNegative(branchNo, "branchNo");
        Branch branch = this.getStorage().getRevisionStorage().getBranchData(session, branchNo);
        this.getStorage().getECDStorage().ensureECDExists(session, ecName, branchNo);
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            if (changedOnly) {
                pstmt = con.prepareStatement(Queries.OpQuery.getDevelopmentOperationsOfECD_changedOnly);
                int col = 0;
                pstmt.setLong(++col, branchNo);
                pstmt.setString(++col, ecName);
            } else {
                String query = Queries.OpQuery.getDevelopmentOperationsOfECD(con.getEXCEPTKeyword());
                pstmt = con.prepareStatement(query);
                int col = 0;
                pstmt.setString(++col, ecName);
                pstmt.setLong(++col, branchNo);
                pstmt.setString(++col, ecName);
                pstmt.setLong(++col, branch.getBaseRevision().getRevision());
                pstmt.setLong(++col, branchNo);
                pstmt.setString(++col, ecName);
            }
            rs = pstmt.executeQuery();
            ArrayList<OperationReference> result = new ArrayList<OperationReference>();
            while (rs.next()) {
                result.add(this.readOperationReference(rs));
            }
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            arrayList = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return arrayList;
    }

    @Override
    public Collection<OperationReference> getChangedDevelopmentOperations(SessionToken session, long branchNo) {
        ArrayList<OperationReference> arrayList;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNegative(branchNo, "branchNo");
        this.ensureBranchExists(session, branchNo);
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(Queries.OpQuery.getChangedDevelopmentOperations);
            int col = 0;
            pstmt.setLong(++col, branchNo);
            rs = pstmt.executeQuery();
            ArrayList<OperationReference> result = new ArrayList<OperationReference>();
            while (rs.next()) {
                result.add(this.readOperationReference(rs));
            }
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            arrayList = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly((Statement)pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return arrayList;
    }

    @Override
    public StorageOperation getDevelopmentOperation(SessionToken session, String ecName, String opName, long branchNo) {
        StorageOperation storageOperation;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(ecName, "ecName");
        ArgChecks.checkForNull(opName, "opName");
        ArgChecks.checkForNegative(branchNo, "branchNo");
        Branch branch = this.getStorage().getRevisionStorage().getBranchData(session, branchNo);
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(Queries.OpQuery.getDevelopmentOperation(con.getEXCEPTKeyword()));
            int col = 0;
            pstmt.setString(++col, ecName);
            pstmt.setString(++col, opName);
            pstmt.setString(++col, ecName);
            pstmt.setString(++col, opName);
            pstmt.setLong(++col, branchNo);
            pstmt.setLong(++col, branch.getBaseRevision().getRevision());
            pstmt.setString(++col, ecName);
            pstmt.setString(++col, opName);
            pstmt.setLong(++col, branchNo);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                throw this.newEntityNotExistingExceptionDev(ecName, opName, branchNo);
            }
            StorageOperation result = this.readOperation(session, rs);
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            storageOperation = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return storageOperation;
    }

    @Override
    public void storeDevelopmentOperation(SessionToken session, StorageOperation op, long branchNo) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(op, "op");
        SQLOpStorage.checkName(op.getName());
        ArgChecks.checkForNegative(branchNo, "branchNo");
        String ecName = op.getExecutableComponentName();
        Branch branch = this.getStorage().getRevisionStorage().getBranchData(session, branchNo);
        this.getStorage().getECDStorage().ensureECDExists(session, ecName, branchNo);
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        try {
            try {
                long _id = this.opIdInBranch(con, ecName, op.getName(), branchNo);
                if (_id >= 0L) {
                    pstmt = con.prepareStatement(Queries.OpQuery.storeDevelopmentOperation_update);
                    int col = 0;
                    ++col;
                    col = this.writeOperation(pstmt, col, op, _id, branch.getBaseRevision(), branch, State.IN_DEVELOPMENT);
                    pstmt.setLong(++col, _id);
                } else {
                    _id = con.nextID("AR_OpID");
                    pstmt = con.prepareStatement(Queries.OpQuery.storeDevelopmentOperation_insert);
                    int col = 0;
                    this.writeOperation(pstmt, ++col, op, _id, branch.getBaseRevision(), branch, State.IN_DEVELOPMENT);
                }
                pstmt.executeUpdate();
                this.updateParameters(session, "opID", _id, op.getParameters(ActivityConstants.AccessType.READ), op.getParameters(ActivityConstants.AccessType.WRITE));
                this.updateParameterTemplates(session, op.getParameterTemplates(), Columns.ParameterTemplateColumn._OP_REF_KEYS, _id);
                pstmt = JDBCTools.close(pstmt);
            }
            catch (SQLException ex) {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(pstmt);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)pstmt);
    }

    @Override
    public void revertDevelopmentOperation(SessionToken session, String ecName, String opName, long branchNo) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(ecName, "ecName");
        ArgChecks.checkForNull(opName, "opName");
        ArgChecks.checkForNegative(branchNo, "branchNo");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        try {
            try {
                long _id = this.opIdInBranch(con, ecName, opName, branchNo);
                if (_id >= 0L) {
                    pstmt = con.prepareStatement(Queries.OpQuery.revertDevelopmentOperation);
                    int col = 0;
                    pstmt.setLong(++col, branchNo);
                    pstmt.setString(++col, ecName);
                    pstmt.setString(++col, opName);
                    pstmt.executeUpdate();
                    pstmt = JDBCTools.close(pstmt);
                    this.deleteParameters(session, "opID", _id);
                    this.deleteParameterTemplates(session, new String[]{"opID"}, _id);
                }
            }
            catch (SQLException ex) {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
        }
        finally {
            JDBCTools.closeQuietly(pstmt);
        }
    }

    @Override
    public void updateDevelopmentOperations(SessionToken session, long branchNo, long newBaseRevisionNo) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNegative(branchNo, "branchNo");
        ArgChecks.checkForNegative(newBaseRevisionNo, "newBaseRevisionNo");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        try {
            try {
                pstmt = con.prepareStatement(Queries.OpQuery.updateDevelopmentOperations);
                int col = 0;
                pstmt.setLong(++col, newBaseRevisionNo);
                pstmt.setLong(++col, branchNo);
                pstmt.executeUpdate();
                pstmt = JDBCTools.close(pstmt);
            }
            catch (SQLException ex) {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(pstmt);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)pstmt);
    }

    @Override
    public void releaseDevelopmentOperations(SessionToken session, long branchNo, long newRevisionNo) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNegative(branchNo, "branchNo");
        ArgChecks.checkForNegative(newRevisionNo, "newRevisionNo");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        try {
            try {
                pstmt = con.prepareStatement(Queries.OpQuery.releaseDevelopmentOperations);
                int col = 0;
                pstmt.setLong(++col, newRevisionNo);
                pstmt.setLong(++col, branchNo);
                pstmt.executeUpdate();
                pstmt = JDBCTools.close(pstmt);
            }
            catch (SQLException ex) {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(pstmt);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)pstmt);
    }

    @Override
    public void outdateOperation(SessionToken session, String ecName, String opName) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(ecName, "ecName");
        ArgChecks.checkForNull(opName, "opName");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        try {
            try {
                pstmt = con.prepareStatement(Queries.OpQuery.outdateOperation);
                pstmt.setString(1, ecName);
                pstmt.setString(2, opName);
                pstmt.executeUpdate();
                pstmt = JDBCTools.close(pstmt);
            }
            catch (SQLException ex) {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(pstmt);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)pstmt);
    }

    void ensureOperationExists(SessionToken session, String ecName, String opName) {
        this.getLatestOperationReference(session, ecName, opName);
    }

    void ensureOperationExists(SessionToken session, String ecName, String opName, long branchNo) {
        this.getDevelopmentOperation(session, ecName, opName, branchNo);
    }

    private UnknownEntityException newEntityNotExistingException(String ecName, String opName) {
        String msg = "The Operation '%s' of Executable Component Description '%s' does not exist (as released or outdated)!";
        msg = String.format(msg, opName, ecName);
        return new UnknownEntityException(msg);
    }

    private UnknownEntityException newEntityNotExistingExceptionDev(String ecName, String opName, long branchNo) {
        String msg = "The Operation '%s' of Executable Component Description '%s' does not exist (as released, outdated or in branch #%d)!";
        msg = String.format(msg, opName, ecName, branchNo);
        return new UnknownEntityException(msg);
    }

    private UnknownEntityException newEntityNotExistingException(String ecName, String opName, long revisionNo) {
        String msg = "The Operation '%s' of Executable Component Description '%s' does not exist in revison #%d!";
        msg = String.format(msg, opName, ecName, revisionNo);
        return new UnknownEntityException(msg);
    }

    private long opIdInBranch(Connection con, String ecName, String opName, long branchNo) throws SQLException {
        long l;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(Queries.OpQuery.opIdInBranch);
            int col = 0;
            pstmt.setString(++col, ecName);
            pstmt.setString(++col, opName);
            pstmt.setLong(++col, branchNo);
            rs = pstmt.executeQuery();
            long result = rs.next() ? rs.getLong(1) : -1L;
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            l = result;
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly((Statement)pstmt, rs);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return l;
    }

    private OperationReference readOperationReference(ResultSet rs) throws SQLException {
        String ecName = rs.getString("ecName");
        String name = rs.getString("name");
        String description = this.getStringNN(rs, "description");
        String devDescription = this.getStringNN(rs, "devDescription");
        long revisionNo = rs.getLong("revision");
        State state = this.getState(rs);
        UUID iconID = this.getUUID(rs, "iconID");
        PluginDataContainer pluginData = this.getPluginData(rs);
        Map<String, String> userAttributes = this.getUserAttributes(rs);
        return this.getModelFactory().createOperationReference(ecName, name, description, devDescription, revisionNo, state, iconID, pluginData, userAttributes);
    }

    private StorageOperation readOperation(SessionToken session, ResultSet rs) throws SQLException {
        String ecName = rs.getString("ecName");
        String name = rs.getString("name");
        String description = this.getStringNN(rs, "description");
        String devDescription = this.getString(rs, "devDescription");
        long revisionNo = rs.getLong("revision");
        State state = this.getState(rs);
        String implementationClass = this.getString(rs, "implementationClass");
        List<String> classPath = this.getClassPath(rs, "classPath");
        Boolean isSingleton = this.getBoolean(rs, "isSingleton");
        byte[] systemComponentSignature = this.getSystemComponentSignature(rs, "sysCompSignature");
        String guiContextID = this.getString(rs, "guiContextID");
        ExecutionControlProperties ecp = this.getECP(rs, "executionControlProperties");
        boolean supportsViewOnly = rs.getBoolean("supportsViewOnly");
        boolean supportsTestExecution = rs.getBoolean("supportsTestExecution");
        UUID iconID = this.getUUID(rs, "iconID");
        String licenceInformation = this.getString(rs, "licence");
        StorageConfigurationDescription confDesc = this.getConfigurationDescription(rs, "configurationDescription");
        StorageActivityConfiguration conf = this.getActivityConfiguration(rs, "configuration");
        StorageActivityConfiguration testConf = this.getActivityConfiguration(rs, "testConfiguration");
        ParameterChangePolicy pcp = this.getParameterChangePolicy(rs, "parameterChangePolicy");
        long _id = rs.getLong("ID_");
        Map<ActivityConstants.AccessType, Map<String, StorageActivityModelParameter>> parameters = this.retrieveParameters(session, "opID", _id);
        Map<String, StorageParameterTemplate> paramTemplates = this.retrieveParameterTemplates(session, Columns.ParameterTemplateColumn._OP_REF_KEYS, _id);
        String sar = this.getString(rs, "staffAssignmentRule");
        PluginDataContainer pluginData = this.getPluginData(rs);
        Map<String, String> userAttributes = this.getUserAttributes(rs);
        return this.getModelFactory().createStorageOperation(ecName, name, description, devDescription, revisionNo, state, implementationClass, classPath, isSingleton, systemComponentSignature, guiContextID, ecp, supportsViewOnly, supportsTestExecution, iconID, licenceInformation, confDesc, conf, testConf, pcp, parameters.get((Object)ActivityConstants.AccessType.READ).values(), parameters.get((Object)ActivityConstants.AccessType.WRITE).values(), paramTemplates, sar, pluginData, userAttributes);
    }

    private int writeOperation(PreparedStatement pstmt, int firstColumn, StorageOperation op, long _id, Revision revision, Branch branch, State state) throws SQLException {
        int col = firstColumn - 1;
        pstmt.setLong(++col, _id);
        pstmt.setString(++col, op.getExecutableComponentName());
        pstmt.setString(++col, op.getName());
        pstmt.setString(++col, op.getDescription());
        this.setString(pstmt, ++col, op.getDeveloperDescription(), op.isDeveloperDescriptionInherited());
        pstmt.setLong(++col, revision.getRevision());
        this.setBranch(pstmt, ++col, branch);
        this.setState(pstmt, ++col, state);
        this.setString(pstmt, ++col, op.getImplementationClass(), op.isImplementationClassInherited());
        this.setClassPath(pstmt, ++col, op.getClassPath());
        this.setBoolean(pstmt, ++col, op.isSingleton(), op.isSingletonInherited());
        this.setSystemComponentSignature(pstmt, ++col, op.getSystemComponent(), op.isSystemComponentInherited());
        this.setString(pstmt, ++col, op.getGUIContextID(), op.isGUIContextIDInherited());
        this.setECP(pstmt, ++col, op.areExecutionControlPropertiesInterhited() ? null : op.getExecutionControlProperties());
        pstmt.setBoolean(++col, op.supportsViewOnly());
        pstmt.setBoolean(++col, op.supportsTestExecution());
        ++col;
        col = this.setUUID(pstmt, col, op.isIconIDInherited() ? null : op.getIconID());
        this.setString(pstmt, ++col, op.getLicenceInformation(), op.isLicenceInformationInherited());
        this.setConfigurationDescription(pstmt, ++col, op.getConfigurationDescription());
        this.setActivityConfiguration(pstmt, ++col, op.getConfiguration());
        this.setActivityConfiguration(pstmt, ++col, op.getTestConfiguration());
        this.setParameterChangePolicy(pstmt, ++col, op.getParameterChangePolicy());
        this.setString(pstmt, ++col, op.getStaffAssignmentRule(), false);
        this.setPluginData(pstmt, ++col, op);
        this.setUserAttributes(pstmt, ++col, op.getUserAttributes());
        return col;
    }
}

