/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.activityrepository.defaultimplementation.sql;

import de.aristaflow.adept2.base.dbaccess.ExtendedConnection;
import de.aristaflow.adept2.base.dbaccess.JDBCTools;
import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.sql.AbstractSQLSubStorage;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.sql.Queries;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.sql.SQLActivityRepositoryStorage;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.storage.ResourceStorage;
import de.aristaflow.adept2.model.activitymodel.ChangeableResourceDescriptor;
import de.aristaflow.adept2.model.common.Branch;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.common.ResourceDescriptor;
import de.aristaflow.adept2.model.common.Revision;
import de.aristaflow.adept2.model.common.State;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.UnknownEntityException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class SQLResourceStorage
extends AbstractSQLSubStorage
implements ResourceStorage {
    public SQLResourceStorage(SQLActivityRepositoryStorage storage) {
        super(storage);
    }

    @Override
    public Collection<ResourceDescriptor> getLatestResources(SessionToken session, boolean productionOnly) {
        ArrayList<ResourceDescriptor> arrayList;
        ArgChecks.checkForNull(session, "session");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            String query = productionOnly ? Queries.ResourceQuery.getLatestResources_prodOnly : Queries.ResourceQuery.getLatestResources;
            pstmt = con.prepareStatement(query);
            rs = pstmt.executeQuery();
            ArrayList<ResourceDescriptor> result = new ArrayList<ResourceDescriptor>();
            while (rs.next()) {
                result.add(this.readResourceDescriptor(rs));
            }
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            arrayList = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return arrayList;
    }

    @Override
    public ResourceDescriptor getLatestResourceDescriptor(SessionToken session, UUID id) {
        ResourceDescriptor resourceDescriptor;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(id, "id");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(Queries.ResourceQuery.getLatestResource);
            int col = 0;
            ++col;
            col = this.setUUID(pstmt, col, id);
            this.setUUID(pstmt, ++col, id);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                throw this.newEntityNotExistingException(id);
            }
            ResourceDescriptor result = this.readResourceDescriptor(rs);
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            resourceDescriptor = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly((Statement)pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return resourceDescriptor;
    }

    @Override
    public byte[] getLatestResource(SessionToken session, UUID id) {
        byte[] byArray;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(id, "id");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(Queries.ResourceQuery.getLatestResource);
            int col = 0;
            ++col;
            col = this.setUUID(pstmt, col, id);
            this.setUUID(pstmt, ++col, id);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                throw this.newEntityNotExistingException(id);
            }
            byte[] result = this.readResource(rs);
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            byArray = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly((Statement)pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return byArray;
    }

    @Override
    public List<ResourceDescriptor> getResourceRevisionHistory(SessionToken session, UUID id) {
        ArrayList<ResourceDescriptor> arrayList;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(id, "id");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(Queries.ResourceQuery.getResourceRevisionHistory);
            int col = 0;
            this.setUUID(pstmt, ++col, id);
            rs = pstmt.executeQuery();
            ArrayList<ResourceDescriptor> result = new ArrayList<ResourceDescriptor>();
            while (rs.next()) {
                result.add(this.readResourceDescriptor(rs));
            }
            if (result.isEmpty()) {
                throw this.newEntityNotExistingException(id);
            }
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            arrayList = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly((Statement)pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return arrayList;
    }

    @Override
    public Collection<ResourceDescriptor> getResourcesOfRevision(SessionToken session, long revisionNo) {
        ArrayList<ResourceDescriptor> arrayList;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNegative(revisionNo, "revisionNo");
        this.ensureRevisionExists(session, revisionNo);
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(Queries.ResourceQuery.getResourcesOfRevision);
            int col = 0;
            pstmt.setLong(++col, revisionNo);
            rs = pstmt.executeQuery();
            ArrayList<ResourceDescriptor> result = new ArrayList<ResourceDescriptor>();
            while (rs.next()) {
                result.add(this.readResourceDescriptor(rs));
            }
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            arrayList = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly((Statement)pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return arrayList;
    }

    @Override
    public ResourceDescriptor getResourceDescriptorRevision(SessionToken session, UUID id, long revisionNo) {
        ResourceDescriptor resourceDescriptor;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(id, "id");
        ArgChecks.checkForNegative(revisionNo, "revisionNo");
        this.ensureRevisionExists(session, revisionNo);
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(Queries.ResourceQuery.getResourceRevision);
            int col = 0;
            ++col;
            col = this.setUUID(pstmt, col, id);
            ++col;
            col = this.setUUID(pstmt, col, id);
            pstmt.setLong(++col, revisionNo);
            pstmt.setLong(++col, revisionNo);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                throw this.newEntityNotExistingException(id, revisionNo);
            }
            ResourceDescriptor result = this.readResourceDescriptor(rs);
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            resourceDescriptor = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly((Statement)pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return resourceDescriptor;
    }

    @Override
    public byte[] getResourceRevision(SessionToken session, UUID id, long revisionNo) {
        byte[] byArray;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(id, "id");
        ArgChecks.checkForNegative(revisionNo, "revisionNo");
        this.ensureRevisionExists(session, revisionNo);
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(Queries.ResourceQuery.getResourceRevision);
            int col = 0;
            ++col;
            col = this.setUUID(pstmt, col, id);
            ++col;
            col = this.setUUID(pstmt, col, id);
            pstmt.setLong(++col, revisionNo);
            pstmt.setLong(++col, revisionNo);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                throw this.newEntityNotExistingException(id, revisionNo);
            }
            byte[] result = this.readResource(rs);
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            byArray = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly((Statement)pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return byArray;
    }

    @Override
    public Collection<ChangeableResourceDescriptor> getDevelopmentResources(SessionToken session, long branchNo, boolean changedOnly) {
        ArrayList<ChangeableResourceDescriptor> arrayList;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNegative(branchNo, "branchNo");
        Branch branch = this.getStorage().getRevisionStorage().getBranchData(session, branchNo);
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            if (changedOnly) {
                pstmt = con.prepareStatement(Queries.ResourceQuery.getDevelopmentResources_changedOnly);
                int col = 0;
                pstmt.setLong(++col, branchNo);
            } else {
                String query = Queries.ResourceQuery.getDevelopmentResources(con.getEXCEPTKeyword());
                pstmt = con.prepareStatement(query);
                int col = 0;
                pstmt.setLong(++col, branchNo);
                pstmt.setLong(++col, branch.getBaseRevision().getRevision());
                pstmt.setLong(++col, branchNo);
            }
            rs = pstmt.executeQuery();
            ArrayList<ChangeableResourceDescriptor> result = new ArrayList<ChangeableResourceDescriptor>();
            while (rs.next()) {
                result.add(this.readChangeableResourceDescriptor(rs));
            }
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            arrayList = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return arrayList;
    }

    @Override
    public ChangeableResourceDescriptor getDevelopmentResourceDescriptor(SessionToken session, UUID id, long branchNo) {
        ChangeableResourceDescriptor changeableResourceDescriptor;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(id, "id");
        ArgChecks.checkForNegative(branchNo, "branchNo");
        Branch branch = this.getStorage().getRevisionStorage().getBranchData(session, branchNo);
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(Queries.ResourceQuery.getDevelopmentResource(con.getEXCEPTKeyword()));
            int col = 0;
            ++col;
            col = this.setUUID(pstmt, col, id);
            ++col;
            col = this.setUUID(pstmt, col, id);
            pstmt.setLong(++col, branchNo);
            pstmt.setLong(++col, branch.getBaseRevision().getRevision());
            ++col;
            col = this.setUUID(pstmt, col, id);
            pstmt.setLong(++col, branchNo);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                throw this.newEntityNotExistingExceptionDev(id, branchNo);
            }
            ChangeableResourceDescriptor result = this.readChangeableResourceDescriptor(rs);
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            changeableResourceDescriptor = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return changeableResourceDescriptor;
    }

    @Override
    public byte[] getDevelopmentResource(SessionToken session, UUID id, long branchNo) {
        byte[] byArray;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(id, "id");
        ArgChecks.checkForNegative(branchNo, "branchNo");
        Branch branch = this.getStorage().getRevisionStorage().getBranchData(session, branchNo);
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(Queries.ResourceQuery.getDevelopmentResource(con.getEXCEPTKeyword()));
            int col = 0;
            ++col;
            col = this.setUUID(pstmt, col, id);
            ++col;
            col = this.setUUID(pstmt, col, id);
            pstmt.setLong(++col, branchNo);
            pstmt.setLong(++col, branch.getBaseRevision().getRevision());
            ++col;
            col = this.setUUID(pstmt, col, id);
            pstmt.setLong(++col, branchNo);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                throw this.newEntityNotExistingExceptionDev(id, branchNo);
            }
            byte[] result = this.readResource(rs);
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            byArray = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return byArray;
    }

    @Override
    public void storeDevelopmentResourceDescriptor(SessionToken session, ResourceDescriptor descriptor, byte[] resource, long branchNo) {
        PreparedStatement pstmt;
        block9: {
            ArgChecks.checkForNull(session, "session");
            ArgChecks.checkForNull(descriptor, "descriptor");
            ArgChecks.checkForNegative(branchNo, "branchNo");
            Branch branch = this.getStorage().getRevisionStorage().getBranchData(session, branchNo);
            ExtendedConnection con = this.getConnection(session);
            pstmt = null;
            try {
                try {
                    if (this.resourceChangedInBranch(con, descriptor.getID(), branchNo)) {
                        pstmt = con.prepareStatement(Queries.ResourceQuery.storeDevelopmentResource_update);
                        int col = 0;
                        ++col;
                        col = this.writeResource(pstmt, col, descriptor, null, branch.getBaseRevision(), branch, State.IN_DEVELOPMENT);
                        pstmt.setLong(++col, branchNo);
                        this.setUUID(pstmt, ++col, descriptor.getID());
                        pstmt.executeUpdate();
                        pstmt = JDBCTools.close(pstmt);
                        if (resource != null) {
                            pstmt = con.prepareStatement(Queries.ResourceQuery.storeDevelopmentResource_updateData);
                            col = 0;
                            pstmt.setBytes(++col, resource);
                            pstmt.setLong(++col, branchNo);
                            this.setUUID(pstmt, ++col, descriptor.getID());
                            pstmt.executeUpdate();
                            pstmt = JDBCTools.close(pstmt);
                        }
                        break block9;
                    }
                    pstmt = con.prepareStatement(Queries.ResourceQuery.storeDevelopmentResource_insert);
                    if (resource == null) {
                        try {
                            resource = this.getResourceRevision(session, descriptor.getID(), branch.getBaseRevision().getRevision());
                        }
                        catch (UnknownEntityException unknownEntityException) {
                            resource = new byte[]{};
                        }
                    }
                    int col = 0;
                    this.writeResource(pstmt, ++col, descriptor, resource, branch.getBaseRevision(), branch, State.IN_DEVELOPMENT);
                    pstmt.executeUpdate();
                    pstmt = JDBCTools.close(pstmt);
                }
                catch (SQLException ex) {
                    String msg = "An error occurred while accessing the database!";
                    throw new InternalServiceException(msg, ex);
                }
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(pstmt);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt);
    }

    @Override
    public void revertDevelopmentResource(SessionToken session, UUID id, long branchNo) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(id, "id");
        ArgChecks.checkForNegative(branchNo, "branchNo");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        try {
            try {
                pstmt = con.prepareStatement(Queries.ResourceQuery.revertDevelopmentResource);
                int col = 0;
                pstmt.setLong(++col, branchNo);
                this.setUUID(pstmt, ++col, id);
                pstmt.executeUpdate();
                pstmt = JDBCTools.close(pstmt);
            }
            catch (SQLException ex) {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(pstmt);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)pstmt);
    }

    @Override
    public void updateDevelopmentResources(SessionToken session, long branchNo, long newBaseRevisionNo) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNegative(branchNo, "branchNo");
        ArgChecks.checkForNegative(newBaseRevisionNo, "newBaseRevisionNo");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        try {
            try {
                pstmt = con.prepareStatement(Queries.ResourceQuery.updateDevelopmentResources);
                int col = 0;
                pstmt.setLong(++col, newBaseRevisionNo);
                pstmt.setLong(++col, branchNo);
                pstmt.executeUpdate();
                pstmt = JDBCTools.close(pstmt);
            }
            catch (SQLException ex) {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(pstmt);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)pstmt);
    }

    @Override
    public void releaseDevelopmentResources(SessionToken session, long branchNo, long newRevisionNo) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNegative(branchNo, "branchNo");
        ArgChecks.checkForNegative(newRevisionNo, "newRevisionNo");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        try {
            try {
                pstmt = con.prepareStatement(Queries.ResourceQuery.releaseDevelopmentResources);
                int col = 0;
                pstmt.setLong(++col, newRevisionNo);
                pstmt.setLong(++col, branchNo);
                pstmt.executeUpdate();
                pstmt = JDBCTools.close(pstmt);
            }
            catch (SQLException ex) {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(pstmt);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)pstmt);
    }

    @Override
    public void outdateResource(SessionToken session, UUID id) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(id, "id");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        try {
            try {
                pstmt = con.prepareStatement(Queries.ResourceQuery.outdateResource);
                int col = 0;
                this.setUUID(pstmt, ++col, id);
                pstmt.executeUpdate();
                pstmt = JDBCTools.close(pstmt);
            }
            catch (SQLException ex) {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(pstmt);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)pstmt);
    }

    void ensureResourceExists(SessionToken session, UUID id) {
        this.getLatestResourceDescriptor(session, id);
    }

    void ensureResourceExists(SessionToken session, UUID id, long branchNo) {
        this.getDevelopmentResourceDescriptor(session, id, branchNo);
    }

    private UnknownEntityException newEntityNotExistingException(UUID id) {
        String msg = "The Resource '%s' does not exist (as released or outdated)!";
        msg = String.format(msg, id);
        return new UnknownEntityException(msg);
    }

    private UnknownEntityException newEntityNotExistingExceptionDev(UUID id, long branchNo) {
        String msg = "The Resource '%s' does not exist (as released, outdated or in branch #%d)!";
        msg = String.format(msg, id, branchNo);
        return new UnknownEntityException(msg);
    }

    private UnknownEntityException newEntityNotExistingException(UUID id, long revisionNo) {
        String msg = "The Resource '%s' does not exist in revision #%d!";
        msg = String.format(msg, id, revisionNo);
        return new UnknownEntityException(msg);
    }

    private boolean resourceChangedInBranch(Connection con, UUID id, long branchNo) throws SQLException {
        boolean bl;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(Queries.ResourceQuery.resourceChangedInBranch);
            int col = 0;
            ++col;
            col = this.setUUID(pstmt, col, id);
            pstmt.setLong(++col, branchNo);
            rs = pstmt.executeQuery();
            rs.next();
            boolean result = rs.getInt(1) > 0;
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            bl = result;
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly((Statement)pstmt, rs);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return bl;
    }

    private ResourceDescriptor readResourceDescriptor(ResultSet rs) throws SQLException {
        UUID id = this.getUUID(rs, "id");
        String name = rs.getString("name");
        String description = this.getStringNN(rs, "description");
        long revisionNo = rs.getLong("revision");
        State state = this.getState(rs);
        PluginDataContainer pluginData = this.getPluginData(rs);
        Map<String, String> userAttributes = this.getUserAttributes(rs);
        return this.getModelFactory().createResourceDescriptor(id, name, description, revisionNo, state, pluginData, userAttributes);
    }

    private ChangeableResourceDescriptor readChangeableResourceDescriptor(ResultSet rs) throws SQLException {
        UUID id = this.getUUID(rs, "id");
        String name = rs.getString("name");
        String description = this.getStringNN(rs, "description");
        long revisionNo = rs.getLong("revision");
        State state = this.getState(rs);
        PluginDataContainer pluginData = this.getPluginData(rs);
        Map<String, String> userAttributes = this.getUserAttributes(rs);
        return this.getModelFactory().createChangeableResourceDescriptor(id, name, description, revisionNo, state, pluginData, userAttributes);
    }

    private byte[] readResource(ResultSet rs) throws SQLException {
        return rs.getBytes("data");
    }

    private int writeResource(PreparedStatement pstmt, int firstColumn, ResourceDescriptor descriptor, byte[] resource, Revision revision, Branch branch, State state) throws SQLException {
        int col = firstColumn - 1;
        ++col;
        col = this.setUUID(pstmt, col, descriptor.getID());
        pstmt.setString(++col, descriptor.getName());
        pstmt.setString(++col, descriptor.getDescription());
        if (resource != null) {
            pstmt.setBytes(++col, new byte[0]);
        }
        pstmt.setLong(++col, revision.getRevision());
        this.setBranch(pstmt, ++col, branch);
        this.setState(pstmt, ++col, state);
        this.setPluginData(pstmt, ++col, descriptor);
        this.setUserAttributes(pstmt, ++col, descriptor.getUserAttributes());
        return col;
    }
}

