/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.activityrepository.defaultimplementation.sql;

import de.aristaflow.adept2.base.dbaccess.ExtendedConnection;
import de.aristaflow.adept2.base.dbaccess.JDBCTools;
import de.aristaflow.adept2.base.service.DataConsistencyException;
import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.sql.AbstractSQLSubStorage;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.sql.Queries;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.sql.SQLActivityRepositoryStorage;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.storage.RevisionStorage;
import de.aristaflow.adept2.model.common.Branch;
import de.aristaflow.adept2.model.common.Revision;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.UnknownEntityException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;

class SQLRevisionStorage
extends AbstractSQLSubStorage
implements RevisionStorage {
    SQLRevisionStorage(SQLActivityRepositoryStorage storage) {
        super(storage);
    }

    @Override
    public Revision createRevision(SessionToken session, long timestamp, QualifiedAgent agent, String comment) {
        Revision revision;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(agent, "agent");
        ArgChecks.checkForNull(comment, "comment");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        try {
            long revisionNo = con.nextID("AR_RevisionNo");
            pstmt = con.prepareStatement(Queries.RevisionQuery.createRevision);
            int col = 0;
            pstmt.setLong(++col, revisionNo);
            pstmt.setLong(++col, timestamp);
            pstmt.setLong(++col, agent.getAgentID());
            pstmt.setString(++col, agent.getAgentUserName());
            pstmt.setLong(++col, agent.getOrgPositionID());
            pstmt.setString(++col, agent.getOrgPositionName());
            pstmt.setString(++col, comment);
            pstmt.executeUpdate();
            pstmt = JDBCTools.close(pstmt);
            revision = new Revision(revisionNo, timestamp, agent, comment);
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(pstmt);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt);
        return revision;
    }

    @Override
    public Revision getRevisionData(SessionToken session, long revisionNo) {
        Revision revision;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNegative(revisionNo, "revisionNo");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(Queries.RevisionQuery.retrieveRevisionData);
            pstmt.setLong(1, revisionNo);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                String msg = "The revision #%d does not exist!";
                msg = String.format(msg, revisionNo);
                throw new UnknownEntityException(msg);
            }
            Revision result = this.readRevision(rs);
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            revision = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly((Statement)pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return revision;
    }

    @Override
    public Revision getLatestRevisionData(SessionToken session) {
        Revision revision;
        ArgChecks.checkForNull(session, "session");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(Queries.RevisionQuery.getLatestRevisionData);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                String msg = "The database contains no revision, not even the predefined revision #0!";
                throw new DataConsistencyException(msg);
            }
            Revision result = this.readRevision(rs);
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            revision = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly((Statement)pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return revision;
    }

    @Override
    public Collection<Branch> getAllBranches(SessionToken session) {
        ArrayList<Branch> arrayList;
        ArgChecks.checkForNull(session, "session");
        ExtendedConnection con = this.getConnection(session);
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery(Queries.BranchQuery.retrieveAllBranches);
            ArrayList<Branch> result = new ArrayList<Branch>();
            while (rs.next()) {
                result.add(this.readBranch(session, rs));
            }
            rs = JDBCTools.close(rs);
            stmt = JDBCTools.close(stmt);
            arrayList = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(stmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly(stmt, rs);
        return arrayList;
    }

    @Override
    public Branch createBranch(SessionToken session, long creationTime, QualifiedAgent creationAgent, String comment) {
        Branch branch;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNull(creationAgent, "creationAgent");
        ArgChecks.checkForNull(comment, "comment");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        try {
            long branchNo = con.nextID("AR_BranchNo");
            Revision baseRevision = this.getLatestRevisionData(session);
            pstmt = con.prepareStatement(Queries.BranchQuery.createBranch);
            int col = 0;
            pstmt.setLong(++col, branchNo);
            pstmt.setLong(++col, baseRevision.getRevision());
            pstmt.setLong(++col, creationTime);
            pstmt.setLong(++col, creationAgent.getAgentID());
            pstmt.setString(++col, creationAgent.getAgentUserName());
            pstmt.setLong(++col, creationAgent.getOrgPositionID());
            pstmt.setString(++col, creationAgent.getOrgPositionName());
            pstmt.setLong(++col, creationTime);
            pstmt.setLong(++col, creationAgent.getAgentID());
            pstmt.setString(++col, creationAgent.getAgentUserName());
            pstmt.setLong(++col, creationAgent.getOrgPositionID());
            pstmt.setString(++col, creationAgent.getOrgPositionName());
            pstmt.setString(++col, comment);
            pstmt.executeUpdate();
            branch = new Branch(branchNo, baseRevision, System.currentTimeMillis(), creationAgent, System.currentTimeMillis(), creationAgent, comment);
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly(pstmt);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt);
        return branch;
    }

    @Override
    public Branch getBranchData(SessionToken session, long branchNo) {
        Branch branch;
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNegative(branchNo, "branchNo");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = con.prepareStatement(Queries.BranchQuery.retrieveBranchData);
            pstmt.setLong(1, branchNo);
            rs = pstmt.executeQuery();
            if (!rs.next()) {
                String msg = "The branch #%d does not exist!";
                msg = String.format(msg, branchNo);
                throw new UnknownEntityException(msg);
            }
            Branch result = this.readBranch(session, rs);
            rs = JDBCTools.close(rs);
            pstmt = JDBCTools.close(pstmt);
            branch = result;
        }
        catch (SQLException ex) {
            try {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
            catch (Throwable throwable) {
                JDBCTools.closeQuietly((Statement)pstmt, rs);
                throw throwable;
            }
        }
        JDBCTools.closeQuietly((Statement)pstmt, rs);
        return branch;
    }

    @Override
    public void updateBranchData(SessionToken session, long branchNo, long baseRevisionNo, long modificationTime, QualifiedAgent modificationAgent, String comment) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNegative(branchNo, "branchNo");
        ArgChecks.checkForNegative(baseRevisionNo, "baseRevisionNo");
        ArgChecks.checkForNull(modificationAgent, "modificationAgent");
        ArgChecks.checkForNull(comment, "comment");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        try {
            try {
                this.getBranchData(session, branchNo);
                pstmt = con.prepareStatement(Queries.BranchQuery.updateBranchData);
                int col = 0;
                pstmt.setLong(++col, baseRevisionNo);
                pstmt.setLong(++col, modificationTime);
                pstmt.setLong(++col, modificationAgent.getAgentID());
                pstmt.setString(++col, modificationAgent.getAgentUserName());
                pstmt.setLong(++col, modificationAgent.getOrgPositionID());
                pstmt.setString(++col, modificationAgent.getOrgPositionName());
                pstmt.setString(++col, comment);
                pstmt.setLong(++col, branchNo);
                pstmt.executeUpdate();
            }
            catch (SQLException ex) {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(pstmt);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)pstmt);
    }

    @Override
    public void deleteBranch(SessionToken session, long branchNo) {
        ArgChecks.checkForNull(session, "session");
        ArgChecks.checkForNegative(branchNo, "branchNo");
        ExtendedConnection con = this.getConnection(session);
        PreparedStatement pstmt = null;
        try {
            try {
                this.getBranchData(session, branchNo);
                pstmt = con.prepareStatement(Queries.BranchQuery.deleteBranch);
                pstmt.setLong(1, branchNo);
                pstmt.executeUpdate();
            }
            catch (SQLException ex) {
                String msg = "An error occurred while accessing the database!";
                throw new InternalServiceException(msg, ex);
            }
        }
        catch (Throwable throwable) {
            JDBCTools.closeQuietly(pstmt);
            throw throwable;
        }
        JDBCTools.closeQuietly((Statement)pstmt);
    }

    private Revision readRevision(ResultSet rs) throws SQLException {
        long revisionNo = rs.getLong("revisionNo");
        long timestamp = rs.getLong("timestamp_");
        QualifiedAgent agent = new QualifiedAgent(rs.getLong("agentID"), rs.getString("agentUserName"), rs.getLong("agentOrgposID"), rs.getString("agentOrgposName"));
        String comment = this.getStringNN(rs, "comment_");
        return new Revision(revisionNo, timestamp, agent, comment);
    }

    private Branch readBranch(SessionToken session, ResultSet rs) throws SQLException {
        long branchNo = rs.getLong("branchNo");
        long baseRevisionNo = rs.getLong("baseRevision");
        Revision baseRevision = this.getRevisionData(session, baseRevisionNo);
        long creationTime = rs.getLong("creationTime");
        QualifiedAgent creationAgent = new QualifiedAgent(rs.getLong("creationAgentID"), rs.getString("creationAgentUserName"), rs.getLong("creationAgentOrgposID"), rs.getString("creationAgentOrgposName"));
        long modificationTime = rs.getLong("modificationTime");
        QualifiedAgent modificationAgent = new QualifiedAgent(rs.getLong("modificationAgentID"), rs.getString("modificationAgentUserName"), rs.getLong("modificationAgentOrgposID"), rs.getString("modificationAgentOrgposName"));
        String comment = this.getStringNN(rs, "comment_");
        return new Branch(branchNo, baseRevision, creationTime, creationAgent, modificationTime, modificationAgent, comment);
    }
}

