/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.activityrepository.defaultimplementation.storage;

import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.service.ServiceNotKnownException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.storage.ATDStorage;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.storage.CSStorage;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.storage.ECDStorage;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.storage.IconStorage;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.storage.IdentifierStorage;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.storage.OpStorage;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.storage.ResourceStorage;
import de.aristaflow.adept2.core.activityrepository.defaultimplementation.storage.RevisionStorage;
import de.aristaflow.adept2.model.activitymodel.ActivityModelFactory;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.logging.Logger;
import org.apache.commons.configuration.Configuration;

public abstract class ActivityRepositoryStorage {
    private Logger logger = LoggerTools.getLogger(this);
    private ActivityModelFactory modelFactory;

    public ActivityRepositoryStorage(Configuration config, Registry dependencyRegistry, SessionToken initSession) throws ServiceNotKnownException {
        this.modelFactory = dependencyRegistry.getModelFactory("ActivityModelFactory", ActivityModelFactory.class);
    }

    public Logger getLogger() {
        return this.logger;
    }

    public ActivityModelFactory getModelFactory() {
        return this.modelFactory;
    }

    public abstract RevisionStorage getRevisionStorage();

    public abstract IdentifierStorage getIdentifierStorage();

    public abstract ECDStorage getECDStorage();

    public abstract OpStorage getOpStorage();

    public abstract CSStorage getCSStorage();

    public abstract ATDStorage getATDStorage();

    public abstract ResourceStorage getResourceStorage();

    public abstract IconStorage getIconStorage();

    public abstract void startSession(SessionToken var1);

    public abstract void endSession(SessionToken var1);

    public abstract void startTransaction(SessionToken var1);

    public abstract void finishTransaction(SessionToken var1);
}

