/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.automaticclient;

import de.aristaflow.adept2.base.communication.ServiceConnectionException;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.worklistmanager.WorklistManager;
import de.aristaflow.adept2.core.worklistmanager.WorklistUpdateManager;
import de.aristaflow.adept2.model.globals.WorklistConstants;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.worklistmodel.ADEPT2EBPReference;
import de.aristaflow.adept2.model.worklistmodel.ActivityReference;
import de.aristaflow.adept2.model.worklistmodel.ClientWorklist;
import de.aristaflow.adept2.model.worklistmodel.ClientWorklistItem;
import de.aristaflow.adept2.model.worklistmodel.ClientWorklistListener;
import de.aristaflow.adept2.model.worklistmodel.WorklistUpdate;
import de.aristaflow.adept2.model.worklistmodel.WorklistUpdateConfiguration;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractWorklistHandler
implements Runnable,
ClientWorklistListener {
    private static final String VM_ERROR_OUTPUT = "VirtualMachineError in LicenceChecker-Thread.";
    protected static final String CONF_WORKER_PRIORITY = "WorkerPriority";
    protected static final String CONF_PING_WLM_INTERVAL = "PingWLM";
    protected static final String CONF_UPDATE_INTERVAL = "UpdateInterval";
    protected final Logger logger;
    protected final WorklistManager wlm;
    protected final Object worklistLock;
    protected ClientWorklist worklist;
    protected final long recheckTime;
    protected final WorklistUpdateConfiguration updateConfiguration;
    protected final BlockingQueue<WorklistUpdate> updateQueue;
    protected volatile boolean update0pending;
    protected final int threadPriority;
    protected Thread thread;
    protected boolean shutdown;

    public AbstractWorklistHandler(WorklistManager wlm, WorklistUpdateConfiguration updateConfiguration, long recheckTime, int threadPriority) {
        ArgChecks.checkForNull(wlm, "wlm");
        ArgChecks.checkForNull(updateConfiguration, "updateConfiguration");
        this.logger = LoggerTools.getLogger(this);
        this.worklistLock = new Object();
        this.wlm = wlm;
        this.updateConfiguration = updateConfiguration;
        this.recheckTime = recheckTime;
        this.updateQueue = new LinkedBlockingQueue<WorklistUpdate>();
        this.update0pending = false;
        this.threadPriority = threadPriority;
        this.shutdown = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.thread = Thread.currentThread();
        if (this.shutdown) {
            return;
        }
        int oldPriority = this.thread.getPriority();
        this.thread.setPriority(this.threadPriority);
        try {
            try {
                try {
                    this.connectAndHandleWL();
                    this.logger.fine("Starting update processing loop.");
                    boolean connected = true;
                    while (!Thread.interrupted()) {
                        try {
                            WorklistUpdate update = this.updateQueue.poll(this.recheckTime, TimeUnit.MILLISECONDS);
                            if (update != null) {
                                this.processUpdate(update);
                                continue;
                            }
                            connected = this.checkAndReconnect(connected);
                        }
                        catch (InterruptedException interruptedException) {
                            Thread.currentThread().interrupt();
                        }
                        catch (RuntimeException re) {
                            this.logger.log(Level.INFO, "An unexpected exception occured while handling a worklist update. Continuing with worklist updates.", re);
                        }
                        catch (VirtualMachineError vme) {
                            LoggerTools.logVirtualMachineErrorSafely(vme, VM_ERROR_OUTPUT);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object object = this.worklistLock;
                    synchronized (object) {
                        if (this.worklist != null) {
                            this.worklist.removeWorklistListener(this);
                            SessionToken session = this.createSession();
                            this.wlm.getWorklistUpdateManager().removeUpdateableClientWorklist(session, this.worklist);
                            String msg = String.format("Deregistered client worklist %s.", this.worklist.getID());
                            this.logger.fine(msg);
                        }
                    }
                    throw throwable;
                }
                Object object = this.worklistLock;
                synchronized (object) {
                    if (this.worklist != null) {
                        this.worklist.removeWorklistListener(this);
                        SessionToken session = this.createSession();
                        this.wlm.getWorklistUpdateManager().removeUpdateableClientWorklist(session, this.worklist);
                        String msg = String.format("Deregistered client worklist %s.", this.worklist.getID());
                        this.logger.fine(msg);
                    }
                }
            }
            catch (RuntimeException re) {
                this.logger.log(Level.INFO, "An unexpected exception occured while shutting down worklist handler. Log is just for information purpose.", re);
                Thread.currentThread().setPriority(oldPriority);
            }
        }
        finally {
            Thread.currentThread().setPriority(oldPriority);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectAndHandleWL() {
        UUID worklistID;
        SessionToken session = this.createSession();
        Object object = this.worklistLock;
        synchronized (object) {
            worklistID = this.wlm.logon(session);
            WorklistUpdateManager wum = this.wlm.getWorklistUpdateManager();
            this.worklist = wum.createClientWorklist(session, worklistID, this.updateConfiguration);
            String msg = String.format("Retrieved client worklist %s.", this.worklist.getID());
            this.logger.fine(msg);
            wum.addUpdateableClientWorklist(session, this.worklist);
            try {
                this.worklist.addWorklistListener(this);
            }
            catch (Throwable throwable) {
                wum.removeUpdateableClientWorklist(session, this.worklist);
            }
        }
        if (!Thread.currentThread().isInterrupted()) {
            List<ClientWorklistItem> worklistItems;
            this.logger.fine("Executing items from initial worklist.");
            Object object2 = this.worklistLock;
            synchronized (object2) {
                worklistItems = this.worklist.getWorklistItems();
                worklistID = this.worklist.getID();
            }
            this.processCompleteUpdate(worklistItems, worklistID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkAndReconnect(boolean connected) {
        boolean ret = connected;
        if (ret) {
            this.logger.finest("Rechecking whether the worklist manager is still available.");
            try {
                ret = this.wlm.ping();
            }
            catch (ServiceConnectionException sce) {
                this.logger.log(Level.INFO, "Worklist manager unavailable. Trying to reconnect.", sce);
                Object object = this.worklistLock;
                synchronized (object) {
                    this.worklist.removeWorklistListener(this);
                    ret = false;
                    try {
                        this.connectAndHandleWL();
                        ret = true;
                    }
                    catch (ServiceConnectionException sce1) {
                        String msg = "Worklist manager unavailable and reconnecting failed. Remaining unconnected and retrying to connect.";
                        this.logger.log(Level.INFO, msg, sce1);
                    }
                }
            }
            if (!ret) {
                AbstractWorklistHandler sce = this;
                synchronized (sce) {
                    this.prepareCompleteUpdate();
                }
            }
        } else {
            try {
                this.connectAndHandleWL();
                ret = true;
            }
            catch (ServiceConnectionException sce) {
                String msg = "Unconnected from worklist manager and reconnecting failed. Remaining unconnected and retrying to connect.";
                this.logger.log(Level.INFO, msg, sce);
            }
        }
        return ret;
    }

    protected void processCompleteUpdate(Collection<ClientWorklistItem> items, UUID worklistID) {
        String msg = String.format("Processing initial worklist items of worklist %s", worklistID);
        this.logger.finer(msg);
        for (ClientWorklistItem item : items) {
            if (Thread.currentThread().isInterrupted()) {
                msg = String.format("Interrupted while processing initial worklist items of worklist %s.", worklistID);
                this.logger.finer(msg);
                break;
            }
            if (this.update0pending) {
                msg = String.format("Retrieved an update with source revision 0, aborting initial processing of items of worklist %s.", worklistID);
                this.logger.finer(msg);
                break;
            }
            if (!this.itemProcessable(item)) continue;
            this.processCompleteUpdate(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processUpdate(WorklistUpdate update) {
        String msg = this.logger.isLoggable(Level.FINEST) ? String.format("Processing worklist update (from revision %s to %s) for worklist %s: %s", update.getSourceRevision(), update.getTargetRevision(), update.getWorklistID(), update.toString()) : String.format("Processing worklist update (from revision %s to %s) for worklist %s.", update.getSourceRevision(), update.getTargetRevision(), update.getWorklistID());
        this.logger.finer(msg);
        if (update.getSourceRevision() == 0L) {
            AbstractWorklistHandler abstractWorklistHandler = this;
            synchronized (abstractWorklistHandler) {
                this.update0pending = false;
                this.prepareCompleteUpdate();
            }
            this.processCompleteUpdate(update.getItemUpdates().keySet(), update.getWorklistID());
        } else {
            for (Map.Entry<ClientWorklistItem, WorklistConstants.WorklistItemUpdateType> entry : update.getItemUpdates().entrySet()) {
                if (Thread.currentThread().isInterrupted()) {
                    msg = String.format("Interrupted while processing worklist update (fromrevision %s to %s) for worklist %s.", update.getSourceRevision(), update.getTargetRevision(), update.getWorklistID());
                    this.logger.finer(msg);
                    break;
                }
                if (this.update0pending) {
                    UUID wlID;
                    Object object = this.worklistLock;
                    synchronized (object) {
                        wlID = this.worklist.getID();
                    }
                    msg = String.format("Retrieved an update with source revision 0, aborting processing worklist update (from revision %s to %s) for worklist %s.", update.getSourceRevision(), update.getTargetRevision(), wlID);
                    this.logger.finer(msg);
                    break;
                }
                ClientWorklistItem updatedItem = entry.getKey();
                msg = String.format("Examining worklist item %s (%s), state change: '%s': '%s').", new Object[]{updatedItem.getActivityReference(), updatedItem.getID(), entry.getValue(), updatedItem.getState()});
                this.logger.finest(msg);
                if (!this.itemProcessable(updatedItem)) continue;
                this.processUpdatedItem(updatedItem, entry.getValue());
            }
            msg = String.format("Finished processing worklist update (from revision %s to %s) for worklist %s.", update.getSourceRevision(), update.getTargetRevision(), update.getWorklistID());
            this.logger.finest(msg);
        }
    }

    protected boolean itemProcessable(ClientWorklistItem item) {
        boolean ret = false;
        String activityReferenceType = item.getActivityReference().getActivityReferenceType();
        if ("de.aristaflow.ADEPT2ActivityReference".equals(activityReferenceType)) {
            ret = ((ADEPT2EBPReference)item.getActivityReference()).getGUIContextID().equals("NullContext");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientWorklistItem getWorklistItem(EBPInstanceReference ebpInstanceReference) {
        ArrayList items;
        Object object = this.worklistLock;
        synchronized (object) {
            items = new ArrayList(this.worklist.getWorklistItems());
        }
        for (ClientWorklistItem item : items) {
            ActivityReference activityReference;
            String activityReferenceType = item.getActivityReference().getActivityReferenceType();
            if (!activityReferenceType.equals("de.aristaflow.ADEPT2ActivityReference") && !activityReferenceType.equals("de.aristaflow.LWPActivityReference") || !ebpInstanceReference.equals(activityReference = item.getActivityReference())) continue;
            return item;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void worklistUpdated(ClientWorklist clientWorklist, WorklistUpdate worklistUpdate) {
        String msg;
        boolean offered;
        UUID wlID;
        Object object = this.worklistLock;
        synchronized (object) {
            wlID = this.worklist.getID();
        }
        assert (clientWorklist.getID().equals(wlID));
        if (worklistUpdate.getSourceRevision() == 0L) {
            object = this;
            synchronized (object) {
                this.update0pending = true;
                this.updateQueue.clear();
            }
        }
        if (!(offered = this.updateQueue.offer(worklistUpdate))) {
            msg = String.format("The worklist update for worklist %s could not be added to the update queue!", worklistUpdate.getWorklistID());
            this.logger.severe(msg);
        }
        msg = String.format("Received worklist update (from revision %s to %s) for worklist %s", worklistUpdate.getSourceRevision(), worklistUpdate.getTargetRevision(), worklistUpdate.getWorklistID());
        this.logger.finer(msg);
    }

    public void shutdown() {
        this.shutdown = true;
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    protected abstract SessionToken createSession();

    protected abstract void processCompleteUpdate(ClientWorklistItem var1);

    protected abstract void prepareCompleteUpdate();

    protected abstract void processUpdatedItem(ClientWorklistItem var1, WorklistConstants.WorklistItemUpdateType var2);
}

