/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.core.automaticclient;

import de.aristaflow.adept2.base.configuration.AbortServiceException;
import de.aristaflow.adept2.base.configuration.ConfigurationDescription;
import de.aristaflow.adept2.base.configuration.ConfigurationException;
import de.aristaflow.adept2.base.configuration.Property;
import de.aristaflow.adept2.base.security.AuthenticationException;
import de.aristaflow.adept2.base.security.SecurityManager;
import de.aristaflow.adept2.base.service.AbstractADEPT2Service;
import de.aristaflow.adept2.base.service.InternalServiceException;
import de.aristaflow.adept2.base.service.Registry;
import de.aristaflow.adept2.base.sessionmanagement.ClientSessionFactory;
import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.base.sessionmanagement.SessionToken;
import de.aristaflow.adept2.core.automaticclient.ItemExecutor;
import de.aristaflow.adept2.core.automaticclient.ItemExecutorService;
import de.aristaflow.adept2.core.automaticclient.ItemResumer;
import de.aristaflow.adept2.core.automaticclient.ItemStarter;
import de.aristaflow.adept2.core.automaticclient.LimitedCollection;
import de.aristaflow.adept2.core.automaticclient.WorklistHandler;
import de.aristaflow.adept2.core.automaticclient.WorklistItemComparator;
import de.aristaflow.adept2.core.automaticclient.WorklistItemExecutorService;
import de.aristaflow.adept2.core.runtimemanager.ResumingRuntimeManager;
import de.aristaflow.adept2.core.runtimemanager.RuntimeManager;
import de.aristaflow.adept2.core.worklistmanager.WorklistManager;
import de.aristaflow.adept2.model.worklistmodel.ClientWorklistItem;
import de.aristaflow.adept2.model.worklistmodel.WorklistItem;
import de.aristaflow.adept2.model.worklistmodel.WorklistModelFactory;
import de.aristaflow.adept2.model.worklistmodel.WorklistUpdateConfiguration;
import de.aristaflow.adept2.util.Adept2ThreadFactory;
import de.aristaflow.adept2.util.ConfigurationTools;
import de.aristaflow.adept2.util.DataSourceException;
import de.aristaflow.adept2.util.ExecutorTools;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration.Configuration;

@ConfigurationDescription(properties={@Property(name="UserID", type=Property.Type.STRING, defaultValue="automaticclient", description="The user name of the automatic client."), @Property(name="Password", type=Property.Type.STRING, description="The password of the automatic client."), @Property(name="OrgPosition", type=Property.Type.LONG, defaultValue="-9223372036854775808", description="The ID of the organisational position of the automatic client."), @Property(name="MinPoolSize", type=Property.Type.INT, defaultValue="0", description="The minimal number of executor threads for starting itemsand the number of threads for resuming items."), @Property(name="MaxPoolSize", type=Property.Type.INT, defaultValue="50", description="The maximum number of executor threads for starting items."), @Property(name="KeepAliveTime", type=Property.Type.LONG, defaultValue="60000", description="The time span in milliseconds idle threads wait for new work in a pool instead of being removed."), @Property(name="PingWLM", type=Property.Type.LONG, defaultValue="5000", description="The time span in milliseconds after which the worklist manager is pinged to check whether it is still available. If not, reconnecting will be tried in the same time span."), @Property(name="WorkerPriority", type=Property.Type.INT, defaultValue="3", description="The priority of the worker threads. The worklist handler thread responsible for worklist updates will have a priority higher by 2."), @Property(name="WorkerStackSize", type=Property.Type.LONG, defaultValue="0", description="The stack size of the worker threads in KiB. This has to be chosen with care. Since there are a lot of threads this should be as low as possible to avoid OutOfMemoryError. However setting it too low may lead to StackOverflowError. 0 uses the default stack size of the JVM."), @Property(name="RunningItemLimit", type=Property.Type.INT, defaultValue="100", description="The amount of worklist items that are executed concurrently. Since resumed items have a scheduled start time, they may lead to a temporary violation of this limit."), @Property(name="UpdateInterval", type=Property.Type.LONG, defaultValue="1000", description="The interval for pushed updates in ms."), @Property(name="AutomaticallyResume", type=Property.Type.BOOLEAN, defaultValue="true", description="Whether the automatic client should automatically resume the appropriate activities if supported by its runtime manager. This creates a second thread pool."), @Property(name="ResumingNeeded", type=Property.Type.BOOLEAN, defaultValue="false", description="Whether a resuming runtime manager is crucial for running this automatic client. If so, the automatic client will not start if it does not have an appropriate runtime manager. This configuration will only make sense if the automatic client should automatically resume.")})
public class AutomaticClient
extends AbstractADEPT2Service
implements WorklistItemExecutorService<ClientWorklistItem> {
    protected static final String CONF_USERNAME = "UserID";
    protected final String userName;
    protected static final String CONF_ORG_POSITION = "OrgPosition";
    protected long orgPosition;
    protected static final String CONF_PASSWORD = "Password";
    protected final String password;
    protected final int workerPriority;
    protected static final String CONF_WORKER_STACK_SIZE = "WorkerStackSize";
    protected final long workerStackSize;
    protected static final String CONF_KEEP_ALIVE_TIME = "KeepAliveTime";
    protected final long keepAliveTime;
    protected final long pingWLMInterval;
    protected static final String CONF_MIN_POOL_SIZE = "MinPoolSize";
    protected final int minPoolSize;
    protected static final String CONF_MAX_POOL_SIZE = "MaxPoolSize";
    protected final int maxPoolSize;
    protected static final String CONF_RUNNING_ITEM_LIMIT = "RunningItemLimit";
    protected final long updateInterval;
    protected static final String CONF_AUTOMATICALLY_RESUME = "AutomaticallyResume";
    protected final boolean automaticallyResume;
    protected static final String CONF_RESUMING_NEEDED = "ResumingNeeded";
    protected final boolean resumingNeeded;
    public static final String AUTOMATIC_RESUME_DATE = "AutomaticResumeDate";
    protected ClientSessionFactory csf;
    protected ThreadPoolExecutor executor;
    protected ScheduledExecutorService scheduledExecutor;
    protected final Collection<ItemExecutor> pendingStartItems;
    protected final Collection<ItemExecutor> pendingResumeItems;
    protected final LimitedCollection<WorklistItem> runningItems;
    protected RuntimeManager runtimeManager;
    protected WorklistManager worklistManager;
    protected WorklistHandler worklistHandler;
    private static final String[] startupRequiredServices = new String[]{"RuntimeManager", "ExecutionManager"};
    private static final String[] runtimeRequiredServices = new String[]{"WorklistManager"};

    public AutomaticClient(Configuration configuration, Registry registry) throws ConfigurationException {
        super(configuration, registry, startupRequiredServices, runtimeRequiredServices);
        this.userName = configuration.getString(CONF_USERNAME);
        this.orgPosition = configuration.getLong(CONF_ORG_POSITION);
        try {
            this.password = ConfigurationTools.parsePassword(configuration, CONF_PASSWORD);
        }
        catch (GeneralSecurityException e) {
            throw new ConfigurationException("The password could not be parsed! Maybe it is not set.", e);
        }
        this.workerPriority = configuration.getInt("WorkerPriority");
        this.workerStackSize = configuration.getInt(CONF_WORKER_STACK_SIZE);
        this.keepAliveTime = configuration.getLong(CONF_KEEP_ALIVE_TIME);
        this.pingWLMInterval = configuration.getLong("PingWLM");
        this.maxPoolSize = configuration.getInt(CONF_MAX_POOL_SIZE) + 2;
        this.minPoolSize = configuration.getInt(CONF_MIN_POOL_SIZE) + 2;
        this.pendingStartItems = Collections.synchronizedCollection(new HashSet(this.maxPoolSize));
        this.pendingResumeItems = Collections.synchronizedCollection(new HashSet(this.maxPoolSize));
        int runningItemLimit = configuration.getInt(CONF_RUNNING_ITEM_LIMIT);
        this.runningItems = new LimitedCollection(runningItemLimit);
        this.updateInterval = configuration.getLong("UpdateInterval");
        this.automaticallyResume = configuration.getBoolean(CONF_AUTOMATICALLY_RESUME);
        this.resumingNeeded = configuration.getBoolean(CONF_RESUMING_NEEDED);
    }

    @Override
    public void init(URI[] uris) throws AbortServiceException {
        super.init(uris);
        this.executor = new ItemExecutorService(this.minPoolSize, this.maxPoolSize, this.keepAliveTime, TimeUnit.MILLISECONDS, this.workerPriority, this.workerStackSize, new WorklistItemComparator());
        this.scheduledExecutor = null;
        try {
            SecurityManager securityManager = this.registry.getSecurityManager();
            if (this.orgPosition == Long.MIN_VALUE) {
                List<QualifiedAgent> orgPos = securityManager.authenticate(this.userName, this.password);
                if (orgPos.size() > 1) {
                    String msg = "Cannot authenticate since no organisational position has been configured for agent '%s' and the organisational model provides %d organisational positions. Please set one in the configuration.";
                    msg = String.format(msg, this.userName, orgPos.size());
                    throw new ConfigurationException(msg);
                }
                if (orgPos.size() < 1) {
                    String msg = "Cannot authenticate since the agent '%s' has no organisational position in the organisational model. Please adapt your model appropriately.";
                    throw new ConfigurationException(String.format(msg, this.userName));
                }
                this.orgPosition = orgPos.get(0).getOrgPositionID();
            }
            this.csf = securityManager.authenticate(this.userName, this.orgPosition, this.password);
            this.csf.setClientURIs(uris);
        }
        catch (AuthenticationException exp) {
            String message = String.format("Authentication failed with '%1$s' and organisational position %2$s.", this.userName, this.orgPosition);
            this.logger.severe(message);
            throw new ConfigurationException(message, exp);
        }
        catch (DataSourceException e) {
            String message = "Security Manager has problems accessing the database, the Automatic Client cannot authenticate.";
            throw new InternalServiceException(message, e);
        }
        SessionToken session = this.csf.getSessionToken(this.getURIs());
        this.runtimeManager = this.registry.getServiceOfType(session, "RuntimeManager", RuntimeManager.class);
        this.runtimeManager.logon(session, this.csf);
        if (this.resumingNeeded && !(this.runtimeManager instanceof ResumingRuntimeManager)) {
            String message = "The Automatic Client is configured for automatically resume but the runtime manager does not support this.";
            this.logger.severe(message);
            throw new ConfigurationException(message);
        }
    }

    @Override
    public void start() throws AbortServiceException {
        super.start();
        SessionToken session = this.csf.getSessionToken();
        this.worklistManager = this.registry.getServiceOfType(session, "WorklistManager", WorklistManager.class);
        WorklistModelFactory wmf = this.registry.getModelFactory("WorklistModelFactory", WorklistModelFactory.class);
        WorklistUpdateConfiguration updateConfiguration = wmf.createPushWorklistConfiguration(this.updateInterval, null);
        this.worklistHandler = new WorklistHandler(this.csf, this.worklistManager, updateConfiguration, this, this.runningItems, this.pingWLMInterval, Math.min(this.workerPriority + 2, 10));
        if (this.automaticallyResume && this.runtimeManager instanceof ResumingRuntimeManager) {
            this.logger.info("Running automatic client with automatically resuming.");
            ((ResumingRuntimeManager)((Object)this.runtimeManager)).registerAutomaticResumer(this.worklistHandler);
            Adept2ThreadFactory factory = new Adept2ThreadFactory("AutomaticClientWorklistScheduledExecutorPool", this.workerStackSize, this.workerPriority, this.logger);
            this.scheduledExecutor = ExecutorTools.createScheduledExecutor(this.minPoolSize, factory);
        }
        this.executor.execute(this.worklistHandler);
    }

    @Override
    public void emergencyShutdown() {
        this.logger.info("Emergency shutdown of Automatic Client.");
        super.emergencyShutdown();
        this.shutdown(true);
        this.logger.info("Emergency shutdown of Automatic Client finished.");
    }

    @Override
    public void shutdown() {
        this.logger.info("Shutting down Automatic Client.");
        super.shutdown();
        this.shutdown(false);
        this.logger.info("Shutting down Automatic Client finished.");
    }

    public void shutdown(boolean emergency) {
        boolean terminated = false;
        this.logger.info("Shutting down Automatic Client...");
        SessionToken session = this.csf.getSessionToken(this.getURIs());
        this.logger.fine("Stopping worklist handling.");
        this.worklistHandler.stopWLHandling(false);
        this.logger.info("Shutting down executors, dropping all outstanding items.");
        this.runningItems.closeAndInterruptWaiters();
        if (emergency) {
            this.executor.shutdownNow();
        } else {
            this.executor.shutdown();
        }
        if (this.scheduledExecutor != null) {
            this.logger.info("Shutting down automatic resuming (scheduled) executors, dropping all outstanding scheduled items.");
            if (emergency) {
                this.scheduledExecutor.shutdownNow();
            } else {
                this.scheduledExecutor.shutdown();
            }
            while (!terminated) {
                this.logger.fine("Waiting 30 seconds for the scheduled executors to shut down.");
                try {
                    terminated = this.scheduledExecutor.awaitTermination(30L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    this.logger.info("Interrupted while waiting for the scheduled executor to shut down, I continue waiting.");
                }
            }
            terminated = false;
        }
        while (!terminated) {
            this.logger.fine("Waiting 30 seconds for the executors to shut down.");
            try {
                terminated = this.executor.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                this.logger.info("Interrupted while waiting for the executor to shut down, I continue waiting.");
            }
        }
        session = this.csf.getSessionToken(this.getURIs());
        QualifiedAgent agent = this.csf.getAuthenticatedAgent().getQualifiedAgent();
        this.runtimeManager.logoffAndTerminateActivities(session, agent, emergency);
        this.logger.fine("Logged off from the runtime manager.");
        if (this.scheduledExecutor != null) {
            ((ResumingRuntimeManager)((Object)this.runtimeManager)).deregisterAutomaticResumer(this.worklistHandler);
        }
        this.worklistHandler.logoff();
        this.logger.fine("Logged off from worklist manager.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean submit(ClientWorklistItem item) {
        boolean ret;
        ItemStarter itemStarter = new ItemStarter(this.csf.getSessionToken(), item, this.runtimeManager.getURIs(), this.worklistHandler, this.pendingStartItems, this.runningItems, this.registry);
        Collection<ItemExecutor> collection = this.pendingStartItems;
        synchronized (collection) {
            boolean bl = ret = !this.pendingStartItems.contains(itemStarter);
            if (ret) {
                this.pendingStartItems.add(itemStarter);
                this.executor.execute(itemStarter);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean submit(ClientWorklistItem item, long delay) {
        boolean ret = false;
        if (this.scheduledExecutor != null) {
            ItemResumer itemResumer = new ItemResumer(this.csf.getSessionToken(), item, this.runtimeManager.getURIs(), this.worklistHandler, this.pendingResumeItems, this.runningItems, this.registry);
            Collection<ItemExecutor> collection = this.pendingResumeItems;
            synchronized (collection) {
                boolean bl = ret = !this.pendingResumeItems.contains(itemResumer);
                if (ret) {
                    this.pendingResumeItems.add(itemResumer);
                    this.scheduledExecutor.schedule(itemResumer, delay, TimeUnit.MILLISECONDS);
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll() {
        int currPrio = Thread.currentThread().getPriority();
        int incrPrio = this.workerPriority + 3;
        incrPrio = Math.min(incrPrio, 10);
        Thread.currentThread().setPriority(incrPrio);
        Collection<ItemExecutor> collection = this.pendingStartItems;
        synchronized (collection) {
            Collection<ItemExecutor> collection2 = this.pendingResumeItems;
            synchronized (collection2) {
                Iterator<ItemExecutor> iterator = this.pendingStartItems.iterator();
                while (iterator.hasNext()) {
                    if (!iterator.next().invalidate()) continue;
                    iterator.remove();
                }
                iterator = this.pendingResumeItems.iterator();
                while (iterator.hasNext()) {
                    if (!iterator.next().invalidate()) continue;
                    iterator.remove();
                }
            }
        }
        Thread.currentThread().setPriority(currPrio);
    }
}

